/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.logging;

import com.elixirtech.arch.Credentials;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LogMessage$Debug$;
import com.elixirtech.arch.LogMessage$Error$;
import com.elixirtech.arch.LogMessage$ErrorEx$;
import com.elixirtech.arch.LogMessage$Info$;
import com.elixirtech.arch.LogMessage$LogMessageList$;
import com.elixirtech.arch.LogMessage$None$;
import com.elixirtech.arch.LogMessage$Warn$;
import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.LoggingHelper$Debug$;
import com.elixirtech.arch.LoggingHelper$Error$;
import com.elixirtech.arch.LoggingHelper$Info$;
import com.elixirtech.arch.LoggingHelper$Warn$;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.logging.SLF4J$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.MDC;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName;
import sourcecode.Line;

public interface SLF4J
extends LoggingInterface {
    public static Set<String> All() {
        return SLF4J$.MODULE$.All();
    }

    public static String ElapsedTime() {
        return SLF4J$.MODULE$.ElapsedTime();
    }

    public static String Prefix() {
        return SLF4J$.MODULE$.Prefix();
    }

    public static String SourceLine() {
        return SLF4J$.MODULE$.SourceLine();
    }

    public static String SourceName() {
        return SLF4J$.MODULE$.SourceName();
    }

    public static String User() {
        return SLF4J$.MODULE$.User();
    }

    public Logger logger();

    public static LoggingHelper.Level getLevel$(SLF4J $this) {
        return $this.getLevel();
    }

    @Override
    default public LoggingHelper.Level getLevel() {
        if (this.logger().isDebugEnabled()) {
            return LoggingHelper$Debug$.MODULE$;
        }
        if (this.logger().isInfoEnabled()) {
            return LoggingHelper$Info$.MODULE$;
        }
        if (this.logger().isWarnEnabled()) {
            return LoggingHelper$Warn$.MODULE$;
        }
        return LoggingHelper$Error$.MODULE$;
    }

    public static void withSourceInfo$(SLF4J $this, Option optCreds, Function0 fn, Line line, FullName fullName) {
        $this.withSourceInfo((Option<Credentials>)optCreds, (Function0<BoxedUnit>)fn, line, fullName);
    }

    default public void withSourceInfo(Option<Credentials> optCreds, Function0<BoxedUnit> fn, Line line, FullName fullName) {
        optCreds.foreach((Function1)(JProcedure1 & Serializable)c -> MDC.put((String)SLF4J$.MODULE$.User(), (String)c.username()));
        MDC.put((String)SLF4J$.MODULE$.SourceName(), (String)fullName.value());
        MDC.put((String)SLF4J$.MODULE$.SourceLine(), (String)String.valueOf(line.value()));
        try {
            fn.apply$mcV$sp();
        }
        finally {
            MDC.remove((String)SLF4J$.MODULE$.User());
            MDC.remove((String)SLF4J$.MODULE$.SourceName());
            MDC.remove((String)SLF4J$.MODULE$.SourceLine());
        }
    }

    public static void withElapsedTime$(SLF4J $this, Option optCreds, long elapsedTime, Function0 fn, Line line, FullName fullName) {
        $this.withElapsedTime((Option<Credentials>)optCreds, elapsedTime, (Function0<BoxedUnit>)fn, line, fullName);
    }

    default public void withElapsedTime(Option<Credentials> optCreds, long elapsedTime, Function0<BoxedUnit> fn, Line line, FullName fullName) {
        optCreds.foreach((Function1)(JProcedure1 & Serializable)c -> MDC.put((String)SLF4J$.MODULE$.User(), (String)c.username()));
        MDC.put((String)SLF4J$.MODULE$.SourceName(), (String)fullName.value());
        MDC.put((String)SLF4J$.MODULE$.SourceLine(), (String)String.valueOf(line.value()));
        MDC.put((String)SLF4J$.MODULE$.ElapsedTime(), (String)String.valueOf(elapsedTime));
        try {
            fn.apply$mcV$sp();
        }
        finally {
            MDC.remove((String)SLF4J$.MODULE$.User());
            MDC.remove((String)SLF4J$.MODULE$.SourceName());
            MDC.remove((String)SLF4J$.MODULE$.SourceLine());
            MDC.remove((String)SLF4J$.MODULE$.ElapsedTime());
        }
    }

    public static void error$(SLF4J $this, Function0 message, Line line, FullName fullName) {
        $this.error((Function0<Object>)message, line, fullName);
    }

    @Override
    default public void error(Function0<Object> message, Line line, FullName fullName) {
        if (this.logger().isErrorEnabled()) {
            this.withSourceInfo((Option<Credentials>)None$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.error$$anonfun$1(message);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void error$(SLF4J $this, Credentials creds, Function0 message, Line line, FullName fullName) {
        $this.error(creds, (Function0<Object>)message, line, fullName);
    }

    @Override
    default public void error(Credentials creds, Function0<Object> message, Line line, FullName fullName) {
        if (this.logger().isErrorEnabled()) {
            this.withSourceInfo((Option<Credentials>)Some$.MODULE$.apply((Object)creds), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.error$$anonfun$2(message);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void error$(SLF4J $this, Function0 message, Throwable t, Line line, FullName fullName) {
        $this.error((Function0<Object>)message, t, line, fullName);
    }

    @Override
    default public void error(Function0<Object> message, Throwable t, Line line, FullName fullName) {
        if (this.logger().isErrorEnabled()) {
            this.withSourceInfo((Option<Credentials>)None$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.error$$anonfun$3(message, t);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void error$(SLF4J $this, Credentials creds, Function0 message, Throwable t, Line line, FullName fullName) {
        $this.error(creds, (Function0<Object>)message, t, line, fullName);
    }

    @Override
    default public void error(Credentials creds, Function0<Object> message, Throwable t, Line line, FullName fullName) {
        if (this.logger().isErrorEnabled()) {
            this.withSourceInfo((Option<Credentials>)Some$.MODULE$.apply((Object)creds), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.error$$anonfun$4(message, t);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void warn$(SLF4J $this, Function0 message, Line line, FullName fullName) {
        $this.warn((Function0<Object>)message, line, fullName);
    }

    @Override
    default public void warn(Function0<Object> message, Line line, FullName fullName) {
        if (this.logger().isWarnEnabled()) {
            this.withSourceInfo((Option<Credentials>)None$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.warn$$anonfun$1(message);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void warn$(SLF4J $this, Credentials creds, Function0 message, Line line, FullName fullName) {
        $this.warn(creds, (Function0<Object>)message, line, fullName);
    }

    @Override
    default public void warn(Credentials creds, Function0<Object> message, Line line, FullName fullName) {
        if (this.logger().isWarnEnabled()) {
            this.withSourceInfo((Option<Credentials>)Some$.MODULE$.apply((Object)creds), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.warn$$anonfun$2(message);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void warn$(SLF4J $this, Function0 message, Throwable t, Line line, FullName fullName) {
        $this.warn((Function0<Object>)message, t, line, fullName);
    }

    default public void warn(Function0<Object> message, Throwable t, Line line, FullName fullName) {
        if (this.logger().isWarnEnabled()) {
            this.withSourceInfo((Option<Credentials>)None$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.warn$$anonfun$3(message, t);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void warn$(SLF4J $this, Credentials creds, Function0 message, Throwable t, Line line, FullName fullName) {
        $this.warn(creds, (Function0<Object>)message, t, line, fullName);
    }

    default public void warn(Credentials creds, Function0<Object> message, Throwable t, Line line, FullName fullName) {
        if (this.logger().isWarnEnabled()) {
            this.withSourceInfo((Option<Credentials>)Some$.MODULE$.apply((Object)creds), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.warn$$anonfun$4(message, t);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void info$(SLF4J $this, Function0 message, Line line, FullName fullName) {
        $this.info((Function0<Object>)message, line, fullName);
    }

    @Override
    default public void info(Function0<Object> message, Line line, FullName fullName) {
        if (this.logger().isInfoEnabled()) {
            this.withSourceInfo((Option<Credentials>)None$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.info$$anonfun$1(message);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void info$(SLF4J $this, Credentials creds, Function0 message, Line line, FullName fullName) {
        $this.info(creds, (Function0<Object>)message, line, fullName);
    }

    @Override
    default public void info(Credentials creds, Function0<Object> message, Line line, FullName fullName) {
        if (this.logger().isInfoEnabled()) {
            this.withSourceInfo((Option<Credentials>)Some$.MODULE$.apply((Object)creds), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.info$$anonfun$2(message);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void debug$(SLF4J $this, Function0 message, Line line, FullName fullName) {
        $this.debug((Function0<Object>)message, line, fullName);
    }

    @Override
    default public void debug(Function0<Object> message, Line line, FullName fullName) {
        if (this.logger().isDebugEnabled()) {
            this.withSourceInfo((Option<Credentials>)None$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.debug$$anonfun$1(message);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static void debug$(SLF4J $this, Credentials creds, Function0 message, Line line, FullName fullName) {
        $this.debug(creds, (Function0<Object>)message, line, fullName);
    }

    @Override
    default public void debug(Credentials creds, Function0<Object> message, Line line, FullName fullName) {
        if (this.logger().isDebugEnabled()) {
            this.withSourceInfo((Option<Credentials>)Some$.MODULE$.apply((Object)creds), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.debug$$anonfun$2(message);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return;
        }
    }

    public static Object warnIfElapsed$(SLF4J $this, long ms, Function0 name, Function0 fn, Line line, FullName fullName) {
        return $this.warnIfElapsed(ms, (Function0<String>)name, fn, line, fullName);
    }

    @Override
    default public <T> T warnIfElapsed(long ms, Function0<String> name, Function0<T> fn, Line line, FullName fullName) {
        long start = System.currentTimeMillis();
        Object t = fn.apply();
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed > ms) {
            this.withElapsedTime((Option<Credentials>)None$.MODULE$, elapsed, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.warnIfElapsed$$anonfun$1(name, elapsed);
                return BoxedUnit.UNIT;
            }, line, fullName);
        }
        return (T)t;
    }

    public static Object warnIfElapsed$(SLF4J $this, Credentials creds, long ms, Function0 name, Function0 fn, Line line, FullName fullName) {
        return $this.warnIfElapsed(creds, ms, (Function0<String>)name, fn, line, fullName);
    }

    @Override
    default public <T> T warnIfElapsed(Credentials creds, long ms, Function0<String> name, Function0<T> fn, Line line, FullName fullName) {
        long start = System.currentTimeMillis();
        Object t = fn.apply();
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed > ms) {
            this.withElapsedTime((Option<Credentials>)Some$.MODULE$.apply((Object)creds), elapsed, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.warnIfElapsed$$anonfun$2(name, elapsed);
                return BoxedUnit.UNIT;
            }, line, fullName);
        }
        return (T)t;
    }

    public static Object infoElapsedTime$(SLF4J $this, Function0 name, Function0 fn, Line line, FullName fullName) {
        return $this.infoElapsedTime((Function0<String>)name, fn, line, fullName);
    }

    @Override
    default public <T> T infoElapsedTime(Function0<String> name, Function0<T> fn, Line line, FullName fullName) {
        if (this.logger().isInfoEnabled()) {
            this.withSourceInfo((Option<Credentials>)None$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.infoElapsedTime$$anonfun$1(name, fullName, line);
                return BoxedUnit.UNIT;
            }, line, fullName);
            long start = System.currentTimeMillis();
            Object t = fn.apply();
            long stop = System.currentTimeMillis();
            long elapsedTime = stop - start;
            this.withElapsedTime((Option<Credentials>)None$.MODULE$, elapsedTime, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.infoElapsedTime$$anonfun$2(name, elapsedTime);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return (T)t;
        }
        return (T)fn.apply();
    }

    public static Object infoElapsedTime$(SLF4J $this, Credentials creds, Function0 name, Function0 fn, Line line, FullName fullName) {
        return $this.infoElapsedTime(creds, (Function0<String>)name, fn, line, fullName);
    }

    @Override
    default public <T> T infoElapsedTime(Credentials creds, Function0<String> name, Function0<T> fn, Line line, FullName fullName) {
        if (this.logger().isInfoEnabled()) {
            this.withSourceInfo((Option<Credentials>)Some$.MODULE$.apply((Object)creds), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.infoElapsedTime$$anonfun$3(name, fullName, line);
                return BoxedUnit.UNIT;
            }, line, fullName);
            long start = System.currentTimeMillis();
            Object t = fn.apply();
            long stop = System.currentTimeMillis();
            long elapsedTime = stop - start;
            this.withElapsedTime((Option<Credentials>)Some$.MODULE$.apply((Object)creds), elapsedTime, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.infoElapsedTime$$anonfun$4(name, elapsedTime);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return (T)t;
        }
        return (T)fn.apply();
    }

    public static Object debugElapsedTime$(SLF4J $this, Function0 name, Function0 fn, Line line, FullName fullName) {
        return $this.debugElapsedTime((Function0<String>)name, fn, line, fullName);
    }

    @Override
    default public <T> T debugElapsedTime(Function0<String> name, Function0<T> fn, Line line, FullName fullName) {
        if (this.logger().isDebugEnabled()) {
            this.withSourceInfo((Option<Credentials>)None$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.debugElapsedTime$$anonfun$1(name, fullName, line);
                return BoxedUnit.UNIT;
            }, line, fullName);
            long start = System.currentTimeMillis();
            Object t = fn.apply();
            long stop = System.currentTimeMillis();
            long elapsedTime = stop - start;
            this.withElapsedTime((Option<Credentials>)None$.MODULE$, elapsedTime, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.debugElapsedTime$$anonfun$2(name, elapsedTime);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return (T)t;
        }
        return (T)fn.apply();
    }

    public static Object debugElapsedTime$(SLF4J $this, Credentials creds, Function0 name, Function0 fn, Line line, FullName fullName) {
        return $this.debugElapsedTime(creds, (Function0<String>)name, fn, line, fullName);
    }

    @Override
    default public <T> T debugElapsedTime(Credentials creds, Function0<String> name, Function0<T> fn, Line line, FullName fullName) {
        if (this.logger().isDebugEnabled()) {
            this.withSourceInfo((Option<Credentials>)Some$.MODULE$.apply((Object)creds), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.debugElapsedTime$$anonfun$3(name, fullName, line);
                return BoxedUnit.UNIT;
            }, line, fullName);
            long start = System.currentTimeMillis();
            Object t = fn.apply();
            long stop = System.currentTimeMillis();
            long elapsedTime = stop - start;
            this.withElapsedTime((Option<Credentials>)Some$.MODULE$.apply((Object)creds), elapsedTime, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.debugElapsedTime$$anonfun$4(name, elapsedTime);
                return BoxedUnit.UNIT;
            }, line, fullName);
            return (T)t;
        }
        return (T)fn.apply();
    }

    public static Object logAndReturn$(SLF4J $this, Object t, LogMessage msg, Line line, FullName fullName) {
        return $this.logAndReturn(t, msg, line, fullName);
    }

    @Override
    default public <T> T logAndReturn(T t, LogMessage msg, Line line, FullName fullName) {
        this.withSourceInfo((Option<Credentials>)None$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.logAndReturn$$anonfun$1(msg, line, fullName);
            return BoxedUnit.UNIT;
        }, line, fullName);
        return t;
    }

    public static Object logAndReturn$(SLF4J $this, Credentials creds, Object t, LogMessage msg, Line line, FullName fullName) {
        return $this.logAndReturn(creds, t, msg, line, fullName);
    }

    @Override
    default public <T> T logAndReturn(Credentials creds, T t, LogMessage msg, Line line, FullName fullName) {
        this.withSourceInfo((Option<Credentials>)Some$.MODULE$.apply((Object)creds), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.logAndReturn$$anonfun$2(msg, line, fullName);
            return BoxedUnit.UNIT;
        }, line, fullName);
        return t;
    }

    public static void apply$(SLF4J $this, LogMessage msg, Line line, FullName fullName) {
        $this.apply(msg, line, fullName);
    }

    @Override
    default public void apply(LogMessage msg2, Line line, FullName fullName) {
        LogMessage logMessage = msg2;
        if (LogMessage$None$.MODULE$.equals(logMessage)) {
            return;
        }
        if (logMessage instanceof LogMessage.Debug) {
            String string;
            LogMessage.Debug debug = LogMessage$Debug$.MODULE$.unapply((LogMessage.Debug)logMessage);
            String msg3 = string = debug._1();
            this.debug((Function0<Object>)((Function0 & Serializable)() -> SLF4J.apply$$anonfun$1(msg3)), line, fullName);
            return;
        }
        if (logMessage instanceof LogMessage.Info) {
            String string;
            LogMessage.Info info = LogMessage$Info$.MODULE$.unapply((LogMessage.Info)logMessage);
            String msg4 = string = info._1();
            this.info((Function0<Object>)((Function0 & Serializable)() -> SLF4J.apply$$anonfun$2(msg4)), line, fullName);
            return;
        }
        if (logMessage instanceof LogMessage.Warn) {
            String string;
            LogMessage.Warn warn = LogMessage$Warn$.MODULE$.unapply((LogMessage.Warn)logMessage);
            String msg5 = string = warn._1();
            this.warn((Function0<Object>)((Function0 & Serializable)() -> SLF4J.apply$$anonfun$3(msg5)), line, fullName);
            return;
        }
        if (logMessage instanceof LogMessage.Error) {
            String string;
            LogMessage.Error error = LogMessage$Error$.MODULE$.unapply((LogMessage.Error)logMessage);
            String msg6 = string = error._1();
            this.error((Function0<Object>)((Function0 & Serializable)() -> SLF4J.apply$$anonfun$4(msg6)), line, fullName);
            return;
        }
        if (logMessage instanceof LogMessage.ErrorEx) {
            LogMessage.ErrorEx errorEx = LogMessage$ErrorEx$.MODULE$.unapply((LogMessage.ErrorEx)logMessage);
            String string = errorEx._1();
            Throwable throwable = errorEx._2();
            String msg7 = string;
            Throwable ex = throwable;
            this.error((Function0<Object>)((Function0 & Serializable)() -> SLF4J.apply$$anonfun$5(msg7)), ex, line, fullName);
            return;
        }
        if (logMessage instanceof LogMessage.ErrorCode) {
            LogMessage.ErrorCode ec = (LogMessage.ErrorCode)logMessage;
            this.error((Function0<Object>)((Function0 & Serializable)() -> SLF4J.apply$$anonfun$6(ec)), line, fullName);
            return;
        }
        if (logMessage instanceof LogMessage.LogMessageList) {
            List<LogMessage> list;
            LogMessage.LogMessageList logMessageList = LogMessage$LogMessageList$.MODULE$.unapply((LogMessage.LogMessageList)logMessage);
            List<LogMessage> logs = list = logMessageList._1();
            logs.foreach((Function1)(JProcedure1 & Serializable)msg -> this.apply((LogMessage)msg, line, fullName));
            return;
        }
        throw new MatchError((Object)logMessage);
    }

    private void error$$anonfun$1(Function0 message$1) {
        this.logger().error(String.valueOf(message$1.apply()));
    }

    private void error$$anonfun$2(Function0 message$2) {
        this.logger().error(String.valueOf(message$2.apply()));
    }

    private void error$$anonfun$3(Function0 message$3, Throwable t$1) {
        this.logger().error(String.valueOf(message$3.apply()), t$1);
    }

    private void error$$anonfun$4(Function0 message$4, Throwable t$2) {
        this.logger().error(String.valueOf(message$4.apply()), t$2);
    }

    private void warn$$anonfun$1(Function0 message$5) {
        this.logger().warn(String.valueOf(message$5.apply()));
    }

    private void warn$$anonfun$2(Function0 message$6) {
        this.logger().warn(String.valueOf(message$6.apply()));
    }

    private void warn$$anonfun$3(Function0 message$7, Throwable t$3) {
        this.logger().warn(String.valueOf(message$7.apply()), t$3);
    }

    private void warn$$anonfun$4(Function0 message$8, Throwable t$4) {
        this.logger().warn(String.valueOf(message$8.apply()), t$4);
    }

    private void info$$anonfun$1(Function0 message$9) {
        this.logger().info(String.valueOf(message$9.apply()));
    }

    private void info$$anonfun$2(Function0 message$10) {
        this.logger().info(String.valueOf(message$10.apply()));
    }

    private void debug$$anonfun$1(Function0 message$11) {
        this.logger().debug(String.valueOf(message$11.apply()));
    }

    private void debug$$anonfun$2(Function0 message$12) {
        this.logger().debug(String.valueOf(message$12.apply()));
    }

    private void warnIfElapsed$$anonfun$1(Function0 name$1, long elapsed$1) {
        this.logger().warn(name$1.apply() + " elapsed time: " + BoxesRunTime.boxToLong((long)elapsed$1).toString() + " ms");
    }

    private void warnIfElapsed$$anonfun$2(Function0 name$2, long elapsed$2) {
        this.logger().warn(name$2.apply() + " elapsed time: " + BoxesRunTime.boxToLong((long)elapsed$2).toString() + " ms");
    }

    private void infoElapsedTime$$anonfun$1(Function0 name$3, FullName fullName$1, Line line$1) {
        this.logger().info(name$3.apply() + " starting (" + fullName$1.value() + ":" + BoxesRunTime.boxToInteger((int)line$1.value()).toString() + ")");
    }

    private void infoElapsedTime$$anonfun$2(Function0 name$4, long elapsedTime$1) {
        this.logger().info(name$4.apply() + " elapsed time " + BoxesRunTime.boxToLong((long)elapsedTime$1).toString() + "ms");
    }

    private void infoElapsedTime$$anonfun$3(Function0 name$5, FullName fullName$2, Line line$2) {
        this.logger().info(name$5.apply() + " starting (" + fullName$2.value() + ":" + BoxesRunTime.boxToInteger((int)line$2.value()).toString() + ")");
    }

    private void infoElapsedTime$$anonfun$4(Function0 name$6, long elapsedTime$2) {
        this.logger().info(name$6.apply() + " elapsed time " + BoxesRunTime.boxToLong((long)elapsedTime$2).toString() + "ms");
    }

    private void debugElapsedTime$$anonfun$1(Function0 name$7, FullName fullName$3, Line line$3) {
        this.logger().debug(name$7.apply() + " starting (" + fullName$3.value() + ":" + BoxesRunTime.boxToInteger((int)line$3.value()).toString() + ")");
    }

    private void debugElapsedTime$$anonfun$2(Function0 name$8, long elapsedTime$3) {
        this.logger().debug(name$8.apply() + " elapsed time " + BoxesRunTime.boxToLong((long)elapsedTime$3).toString() + "ms");
    }

    private void debugElapsedTime$$anonfun$3(Function0 name$9, FullName fullName$4, Line line$4) {
        this.logger().debug(name$9.apply() + " starting (" + fullName$4.value() + ":" + BoxesRunTime.boxToInteger((int)line$4.value()).toString() + ")");
    }

    private void debugElapsedTime$$anonfun$4(Function0 name$10, long elapsedTime$4) {
        this.logger().debug(name$10.apply() + " elapsed time " + BoxesRunTime.boxToLong((long)elapsedTime$4).toString() + "ms");
    }

    private void logAndReturn$$anonfun$1(LogMessage msg$1, Line line$5, FullName fullName$5) {
        this.apply(msg$1, line$5, fullName$5);
    }

    private void logAndReturn$$anonfun$2(LogMessage msg$2, Line line$6, FullName fullName$6) {
        this.apply(msg$2, line$6, fullName$6);
    }

    private static Object apply$$anonfun$1(String msg$3) {
        return msg$3;
    }

    private static Object apply$$anonfun$2(String msg$4) {
        return msg$4;
    }

    private static Object apply$$anonfun$3(String msg$5) {
        return msg$5;
    }

    private static Object apply$$anonfun$4(String msg$6) {
        return msg$6;
    }

    private static Object apply$$anonfun$5(String msg$7) {
        return msg$7;
    }

    private static Object apply$$anonfun$6(LogMessage.ErrorCode ec$1) {
        return ec$1.msg();
    }
}

