/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.binarystore;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.binarystore.BinaryStoreMigrator;
import ambience.etl.binarystore.BinaryStoreMigrator$Input$;
import ambience.etl.mongodb.ConnectionPool$;
import ambience.etl.package$;
import ambience.framework.AWSS3BinaryStoreLocation;
import cats.Functor;
import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.RichMongoCollection;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import scala.util.Right$;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class BinaryStoreMigrator$
implements Builder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(BinaryStoreMigrator$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(BinaryStoreMigrator$.class.getDeclaredField("api$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    public static final BinaryStoreMigrator$Input$ Input;
    private volatile Object api$lzy1;
    public static final BinaryStoreMigrator$ MODULE$;

    private BinaryStoreMigrator$() {
    }

    static {
        MODULE$ = new BinaryStoreMigrator$();
        stepType = ETLStepType$.MODULE$.apply("binarystore.BinaryStoreMigrator");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BinaryStoreMigrator$.class);
    }

    public String stepType() {
        return stepType;
    }

    public BinaryStore api() {
        Object object = this.api$lzy1;
        if (object instanceof BinaryStore) {
            return (BinaryStore)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BinaryStore)this.api$lzyINIT1();
    }

    private Object api$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.api$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BinaryStore binaryStore = null;
                    try {
                        binaryStore = (BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class));
                        object2 = binaryStore == null ? LazyVals.NullValue$.MODULE$ : binaryStore;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.api$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return binaryStore;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        return Right$.MODULE$.apply((Function1 & Serializable)from -> from.mapEval((Function1 & Serializable)doc -> MODULE$.run(cxt, (Document)doc)));
    }

    public Task<Document> run(Builder.Context cxt, Document doc) {
        return this.getInput(doc).flatMap((Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                BinaryStoreMigrator.Input input = (BinaryStoreMigrator.Input)((Some)option).value();
                String string = input.fromStoreName();
                String string2 = input.toStoreName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"success");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonBoolean$.MODULE$.apply(false)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                    objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"From and To stores are the same"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                    return Task$.MODULE$.now(doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                }
                return MODULE$.run(cxt, input).map((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Right) {
                        long count = BoxesRunTime.unboxToLong((Object)((Right)either).value());
                        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"success");
                        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonBoolean$.MODULE$.apply(true)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"count");
                        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt64$.MODULE$.apply(count)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }
                    if (either instanceof Left) {
                        String msg = (String)((Left)either).value();
                        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"success");
                        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonBoolean$.MODULE$.apply(false)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)msg), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                        return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }
                    throw new MatchError((Object)either);
                });
            }
            if (None$.MODULE$.equals(option)) {
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"success");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonBoolean$.MODULE$.apply(false)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)"Missing input fields"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                return Task$.MODULE$.now(doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<String, Object>> run(Builder.Context cxt, BinaryStoreMigrator.Input input) {
        Option option = ConnectionPool$.MODULE$.getPool(input.db());
        if (option instanceof Some) {
            MongoDatabase db = (MongoDatabase)((Some)option).value();
            RichMongoCollection cltn = new RichMongoCollection(db.getCollection(input.cltn(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
            RichMongoCollection output = new RichMongoCollection(db.getCollection(input.cltn() + "_Migrated", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
            return cltn.findO().mapEval((Function1 & Serializable)doc -> MODULE$.migrate(cxt, input, output, (Document)doc)).countL().map((Function1 & Serializable)c -> Right$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)c))));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.apply(() -> BinaryStoreMigrator$.run$$anonfun$4(input));
        }
        throw new MatchError((Object)option);
    }

    public Task<BoxedUnit> migrate(Builder.Context cxt, BinaryStoreMigrator.Input input, RichMongoCollection output, Document doc) {
        return this.migrate(cxt, input, doc).flatMap((Function1 & Serializable)doc2 -> output.insertOneT(doc2).void());
    }

    public Task<Document> migrate(Builder.Context cxt, BinaryStoreMigrator.Input input, Document doc) {
        return this.migrateDoc(cxt, input, doc.toBsonDocument()).map((Function1 & Serializable)_$1 -> package$.MODULE$.ETLRecord().apply(_$1));
    }

    public Task<BsonValue> migrate(Builder.Context cxt, BinaryStoreMigrator.Input input, BsonValue bv) {
        BsonValue bsonValue = bv;
        if (bsonValue instanceof BsonDocument) {
            BsonDocument bd = (BsonDocument)bsonValue;
            return this.migrateDoc(cxt, input, bd);
        }
        if (bsonValue instanceof BsonArray) {
            BsonArray ba = (BsonArray)bsonValue;
            return this.migrateArray(cxt, input, ba);
        }
        return Task$.MODULE$.now((Object)bv);
    }

    public Task<BsonDocument> migrateDoc(Builder.Context cxt, BinaryStoreMigrator.Input input, BsonDocument bv) {
        Task<Document> task;
        Document doc = package$.MODULE$.ETLRecord().apply(bv);
        Option optCoord = doc.get("store", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue()).flatMap((Function1 & Serializable)store -> doc.get("contentId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).map((Function1 & Serializable)contentId -> BinaryStore.Id$.MODULE$.apply(BinaryStore.LocationId$.MODULE$.apply(store), BinaryStore.ContentId$.MODULE$.apply(contentId))));
        Option option = optCoord;
        if (option instanceof Some) {
            BinaryStore.Id coord = (BinaryStore.Id)((Some)option).value();
            task = this.migrateCoord(cxt, input, doc, coord);
        } else if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.now((Object)doc);
        } else {
            throw new MatchError((Object)option);
        }
        Task<Document> tdoc = task;
        return tdoc.flatMap((Function1 & Serializable)newDoc -> {
            List newPairs = newDoc.toList().map((Function1 & Serializable)kv -> MODULE$.migrate(cxt, input, (BsonValue)kv._2()).map((Function1 & Serializable)v -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc(kv._1());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, v);
            }));
            return Task$.MODULE$.sequence((Iterable)newPairs, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)_$4 -> BsonDocument$.MODULE$.apply((Iterable)_$4));
        });
    }

    public Task<Document> migrateCoord(Builder.Context cxt, BinaryStoreMigrator.Input input, Document doc, BinaryStore.Id coord) {
        String string = coord.locationId();
        String string2 = input.fromStoreName();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return BinaryStore$.MODULE$.get(coord).flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                    return MODULE$.addPreservingContentId(input.toStore(), coord.contentId(), content).map((Function1 & Serializable)newContentId -> BinaryStoreMigrator$.migrateCoord$$anonfun$1$$anonfun$1(doc, input, newContentId == null ? null : ((BinaryStore.ContentId)newContentId).value()));
                }
                if (None$.MODULE$.equals(option)) {
                    MODULE$.log().warn(() -> BinaryStoreMigrator$.migrateCoord$$anonfun$1$$anonfun$2(coord), Line$.MODULE$.apply(101), FullName$.MODULE$.apply("ambience.etl.binarystore.BinaryStoreMigrator.migrateCoord"));
                    return cxt.logRecord(doc, (LogMessage)LogMessage.Warn$.MODULE$.apply("No content found for " + coord));
                }
                throw new MatchError((Object)option);
            });
        }
        return Task$.MODULE$.now((Object)doc);
    }

    public Task<BsonArray> migrateArray(Builder.Context cxt, BinaryStoreMigrator.Input input, BsonArray bv) {
        return Task$.MODULE$.sequence((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(bv.getValues()).asScala().toList().map((Function1 & Serializable)_$5 -> MODULE$.migrate(cxt, input, (BsonValue)_$5)), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)elems -> BsonArray$.MODULE$.fromIterable(elems));
    }

    public Task<Option<BinaryStoreMigrator.Input>> getInput(Document doc) {
        OptionT ret = OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)doc.get("db", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$6 -> _$6.getValue()))).flatMap((Function1 & Serializable)db -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)doc.get("cltn", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$7 -> _$7.getValue()))).flatMap((Function1 & Serializable)cltn -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)doc.get("fromStore", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$8 -> _$8.getValue()))).flatMap((Function1 & Serializable)fromStoreName -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)doc.get("toStore", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$9 -> _$9.getValue()))).flatMap((Function1 & Serializable)toStoreName -> OptionT$.MODULE$.apply((Object)MODULE$.api().location(BinaryStore.LocationId$.MODULE$.apply(toStoreName))).map((Function1 & Serializable)toStore -> BinaryStoreMigrator$Input$.MODULE$.apply((String)db, (String)cltn, (String)fromStoreName, (String)toStoreName, (BinaryStore.Location)toStore), (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return (Task)ret.value();
    }

    public Task<BinaryStore.ContentId> addPreservingContentId(BinaryStore.Location loc, String contentId, BinaryStore.Content content) {
        BinaryStore.Location location = loc;
        if (location instanceof AWSS3BinaryStoreLocation) {
            AWSS3BinaryStoreLocation aws = (AWSS3BinaryStoreLocation)location;
            return this.awsAdd(aws, contentId, content);
        }
        return loc.add(content);
    }

    public Task<BinaryStore.ContentId> awsAdd(AWSS3BinaryStoreLocation loc, String uuid, BinaryStore.Content content) {
        return content.bytes().observable().toListL().flatMap((Function1 & Serializable)f -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])f.toArray(ClassTag$.MODULE$.apply(Byte.TYPE).wrap()));
            byte[] bytes = (byte[])ArrayOps$.MODULE$.flatten$extension(object, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE));
            long contentLength = bytes.length;
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("Content-Length", String.valueOf(contentLength));
            metadata.put("elxMetadata", content.metadata().noSpaces());
            return loc.run((Function1 & Serializable)clientInfo -> new BinaryStore.ContentId(BinaryStoreMigrator$.awsAdd$$anonfun$1$$anonfun$1(uuid, metadata, contentLength, bytes, clientInfo))).map((Function1 & Serializable)x$1 -> new BinaryStore.ContentId(BinaryStoreMigrator$.awsAdd$$anonfun$1$$anonfun$2(x$1)));
        });
    }

    private static final Left run$$anonfun$4(BinaryStoreMigrator.Input input$2) {
        return Left$.MODULE$.apply((Object)("Can't access database " + input$2.db()));
    }

    private static final /* synthetic */ Document migrateCoord$$anonfun$1$$anonfun$1(Document doc$5, BinaryStoreMigrator.Input input$6, String newContentId) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"store");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(input$6.toStoreName())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"contentId");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(newContentId)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return (Document)doc$5.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final Object migrateCoord$$anonfun$1$$anonfun$2(BinaryStore.Id coord$2) {
        return "No content found for " + coord$2;
    }

    private static final Object awsAdd$$anonfun$1$$anonfun$1$$anonfun$1(long contentLength$2, AWSS3BinaryStoreLocation.ClientInfo clientInfo$1, String uuid$3) {
        return "Writing " + contentLength$2 + " bytes to " + clientInfo$1.path() + "/" + uuid$3;
    }

    private static final /* synthetic */ String awsAdd$$anonfun$1$$anonfun$1(String uuid$2, HashMap metadata$1, long contentLength$1, byte[] bytes$1, AWSS3BinaryStoreLocation.ClientInfo clientInfo) {
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(clientInfo.bucket()).key(clientInfo.path() + "/" + uuid$2).metadata((Map)metadata$1).build();
        MODULE$.log().info(() -> BinaryStoreMigrator$.awsAdd$$anonfun$1$$anonfun$1$$anonfun$1(contentLength$1, clientInfo, uuid$2), Line$.MODULE$.apply(145), FullName$.MODULE$.apply("ambience.etl.binarystore.BinaryStoreMigrator.awsAdd"));
        clientInfo.client().putObject(request, RequestBody.fromBytes((byte[])bytes$1));
        return uuid$2;
    }

    private static final /* synthetic */ String awsAdd$$anonfun$1$$anonfun$2(Either x$1) {
        Either either = x$1;
        if (either instanceof Right) {
            Object object = ((Right)either).value();
            String cId = object == null ? null : ((BinaryStore.ContentId)object).value();
            return cId;
        }
        if (either instanceof Left) {
            LogMessage err = (LogMessage)((Left)either).value();
            MODULE$.log().apply(err, Line$.MODULE$.apply(152), FullName$.MODULE$.apply("ambience.etl.binarystore.BinaryStoreMigrator.awsAdd"));
            throw new RuntimeException("Can't add content: " + err);
        }
        throw new MatchError((Object)either);
    }
}

