/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.file;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.Builder$;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.file.FileCategory$;
import ambience.etl.file.FileWriter;
import ambience.etl.file.FileWriter$Info$;
import ambience.etl.file.FileWriter$State$;
import ambience.etl.package$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonBinary;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple1$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FileWriter$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(FileWriter$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final Clock clock;
    public static final FileWriter$Info$ Info;
    public static final FileWriter$State$ State;
    private static final String stepType;
    private static final Function1 getBytes;
    public static final FileWriter$ MODULE$;

    private FileWriter$() {
    }

    static {
        MODULE$ = new FileWriter$();
        clock = (Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class));
        stepType = ETLStepType$.MODULE$.apply("file.FileWriter");
        getBytes = (Function1 & Serializable)_$1 -> _$1.flatMap((Function1 & Serializable)doc -> {
            BsonValue bsonValue;
            Option option = doc.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonBinary) {
                BsonBinary bin = (BsonBinary)bsonValue;
                return Observable$.MODULE$.now((Object)bin);
            }
            return Observable$.MODULE$.empty();
        });
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileWriter$.class);
    }

    public Clock clock() {
        return clock;
    }

    public String stepType() {
        return stepType;
    }

    public Function1<Observable<Document>, Observable<BsonBinary>> getBytes() {
        return getBytes;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "filepath";
        boolean size = true;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", FileWriter$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), FileWriter$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(FileWriter$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> MODULE$.run(cxt, (FileWriter.Info)info));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "filepath";
        boolean size = true;
        FileWriter.Info info = (FileWriter.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", FileWriter$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), FileWriter$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(FileWriter$::$anonfun$3))))).toOption().getOrElse(FileWriter$::$anonfun$4);
        return Task$.MODULE$.apply(() -> FileWriter$.buildPanel$$anonfun$1(info));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> FileWriter$.savePanel$$anonfun$1(results, step));
    }

    public Function1<Observable<Document>, Observable<Document>> run(Builder.Context cxt, FileWriter.Info info) {
        return (Function1 & Serializable)from -> {
            File file = MODULE$.getFile(info);
            if (FileCategory$.MODULE$.canWrite(file)) {
                Option$.MODULE$.apply((Object)file.getAbsoluteFile().getParentFile()).foreach((Function1 & Serializable)_$2 -> _$2.mkdirs());
                if (file.isDirectory()) {
                    String msg = "Can't write to " + file.getAbsolutePath() + " - it is a directory";
                    return Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.Error$.MODULE$.apply(msg))).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return from.map((Function1 & Serializable)doc -> Builder$.MODULE$.withError(doc, msg)).map((Function1 & Serializable)ret -> ret);
                    });
                }
                Try try_ = Try$.MODULE$.apply(() -> FileWriter$.run$$anonfun$1$$anonfun$3(file, from, cxt));
                if (try_ instanceof Success) {
                    Observable doc = (Observable)((Success)try_).value();
                    return doc;
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    String msg = "Can't write to " + file.getAbsolutePath() + ": " + ex;
                    return Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply(msg, ex))).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object[] objectArray = new Document[1];
                        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[2];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"count");
                        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt64$.MODULE$.apply(0L)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
                        objectArray2[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt64$.MODULE$.apply(0L)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        objectArray[0] = Builder$.MODULE$.withError(package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)), msg);
                        return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)ret -> ret);
                    });
                }
                throw new MatchError((Object)try_);
            }
            String msg = "Write disallowed by config: " + file.getAbsolutePath();
            return Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.Error$.MODULE$.apply(msg))).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return from.map((Function1 & Serializable)doc -> Builder$.MODULE$.withError(doc, msg)).map((Function1 & Serializable)ret -> ret);
            });
        };
    }

    public File getFile(FileWriter.Info info) {
        return new File(info.filepath());
    }

    public FileWriter.State write(FileWriter.State s, BsonBinary bin) {
        s.os().write(bin.getData());
        long l = s.count() + 1L;
        long l2 = s.length() + (long)bin.getData().length;
        Builder.Context context = s.copy$default$1();
        File file = s.copy$default$2();
        OutputStream outputStream = s.copy$default$3();
        long l3 = s.copy$default$4();
        return s.copy(context, file, outputStream, l3, l, l2);
    }

    public Task<Document> buildResult(FileWriter.State s) {
        return s.cxt().logT((LogMessage)LogMessage.Info$.MODULE$.apply("Closing " + s.file().getAbsolutePath())).map((Function1 & Serializable)_$4 -> {
            s.os().close();
            long elapsedTime = MODULE$.clock().now() - s.start();
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"count");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt64$.MODULE$.apply(s.count())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt64$.MODULE$.apply(s.length())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"elapsedTime");
            objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt64$.MODULE$.apply(elapsedTime)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        });
    }

    private static final List build$$anonfun$1() {
        Decoder decodeA;
        DecoderNotDeriveSum f$proxy1;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy1 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder);
    }

    private static final Function1 build$$anonfun$2() {
        FileWriter$Info$ fileWriter$Info$ = FileWriter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileWriter.Info)fileWriter$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileWriter$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    private static final List $anonfun$1() {
        Decoder decodeA;
        DecoderNotDeriveSum f$proxy2;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy2 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy2 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder);
    }

    private static final Function1 $anonfun$2() {
        FileWriter$Info$ fileWriter$Info$ = FileWriter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileWriter.Info)fileWriter$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileWriter$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    private static final FileWriter.Info $anonfun$4() {
        return FileWriter$Info$.MODULE$.apply(FileWriter$Info$.MODULE$.$lessinit$greater$default$1());
    }

    private static final Panel buildPanel$$anonfun$1(FileWriter.Info info$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)PanelItem$.MODULE$.text("filepath", "File Path", info$1.filepath(), PanelItem$.MODULE$.text$default$4()), (List)Nil$.MODULE$));
    }

    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        DecoderNotDeriveSum f$proxy3;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy3 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy3 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        FileWriter$Info$ fileWriter$Info$ = FileWriter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileWriter.Info)fileWriter$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileWriter$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    private static final List $anonfun$5() {
        Encoder encodeA;
        EncoderNotDeriveSum f$proxy4;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy4 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy4 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "filepath";
        boolean size = true;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", FileWriter$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), FileWriter$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(FileWriter$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            FileWriter.Info info2 = (FileWriter.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "filepath";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(FileWriter$::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string2 = step$2.copy$default$1();
            String string3 = step$2.copy$default$2();
            String string4 = step$2.copy$default$3();
            String string5 = step$2.copy$default$4();
            String string6 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string2, string3, string4, string5, string6, json, bl, bl2);
        });
    }

    private static final FileWriter.State run$$anonfun$1$$anonfun$3$$anonfun$2(Builder.Context cxt$7, File file$5, BufferedOutputStream os$3) {
        return FileWriter$State$.MODULE$.apply(cxt$7, file$5, os$3, FileWriter$State$.MODULE$.$lessinit$greater$default$4(), FileWriter$State$.MODULE$.$lessinit$greater$default$5(), FileWriter$State$.MODULE$.$lessinit$greater$default$6());
    }

    private static final Observable run$$anonfun$1$$anonfun$3(File file$3, Observable from$2, Builder.Context cxt$5) {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file$3));
        return ((Observable)MODULE$.getBytes().apply((Object)from$2.doOnStart((Function1 & Serializable)_$3 -> cxt$5.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Opening " + file$3.getAbsolutePath()))))).foldLeft(() -> FileWriter$.run$$anonfun$1$$anonfun$3$$anonfun$2(cxt$5, file$3, os), (Function2 & Serializable)(s, bin) -> MODULE$.write((FileWriter.State)s, (BsonBinary)bin)).mapEval((Function1 & Serializable)s -> MODULE$.buildResult((FileWriter.State)s));
    }
}

