/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.jdbc;

import ambience.etl.jdbc.DocBuilder$;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;

public interface DocBuilder {
    public static BsonNull BNull() {
        return DocBuilder$.MODULE$.BNull();
    }

    public static DateTimeFormatter DateFormatter() {
        return DocBuilder$.MODULE$.DateFormatter();
    }

    public static DateTimeFormatter TimeFormatter() {
        return DocBuilder$.MODULE$.TimeFormatter();
    }

    public static DateTimeFormatter TimestampFormatter() {
        return DocBuilder$.MODULE$.TimestampFormatter();
    }

    public static void append(BsonDocument bsonDocument, String string, BsonValue bsonValue) {
        DocBuilder$.MODULE$.append(bsonDocument, string, bsonValue);
    }

    public static DocBuilder[] constructBuilders(ResultSetMetaData resultSetMetaData, boolean bl) {
        return DocBuilder$.MODULE$.constructBuilders(resultSetMetaData, bl);
    }

    public void build(BsonDocument var1, ResultSet var2);

    public static class BinaryDocBuilder
    implements DocBuilder {
        private final int idx;
        private final String name;
        private final boolean preserveNulls;

        public BinaryDocBuilder(int idx, String name, boolean preserveNulls) {
            this.idx = idx;
            this.name = name;
            this.preserveNulls = preserveNulls;
        }

        @Override
        public void build(BsonDocument doc, ResultSet rs) {
            byte[] value = rs.getBytes(this.idx);
            if (!rs.wasNull()) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)new BsonBinary(value));
            } else if (this.preserveNulls) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)DocBuilder$.MODULE$.BNull());
            }
        }
    }

    public static class BooleanDocBuilder
    implements DocBuilder {
        private final int idx;
        private final String name;
        private final boolean preserveNulls;

        public BooleanDocBuilder(int idx, String name, boolean preserveNulls) {
            this.idx = idx;
            this.name = name;
            this.preserveNulls = preserveNulls;
        }

        @Override
        public void build(BsonDocument doc, ResultSet rs) {
            boolean value = rs.getBoolean(this.idx);
            if (!rs.wasNull()) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)new BsonBoolean(value));
            } else if (this.preserveNulls) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)DocBuilder$.MODULE$.BNull());
            }
        }
    }

    public static class DateDocBuilder
    implements DocBuilder {
        private final int idx;
        private final String name;
        private final boolean preserveNulls;

        public DateDocBuilder(int idx, String name, boolean preserveNulls) {
            this.idx = idx;
            this.name = name;
            this.preserveNulls = preserveNulls;
        }

        @Override
        public void build(BsonDocument doc, ResultSet rs) {
            Date value = rs.getDate(this.idx);
            if (!rs.wasNull()) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)new BsonString(DocBuilder$.MODULE$.DateFormatter().format(value.toLocalDate())));
            } else if (this.preserveNulls) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)DocBuilder$.MODULE$.BNull());
            }
        }
    }

    public static class DecimalDocBuilder
    implements DocBuilder {
        private final int idx;
        private final String name;
        private final boolean preserveNulls;

        public DecimalDocBuilder(int idx, String name, boolean preserveNulls) {
            this.idx = idx;
            this.name = name;
            this.preserveNulls = preserveNulls;
        }

        @Override
        public void build(BsonDocument doc, ResultSet rs) {
            double value = rs.getDouble(this.idx);
            if (!rs.wasNull()) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)new BsonDouble(value));
            } else if (this.preserveNulls) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)DocBuilder$.MODULE$.BNull());
            }
        }
    }

    public static class DoubleDocBuilder
    implements DocBuilder {
        private final int idx;
        private final String name;
        private final boolean preserveNulls;

        public DoubleDocBuilder(int idx, String name, boolean preserveNulls) {
            this.idx = idx;
            this.name = name;
            this.preserveNulls = preserveNulls;
        }

        @Override
        public void build(BsonDocument doc, ResultSet rs) {
            double value = rs.getDouble(this.idx);
            if (!rs.wasNull()) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)new BsonDouble(value));
            } else if (this.preserveNulls) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)DocBuilder$.MODULE$.BNull());
            }
        }
    }

    public static class IntDocBuilder
    implements DocBuilder {
        private final int idx;
        private final String name;
        private final boolean preserveNulls;

        public IntDocBuilder(int idx, String name, boolean preserveNulls) {
            this.idx = idx;
            this.name = name;
            this.preserveNulls = preserveNulls;
        }

        @Override
        public void build(BsonDocument doc, ResultSet rs) {
            int value = rs.getInt(this.idx);
            if (!rs.wasNull()) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)new BsonInt32(value));
            } else if (this.preserveNulls) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)DocBuilder$.MODULE$.BNull());
            }
        }
    }

    public static class LongDocBuilder
    implements DocBuilder {
        private final int idx;
        private final String name;
        private final boolean preserveNulls;

        public LongDocBuilder(int idx, String name, boolean preserveNulls) {
            this.idx = idx;
            this.name = name;
            this.preserveNulls = preserveNulls;
        }

        @Override
        public void build(BsonDocument doc, ResultSet rs) {
            long value = rs.getLong(this.idx);
            if (!rs.wasNull()) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)new BsonInt64(value));
            } else if (this.preserveNulls) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)DocBuilder$.MODULE$.BNull());
            }
        }
    }

    public static class StringDocBuilder
    implements DocBuilder {
        private final int idx;
        private final String name;
        private final boolean preserveNulls;

        public StringDocBuilder(int idx, String name, boolean preserveNulls) {
            this.idx = idx;
            this.name = name;
            this.preserveNulls = preserveNulls;
        }

        @Override
        public void build(BsonDocument doc, ResultSet rs) {
            Option option = Option$.MODULE$.apply((Object)rs.getString(this.idx));
            if (option instanceof Some) {
                String s = (String)((Some)option).value();
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)new BsonString(s));
            } else if (None$.MODULE$.equals(option)) {
                if (this.preserveNulls) {
                    DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)DocBuilder$.MODULE$.BNull());
                }
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    public static class TimeDocBuilder
    implements DocBuilder {
        private final int idx;
        private final String name;
        private final boolean preserveNulls;

        public TimeDocBuilder(int idx, String name, boolean preserveNulls) {
            this.idx = idx;
            this.name = name;
            this.preserveNulls = preserveNulls;
        }

        @Override
        public void build(BsonDocument doc, ResultSet rs) {
            Time value = rs.getTime(this.idx);
            if (!rs.wasNull()) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)new BsonString(DocBuilder$.MODULE$.TimeFormatter().format(value.toLocalTime())));
            } else if (this.preserveNulls) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)DocBuilder$.MODULE$.BNull());
            }
        }
    }

    public static class TimestampDocBuilder
    implements DocBuilder {
        private final int idx;
        private final String name;
        private final boolean preserveNulls;

        public TimestampDocBuilder(int idx, String name, boolean preserveNulls) {
            this.idx = idx;
            this.name = name;
            this.preserveNulls = preserveNulls;
        }

        @Override
        public void build(BsonDocument doc, ResultSet rs) {
            Timestamp value = rs.getTimestamp(this.idx);
            if (!rs.wasNull()) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)new BsonDateTime(value.toInstant().toEpochMilli()));
            } else if (this.preserveNulls) {
                DocBuilder$.MODULE$.append(doc, this.name, (BsonValue)DocBuilder$.MODULE$.BNull());
            }
        }
    }
}

