/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.jdbc;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ChainSetIdentifier;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.Helpers$;
import ambience.etl.jdbc.ColumnInserter;
import ambience.etl.jdbc.ConnectionPool$;
import ambience.etl.jdbc.HikariPool;
import ambience.etl.jdbc.JDBCBulkInserter;
import ambience.etl.jdbc.JDBCBulkInserter$Info$;
import ambience.etl.jdbc.JDBCBulkInserter$Result$;
import ambience.etl.jdbc.JDBCInserter$;
import ambience.etl.jdbc.sql.BasicSQLBuilder;
import ambience.etl.jdbc.sql.BasicSQLBuilder$;
import ambience.etl.jdbc.sql.Dialect;
import ambience.etl.jdbc.sql.Dialect$;
import ambience.etl.jdbc.sql.JDBCMetadata;
import ambience.etl.jdbc.sql.JDBCMetadata$;
import ambience.etl.jdbc.sql.JDBCSchema;
import ambience.etl.package$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.UnorderedFoldable;
import cats.implicits$;
import cats.kernel.Order;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple5$;
import scala.collection.Iterable;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

public final class JDBCBulkInserter$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(JDBCBulkInserter$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(JDBCBulkInserter$.class.getDeclaredField("clock$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    public static final JDBCBulkInserter$Info$ Info;
    private static final Json InfoJson;
    public static final JDBCBulkInserter$Result$ Result;
    private volatile Object clock$lzy1;
    public static final JDBCBulkInserter$ MODULE$;

    private JDBCBulkInserter$() {
    }

    static {
        MODULE$ = new JDBCBulkInserter$();
        stepType = ETLStepType$.MODULE$.apply("jdbc.JDBCBulkInserter");
        JDBCBulkInserter.Info info = (JDBCBulkInserter.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)JDBCBulkInserter$Info$.MODULE$.apply(JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$1(), JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$2(), JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$3(), JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$4(), JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$5()));
        String string = "pool";
        String string2 = "table";
        String string3 = "successChainName";
        String string4 = "failureChainName";
        String string5 = "batchSize";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JDBCBulkInserter$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public Clock clock() {
        Object object = this.clock$lzy1;
        if (object instanceof Clock) {
            return (Clock)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Clock)this.clock$lzyINIT1();
    }

    private Object clock$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.clock$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Clock clock = null;
                    try {
                        clock = (Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class));
                        object2 = clock == null ? LazyVals.NullValue$.MODULE$ : clock;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.clock$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clock;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "pool";
        String string2 = "table";
        String string3 = "successChainName";
        String string4 = "failureChainName";
        String string5 = "batchSize";
        int size = 5;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCBulkInserter$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JDBCBulkInserter$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCBulkInserter$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (JDBCBulkInserter.Info)info, (Observable<Document>)from));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "pool";
        String string2 = "table";
        String string3 = "successChainName";
        String string4 = "failureChainName";
        String string5 = "batchSize";
        int size = 5;
        JDBCBulkInserter.Info info = (JDBCBulkInserter.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCBulkInserter$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JDBCBulkInserter$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCBulkInserter$::$anonfun$3))))).toOption().getOrElse(JDBCBulkInserter$::$anonfun$4);
        return JDBCInserter$.MODULE$.getTables(info.pool()).flatMap((Function1 & Serializable)tables -> Helpers$.MODULE$.getChainChoices(cxt.user(), (ChainSetIdentifier)cxt.chainSetId()).map((Function1 & Serializable)allChainChoices -> {
            Panel.SelectChoice selectChoice = Panel.SelectChoice$.MODULE$.apply("", Json$.MODULE$.fromString(""));
            List chainChoices = allChainChoices.$colon$colon((Object)selectChoice);
            List tableChoices = ((List)tables.sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)s -> Panel.SelectChoice$.MODULE$.apply(s, Json$.MODULE$.fromString(s)));
            Panel.Item poolField = PanelItem$.MODULE$.select("pool", "Database", Json$.MODULE$.fromString(info.pool()), JDBCInserter$.MODULE$.PoolChoices(), true);
            Panel.Item tableField = PanelItem$.MODULE$.select("table", "Table", Json$.MODULE$.fromString(info.table()), tableChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item successChainName = PanelItem$.MODULE$.select("successChainName", "Success Chain", Json$.MODULE$.fromString(info.successChainName()), chainChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item failureChainName = PanelItem$.MODULE$.select("failureChainName", "Failure Chain", Json$.MODULE$.fromString(info.failureChainName()), chainChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item batchSize = PanelItem$.MODULE$.integer("batchSize", "Batch Size", info.batchSize(), PanelItem$.MODULE$.integer$default$4());
            return Panel$.MODULE$.apply((List)new .colon.colon((Object)poolField, (List)new .colon.colon((Object)tableField, (List)new .colon.colon((Object)successChainName, (List)new .colon.colon((Object)failureChainName, (List)new .colon.colon((Object)batchSize, (List)Nil$.MODULE$))))));
        }));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> JDBCBulkInserter$.savePanel$$anonfun$1(results, step));
    }

    public Observable<Document> run(Builder.Context cxt, JDBCBulkInserter.Info info, Observable<Document> from) {
        Option option = ConnectionPool$.MODULE$.getPool(info.pool());
        if (option instanceof Some) {
            HikariPool pool = (HikariPool)((Some)option).value();
            Observable from2 = cxt.logStart(from, (LogMessage)LogMessage.Info$.MODULE$.apply("Got JDBC connection to " + info.pool()));
            Connection connection = pool.ds().getConnection();
            connection.setAutoCommit(false);
            DatabaseMetaData md = connection.getMetaData();
            Option<JDBCMetadata.Table> option2 = JDBCMetadata$.MODULE$.getTable(md, pool, info.table());
            if (option2 instanceof Some) {
                JDBCMetadata.Table table = (JDBCMetadata.Table)((Some)option2).value();
                return this.populateTable(cxt, info, connection, md, table, (Observable<Document>)from2).guarantee(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    JDBCBulkInserter$.run$$anonfun$1(connection);
                    return BoxedUnit.UNIT;
                }));
            }
            if (None$.MODULE$.equals(option2)) {
                return cxt.logStart(from2, (LogMessage)LogMessage.Warn$.MODULE$.apply("Can't find table " + info.table())).guarantee(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    JDBCBulkInserter$.run$$anonfun$2(connection);
                    return BoxedUnit.UNIT;
                }));
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return cxt.logStart(from, (LogMessage)LogMessage.Warn$.MODULE$.apply("Can't find pool " + info.pool()));
        }
        throw new MatchError((Object)option);
    }

    public Observable<Document> populateTable(Builder.Context cxt, JDBCBulkInserter.Info info, Connection connection, DatabaseMetaData md, JDBCMetadata.Table table, Observable<Document> from) {
        JDBCSchema schema = JDBCMetadata$.MODULE$.getSchema(md, table);
        Dialect dialect = Dialect$.MODULE$.defaultDialect();
        BasicSQLBuilder sqlBuilder = BasicSQLBuilder$.MODULE$.apply(dialect, table, schema);
        PreparedStatement ps = connection.prepareStatement(sqlBuilder.insertString());
        Either<LogMessage, Function1<Observable<Document>, Observable<Document>>> optSuccessChain = JDBCInserter$.MODULE$.buildChain(cxt, info.successChainName());
        Either<LogMessage, Function1<Observable<Document>, Observable<Document>>> optFailureChain = JDBCInserter$.MODULE$.buildChain(cxt, info.failureChainName());
        IntRef successCount = IntRef.create((int)0);
        IntRef failureCount = IntRef.create((int)0);
        LongRef startTime = LongRef.create((long)this.clock().now());
        List inserters = ((List)schema.columns().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                JDBCMetadata.Column col = (JDBCMetadata.Column)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return JDBCInserter$.MODULE$.getInserter(cxt, ps, idx + 1, col);
            }
            throw new MatchError((Object)tuple2);
        });
        return from.doOnStart((Function1 & Serializable)t -> this.atStart$1(startTime, cxt, (Either)optSuccessChain, (Either)optFailureChain, (Document)t)).bufferTumbling(info.batchSize()).flatMap((Function1 & Serializable)docs -> Observable$.MODULE$.fromTask(MODULE$.setupPs(cxt, ps, (List<ColumnInserter>)inserters, (Seq<Document>)docs)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Observable$.MODULE$.fromTask(MODULE$.run(cxt, connection, ps, (Seq<Document>)docs)).flatMap((Function1 & Serializable)failedIndexes -> Observable$.MODULE$.fromTask(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                JDBCBulkInserter$.populateTable$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(successCount, docs, failedIndexes, failureCount);
                return BoxedUnit.UNIT;
            })).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Successes: " + successCount$8.elem + " Failures: " + failureCount$8.elem))).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return MODULE$.handleFailures((Seq<Document>)docs, (Vector<Object>)failedIndexes, (Option<Function1<Observable<Document>, Observable<Document>>>)optSuccessChain.toOption(), (Option<Function1<Observable<Document>, Observable<Document>>>)optFailureChain.toOption()).map((Function1 & Serializable)ret -> ret);
                });
            }));
        })).$plus$plus(() -> this.populateTable$$anonfun$3(cxt, successCount, failureCount, ps, optSuccessChain, optFailureChain, startTime));
    }

    public Task<BoxedUnit> setupPs(Builder.Context cxt, PreparedStatement ps, List<ColumnInserter> inserters, Seq<Document> docs) {
        int docsSize = docs.size();
        return cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Processing: " + docsSize + " records")).map((Function1)(JProcedure1 & Serializable)_$1 -> docs.foreach((Function1)(JProcedure1 & Serializable)doc -> {
            ps.clearParameters();
            inserters.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.apply((Document)doc));
            ps.addBatch();
        }));
    }

    public Task<Vector<Object>> run(Builder.Context cxt, Connection connection, PreparedStatement ps, Seq<Document> docs) {
        Task task;
        try {
            ps.executeBatch();
            connection.commit();
            task = cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Batch completed")).as((Object)scala.package$.MODULE$.Vector().empty());
        }
        catch (BatchUpdateException ex) {
            task = cxt.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply("Batch error: " + ex, (Throwable)ex)).map((Function1 & Serializable)_$3 -> (Vector)((StrictOptimizedIterableOps)Predef$.MODULE$.wrapIntArray(ex.getUpdateCounts()).toVector().zipWithIndex()).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    int code = tuple2._1$mcI$sp();
                    int idx = tuple2._2$mcI$sp();
                    if (code == -3) {
                        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)idx));
                    }
                    return None$.MODULE$;
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        catch (SQLException ex) {
            task = cxt.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply("Unexpected SQL error: " + ex, (Throwable)ex)).map((Function1 & Serializable)_$4 -> docs.indices().toVector());
        }
        return task;
    }

    public Observable<Document> handleFailures(Seq<Document> docs, Vector<Object> failedIndexes, Option<Function1<Observable<Document>, Observable<Document>>> optSuccessChain, Option<Function1<Observable<Document>, Observable<Document>>> optFailureChain) {
        Set failedSet = failedIndexes.toSet();
        if (optSuccessChain.nonEmpty() || optFailureChain.nonEmpty()) {
            return Observable$.MODULE$.fromIterable((Iterable)docs.zipWithIndex()).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Document doc = (Document)tuple2._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    if (failedSet.contains((Object)BoxesRunTime.boxToInteger((int)idx))) {
                        Option option = optFailureChain;
                        if (option instanceof Some) {
                            Function1 chain = (Function1)((Some)option).value();
                            return (Observable)chain.apply((Object)Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Document[]{doc})));
                        }
                        if (None$.MODULE$.equals(option)) {
                            return Observable$.MODULE$.empty();
                        }
                        throw new MatchError((Object)option);
                    }
                    Option option = optSuccessChain;
                    if (option instanceof Some) {
                        Function1 chain = (Function1)((Some)option).value();
                        return (Observable)chain.apply((Object)Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Document[]{doc})));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Observable$.MODULE$.empty();
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return Observable$.MODULE$.empty();
    }

    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        Encoder encodeA5;
        EncoderNotDeriveSum f$proxy1;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy1 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA5 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA4 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy1;
        Configuration x$2$proxy3 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder3 = encodeA3 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this4 = f$proxy1;
        Configuration x$2$proxy4 = EncoderNotDeriveSum_this4.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder4 = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this5 = f$proxy1;
        Configuration x$2$proxy5 = EncoderNotDeriveSum_this5.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder5 = encodeA = Encoder$.MODULE$.encodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        DecoderNotDeriveSum f$proxy2;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy2 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy6 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA5 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy7 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA4 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy2;
        Configuration x$2$proxy8 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy2;
        Configuration x$2$proxy9 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this5 = f$proxy2;
        Configuration x$2$proxy10 = DecoderNotDeriveSum_this5.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder5 = decodeA = Decoder$.MODULE$.decodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 build$$anonfun$2() {
        JDBCBulkInserter$Info$ jDBCBulkInserter$Info$ = JDBCBulkInserter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCBulkInserter.Info)jDBCBulkInserter$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$5())));
    }

    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        DecoderNotDeriveSum f$proxy3;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy3 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy11 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA5 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy3;
        Configuration x$2$proxy12 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA4 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy3;
        Configuration x$2$proxy13 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy3;
        Configuration x$2$proxy14 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this5 = f$proxy3;
        Configuration x$2$proxy15 = DecoderNotDeriveSum_this5.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder5 = decodeA = Decoder$.MODULE$.decodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 $anonfun$2() {
        JDBCBulkInserter$Info$ jDBCBulkInserter$Info$ = JDBCBulkInserter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCBulkInserter.Info)jDBCBulkInserter$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$5())));
    }

    private static final JDBCBulkInserter.Info $anonfun$4() {
        return JDBCBulkInserter$Info$.MODULE$.apply(JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$1(), JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$2(), JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$3(), JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$4(), JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$5());
    }

    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        DecoderNotDeriveSum f$proxy4;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy4 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy16 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA5 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy4;
        Configuration x$2$proxy17 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA4 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy4;
        Configuration x$2$proxy18 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy4;
        Configuration x$2$proxy19 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this5 = f$proxy4;
        Configuration x$2$proxy20 = DecoderNotDeriveSum_this5.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder5 = decodeA = Decoder$.MODULE$.decodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        JDBCBulkInserter$Info$ jDBCBulkInserter$Info$ = JDBCBulkInserter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCBulkInserter.Info)jDBCBulkInserter$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)JDBCBulkInserter$Info$.MODULE$.$lessinit$greater$default$5())));
    }

    private static final List $anonfun$6() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        Encoder encodeA5;
        EncoderNotDeriveSum f$proxy5;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy5 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy21 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA5 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy5;
        Configuration x$2$proxy22 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA4 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy5;
        Configuration x$2$proxy23 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder3 = encodeA3 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this4 = f$proxy5;
        Configuration x$2$proxy24 = EncoderNotDeriveSum_this4.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder4 = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this5 = f$proxy5;
        Configuration x$2$proxy25 = EncoderNotDeriveSum_this5.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder5 = encodeA = Encoder$.MODULE$.encodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "pool";
        String string2 = "table";
        String string3 = "successChainName";
        String string4 = "failureChainName";
        String string5 = "batchSize";
        int size = 5;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCBulkInserter$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JDBCBulkInserter$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCBulkInserter$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            JDBCBulkInserter.Info info2 = (JDBCBulkInserter.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "pool";
            String string2 = "table";
            String string3 = "successChainName";
            String string4 = "failureChainName";
            String string5 = "batchSize";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(JDBCBulkInserter$::$anonfun$6, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string6 = step$2.copy$default$1();
            String string7 = step$2.copy$default$2();
            String string8 = step$2.copy$default$3();
            String string9 = step$2.copy$default$4();
            String string10 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string6, string7, string8, string9, string10, json, bl, bl2);
        });
    }

    private static final void run$$anonfun$1(Connection connection$1) {
        connection$1.close();
    }

    private static final void run$$anonfun$2(Connection connection$2) {
        connection$2.close();
    }

    private static final void atStart$1$$anonfun$1(LongRef startTime$2) {
        startTime$2.elem = MODULE$.clock().now();
    }

    private final Task atStart$1(LongRef startTime$1, Builder.Context cxt$4, Either optSuccessChain$1, Either optFailureChain$1, Document t) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            JDBCBulkInserter$.atStart$1$$anonfun$1(startTime$1);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return JDBCInserter$.MODULE$.logChainErrorT(cxt$4, (Either<LogMessage, Function1<Observable<Document>, Observable<Document>>>)optSuccessChain$1).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return JDBCInserter$.MODULE$.logChainErrorT(cxt$4, (Either<LogMessage, Function1<Observable<Document>, Observable<Document>>>)optFailureChain$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        });
    }

    private static final void atEnd$1$$anonfun$1$$anonfun$1$$anonfun$1(PreparedStatement ps$4) {
        ps$4.close();
    }

    private static final Try atEnd$1$$anonfun$1$$anonfun$1(PreparedStatement ps$3) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            JDBCBulkInserter$.atEnd$1$$anonfun$1$$anonfun$1$$anonfun$1(ps$3);
            return BoxedUnit.UNIT;
        });
    }

    private final Observable atEnd$1(Builder.Context cxt$7, IntRef successCount$1, IntRef failureCount$1, PreparedStatement ps$1, Either optSuccessChain$3, Either optFailureChain$4, LongRef startTime$3) {
        return Observable$.MODULE$.fromTask(cxt$7.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Successes: " + successCount$1.elem + " Failures: " + failureCount$1.elem))).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Observable$.MODULE$.fromTask(Task$.MODULE$.apply(() -> JDBCBulkInserter$.atEnd$1$$anonfun$1$$anonfun$1(ps$1))).flatMap((Function1 & Serializable)x$1 -> {
                Try try_ = x$1;
                return this.doAtEnd$1(optSuccessChain$3, optFailureChain$4, successCount$1, failureCount$1, startTime$3).map((Function1 & Serializable)ret -> ret);
            });
        });
    }

    private final Observable doAtEnd$1(Either optSuccessChain$5, Either optFailureChain$6, IntRef successCount$3, IntRef failureCount$3, LongRef startTime$5) {
        if (implicits$.MODULE$.toUnorderedFoldableOps((Object)optSuccessChain$5, (UnorderedFoldable)implicits$.MODULE$.catsStdInstancesForEither()).isEmpty() && implicits$.MODULE$.toUnorderedFoldableOps((Object)optFailureChain$6, (UnorderedFoldable)implicits$.MODULE$.catsStdInstancesForEither()).isEmpty()) {
            Object[] objectArray = new Document[1];
            Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"successCount");
            objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(successCount$3.elem)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"failureCount");
            objectArray2[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt32$.MODULE$.apply(failureCount$3.elem)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"elapsedTime");
            objectArray2[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt64$.MODULE$.apply(this.clock().now() - startTime$5.elem)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray[0] = package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        return Observable$.MODULE$.empty();
    }

    private static final void populateTable$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(IntRef successCount$7, Seq docs$3, Vector failedIndexes$1, IntRef failureCount$7) {
        successCount$7.elem += docs$3.size() - failedIndexes$1.size();
        failureCount$7.elem += failedIndexes$1.size();
    }

    private final Observable populateTable$$anonfun$3(Builder.Context cxt$14, IntRef successCount$11, IntRef failureCount$11, PreparedStatement ps$11, Either optSuccessChain$14, Either optFailureChain$15, LongRef startTime$9) {
        return this.atEnd$1(cxt$14, successCount$11, failureCount$11, ps$11, optSuccessChain$14, optFailureChain$15, startTime$9);
    }
}

