/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.jdbc;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ChainSetIdentifier;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.Helpers$;
import ambience.etl.jdbc.ColumnInserter;
import ambience.etl.jdbc.ConnectionPool$;
import ambience.etl.jdbc.HikariPool;
import ambience.etl.jdbc.JDBCInserter$;
import ambience.etl.jdbc.JDBCUpdater;
import ambience.etl.jdbc.JDBCUpdater$Info$;
import ambience.etl.jdbc.JDBCUpdater$Result$;
import ambience.etl.jdbc.sql.BasicSQLBuilder;
import ambience.etl.jdbc.sql.BasicSQLBuilder$;
import ambience.etl.jdbc.sql.Dialect;
import ambience.etl.jdbc.sql.Dialect$;
import ambience.etl.jdbc.sql.JDBCMetadata;
import ambience.etl.jdbc.sql.JDBCMetadata$;
import ambience.etl.jdbc.sql.JDBCSchema;
import ambience.etl.package$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.UnorderedFoldable;
import cats.implicits$;
import cats.kernel.Order;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple6$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class JDBCUpdater$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(JDBCUpdater$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(JDBCUpdater$.class.getDeclaredField("PoolChoices$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(JDBCUpdater$.class.getDeclaredField("clock$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    public static final JDBCUpdater$Info$ Info;
    private static final Json InfoJson;
    public static final JDBCUpdater$Result$ Result;
    private volatile Object clock$lzy1;
    private volatile Object PoolChoices$lzy1;
    public static final JDBCUpdater$ MODULE$;

    private JDBCUpdater$() {
    }

    static {
        MODULE$ = new JDBCUpdater$();
        stepType = ETLStepType$.MODULE$.apply("jdbc.JDBCUpdater");
        JDBCUpdater.Info info = (JDBCUpdater.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)JDBCUpdater$Info$.MODULE$.apply(JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$1(), JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$2(), JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$3(), JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$4(), JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$5(), JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$6()));
        String string = "pool";
        String string2 = "table";
        String string3 = "columns";
        String string4 = "successChainName";
        String string5 = "failureChainName";
        String string6 = "logCount";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JDBCUpdater$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public Clock clock() {
        Object object = this.clock$lzy1;
        if (object instanceof Clock) {
            return (Clock)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Clock)this.clock$lzyINIT1();
    }

    private Object clock$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.clock$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Clock clock = null;
                    try {
                        clock = (Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class));
                        object2 = clock == null ? LazyVals.NullValue$.MODULE$ : clock;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.clock$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clock;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<Panel.SelectChoice> PoolChoices() {
        Object object = this.PoolChoices$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.PoolChoices$lzyINIT1();
    }

    private Object PoolChoices$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.PoolChoices$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = ((List)ConnectionPool$.MODULE$.getPoolNames().toList().sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)s -> Panel.SelectChoice$.MODULE$.apply(s, Json$.MODULE$.fromString(s)));
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.PoolChoices$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "pool";
        String string2 = "table";
        String string3 = "columns";
        String string4 = "successChainName";
        String string5 = "failureChainName";
        String string6 = "logCount";
        int size = 6;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCUpdater$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JDBCUpdater$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCUpdater$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (JDBCUpdater.Info)info, (Observable<Document>)from));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "pool";
        String string2 = "table";
        String string3 = "columns";
        String string4 = "successChainName";
        String string5 = "failureChainName";
        String string6 = "logCount";
        int size = 6;
        JDBCUpdater.Info info = (JDBCUpdater.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCUpdater$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JDBCUpdater$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCUpdater$::$anonfun$3))))).toOption().getOrElse(JDBCUpdater$::$anonfun$4);
        return JDBCInserter$.MODULE$.getTables(info.pool()).flatMap((Function1 & Serializable)tables -> Helpers$.MODULE$.getChainChoices(cxt.user(), (ChainSetIdentifier)cxt.chainSetId()).map((Function1 & Serializable)allChainChoices -> {
            Panel.SelectChoice selectChoice = Panel.SelectChoice$.MODULE$.apply("", Json$.MODULE$.fromString(""));
            List chainChoices = allChainChoices.$colon$colon((Object)selectChoice);
            List tableChoices = ((List)tables.sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)s -> Panel.SelectChoice$.MODULE$.apply(s, Json$.MODULE$.fromString(s)));
            Panel.Item poolField = PanelItem$.MODULE$.select("pool", "Database", Json$.MODULE$.fromString(info.pool()), MODULE$.PoolChoices(), true);
            Panel.Item tableField = PanelItem$.MODULE$.select("table", "Table", Json$.MODULE$.fromString(info.table()), tableChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item columnsField = PanelItem$.MODULE$.textList("columns", "Columns", info.columns());
            Panel.Item successChainName = PanelItem$.MODULE$.select("successChainName", "Success Chain", Json$.MODULE$.fromString(info.successChainName()), chainChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item failureChainName = PanelItem$.MODULE$.select("failureChainName", "Failure Chain", Json$.MODULE$.fromString(info.failureChainName()), chainChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item logCount = PanelItem$.MODULE$.integer("logCount", "Log Every", info.logCount(), PanelItem$.MODULE$.integer$default$4());
            return Panel$.MODULE$.apply((List)new .colon.colon((Object)poolField, (List)new .colon.colon((Object)tableField, (List)new .colon.colon((Object)columnsField, (List)new .colon.colon((Object)successChainName, (List)new .colon.colon((Object)failureChainName, (List)new .colon.colon((Object)logCount, (List)Nil$.MODULE$)))))));
        }));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> JDBCUpdater$.savePanel$$anonfun$1(results, step));
    }

    public Observable<Document> run(Builder.Context cxt, JDBCUpdater.Info info, Observable<Document> from) {
        this.log().info(JDBCUpdater$::run$$anonfun$1, Line$.MODULE$.apply(65), FullName$.MODULE$.apply("ambience.etl.jdbc.JDBCUpdater.run"));
        Option option = ConnectionPool$.MODULE$.getPool(info.pool());
        if (option instanceof Some) {
            HikariPool pool = (HikariPool)((Some)option).value();
            this.log().info(() -> JDBCUpdater$.run$$anonfun$2(info), Line$.MODULE$.apply(68), FullName$.MODULE$.apply("ambience.etl.jdbc.JDBCUpdater.run"));
            Observable from2 = cxt.logStart(from, (LogMessage)LogMessage.Info$.MODULE$.apply("Got JDBC connection to " + info.pool()));
            Connection connection = pool.ds().getConnection();
            DatabaseMetaData md = connection.getMetaData();
            this.log().info(JDBCUpdater$::run$$anonfun$3, Line$.MODULE$.apply(72), FullName$.MODULE$.apply("ambience.etl.jdbc.JDBCUpdater.run"));
            Option<JDBCMetadata.Table> option2 = JDBCMetadata$.MODULE$.getTable(md, pool, info.table());
            if (option2 instanceof Some) {
                JDBCMetadata.Table table = (JDBCMetadata.Table)((Some)option2).value();
                return this.populateTable(cxt, info, connection, md, table, (Observable<Document>)from2).guarantee(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    JDBCUpdater$.run$$anonfun$4(connection);
                    return BoxedUnit.UNIT;
                }));
            }
            if (None$.MODULE$.equals(option2)) {
                return cxt.logStart(from2, (LogMessage)LogMessage.Warn$.MODULE$.apply("Can't find table " + info.table())).guarantee(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    JDBCUpdater$.run$$anonfun$5(connection);
                    return BoxedUnit.UNIT;
                }));
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return cxt.logStart(from, (LogMessage)LogMessage.Warn$.MODULE$.apply("Can't find pool " + info.pool()));
        }
        throw new MatchError((Object)option);
    }

    public Observable<Document> populateTable(Builder.Context cxt, JDBCUpdater.Info info, Connection connection, DatabaseMetaData md, JDBCMetadata.Table table, Observable<Document> from) {
        this.log().info(JDBCUpdater$::populateTable$$anonfun$1, Line$.MODULE$.apply(89), FullName$.MODULE$.apply("ambience.etl.jdbc.JDBCUpdater.populateTable"));
        JDBCSchema schema = JDBCMetadata$.MODULE$.getSchema(md, table);
        Dialect dialect = Dialect$.MODULE$.defaultDialect();
        BasicSQLBuilder sqlBuilder = BasicSQLBuilder$.MODULE$.apply(dialect, table, schema);
        Option<String> option = sqlBuilder.updateString(info.columns());
        if (option instanceof Some) {
            String sql = (String)((Some)option).value();
            return this.populateTableSQL(cxt, info, connection, schema, from, sql);
        }
        if (None$.MODULE$.equals(option)) {
            return Observable$.MODULE$.raiseError((Throwable)new RuntimeException("Table has no primary keys"));
        }
        throw new MatchError(option);
    }

    public Observable<Document> populateTableSQL(Builder.Context cxt, JDBCUpdater.Info info, Connection connection, JDBCSchema schema, Observable<Document> from, String sql) {
        this.log().info(() -> JDBCUpdater$.populateTableSQL$$anonfun$1(sql), Line$.MODULE$.apply(107), FullName$.MODULE$.apply("ambience.etl.jdbc.JDBCUpdater.populateTableSQL"));
        PreparedStatement ps = connection.prepareStatement(sql);
        Either<LogMessage, Function1<Observable<Document>, Observable<Document>>> optSuccessChain = JDBCInserter$.MODULE$.buildChain(cxt, info.successChainName());
        Either<LogMessage, Function1<Observable<Document>, Observable<Document>>> optFailureChain = JDBCInserter$.MODULE$.buildChain(cxt, info.failureChainName());
        IntRef successCount = IntRef.create((int)0);
        IntRef failureCount = IntRef.create((int)0);
        LongRef startTime = LongRef.create((long)this.clock().now());
        List<ColumnInserter> inserters = this.buildInserters(cxt, info, ps, schema);
        this.log().info(() -> JDBCUpdater$.populateTableSQL$$anonfun$2(inserters), Line$.MODULE$.apply(117), FullName$.MODULE$.apply("ambience.etl.jdbc.JDBCUpdater.populateTableSQL"));
        return from.doOnStart((Function1 & Serializable)t -> this.atStart$1(startTime, cxt, sql, (Either)optSuccessChain, (Either)optFailureChain, (List)inserters, (Document)t)).flatMap((Function1 & Serializable)doc -> {
            Observable observable;
            block6: {
                ps.clearParameters();
                inserters.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.apply((Document)doc));
                try {
                    ps.executeUpdate();
                    ++successCount$4.elem;
                    Option option = optSuccessChain.toOption();
                    if (option instanceof Some) {
                        Function1 chain = (Function1)((Some)option).value();
                        observable = (Observable)chain.apply((Object)Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Document[]{doc})));
                        break block6;
                    }
                    if (None$.MODULE$.equals(option)) {
                        observable = Observable$.MODULE$.empty();
                        break block6;
                    }
                    throw new MatchError((Object)option);
                }
                catch (SQLException ex) {
                    MODULE$.log().error(() -> JDBCUpdater$.$anonfun$7(ex), (Throwable)ex, Line$.MODULE$.apply(164), FullName$.MODULE$.apply("ambience.etl.jdbc.JDBCUpdater.ret"));
                    ++failureCount$4.elem;
                    Option option = optFailureChain.toOption();
                    if (option instanceof Some) {
                        Function1 chain = (Function1)((Some)option).value();
                        observable = (Observable)chain.apply((Object)Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Document[]{doc})));
                    }
                    if (None$.MODULE$.equals(option)) {
                        observable = Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply("Error inserting: " + ex, (Throwable)ex))).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return Observable$.MODULE$.empty().map((Function1 & Serializable)ret -> ret);
                        });
                    }
                    throw new MatchError((Object)option);
                }
            }
            Observable ret = observable;
            Task task = successCount$4.elem + failureCount$4.elem % scala.math.package$.MODULE$.max(1, info.logCount()) == 0 ? cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Successes: " + successCount$4.elem + " Failures: " + failureCount$4.elem)) : Task$.MODULE$.unit();
            return Observable$.MODULE$.fromTask(task).flatMap((Function1 & Serializable)_$2 -> ret);
        }).$plus$plus(() -> this.populateTableSQL$$anonfun$5(cxt, successCount, failureCount, ps, optSuccessChain, optFailureChain, startTime));
    }

    public List<ColumnInserter> buildInserters(Builder.Context cxt, JDBCUpdater.Info info, PreparedStatement ps, JDBCSchema schema) {
        List<JDBCMetadata.PrimaryKey> primaryKeys = schema.primaryKeys();
        Set keyNames = primaryKeys.map((Function1 & Serializable)_$3 -> _$3.column()).toSet();
        List cols = schema.columns().filter((Function1 & Serializable)col -> info.columns().contains((Object)col.name())).filterNot((Function1 & Serializable)col -> keyNames.contains((Object)col.name()));
        List pks = primaryKeys.flatMap((Function1 & Serializable)pk -> schema.columns().find((Function1 & Serializable)_$4 -> {
            String string = _$4.name();
            String string2 = pk.column();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
        return ((List)pks.$colon$colon$colon(cols).zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                JDBCMetadata.Column col = (JDBCMetadata.Column)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return JDBCInserter$.MODULE$.getInserter(cxt, ps, idx + 1, col);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder.AsArray encodeA4;
        Encoder encodeA5;
        Encoder encodeA6;
        EncoderNotDeriveSum f$proxy1;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy1 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA6 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA5 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy1;
        Configuration x$2$proxy3 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder.AsArray asArray = encodeA4 = Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString());
        EncoderNotDeriveSum EncoderNotDeriveSum_this4 = f$proxy1;
        Configuration x$2$proxy4 = EncoderNotDeriveSum_this4.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder3 = encodeA3 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this5 = f$proxy1;
        Configuration x$2$proxy5 = EncoderNotDeriveSum_this5.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder4 = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this6 = f$proxy1;
        Configuration x$2$proxy6 = EncoderNotDeriveSum_this6.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder5 = encodeA = Encoder$.MODULE$.encodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)asArray).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        Decoder decodeA6;
        DecoderNotDeriveSum f$proxy2;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy2 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy7 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA6 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy8 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA5 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy2;
        Configuration x$2$proxy9 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA4 = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString());
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy2;
        Configuration x$2$proxy10 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this5 = f$proxy2;
        Configuration x$2$proxy11 = DecoderNotDeriveSum_this5.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder5 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this6 = f$proxy2;
        Configuration x$2$proxy12 = DecoderNotDeriveSum_this6.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder6 = decodeA = Decoder$.MODULE$.decodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder6).$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 build$$anonfun$2() {
        JDBCUpdater$Info$ jDBCUpdater$Info$ = JDBCUpdater$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCUpdater.Info)jDBCUpdater$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply(JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$6())));
    }

    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        Decoder decodeA6;
        DecoderNotDeriveSum f$proxy3;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy3 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy13 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA6 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy3;
        Configuration x$2$proxy14 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA5 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy3;
        Configuration x$2$proxy15 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA4 = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString());
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy3;
        Configuration x$2$proxy16 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this5 = f$proxy3;
        Configuration x$2$proxy17 = DecoderNotDeriveSum_this5.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder5 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this6 = f$proxy3;
        Configuration x$2$proxy18 = DecoderNotDeriveSum_this6.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder6 = decodeA = Decoder$.MODULE$.decodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder6).$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 $anonfun$2() {
        JDBCUpdater$Info$ jDBCUpdater$Info$ = JDBCUpdater$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCUpdater.Info)jDBCUpdater$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply(JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$6())));
    }

    private static final JDBCUpdater.Info $anonfun$4() {
        return JDBCUpdater$Info$.MODULE$.apply(JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$1(), JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$2(), JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$3(), JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$4(), JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$5(), JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$6());
    }

    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        Decoder decodeA6;
        DecoderNotDeriveSum f$proxy4;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy4 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy19 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA6 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy4;
        Configuration x$2$proxy20 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA5 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy4;
        Configuration x$2$proxy21 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA4 = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString());
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy4;
        Configuration x$2$proxy22 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this5 = f$proxy4;
        Configuration x$2$proxy23 = DecoderNotDeriveSum_this5.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder5 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this6 = f$proxy4;
        Configuration x$2$proxy24 = DecoderNotDeriveSum_this6.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder6 = decodeA = Decoder$.MODULE$.decodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder6).$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        JDBCUpdater$Info$ jDBCUpdater$Info$ = JDBCUpdater$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCUpdater.Info)jDBCUpdater$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply(JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)JDBCUpdater$Info$.MODULE$.$lessinit$greater$default$6())));
    }

    private static final List $anonfun$6() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder.AsArray encodeA4;
        Encoder encodeA5;
        Encoder encodeA6;
        EncoderNotDeriveSum f$proxy5;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy5 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy25 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA6 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy5;
        Configuration x$2$proxy26 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA5 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy5;
        Configuration x$2$proxy27 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder.AsArray asArray = encodeA4 = Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString());
        EncoderNotDeriveSum EncoderNotDeriveSum_this4 = f$proxy5;
        Configuration x$2$proxy28 = EncoderNotDeriveSum_this4.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder3 = encodeA3 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this5 = f$proxy5;
        Configuration x$2$proxy29 = EncoderNotDeriveSum_this5.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder4 = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this6 = f$proxy5;
        Configuration x$2$proxy30 = EncoderNotDeriveSum_this6.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder5 = encodeA = Encoder$.MODULE$.encodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)asArray).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "pool";
        String string2 = "table";
        String string3 = "columns";
        String string4 = "successChainName";
        String string5 = "failureChainName";
        String string6 = "logCount";
        int size = 6;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCUpdater$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JDBCUpdater$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCUpdater$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            JDBCUpdater.Info info2 = (JDBCUpdater.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "pool";
            String string2 = "table";
            String string3 = "columns";
            String string4 = "successChainName";
            String string5 = "failureChainName";
            String string6 = "logCount";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(JDBCUpdater$::$anonfun$6, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string7 = step$2.copy$default$1();
            String string8 = step$2.copy$default$2();
            String string9 = step$2.copy$default$3();
            String string10 = step$2.copy$default$4();
            String string11 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string7, string8, string9, string10, string11, json, bl, bl2);
        });
    }

    private static final Object run$$anonfun$1() {
        return "run";
    }

    private static final Object run$$anonfun$2(JDBCUpdater.Info info$4) {
        return "Got JDBC connection to " + info$4.pool();
    }

    private static final Object run$$anonfun$3() {
        return "run metadata available";
    }

    private static final void run$$anonfun$4(Connection connection$1) {
        connection$1.close();
    }

    private static final void run$$anonfun$5(Connection connection$2) {
        connection$2.close();
    }

    private static final Object populateTable$$anonfun$1() {
        return "populateTable";
    }

    private static final Object populateTableSQL$$anonfun$1(String sql$1) {
        return "populateTableSQL " + sql$1;
    }

    private static final Object populateTableSQL$$anonfun$2(List inserters$1) {
        return "Inserters: " + inserters$1.mkString(",");
    }

    private static final void atStart$1$$anonfun$1(LongRef startTime$2) {
        startTime$2.elem = MODULE$.clock().now();
    }

    private final Task atStart$1(LongRef startTime$1, Builder.Context cxt$4, String sql$2, Either optSuccessChain$1, Either optFailureChain$1, List inserters$2, Document t) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            JDBCUpdater$.atStart$1$$anonfun$1(startTime$1);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return cxt$4.logT((LogMessage)LogMessage.Debug$.MODULE$.apply(sql$2)).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return JDBCInserter$.MODULE$.logChainErrorT(cxt$4, (Either<LogMessage, Function1<Observable<Document>, Observable<Document>>>)optSuccessChain$1).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return JDBCInserter$.MODULE$.logChainErrorT(cxt$4, (Either<LogMessage, Function1<Observable<Document>, Observable<Document>>>)optFailureChain$1).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return cxt$4.logT((LogMessage)LogMessage.Debug$.MODULE$.apply("Inserters: " + inserters$2.mkString(","))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    });
                });
            });
        });
    }

    private static final void atEnd$1$$anonfun$1$$anonfun$1$$anonfun$1(PreparedStatement ps$4) {
        ps$4.close();
    }

    private static final Try atEnd$1$$anonfun$1$$anonfun$1(PreparedStatement ps$3) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            JDBCUpdater$.atEnd$1$$anonfun$1$$anonfun$1$$anonfun$1(ps$3);
            return BoxedUnit.UNIT;
        });
    }

    private final Observable atEnd$1(Builder.Context cxt$9, IntRef successCount$1, IntRef failureCount$1, PreparedStatement ps$1, Either optSuccessChain$4, Either optFailureChain$5, LongRef startTime$3) {
        return Observable$.MODULE$.fromTask(cxt$9.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Successes: " + successCount$1.elem + " Failures: " + failureCount$1.elem))).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Observable$.MODULE$.fromTask(Task$.MODULE$.apply(() -> JDBCUpdater$.atEnd$1$$anonfun$1$$anonfun$1(ps$1))).flatMap((Function1 & Serializable)x$1 -> {
                Try try_ = x$1;
                return this.doAtEnd$1(optSuccessChain$4, optFailureChain$5, successCount$1, failureCount$1, startTime$3).map((Function1 & Serializable)ret -> ret);
            });
        });
    }

    private final Observable doAtEnd$1(Either optSuccessChain$6, Either optFailureChain$7, IntRef successCount$3, IntRef failureCount$3, LongRef startTime$5) {
        if (implicits$.MODULE$.toUnorderedFoldableOps((Object)optSuccessChain$6, (UnorderedFoldable)implicits$.MODULE$.catsStdInstancesForEither()).isEmpty() && implicits$.MODULE$.toUnorderedFoldableOps((Object)optFailureChain$7, (UnorderedFoldable)implicits$.MODULE$.catsStdInstancesForEither()).isEmpty()) {
            Object[] objectArray = new Document[1];
            Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"successCount");
            objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(successCount$3.elem)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"failureCount");
            objectArray2[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt32$.MODULE$.apply(failureCount$3.elem)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"elapsedTime");
            objectArray2[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt64$.MODULE$.apply(this.clock().now() - startTime$5.elem)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray[0] = package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        return Observable$.MODULE$.empty();
    }

    private static final Object $anonfun$7(SQLException ex$1) {
        return "executeUpdate: " + ex$1;
    }

    private final Observable populateTableSQL$$anonfun$5(Builder.Context cxt$13, IntRef successCount$6, IntRef failureCount$6, PreparedStatement ps$8, Either optSuccessChain$10, Either optFailureChain$11, LongRef startTime$9) {
        return this.atEnd$1(cxt$13, successCount$6, failureCount$6, ps$8, optSuccessChain$10, optFailureChain$11, startTime$9);
    }
}

