/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.jdbc.sql;

import ambience.etl.jdbc.sql.BasicSQLBuilder$;
import ambience.etl.jdbc.sql.Dialect;
import ambience.etl.jdbc.sql.ISQLBuilder;
import ambience.etl.jdbc.sql.JDBCMetadata;
import ambience.etl.jdbc.sql.JDBCSchema;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;

public class BasicSQLBuilder
implements ISQLBuilder {
    private final JDBCMetadata.Table table;
    private final JDBCSchema schema;

    public static BasicSQLBuilder apply(Dialect dialect, JDBCMetadata.Table table, JDBCSchema jDBCSchema) {
        return BasicSQLBuilder$.MODULE$.apply(dialect, table, jDBCSchema);
    }

    public BasicSQLBuilder(Dialect dialect, JDBCMetadata.Table table, JDBCSchema schema) {
        this.table = table;
        this.schema = schema;
    }

    @Override
    public String insertString() {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(this.sqlName(this.table));
        sql.append(" (");
        sql.append(this.schema.columns().map((Function1 & Serializable)col -> this.sqlName(col.name())).mkString(","));
        sql.append(") VALUES (");
        sql.append(this.schema.columns().map((Function1 & Serializable)_$1 -> "?").mkString(","));
        sql.append(")");
        return sql.toString();
    }

    @Override
    public Option<String> updateString() {
        List<JDBCMetadata.PrimaryKey> primaryKeys = this.schema.primaryKeys();
        if (primaryKeys.isEmpty()) {
            return None$.MODULE$;
        }
        Set keyNames = primaryKeys.map((Function1 & Serializable)_$2 -> _$2.column()).toSet();
        List cols = this.schema.columns().filterNot((Function1 & Serializable)col -> keyNames.contains((Object)col.name()));
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(this.sqlName(this.table));
        sql.append(" SET ");
        sql.append(cols.map((Function1 & Serializable)col -> this.sqlName(col.name()) + "=?").mkString(", "));
        sql.append(" WHERE ");
        sql.append(primaryKeys.map((Function1 & Serializable)col -> this.sqlName(col.column()) + "=?").mkString(" AND "));
        return Some$.MODULE$.apply((Object)sql.toString());
    }

    @Override
    public Option<String> updateString(List<String> columns) {
        List<JDBCMetadata.PrimaryKey> primaryKeys = this.schema.primaryKeys();
        if (primaryKeys.isEmpty()) {
            return None$.MODULE$;
        }
        Set keyNames = primaryKeys.map((Function1 & Serializable)_$3 -> _$3.column()).toSet();
        List cols = this.schema.columns().filter((Function1 & Serializable)col -> columns.contains((Object)col.name())).filterNot((Function1 & Serializable)col -> keyNames.contains((Object)col.name()));
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(this.sqlName(this.table));
        sql.append(" SET ");
        sql.append(cols.map((Function1 & Serializable)col -> this.sqlName(col.name()) + "=?").mkString(", "));
        sql.append(" WHERE ");
        sql.append(primaryKeys.map((Function1 & Serializable)col -> this.sqlName(col.column()) + "=?").mkString(" AND "));
        return Some$.MODULE$.apply((Object)sql.toString());
    }

    public String sqlName(JDBCMetadata.Table t) {
        String catalogSeparator = this.schema.catalogSeparator().isEmpty() ? "." : this.schema.catalogSeparator();
        return ((List)((StrictOptimizedIterableOps)new .colon.colon(t.catalog(), (List)new .colon.colon(t.schema(), (List)new .colon.colon((Object)Some$.MODULE$.apply((Object)t.name()), (List)Nil$.MODULE$)))).flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)s -> this.sqlName((String)s)).mkString(catalogSeparator);
    }

    public String sqlName(String s) {
        return this.schema.idQuote() + s + this.schema.idQuote();
    }
}

