/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.xlsx;

import ambience.etl.BsonExtractJson$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLJsonParsingException;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.ETLURL;
import ambience.etl.ETLURL$;
import ambience.etl.package$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.etl.xlsx.XlsxCategory$;
import ambience.etl.xlsx.XlsxDefinition;
import ambience.etl.xlsx.XlsxDefinition$;
import ambience.etl.xlsx.XlsxRichReader;
import ambience.etl.xlsx.XlsxRichReader$Header$;
import ambience.etl.xlsx.XlsxRichReader$Info$;
import ambience.etl.xlsx.XlsxRichReader$Record$;
import ambience.etl.xlsx.XlsxRichReader$XlsxRecordDef$;
import ambience.etl.xlsx.XlsxRichReader$XlsxStream$;
import ambience.etl.xlsx.XlsxRichToHtml$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.BsonUtils$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Byte$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple6$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class XlsxRichReader$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(XlsxRichReader$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    public static final XlsxRichReader$Info$ Info;
    private static final Json InfoJson;
    public static final XlsxRichReader$XlsxRecordDef$ XlsxRecordDef;
    public static final XlsxRichReader$Header$ Header;
    public static final XlsxRichReader$XlsxStream$ XlsxStream;
    public static final XlsxRichReader$Record$ Record;
    private static final Function1 getDef;
    private static final Function1 defToStream;
    private static final Function1 streamToRecord;
    private static final Function1 setBase;
    public static final XlsxRichReader$ MODULE$;

    private XlsxRichReader$() {
    }

    static {
        MODULE$ = new XlsxRichReader$();
        stepType = ETLStepType$.MODULE$.apply("xlsx.RichReader");
        XlsxRichReader.Info info = (XlsxRichReader.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)XlsxRichReader$Info$.MODULE$.apply(XlsxRichReader$Info$.MODULE$.$lessinit$greater$default$1(), XlsxRichReader$Info$.MODULE$.$lessinit$greater$default$2()));
        String string = "htmlFields";
        String string2 = "urlRegex";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        getDef = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)doc -> {
            Json json = BsonExtractJson$.MODULE$.toJson((BsonValue)doc.toBsonDocument());
            String string = "url";
            String string2 = "sheet";
            String string3 = "headerRows";
            String string4 = "startRow";
            String string5 = "password";
            String string6 = "base";
            int size = 6;
            Either either = XlsxDefinition$.MODULE$.XlsxDefinitionJson().deepMerge(json).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("XlsxDefinition", this::$init$$$anonfun$2$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::$init$$$anonfun$2$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::$init$$$anonfun$2$$anonfun$1$$anonfun$3)))));
            if (either instanceof Right) {
                XlsxDefinition xdef = (XlsxDefinition)((Right)either).value();
                return Observable$.MODULE$.now((Object)XlsxRichReader$XlsxRecordDef$.MODULE$.apply((Document)doc, xdef));
            }
            if (either instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either).value();
                return Observable$.MODULE$.raiseError((Throwable)new ETLJsonParsingException("Can't read XlsxDefinition", json, (Throwable)err));
            }
            throw new MatchError((Object)either);
        });
        defToStream = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)xlsxDef -> {
            ETLURL url = ETLURL$.MODULE$.apply(xlsxDef.doc(), xlsxDef.xdef().url());
            boolean readable = url.optFile().forall((Function1 & Serializable)f -> this.canRead((File)f));
            if (!readable) {
                return Observable$.MODULE$.raiseError((Throwable)new IOException("XlsxRichReader reading from " + xlsxDef.xdef().url() + " disallowed (see elixir.data.xlsx.readable)"));
            }
            InputStream in = url.openStream();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(xlsxDef.xdef().password()))) {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                EncryptionInfo encInfo = new EncryptionInfo(fs);
                Decryptor dec = encInfo.getDecryptor();
                dec.verifyPassword(Crypt$.MODULE$.encPrefixDecrypt(xlsxDef.xdef().password()));
                InputStream dataStream = dec.getDataStream(fs);
                XSSFWorkbook wb = new XSSFWorkbook(dataStream);
                return Observable$.MODULE$.now((Object)XlsxRichReader$XlsxStream$.MODULE$.apply(xlsxDef.xdef(), wb)).guarantee(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.$init$$$anonfun$3$$anonfun$1$$anonfun$1(wb, dataStream, in);
                    return BoxedUnit.UNIT;
                }));
            }
            XSSFWorkbook wb = new XSSFWorkbook(in);
            return Observable$.MODULE$.now((Object)XlsxRichReader$XlsxStream$.MODULE$.apply(xlsxDef.xdef(), wb)).guarantee(Task$.MODULE$.apply(() -> this.$init$$$anonfun$3$$anonfun$1$$anonfun$2(wb)).void());
        });
        streamToRecord = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)in -> {
            Option optBase = Try$.MODULE$.apply(() -> this.$anonfun$2(in)).toOption();
            Iterator it = in.xlsxDef().sheet().trim().isEmpty() ? CollectionConverters$.MODULE$.IteratorHasAsScala(in.workbook().sheetIterator()).asScala().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Sheet x) {
                    Sheet sheet = x;
                    if (sheet instanceof XSSFSheet) {
                        XSSFSheet x2 = (XSSFSheet)sheet;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Sheet x, Function1 function1) {
                    Sheet sheet = x;
                    if (sheet instanceof XSSFSheet) {
                        XSSFSheet x2 = (XSSFSheet)sheet;
                        return x2;
                    }
                    return function1.apply((Object)x);
                }
            }).flatMap((Function1 & Serializable)sheet -> {
                List headers = in.xlsxDef().headerRows().map((Function1 & Serializable)_$1 -> this.$anonfun$4((XSSFSheet)sheet, BoxesRunTime.unboxToInt((Object)_$1)));
                XlsxRichReader.Header header = (XlsxRichReader.Header)headers.foldLeft((Object)XlsxRichReader$Header$.MODULE$.apply((List<String>)scala.package$.MODULE$.Nil()), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        XlsxRichReader.Header a = (XlsxRichReader.Header)tuple2._1();
                        XlsxRichReader.Header b = (XlsxRichReader.Header)tuple2._2();
                        return a.mergeWith(b);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return this.buildRows((XSSFSheet)sheet, in.xlsxDef().startRow(), header, (Option<String>)Some$.MODULE$.apply((Object)sheet.getSheetName())).iterator();
            }) : (Iterator)Option$.MODULE$.apply((Object)in.workbook().getSheet(in.xlsxDef().sheet())).map((Function1 & Serializable)sheet -> {
                List headers = in.xlsxDef().headerRows().map((Function1 & Serializable)_$2 -> this.$anonfun$7((XSSFSheet)sheet, BoxesRunTime.unboxToInt((Object)_$2)));
                XlsxRichReader.Header header = (XlsxRichReader.Header)headers.foldLeft((Object)XlsxRichReader$Header$.MODULE$.apply((List<String>)scala.package$.MODULE$.Nil()), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        XlsxRichReader.Header a = (XlsxRichReader.Header)tuple2._1();
                        XlsxRichReader.Header b = (XlsxRichReader.Header)tuple2._2();
                        return a.mergeWith(b);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return this.buildRows((XSSFSheet)sheet, in.xlsxDef().startRow(), header, (Option<String>)None$.MODULE$).iterator();
            }).getOrElse(this::$anonfun$9);
            return Observable$.MODULE$.fromIterator(Task$.MODULE$.apply(() -> this.$init$$$anonfun$4$$anonfun$1$$anonfun$1(it))).map((Function1 & Serializable)doc -> XlsxRichReader$Record$.MODULE$.apply((Option<Document>)optBase, (Document)doc));
        });
        setBase = (Function1 & Serializable)from -> from.map((Function1 & Serializable)rec -> {
            Option<Document> option = rec.optBase();
            if (option instanceof Some) {
                Document base = (Document)((Some)option).value();
                return base.$plus$plus((IterableOnce)rec.actual());
            }
            if (None$.MODULE$.equals(option)) {
                return rec.actual();
            }
            throw new MatchError(option);
        });
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(XlsxRichReader$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "htmlFields";
        String string2 = "urlRegex";
        int size = 2;
        XlsxRichReader.Info info = (XlsxRichReader.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", XlsxRichReader$::$anonfun$11, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), XlsxRichReader$::$anonfun$12, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(XlsxRichReader$::$anonfun$13))))).toOption().getOrElse(XlsxRichReader$::$anonfun$14);
        Panel.Item htmlFields = PanelItem$.MODULE$.text("htmlFields", "Html Fields", info.htmlFields(), PanelItem$.MODULE$.text$default$4());
        Panel.Item urlRegexField = PanelItem$.MODULE$.text("urlRegex", "URL Regex", info.urlRegex(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> XlsxRichReader$.buildPanel$$anonfun$1(htmlFields, urlRegexField));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> XlsxRichReader$.savePanel$$anonfun$1(results, step));
    }

    public Function1<Observable<Document>, Observable<XlsxRichReader.XlsxRecordDef>> getDef() {
        return getDef;
    }

    public Function1<Observable<XlsxRichReader.XlsxRecordDef>, Observable<XlsxRichReader.XlsxStream>> defToStream() {
        return defToStream;
    }

    public Function1<Observable<XlsxRichReader.XlsxStream>, Observable<XlsxRichReader.Record>> streamToRecord() {
        return streamToRecord;
    }

    public Function1<Observable<XlsxRichReader.Record>, Observable<Document>> setBase() {
        return setBase;
    }

    public Function1<Observable<Document>, Observable<Document>> richtextToHtml(XlsxRichReader.Info info) {
        return (Function1 & Serializable)from -> {
            Function1 & Serializable fn = (Function1 & Serializable)rec -> XlsxRichToHtml$.MODULE$.apply(info, (Document)rec);
            return from.map((Function1)fn);
        };
    }

    public Function1<Observable<Document>, Observable<Document>> pipeline(Builder.Context cxt, XlsxRichReader.Info info) {
        return this.getDef().andThen(this.defToStream()).andThen(this.streamToRecord()).andThen(this.setBase()).andThen(this.richtextToHtml(info));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "htmlFields";
        String string2 = "urlRegex";
        int size = 2;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", XlsxRichReader$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), XlsxRichReader$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(XlsxRichReader$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> MODULE$.pipeline(cxt, (XlsxRichReader.Info)info));
    }

    public XlsxRichReader.Header buildHeader(XSSFSheet sheet, int i) {
        return (XlsxRichReader.Header)Option$.MODULE$.apply((Object)sheet.getRow(i - 1)).map((Function1 & Serializable)row -> XlsxRichReader$Header$.MODULE$.apply((List<String>)MODULE$.headerText((XSSFRow)row, 0).toList())).getOrElse(XlsxRichReader$::buildHeader$$anonfun$2);
    }

    public LazyList<String> headerText(XSSFRow row, int col) {
        Option option = Option$.MODULE$.apply((Object)row.getCell(col));
        if (option instanceof Some) {
            XSSFCell cell = (XSSFCell)((Some)option).value();
            scala.package$.MODULE$.LazyList();
            return LazyList.cons$.MODULE$.apply(() -> XlsxRichReader$.headerText$$anonfun$1(cell), () -> XlsxRichReader$.headerText$$anonfun$2(row, col));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.LazyList().empty();
        }
        throw new MatchError((Object)option);
    }

    public LazyList<Document> buildRows(XSSFSheet sheet, int i, XlsxRichReader.Header header, Option<String> optSheetName) {
        Option<Document> option = this.buildRow(sheet, i, header, optSheetName);
        if (option instanceof Some) {
            Document doc = (Document)((Some)option).value();
            scala.package$.MODULE$.LazyList();
            return LazyList.cons$.MODULE$.apply(() -> XlsxRichReader$.buildRows$$anonfun$1(doc), () -> XlsxRichReader$.buildRows$$anonfun$2(sheet, i, header, optSheetName));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.LazyList().empty();
        }
        throw new MatchError(option);
    }

    public Option<Document> buildRow(XSSFSheet sheet, int i, XlsxRichReader.Header header, Option<String> optSheetName) {
        BsonDocument doc = new BsonDocument();
        return Option$.MODULE$.apply((Object)sheet.getRow(i - 1)).map((Function1 & Serializable)row -> {
            ((List)header.names().zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String h = (String)tuple2._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return doc.append(h, MODULE$.cellValue((XSSFRow)row, idx));
                }
                throw new MatchError((Object)tuple2);
            });
            optSheetName.foreach((Function1 & Serializable)s -> doc.append("sheet", (BsonValue)new BsonString(s)));
            return Document$.MODULE$.apply(doc);
        });
    }

    public BsonValue cellValue(XSSFRow row, int col) {
        Option option = Option$.MODULE$.apply((Object)row.getCell(col, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK));
        if (option instanceof Some) {
            XSSFCell cell = (XSSFCell)((Some)option).value();
            return this.getValue(cell);
        }
        if (None$.MODULE$.equals(option)) {
            return BsonUtils$.MODULE$.Null();
        }
        throw new MatchError((Object)option);
    }

    public String getString(XSSFCell cell) {
        CellType cellType = cell.getCellType();
        CellType cellType2 = CellType.STRING;
        CellType cellType3 = cellType;
        if (!(cellType2 != null ? !cellType2.equals(cellType3) : cellType3 != null)) {
            return cell.getStringCellValue();
        }
        return BsonUtils$.MODULE$.asString(this.getValue(cell));
    }

    public BsonValue getValue(XSSFCell cell) {
        return (BsonValue)Try$.MODULE$.apply(() -> XlsxRichReader$.getValue$$anonfun$1(cell)).getOrElse(() -> XlsxRichReader$.getValue$$anonfun$2(cell));
    }

    public BsonDocument readRich(XSSFCell cell) {
        XSSFRichTextString txt = cell.getRichStringCellValue();
        if (txt.hasFormatting()) {
            int numFormattingRuns = txt.numFormattingRuns();
            IndexedSeq frs = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numFormattingRuns).map((Function1 & Serializable)fmtIdx -> XlsxRichReader$.$anonfun$18(txt, BoxesRunTime.unboxToInt((Object)fmtIdx)));
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(txt.getString())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"runs");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonArray$.MODULE$.fromIterable((Iterable)frs)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        XSSFFont font = cell.getCellStyle().getFont();
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"begin");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(0)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt32$.MODULE$.apply(txt.length())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonDocument fr = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.addFontInfo(fr, (Font)font);
        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[2];
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonString$.MODULE$.apply(txt.getString())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"runs");
        objectArray2[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BsonArray$.MODULE$.fromIterable((Iterable)new .colon.colon((Object)fr, (List)Nil$.MODULE$))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
    }

    public void addFontInfo(BsonDocument doc, Font font) {
        doc.append("font", (BsonValue)BsonString$.MODULE$.apply(font.getFontName()));
        doc.append("bold", (BsonValue)BsonBoolean$.MODULE$.apply(font.getBold()));
        doc.append("italic", (BsonValue)BsonBoolean$.MODULE$.apply(font.getItalic()));
        doc.append("underline", (BsonValue)BsonInt32$.MODULE$.apply(Byte$.MODULE$.byte2int(font.getUnderline())));
    }

    public boolean canRead(File f) {
        boolean ret = XlsxCategory$.MODULE$.XLSXReadable().exists((Function1 & Serializable)base -> com.elixirtech.arch.package$.MODULE$.enrichFile(f).isChildOf(base));
        if (!ret) {
            this.log().info(() -> XlsxRichReader$.canRead$$anonfun$1(f), Line$.MODULE$.apply(261), FullName$.MODULE$.apply("ambience.etl.xlsx.XlsxRichReader.canRead"));
            this.log().info(XlsxRichReader$::canRead$$anonfun$2, Line$.MODULE$.apply(262), FullName$.MODULE$.apply("ambience.etl.xlsx.XlsxRichReader.canRead"));
        }
        return ret;
    }

    public String safeFieldName(String s) {
        String s2 = s.startsWith("$") ? "<dollar>" + this.safeFieldName(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s), "$")) : s;
        return s2.replace(".", "<dot>");
    }

    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        EncoderNotDeriveSum f$proxy1;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy1 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private final List $init$$$anonfun$2$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        Decoder decodeA6;
        DecoderNotDeriveSum f$proxy5;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy5 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy9 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA6 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy5;
        Configuration x$2$proxy10 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA5 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy5;
        Configuration x$2$proxy11 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA4 = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeInt());
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy5;
        Configuration x$2$proxy12 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA3 = Decoder$.MODULE$.decodeInt();
        DecoderNotDeriveSum DecoderNotDeriveSum_this5 = f$proxy5;
        Configuration x$2$proxy13 = DecoderNotDeriveSum_this5.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder5 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this6 = f$proxy5;
        Configuration x$2$proxy14 = DecoderNotDeriveSum_this6.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder6 = decodeA = Decoder$.MODULE$.decodeJson();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder6).$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private final Function1 $init$$$anonfun$2$$anonfun$1$$anonfun$2() {
        XlsxDefinition$ xlsxDefinition$ = XlsxDefinition$.MODULE$;
        return (Function1 & Serializable)p -> (XlsxDefinition)xlsxDefinition$.fromProduct((Product)p);
    }

    private final Product $init$$$anonfun$2$$anonfun$1$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)XlsxDefinition$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)XlsxDefinition$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply(XlsxDefinition$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)XlsxDefinition$.MODULE$.$lessinit$greater$default$4())), (Object)Some$.MODULE$.apply((Object)XlsxDefinition$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)XlsxDefinition$.MODULE$.$lessinit$greater$default$6()));
    }

    private final void $init$$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(XSSFWorkbook wb$2) {
        wb$2.close();
    }

    private final void $init$$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$2(InputStream dataStream$2) {
        dataStream$2.close();
    }

    private final void $init$$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$3(InputStream in$2) {
        in$2.close();
    }

    private final void $init$$$anonfun$3$$anonfun$1$$anonfun$1(XSSFWorkbook wb$1, InputStream dataStream$1, InputStream in$1) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(wb$1);
            return BoxedUnit.UNIT;
        });
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$2(dataStream$1);
            return BoxedUnit.UNIT;
        });
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$3(in$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void $init$$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1(XSSFWorkbook wb$4) {
        wb$4.close();
    }

    private final Try $init$$$anonfun$3$$anonfun$1$$anonfun$2(XSSFWorkbook wb$3) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1(wb$3);
            return BoxedUnit.UNIT;
        });
    }

    private final Document $anonfun$2(XlsxRichReader.XlsxStream in$3) {
        return package$.MODULE$.ETLRecord().apply(in$3.xlsxDef().base().noSpaces());
    }

    private final /* synthetic */ XlsxRichReader.Header $anonfun$4(XSSFSheet sheet$1, int _$1) {
        return this.buildHeader(sheet$1, _$1);
    }

    private final /* synthetic */ XlsxRichReader.Header $anonfun$7(XSSFSheet sheet$2, int _$2) {
        return this.buildHeader(sheet$2, _$2);
    }

    private final Iterator $anonfun$9() {
        return scala.package$.MODULE$.Iterator().empty();
    }

    private final Iterator $init$$$anonfun$4$$anonfun$1$$anonfun$1(Iterator it$1) {
        return it$1;
    }

    public static final /* synthetic */ String ambience$etl$xlsx$XlsxRichReader$Header$$_$_$$anonfun$10(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String a = (String)tuple2._1();
            String b = (String)tuple2._2();
            return a + " " + b;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final List $anonfun$11() {
        Decoder decodeA;
        Decoder decodeA2;
        DecoderNotDeriveSum f$proxy2;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy2 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy3 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy4 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 $anonfun$12() {
        XlsxRichReader$Info$ xlsxRichReader$Info$ = XlsxRichReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (XlsxRichReader.Info)xlsxRichReader$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$13() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)XlsxRichReader$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)XlsxRichReader$Info$.MODULE$.$lessinit$greater$default$2()));
    }

    private static final XlsxRichReader.Info $anonfun$14() {
        return XlsxRichReader$Info$.MODULE$.apply(XlsxRichReader$Info$.MODULE$.$lessinit$greater$default$1(), XlsxRichReader$Info$.MODULE$.$lessinit$greater$default$2());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item htmlFields$1, Panel.Item urlRegexField$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)htmlFields$1, (List)new .colon.colon((Object)urlRegexField$1, (List)Nil$.MODULE$)));
    }

    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        DecoderNotDeriveSum f$proxy3;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy3 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy5 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy3;
        Configuration x$2$proxy6 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        XlsxRichReader$Info$ xlsxRichReader$Info$ = XlsxRichReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (XlsxRichReader.Info)xlsxRichReader$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)XlsxRichReader$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)XlsxRichReader$Info$.MODULE$.$lessinit$greater$default$2()));
    }

    private static final List $anonfun$15() {
        Encoder encodeA;
        Encoder encodeA2;
        EncoderNotDeriveSum f$proxy4;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy4 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy7 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy4;
        Configuration x$2$proxy8 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "htmlFields";
        String string2 = "urlRegex";
        int size = 2;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", XlsxRichReader$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), XlsxRichReader$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(XlsxRichReader$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            XlsxRichReader.Info info2 = (XlsxRichReader.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "htmlFields";
            String string2 = "urlRegex";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(XlsxRichReader$::$anonfun$15, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string3 = step$1.copy$default$1();
            String string4 = step$1.copy$default$2();
            String string5 = step$1.copy$default$3();
            String string6 = step$1.copy$default$4();
            String string7 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string3, string4, string5, string6, string7, json, bl, bl2);
        });
    }

    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        DecoderNotDeriveSum f$proxy6;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy6 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy15 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy6;
        Configuration x$2$proxy16 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 build$$anonfun$2() {
        XlsxRichReader$Info$ xlsxRichReader$Info$ = XlsxRichReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (XlsxRichReader.Info)xlsxRichReader$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)XlsxRichReader$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)XlsxRichReader$Info$.MODULE$.$lessinit$greater$default$2()));
    }

    private static final XlsxRichReader.Header buildHeader$$anonfun$2() {
        return XlsxRichReader$Header$.MODULE$.apply((List<String>)scala.package$.MODULE$.Nil());
    }

    private static final String headerText$$anonfun$1(XSSFCell cell$1) {
        return MODULE$.safeFieldName(MODULE$.getString(cell$1));
    }

    private static final LazyList headerText$$anonfun$2(XSSFRow row$1, int col$1) {
        return MODULE$.headerText(row$1, col$1 + 1);
    }

    private static final Document buildRows$$anonfun$1(Document doc$1) {
        return doc$1;
    }

    private static final LazyList buildRows$$anonfun$2(XSSFSheet sheet$3, int i$1, XlsxRichReader.Header header$1, Option optSheetName$1) {
        return MODULE$.buildRows(sheet$3, i$1 + 1, header$1, (Option<String>)optSheetName$1);
    }

    private static final BsonDouble $anonfun$17(XSSFCell cell$3) {
        return new BsonDouble(cell$3.getNumericCellValue());
    }

    private static final BsonValue getValue$$anonfun$1$$anonfun$1(XSSFCell cell$4) {
        return new BsonString(cell$4.getStringCellValue());
    }

    private static final BsonValue getValue$$anonfun$1(XSSFCell cell$2) {
        CellType cellType = cell$2.getCellType();
        CellType cellType2 = CellType.BLANK;
        CellType cellType3 = cellType;
        if (!(cellType2 != null ? !cellType2.equals(cellType3) : cellType3 != null)) {
            return new BsonString("");
        }
        CellType cellType4 = CellType.BOOLEAN;
        CellType cellType5 = cellType;
        if (!(cellType4 != null ? !cellType4.equals(cellType5) : cellType5 != null)) {
            return new BsonBoolean(cell$2.getBooleanCellValue());
        }
        CellType cellType6 = CellType.ERROR;
        CellType cellType7 = cellType;
        if (!(cellType6 != null ? !cellType6.equals(cellType7) : cellType7 != null)) {
            return BsonUtils$.MODULE$.Null();
        }
        CellType cellType8 = CellType.FORMULA;
        CellType cellType9 = cellType;
        if (!(cellType8 != null ? !cellType8.equals(cellType9) : cellType9 != null)) {
            Option numericValue = Try$.MODULE$.apply(() -> XlsxRichReader$.$anonfun$17(cell$2)).toOption();
            return (BsonValue)numericValue.getOrElse(() -> XlsxRichReader$.getValue$$anonfun$1$$anonfun$1(cell$2));
        }
        CellType cellType10 = CellType.NUMERIC;
        CellType cellType11 = cellType;
        if (!(cellType10 != null ? !cellType10.equals(cellType11) : cellType11 != null)) {
            return (BsonValue)(DateUtil.isCellDateFormatted((Cell)cell$2) ? new BsonDateTime(cell$2.getDateCellValue().getTime()) : new BsonDouble(cell$2.getNumericCellValue()));
        }
        CellType cellType12 = CellType.STRING;
        CellType cellType13 = cellType;
        if (!(cellType12 != null ? !cellType12.equals(cellType13) : cellType13 != null)) {
            return MODULE$.readRich(cell$2);
        }
        CellType cellType14 = CellType._NONE;
        CellType cellType15 = cellType;
        if (!(cellType14 != null ? !cellType14.equals(cellType15) : cellType15 != null)) {
            return BsonUtils$.MODULE$.Null();
        }
        if (cellType == null) {
            return BsonUtils$.MODULE$.Null();
        }
        throw new MatchError((Object)cellType);
    }

    private static final Object getValue$$anonfun$2$$anonfun$1(XSSFCell cell$6) {
        return "Can't read cell " + cell$6.getAddress();
    }

    private static final BsonValue getValue$$anonfun$2(XSSFCell cell$5) {
        MODULE$.log().warn(() -> XlsxRichReader$.getValue$$anonfun$2$$anonfun$1(cell$5), Line$.MODULE$.apply(223), FullName$.MODULE$.apply("ambience.etl.xlsx.XlsxRichReader.getValue"));
        return BsonUtils$.MODULE$.Null();
    }

    private static final /* synthetic */ BsonDocument $anonfun$18(XSSFRichTextString txt$1, int fmtIdx) {
        int begin = txt$1.getIndexOfFormattingRun(fmtIdx);
        XSSFFont font = txt$1.getFontOfFormattingRun(fmtIdx);
        int length = txt$1.getLengthOfFormattingRun(fmtIdx);
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"begin");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(begin)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt32$.MODULE$.apply(length)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonDocument fr = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        MODULE$.addFontInfo(fr, (Font)font);
        return fr;
    }

    private static final Object canRead$$anonfun$1(File f$2) {
        return "canRead: " + f$2.getAbsolutePath();
    }

    private static final Object canRead$$anonfun$2() {
        return "Does not match:\n" + XlsxCategory$.MODULE$.XLSXReadable().map((Function1 & Serializable)_$3 -> _$3.getAbsolutePath()).mkString("\n");
    }
}

