/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.xlsx;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.StepContext;
import ambience.etl.StepContext$;
import ambience.etl.package$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.etl.xlsx.XlsxWriter;
import ambience.etl.xlsx.XlsxWriter$Info$;
import ambience.etl.xlsx.XlsxWriter$StyleInfo$;
import ambience.etl.xlsx.XlsxWriter$XlsxContext$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.util.WebColor$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeTypes$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Try$;
import scala.util.matching.Regex;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class XlsxWriter$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(XlsxWriter$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    private static final DateTimeFormatter IsoLocalDate;
    private static final Regex RGB;
    public static final XlsxWriter$Info$ Info;
    private static final Json InfoJson;
    public static final XlsxWriter$StyleInfo$ StyleInfo;
    public static final XlsxWriter$XlsxContext$ XlsxContext;
    public static final XlsxWriter$ MODULE$;

    private XlsxWriter$() {
    }

    static {
        MODULE$ = new XlsxWriter$();
        stepType = ETLStepType$.MODULE$.apply("xlsx.Writer");
        IsoLocalDate = DateTimeFormatter.ISO_LOCAL_DATE;
        RGB = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("rgb\\(([0-9]+),([0-9]+),([0-9]+)\\)"));
        XlsxWriter.Info info = (XlsxWriter.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)XlsxWriter$Info$.MODULE$.apply(XlsxWriter$Info$.MODULE$.$lessinit$greater$default$1(), XlsxWriter$Info$.MODULE$.$lessinit$greater$default$2(), XlsxWriter$Info$.MODULE$.$lessinit$greater$default$3()));
        String string = "sheet";
        String string2 = "writeHeader";
        String string3 = "columns";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(XlsxWriter$.class);
    }

    public String stepType() {
        return stepType;
    }

    public DateTimeFormatter IsoLocalDate() {
        return IsoLocalDate;
    }

    public Regex RGB() {
        return RGB;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public Option<XSSFColor> buildColor(XSSFWorkbook wb, String c) {
        IndexedColorMap indexedColorMap = wb.getStylesSource().getIndexedColors();
        if (c.startsWith("#")) {
            return Option$.MODULE$.apply((Object)Color.decode(c)).map((Function1 & Serializable)rgb -> new XSSFColor(rgb, indexedColorMap));
        }
        if (c.startsWith("rgb(")) {
            return this.expandRGB(c).map((Function1 & Serializable)rgb -> new XSSFColor(rgb, indexedColorMap));
        }
        return WebColor$.MODULE$.lookupAWT(c).map((Function1 & Serializable)_$3 -> new XSSFColor(_$3, indexedColorMap));
    }

    public Option<Color> expandRGB(String rgb) {
        List list;
        Option option;
        String string = rgb.replace(" ", "");
        if (string != null && !(option = this.RGB().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(3) == 0) {
            String string2 = (String)list.apply(0);
            String string3 = (String)list.apply(1);
            String string4 = (String)list.apply(2);
            String red = string2;
            String green = string3;
            String blue = string4;
            return Try$.MODULE$.apply(() -> XlsxWriter$.expandRGB$$anonfun$1(red, green, blue)).toOption();
        }
        return None$.MODULE$;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "sheet";
        String string2 = "writeHeader";
        String string3 = "columns";
        int size = 3;
        XlsxWriter.Info info = (XlsxWriter.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", XlsxWriter$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), XlsxWriter$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(XlsxWriter$::$anonfun$3))))).toOption().getOrElse(XlsxWriter$::$anonfun$4);
        Panel.Item sheetField = PanelItem$.MODULE$.text("sheet", "Sheet", info.sheet(), PanelItem$.MODULE$.text$default$4());
        Panel.Item headerField = PanelItem$.MODULE$.checkbox("writeHeader", "Write Header", info.writeHeader(), PanelItem$.MODULE$.checkbox$default$4());
        Panel.Item columnsField = PanelItem$.MODULE$.textArea("columns", "Columns", info.columns(), 10);
        return Task$.MODULE$.apply(() -> XlsxWriter$.buildPanel$$anonfun$1(sheetField, headerField, columnsField));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> XlsxWriter$.savePanel$$anonfun$1(results, step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "sheet";
        String string2 = "writeHeader";
        String string3 = "columns";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", XlsxWriter$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), XlsxWriter$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(XlsxWriter$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (XlsxWriter.Info)info, (Observable<Document>)from));
    }

    public Observable<Document> run(Builder.Context cxt, XlsxWriter.Info info, Observable<Document> from) {
        return StepContext$.MODULE$.withStepContext(cxt, this.stepType(), (Function1 & Serializable)stepCxt -> MODULE$.run2((StepContext)stepCxt, info, from));
    }

    public Observable<Document> run2(StepContext stepCxt, XlsxWriter.Info info, Observable<Document> from) {
        List<String> columns = this.getColumns(info.columns());
        XSSFWorkbook wb = new XSSFWorkbook();
        String sheetName = info.sheet().isEmpty() ? "Sheet 1" : info.sheet();
        XSSFSheet sheet = wb.createSheet(sheetName);
        XSSFDataFormat df = wb.createDataFormat();
        XlsxWriter.XlsxContext xlsxContext = XlsxWriter$XlsxContext$.MODULE$.apply(wb, df, sheet);
        if (info.writeHeader()) {
            this.writeHeader(xlsxContext, columns);
        }
        Observable x = from.foldLeft(() -> XlsxWriter$.$anonfun$6(info), (Function2 & Serializable)(x$1, x$2) -> XlsxWriter$.$anonfun$7(stepCxt, sheet, columns, xlsxContext, BoxesRunTime.unboxToInt((Object)x$1), (Document)x$2));
        return x.map((Function1 & Serializable)rowCount -> XlsxWriter$.run2$$anonfun$1(columns, sheet, wb, info, BoxesRunTime.unboxToInt((Object)rowCount)));
    }

    public Either<LogMessage, BsonValue> getValue(int rowIdx, Document doc, String label) {
        Option optValue = BsonETL$.MODULE$.get(doc, label);
        Option option = optValue;
        if (option instanceof Some) {
            BsonValue value = (BsonValue)((Some)option).value();
            return scala.package$.MODULE$.Right().apply((Object)value);
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Debug$.MODULE$.apply("No value for " + label + " in row " + rowIdx));
        }
        throw new MatchError((Object)option);
    }

    public Option<BsonValue> getFormat(Document doc, String label) {
        return BsonETL$.MODULE$.get(doc, "xlsxFormat." + label);
    }

    public Option<BsonValue> getStyle(Document doc, String label) {
        return BsonETL$.MODULE$.get(doc, "xlsxStyle." + label);
    }

    public Document handleResult(XlsxWriter.Info info, byte[] bytes, int rowCount) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonBinary$.MODULE$.apply(bytes)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"mimeType");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(MimeTypes$.MODULE$.XLSX().value())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rowCount");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt32$.MODULE$.apply(rowCount)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public List<String> getColumns(String columns) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])columns.split("\n"));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$4 -> _$4.trim(), ClassTag$.MODULE$.apply(String.class)));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)_$5 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$5)))).toList();
    }

    public XSSFCellStyle getHeaderStyle(XSSFWorkbook wb) {
        XSSFCellStyle hs = wb.createCellStyle();
        XSSFFont font = wb.createFont();
        font.setBold(true);
        hs.setFont((Font)font);
        return hs;
    }

    public void writeHeader(XlsxWriter.XlsxContext xlsxContext, List<String> columns) {
        XSSFCellStyle headerStyle = this.getHeaderStyle(xlsxContext.wb());
        XSSFRow headerRow = xlsxContext.sheet().createRow(0);
        ((List)columns.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                XSSFCell cell = headerRow.createCell(idx);
                cell.setCellValue(label);
                cell.setCellStyle((CellStyle)headerStyle);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void setCellValue(XlsxWriter.XlsxContext xlsxContext, XSSFCell cell, Option<BsonValue> optValue, Option<BsonValue> optFormat, Option<BsonValue> optStyle) {
        None$ none$;
        BsonValue bsonValue;
        Option<String> option;
        BsonValue bsonValue2;
        boolean isDate = optFormat.exists((Function1 & Serializable)v -> MODULE$.isDateFormat((BsonValue)v));
        optValue.foreach((Function1)(JProcedure1 & Serializable)_$6 -> MODULE$.setCellValue(cell, isDate, (BsonValue)_$6));
        Option<BsonValue> option2 = optFormat;
        if (option2 instanceof Some && (bsonValue2 = (BsonValue)((Some)option2).value()) instanceof BsonString) {
            BsonString bs = (BsonString)bsonValue2;
            option = this.opts(bs.getValue());
        } else {
            option = None$.MODULE$;
        }
        Option<String> optF = option;
        Option<BsonValue> option3 = optStyle;
        if (option3 instanceof Some && (bsonValue = (BsonValue)((Some)option3).value()) instanceof BsonDocument) {
            BsonDocument bd = (BsonDocument)bsonValue;
            none$ = Some$.MODULE$.apply((Object)Document$.MODULE$.apply(bd));
        } else {
            none$ = None$.MODULE$;
        }
        None$ optS = none$;
        Option optBG = optS.flatMap((Function1 & Serializable)_$7 -> _$7.get("background-color", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class))).map((Function1 & Serializable)_$8 -> _$8.getValue());
        Option optFG = optS.flatMap((Function1 & Serializable)_$9 -> _$9.get("color", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class))).map((Function1 & Serializable)_$10 -> _$10.getValue());
        this.setCellStyle(xlsxContext, cell, XlsxWriter$StyleInfo$.MODULE$.apply(optF, (Option<String>)optBG, (Option<String>)optFG));
    }

    public Option<String> opts(String s) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s))) {
            return Some$.MODULE$.apply((Object)s);
        }
        return None$.MODULE$;
    }

    public void setCellValue(XSSFCell cell, boolean isDate, BsonValue value) {
        BsonValue bsonValue = value;
        if (bsonValue instanceof BsonString) {
            BsonString value2 = (BsonString)bsonValue;
            if (isDate) {
                Option<LocalDate> option = this.maybeParse(value2.getValue());
                if (option instanceof Some) {
                    LocalDate localDate = (LocalDate)((Some)option).value();
                    cell.setCellValue(localDate.atStartOfDay());
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    cell.setCellValue(value2.getValue());
                    return;
                }
                throw new MatchError(option);
            }
            cell.setCellValue(value2.getValue());
            return;
        }
        if (bsonValue instanceof BsonInt32) {
            BsonInt32 value3 = (BsonInt32)bsonValue;
            cell.setCellValue(Int$.MODULE$.int2double(value3.getValue()));
            return;
        }
        if (bsonValue instanceof BsonInt64) {
            BsonInt64 value4 = (BsonInt64)bsonValue;
            if (RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(value4.getValue()))) {
                cell.setCellValue(Int$.MODULE$.int2double((int)value4.getValue()));
                return;
            }
            cell.setCellValue((double)value4.getValue());
            return;
        }
        if (bsonValue instanceof BsonDouble) {
            BsonDouble value5 = (BsonDouble)bsonValue;
            cell.setCellValue(value5.getValue());
            return;
        }
        if (bsonValue instanceof BsonBoolean) {
            BsonBoolean value6 = (BsonBoolean)bsonValue;
            cell.setCellValue(value6.getValue());
            return;
        }
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 value7 = (BsonDecimal128)bsonValue;
            cell.setCellValue(value7.doubleValue());
            return;
        }
        if (bsonValue instanceof BsonDateTime) {
            BsonDateTime value8 = (BsonDateTime)bsonValue;
            Instant instant = Instant.ofEpochMilli(value8.getValue());
            cell.setCellValue(LocalDateTime.ofInstant(instant, ZoneId.systemDefault()));
            return;
        }
        this.log().info(() -> XlsxWriter$.setCellValue$$anonfun$2(value), Line$.MODULE$.apply(220), FullName$.MODULE$.apply("ambience.etl.xlsx.XlsxWriter.setCellValue"));
    }

    public void setCellStyle(XlsxWriter.XlsxContext xlsxContext, XSSFCell cell, XlsxWriter.StyleInfo si) {
        cell.setCellStyle((CellStyle)xlsxContext.getCellStyle(si));
    }

    public Option<String> style(Document styleDoc, String key) {
        return styleDoc.get(key, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$11 -> _$11.getValue());
    }

    public boolean isDateFormat(BsonValue v) {
        BsonValue bsonValue = v;
        if (bsonValue instanceof BsonString) {
            BsonString s = (BsonString)bsonValue;
            return this.isDateFormat(s.getValue());
        }
        return false;
    }

    public boolean isDateFormat(String s) {
        return s.contains("d") || s.contains("M") || s.contains("y");
    }

    public Option<LocalDate> maybeParse(String source) {
        return Try$.MODULE$.apply(() -> XlsxWriter$.maybeParse$$anonfun$1(source)).toOption();
    }

    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        EncoderNotDeriveSum f$proxy1;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy1 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeBoolean();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy1;
        Configuration x$2$proxy3 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder3 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    public static final /* synthetic */ void ambience$etl$xlsx$XlsxWriter$XlsxContext$$_$buildStyle$$anonfun$3(XSSFCellStyle cellStyle$2, XSSFColor color) {
        cellStyle$2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle$2.setFillForegroundColor(color);
    }

    private static final Color expandRGB$$anonfun$1(String red$1, String green$1, String blue$1) {
        return new Color(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(red$1)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(green$1)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(blue$1)));
    }

    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        DecoderNotDeriveSum f$proxy2;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy2 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy4 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy5 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeBoolean();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy2;
        Configuration x$2$proxy6 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 $anonfun$2() {
        XlsxWriter$Info$ xlsxWriter$Info$ = XlsxWriter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (XlsxWriter.Info)xlsxWriter$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)XlsxWriter$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)XlsxWriter$Info$.MODULE$.$lessinit$greater$default$2())), (Object)Some$.MODULE$.apply((Object)XlsxWriter$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final XlsxWriter.Info $anonfun$4() {
        return XlsxWriter$Info$.MODULE$.apply(XlsxWriter$Info$.MODULE$.$lessinit$greater$default$1(), XlsxWriter$Info$.MODULE$.$lessinit$greater$default$2(), XlsxWriter$Info$.MODULE$.$lessinit$greater$default$3());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item sheetField$1, Panel.Item headerField$1, Panel.Item columnsField$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)sheetField$1, (List)new .colon.colon((Object)headerField$1, (List)new .colon.colon((Object)columnsField$1, (List)Nil$.MODULE$))));
    }

    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        DecoderNotDeriveSum f$proxy3;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy3 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy7 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy3;
        Configuration x$2$proxy8 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeBoolean();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy3;
        Configuration x$2$proxy9 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        XlsxWriter$Info$ xlsxWriter$Info$ = XlsxWriter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (XlsxWriter.Info)xlsxWriter$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)XlsxWriter$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)XlsxWriter$Info$.MODULE$.$lessinit$greater$default$2())), (Object)Some$.MODULE$.apply((Object)XlsxWriter$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final List $anonfun$5() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        EncoderNotDeriveSum f$proxy4;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy4 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy10 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy4;
        Configuration x$2$proxy11 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeBoolean();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy4;
        Configuration x$2$proxy12 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder3 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "sheet";
        String string2 = "writeHeader";
        String string3 = "columns";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", XlsxWriter$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), XlsxWriter$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(XlsxWriter$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            XlsxWriter.Info info2 = (XlsxWriter.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "sheet";
            String string2 = "writeHeader";
            String string3 = "columns";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(XlsxWriter$::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string4 = step$1.copy$default$1();
            String string5 = step$1.copy$default$2();
            String string6 = step$1.copy$default$3();
            String string7 = step$1.copy$default$4();
            String string8 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string4, string5, string6, string7, string8, json, bl, bl2);
        });
    }

    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        DecoderNotDeriveSum f$proxy5;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy5 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy13 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy5;
        Configuration x$2$proxy14 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeBoolean();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy5;
        Configuration x$2$proxy15 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 build$$anonfun$2() {
        XlsxWriter$Info$ xlsxWriter$Info$ = XlsxWriter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (XlsxWriter.Info)xlsxWriter$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)XlsxWriter$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)XlsxWriter$Info$.MODULE$.$lessinit$greater$default$2())), (Object)Some$.MODULE$.apply((Object)XlsxWriter$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final int $anonfun$6(XlsxWriter.Info info$3) {
        if (info$3.writeHeader()) {
            return 1;
        }
        return 0;
    }

    private static final /* synthetic */ int $anonfun$7(StepContext stepCxt$1, XSSFSheet sheet$1, List columns$1, XlsxWriter.XlsxContext xlsxContext$1, int x$12, Document x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$12), (Object)x$2);
        if (tuple2 != null) {
            int rowIdx = BoxesRunTime.unboxToInt((Object)tuple2._1());
            Document doc = (Document)tuple2._2();
            stepCxt$1.debug("Creating row " + rowIdx);
            XSSFRow dataRow = sheet$1.createRow(rowIdx);
            ((List)columns$1.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String label = (String)tuple2._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    XSSFCell cell = dataRow.createCell(idx);
                    Either<LogMessage, BsonValue> value = MODULE$.getValue(rowIdx, doc, label);
                    value.left().foreach((Function1)(JProcedure1 & Serializable)msg -> stepCxt$1.log(msg));
                    MODULE$.setCellValue(xlsxContext$1, cell, (Option<BsonValue>)value.toOption(), MODULE$.getFormat(doc, label), MODULE$.getStyle(doc, label));
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return rowIdx + 1;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ Document run2$$anonfun$1(List columns$2, XSSFSheet sheet$2, XSSFWorkbook wb$1, XlsxWriter.Info info$4, int rowCount) {
        columns$2.indices().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$0 -> sheet$2.autoSizeColumn(x$0));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        wb$1.write((OutputStream)baos);
        wb$1.close();
        return MODULE$.handleResult(info$4, baos.toByteArray(), rowCount);
    }

    private static final Object setCellValue$$anonfun$2(BsonValue value$1) {
        return "Bson Type " + value$1.getBsonType() + " not supported as a cell value";
    }

    private static final LocalDate maybeParse$$anonfun$1(String source$1) {
        return LocalDate.parse(source$1, MODULE$.IsoLocalDate());
    }
}

