/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.IO;
import cats.effect.IO$;
import scala.Function1;
import scala.MatchError;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public abstract class IOFrame<A, R>
implements Function1<A, R> {
    public abstract R apply(A var1);

    public abstract R recover(Throwable var1);

    public final R fold(Either<Throwable, A> value) {
        R r;
        Either<Throwable, A> either = value;
        if (either instanceof Right) {
            Object a = ((Right)either).value();
            r = this.apply(a);
        } else if (either instanceof Left) {
            Throwable e = (Throwable)((Left)either).value();
            r = this.recover(e);
        } else {
            throw new MatchError(either);
        }
        return r;
    }

    public static final class ErrorHandler<A>
    extends IOFrame<A, IO<A>> {
        private final Function1<Throwable, IO<A>> fe;

        public ErrorHandler(Function1<Throwable, IO<A>> fe) {
            this.fe = fe;
        }

        @Override
        public IO<A> recover(Throwable e) {
            return (IO)this.fe.apply((Object)e);
        }

        @Override
        public IO<A> apply(A a) {
            return IO$.MODULE$.pure(a);
        }
    }

    public static final class Redeem<A, B>
    extends IOFrame<A, IO<B>> {
        private final Function1<Throwable, B> fe;
        private final Function1<A, B> fs;

        public Redeem(Function1<Throwable, B> fe, Function1<A, B> fs) {
            this.fe = fe;
            this.fs = fs;
        }

        @Override
        public IO<B> apply(A a) {
            return IO$.MODULE$.pure(this.fs.apply(a));
        }

        @Override
        public IO<B> recover(Throwable e) {
            return IO$.MODULE$.pure(this.fe.apply((Object)e));
        }
    }

    public static final class RedeemWith<A, B>
    extends IOFrame<A, IO<B>> {
        private final Function1<Throwable, IO<B>> fe;
        private final Function1<A, IO<B>> fs;

        public RedeemWith(Function1<Throwable, IO<B>> fe, Function1<A, IO<B>> fs) {
            this.fe = fe;
            this.fs = fs;
        }

        @Override
        public IO<B> apply(A a) {
            return (IO)this.fs.apply(a);
        }

        @Override
        public IO<B> recover(Throwable e) {
            return (IO)this.fe.apply((Object)e);
        }
    }
}

