/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.internals.NonDaemonThreadLogger$;
import java.util.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.ScalaRunTime$;

public class NonDaemonThreadLogger
extends Thread {
    public static boolean isEnabled() {
        return NonDaemonThreadLogger$.MODULE$.isEnabled();
    }

    public static long sleepIntervalMillis() {
        return NonDaemonThreadLogger$.MODULE$.sleepIntervalMillis();
    }

    public NonDaemonThreadLogger() {
        super("cats-effect-nondaemon-thread-logger");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        boolean done = false;
        while (!done) {
            Thread.sleep(NonDaemonThreadLogger$.MODULE$.sleepIntervalMillis());
            List<String> runningThreads = this.detectThreads();
            if (runningThreads.isEmpty()) {
                done = true;
                continue;
            }
            this.printThreads(runningThreads);
        }
    }

    private List<String> detectThreads() {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        ListBuffer nonDaemons = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        threads.forEach(t -> {
            if (!t.isDaemon()) {
                nonDaemons.$plus$eq((Object)(" - " + t.getId() + ": " + t));
            }
        });
        return nonDaemons.toList();
    }

    private void printThreads(List<String> threads) {
        String msg = threads.mkString("Non-daemon threads currently preventing JVM termination:", "\n - ", "");
        System.err.println(msg);
    }
}

