/*
 * Decompiled with CFR 0.152.
 */
package monix.execution;

import monix.execution.Callback$;
import monix.execution.Callback$Builders$;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.AtomicInt$;
import monix.execution.exceptions.CallbackCalledMultipleTimesException;
import monix.execution.exceptions.UncaughtErrorException$;
import monix.execution.schedulers.TrampolinedRunnable;
import scala.;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Promise;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public abstract class Callback<E, A>
implements Function1<Either<E, A>, BoxedUnit> {
    public static <E, A> void callError(Function1<Either<E, A>, BoxedUnit> function1, E e) {
        Callback$.MODULE$.callError(function1, e);
    }

    public static <E, A> void callSuccess(Function1<Either<E, A>, BoxedUnit> function1, A a) {
        Callback$.MODULE$.callSuccess(function1, a);
    }

    public static <E, A> Callback<E, A> empty(UncaughtExceptionReporter uncaughtExceptionReporter) {
        return Callback$.MODULE$.empty(uncaughtExceptionReporter);
    }

    public static <E, A> Callback<E, A> forked(Callback<E, A> callback, ExecutionContext executionContext) {
        return Callback$.MODULE$.forked(callback, executionContext);
    }

    public static <E, A> Callback<E, A> fromAttempt(Function1<Either<E, A>, BoxedUnit> function1) {
        return Callback$.MODULE$.fromAttempt(function1);
    }

    public static <A> Callback<Throwable, A> fromPromise(Promise<A> promise) {
        return Callback$.MODULE$.fromPromise(promise);
    }

    public static <A> Callback<Throwable, A> fromTry(Function1<Try<A>, BoxedUnit> function1) {
        return Callback$.MODULE$.fromTry(function1);
    }

    public static <E, A> Callback<E, A> safe(Callback<E, A> callback, UncaughtExceptionReporter uncaughtExceptionReporter) {
        return Callback$.MODULE$.safe(callback, uncaughtExceptionReporter);
    }

    public static <E, A> void signalErrorTrampolined(Callback<E, A> callback, E e) {
        Callback$.MODULE$.signalErrorTrampolined(callback, e);
    }

    public static <E, A> Callback<E, A> trampolined(Callback<E, A> callback, ExecutionContext executionContext) {
        return Callback$.MODULE$.trampolined(callback, executionContext);
    }

    public abstract void onSuccess(A var1);

    public abstract void onError(E var1);

    public void apply(Either<E, A> result) {
        Either<E, A> either = result;
        if (either instanceof Right) {
            Object a = ((Right)either).value();
            this.onSuccess(a);
        } else if (either instanceof Left) {
            Object e = ((Left)either).value();
            this.onError(e);
        } else {
            throw new MatchError(either);
        }
    }

    public void apply(Try<A> result, .less.colon.less<Throwable, E> ev) {
        Try<A> try_ = result;
        if (try_ instanceof Success) {
            Object a = ((Success)try_).value();
            this.onSuccess(a);
        } else if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            this.onError(ev.apply((Object)e));
        } else {
            throw new MatchError(try_);
        }
    }

    public <B> Callback<E, B> contramap(Function1<B, A> f) {
        return new Contramap(this, f);
    }

    public boolean tryOnSuccess(A value) {
        boolean bl;
        try {
            this.onSuccess(value);
            bl = true;
        }
        catch (CallbackCalledMultipleTimesException callbackCalledMultipleTimesException) {
            bl = false;
        }
        return bl;
    }

    public boolean tryOnError(E e) {
        boolean bl;
        try {
            this.onError(e);
            bl = true;
        }
        catch (CallbackCalledMultipleTimesException callbackCalledMultipleTimesException) {
            bl = false;
        }
        return bl;
    }

    public boolean tryApply(Try<A> result, .less.colon.less<Throwable, E> ev) {
        boolean bl;
        Try<A> try_ = result;
        if (try_ instanceof Success) {
            Object a = ((Success)try_).value();
            bl = this.tryOnSuccess(a);
        } else if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            bl = this.tryOnError(ev.apply((Object)e));
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    public boolean tryApply(Either<E, A> result) {
        boolean bl;
        Either<E, A> either = result;
        if (either instanceof Right) {
            Object a = ((Right)either).value();
            bl = this.tryOnSuccess(a);
        } else if (either instanceof Left) {
            Object e = ((Left)either).value();
            bl = this.tryOnError(e);
        } else {
            throw new MatchError(either);
        }
        return bl;
    }

    private static final class AsyncFork<E, A>
    extends Base<E, A> {
        public AsyncFork(Callback<E, A> cb, ExecutionContext ec) {
            super(cb, ec);
        }
    }

    private static class Base<E, A>
    extends Callback<E, A>
    implements Runnable {
        private final Callback<E, A> cb;
        private final ExecutionContext ec;
        private final AtomicInt state;
        private A value;
        private E error;

        public Base(Callback<E, A> cb, ExecutionContext ec) {
            this.cb = cb;
            this.ec = ec;
            this.state = AtomicInt$.MODULE$.apply(0);
        }

        @Override
        public final void onSuccess(A value) {
            if (!this.tryOnSuccess(value)) {
                throw new CallbackCalledMultipleTimesException("onSuccess");
            }
        }

        @Override
        public final boolean tryOnSuccess(A value) {
            boolean bl;
            if (this.state.compareAndSet(0, 1)) {
                this.value = value;
                this.ec.execute((Runnable)this);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public final void onError(E e) {
            if (!this.tryOnError(e)) {
                throw new CallbackCalledMultipleTimesException("Callback.onError", UncaughtErrorException$.MODULE$.wrap(e));
            }
        }

        @Override
        public final boolean tryOnError(E e) {
            boolean bl;
            if (this.state.compareAndSet(0, 2)) {
                this.error = e;
                this.ec.execute((Runnable)this);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public final void run() {
            int n = this.state.get();
            if (1 == n) {
                A v = this.value;
                this.value = null;
                this.cb.onSuccess(v);
            } else if (2 == n) {
                E e = this.error;
                this.error = null;
                this.cb.onError(e);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
    }

    public static final class Builders<E> {
        private final boolean ev;

        public static <E> boolean $lessinit$greater$default$1() {
            return Callback$Builders$.MODULE$.$lessinit$greater$default$1();
        }

        public static <A, E> Callback<E, A> empty$extension(boolean bl, UncaughtExceptionReporter uncaughtExceptionReporter) {
            return Callback$Builders$.MODULE$.empty$extension(bl, uncaughtExceptionReporter);
        }

        public static <E> boolean equals$extension(boolean bl, Object object) {
            return Callback$Builders$.MODULE$.equals$extension(bl, object);
        }

        public static <A, E> Callback<E, A> forked$extension(boolean bl, Callback<E, A> callback, ExecutionContext executionContext) {
            return Callback$Builders$.MODULE$.forked$extension(bl, callback, executionContext);
        }

        public static <A, E> Callback<E, A> fromAttempt$extension(boolean bl, Function1<Either<E, A>, BoxedUnit> function1) {
            return Callback$Builders$.MODULE$.fromAttempt$extension(bl, function1);
        }

        public static <A, E> Callback<Throwable, A> fromPromise$extension(boolean bl, Promise<A> promise, .less.colon.less<Throwable, E> less2) {
            return Callback$Builders$.MODULE$.fromPromise$extension(bl, promise, less2);
        }

        public static <A, E> Callback<Throwable, A> fromTry$extension(boolean bl, Function1<Try<A>, BoxedUnit> function1, .less.colon.less<Throwable, E> less2) {
            return Callback$Builders$.MODULE$.fromTry$extension(bl, function1, less2);
        }

        public static <E> int hashCode$extension(boolean bl) {
            return Callback$Builders$.MODULE$.hashCode$extension(bl);
        }

        public static <A, E> Callback<E, A> safe$extension(boolean bl, Callback<E, A> callback, UncaughtExceptionReporter uncaughtExceptionReporter) {
            return Callback$Builders$.MODULE$.safe$extension(bl, callback, uncaughtExceptionReporter);
        }

        public static <A, E> Callback<E, A> trampolined$extension(boolean bl, Callback<E, A> callback, ExecutionContext executionContext) {
            return Callback$Builders$.MODULE$.trampolined$extension(bl, callback, executionContext);
        }

        public Builders(boolean ev) {
            this.ev = ev;
        }

        public int hashCode() {
            return Callback$Builders$.MODULE$.hashCode$extension(this.ev());
        }

        public boolean equals(Object x$0) {
            return Callback$Builders$.MODULE$.equals$extension(this.ev(), x$0);
        }

        public boolean ev() {
            return this.ev;
        }

        public <A> Callback<E, A> safe(Callback<E, A> cb, UncaughtExceptionReporter r) {
            return Callback$Builders$.MODULE$.safe$extension(this.ev(), cb, r);
        }

        public <A> Callback<E, A> empty(UncaughtExceptionReporter r) {
            return Callback$Builders$.MODULE$.empty$extension(this.ev(), r);
        }

        public <A> Callback<Throwable, A> fromPromise(Promise<A> p, .less.colon.less<Throwable, E> ev) {
            return Callback$Builders$.MODULE$.fromPromise$extension(this.ev(), p, ev);
        }

        public <A> Callback<E, A> forked(Callback<E, A> cb, ExecutionContext ec) {
            return Callback$Builders$.MODULE$.forked$extension(this.ev(), cb, ec);
        }

        public <A> Callback<E, A> trampolined(Callback<E, A> cb, ExecutionContext ec) {
            return Callback$Builders$.MODULE$.trampolined$extension(this.ev(), cb, ec);
        }

        public <A> Callback<E, A> fromAttempt(Function1<Either<E, A>, BoxedUnit> cb) {
            return Callback$Builders$.MODULE$.fromAttempt$extension(this.ev(), cb);
        }

        public <A> Callback<Throwable, A> fromTry(Function1<Try<A>, BoxedUnit> cb, .less.colon.less<Throwable, E> ev) {
            return Callback$Builders$.MODULE$.fromTry$extension(this.ev(), cb, ev);
        }
    }

    private static final class Contramap<E, A, B>
    extends Callback<E, B> {
        private final Callback<E, A> underlying;
        private final Function1<B, A> f;

        public Contramap(Callback<E, A> underlying, Function1<B, A> f) {
            this.underlying = underlying;
            this.f = f;
        }

        @Override
        public void onSuccess(B value) {
            this.underlying.onSuccess(this.f.apply(value));
        }

        @Override
        public void onError(E error) {
            this.underlying.onError(error);
        }
    }

    private static final class Empty
    extends Callback<Object, Object> {
        private final UncaughtExceptionReporter r;

        public Empty(UncaughtExceptionReporter r) {
            this.r = r;
        }

        @Override
        public void onSuccess(Object value) {
        }

        @Override
        public void onError(Object error) {
            this.r.reportFailure(UncaughtErrorException$.MODULE$.wrap(error));
        }
    }

    private static final class Safe<E, A>
    extends Callback<E, A> {
        private final Callback<E, A> underlying;
        private final UncaughtExceptionReporter r;
        private final AtomicBoolean isActive;

        public Safe(Callback<E, A> underlying, UncaughtExceptionReporter r) {
            this.underlying = underlying;
            this.r = r;
            this.isActive = AtomicBoolean$.MODULE$.apply(true);
        }

        @Override
        public void onSuccess(A value) {
            if (this.isActive.compareAndSet(true, false)) {
                try {
                    this.underlying.onSuccess(value);
                }
                catch (CallbackCalledMultipleTimesException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable e = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(e)) {
                        this.r.reportFailure(e);
                    }
                    throw throwable;
                }
            } else {
                throw new CallbackCalledMultipleTimesException("onSuccess");
            }
        }

        @Override
        public void onError(E e) {
            if (this.isActive.compareAndSet(true, false)) {
                try {
                    this.underlying.onError(e);
                }
                catch (CallbackCalledMultipleTimesException e2) {
                    throw e2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable e2 = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(e2)) {
                        this.r.reportFailure(UncaughtErrorException$.MODULE$.wrap(e));
                        this.r.reportFailure(e2);
                    }
                    throw throwable;
                }
            } else {
                Throwable ex = UncaughtErrorException$.MODULE$.wrap(e);
                throw new CallbackCalledMultipleTimesException("onError", ex);
            }
        }
    }

    private static final class TrampolinedCallback<E, A>
    extends Base<E, A>
    implements TrampolinedRunnable {
        public TrampolinedCallback(Callback<E, A> cb, ExecutionContext ec) {
            super(cb, ec);
        }
    }
}

