/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.collection;

import java.io.Serializable;
import monix.execution.internal.collection.LinkedMap$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.LongMap;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public class LinkedMap<K, V> {
    private final Map entries;
    private final LongMap<K> insertionOrder;
    private final long nextId;

    public static <K, V> LinkedMap<K, V> empty() {
        return LinkedMap$.MODULE$.empty();
    }

    public LinkedMap(Map<K, Tuple2<V, Object>> entries, LongMap<K> insertionOrder, long nextId) {
        this.entries = entries;
        this.insertionOrder = insertionOrder;
        this.nextId = nextId;
    }

    public Map<K, Tuple2<V, Object>> entries() {
        return this.entries;
    }

    public boolean isEmpty() {
        return this.entries().isEmpty();
    }

    public <V2> LinkedMap<K, V2> updated(K k, V2 v) {
        LongMap insertionOrderOldRemoved = (LongMap)this.entries().get(k).fold(this::$anonfun$1, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = BoxesRunTime.unboxToLong((Object)tuple2._2());
            return (LongMap)this.insertionOrder.$minus((Object)BoxesRunTime.boxToLong((long)id));
        });
        return new LinkedMap<K, V>((Map)this.entries().updated(k, (Object)Tuple2$.MODULE$.apply(v, (Object)BoxesRunTime.boxToLong((long)this.nextId))), insertionOrderOldRemoved.updated(this.nextId, k), this.nextId + 1L);
    }

    public LinkedMap<K, V> $minus(K k) {
        return new LinkedMap<K, V>((Map)this.entries().$minus(k), (LongMap)this.entries().get(k).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = BoxesRunTime.unboxToLong((Object)tuple2._2());
            return (LongMap)this.insertionOrder.$minus((Object)BoxesRunTime.boxToLong((long)id));
        }).getOrElse(this::$minus$$anonfun$2), this.nextId);
    }

    public Iterable<K> keys() {
        return this.insertionOrder.values();
    }

    public Iterable<V> values() {
        return (Iterable)this.keys().flatMap((Function1 & Serializable)k -> this.entries().get(k).toList().map((Function1 & Serializable)_$1 -> _$1._1()));
    }

    public Tuple2<V, LinkedMap<K, V>> dequeue() {
        Object k = ((Tuple2)this.insertionOrder.head())._2();
        return Tuple2$.MODULE$.apply(((Tuple2)this.entries().apply(k))._1(), this.$minus(k));
    }

    public String toString() {
        return ((IterableOnceOps)this.keys().zip(this.values())).mkString("LinkedMap(", ", ", ")");
    }

    private final LongMap $anonfun$1() {
        return this.insertionOrder;
    }

    private final LongMap $minus$$anonfun$2() {
        return this.insertionOrder;
    }
}

