/*
 * Decompiled with CFR 0.152.
 */
package ambience.secrets;

import ambience.arch.package$;
import ambience.secrets.AWSSecretsStoreLocation$;
import ambience.secrets.AWSSecretsStoreLocation$AddInfo$;
import ambience.secrets.AWSVault;
import ambience.secrets.AssumeRoleHelper;
import ambience.secrets.AssumeRoleHelper$;
import ambience.secrets.AssumeRoleHelper$STSEndpointConfig$;
import ambience.secrets.AssumeRoleHelper$STSRegionConfig$;
import ambience.secrets.SecretsStore;
import ambience.secrets.SecretsStore$Content$;
import ambience.secrets.SecretsStore$ContentId$;
import ambience.secrets.SecretsStoreAPI;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexUpdate;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.BaseDocument;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try$;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import sourcecode.FullName$;
import sourcecode.Line$;

public class AWSSecretsStoreLocation
implements SecretsStore.Location,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AWSSecretsStoreLocation.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final SecretsStoreAPI.SSConfig ssConfig;
    private final String access;
    private final String secret;
    private final Region region;
    private final String roleArn;
    private final String roleSessionName;
    private final String stsServiceEndpoint;
    private final SecretsManagerClient client;

    public static AWSVault fromConfig(String string, SecretsStoreAPI.SSConfig sSConfig) {
        return AWSSecretsStoreLocation$.MODULE$.fromConfig(string, sSConfig);
    }

    public static String getRoleArn(Config config) {
        return AWSSecretsStoreLocation$.MODULE$.getRoleArn(config);
    }

    public static String getRoleSession(Config config) {
        return AWSSecretsStoreLocation$.MODULE$.getRoleSession(config);
    }

    public static String getSTS(Config config) {
        return AWSSecretsStoreLocation$.MODULE$.getSTS(config);
    }

    public AWSSecretsStoreLocation(SecretsStoreAPI.SSConfig ssConfig) {
        this.ssConfig = ssConfig;
        this.access = Crypt$.MODULE$.encPrefixDecrypt(ssConfig.config().getString("access"));
        this.secret = Crypt$.MODULE$.encPrefixDecrypt(ssConfig.config().getString("secret"));
        this.region = Region.of((String)Crypt$.MODULE$.encPrefixDecrypt(ssConfig.config().getString("region")));
        this.roleArn = Crypt$.MODULE$.encPrefixDecrypt(AWSSecretsStoreLocation$.MODULE$.getRoleArn(ssConfig.config()));
        this.roleSessionName = Crypt$.MODULE$.encPrefixDecrypt(AWSSecretsStoreLocation$.MODULE$.getRoleSession(ssConfig.config()));
        this.stsServiceEndpoint = Crypt$.MODULE$.encPrefixDecrypt(AWSSecretsStoreLocation$.MODULE$.getSTS(ssConfig.config()));
        this.client = this.buildClient();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String access() {
        return this.access;
    }

    public String secret() {
        return this.secret;
    }

    public Region region() {
        return this.region;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String roleSessionName() {
        return this.roleSessionName;
    }

    public String stsServiceEndpoint() {
        return this.stsServiceEndpoint;
    }

    public SecretsManagerClient client() {
        return this.client;
    }

    public SecretsManagerClient buildClient() {
        return (SecretsManagerClient)SecretsManagerClient.builder().region(this.region()).credentialsProvider(this.buildCredentialsProvider()).build();
    }

    public AwsCredentials buildCredentials() {
        return AwsBasicCredentials.create((String)this.access(), (String)this.secret());
    }

    public AwsCredentialsProvider buildCredentialsProvider() {
        AwsCredentials creds = this.buildCredentials();
        if (this.roleArn().trim().isEmpty() || this.roleSessionName().trim().isEmpty()) {
            return StaticCredentialsProvider.create((AwsCredentials)creds);
        }
        AssumeRoleHelper.STSConfig stsConfig = this.buildEndpointConfig();
        StsClient stsClient = AssumeRoleHelper$.MODULE$.buildSts(creds, stsConfig);
        AssumeRoleRequest roleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(this.roleArn()).roleSessionName(this.roleSessionName()).build();
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(roleRequest).build();
    }

    public AssumeRoleHelper.STSConfig buildEndpointConfig() {
        return (AssumeRoleHelper.STSConfig)(this.stsServiceEndpoint().trim().isEmpty() ? AssumeRoleHelper$STSRegionConfig$.MODULE$.apply(this.region()) : AssumeRoleHelper$STSEndpointConfig$.MODULE$.apply(this.region(), this.stsServiceEndpoint()));
    }

    @Override
    public String id() {
        return this.ssConfig.id();
    }

    @Override
    public boolean isAddable() {
        boolean req = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(this::$anonfun$1).toOption().getOrElse(AWSSecretsStoreLocation::$anonfun$2));
        if (req) {
            this.log().warn(AWSSecretsStoreLocation::isAddable$$anonfun$1, Line$.MODULE$.apply(98), FullName$.MODULE$.apply("ambience.secrets.AWSSecretsStoreLocation.isAddable"));
        }
        return false;
    }

    @Override
    public boolean isLinkable() {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(this::isLinkable$$anonfun$1).toOption().getOrElse(AWSSecretsStoreLocation::isLinkable$$anonfun$2));
    }

    @Override
    public Task<Either<LogMessage, Document>> add(Document doc) {
        return Task$.MODULE$.apply(() -> this.add$$anonfun$1(doc));
    }

    public Either<LogMessage, Document> linkToVault(Document doc, AddInfo info) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"control");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonBoolean$.MODULE$.apply(false)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return package$.MODULE$.right(((BaseDocument)doc.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"secret"}))).$plus((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    @Override
    public Task<Either<LogMessage, List<SecretsStore.ContentId>>> all() {
        ListSecretsResponse response = this.client().listSecrets();
        List out = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response.secretList()).asScala().map((Function1 & Serializable)s -> new SecretsStore.ContentId(SecretsStore$ContentId$.MODULE$.apply(s.name())))).toList();
        return Task$.MODULE$.apply(() -> AWSSecretsStoreLocation.all$$anonfun$1(out));
    }

    public String asSecret(String s) {
        return new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8);
    }

    @Override
    public Task<Option<SecretsStore.Content>> get(String id) {
        return Task$.MODULE$.apply(() -> this.get$$anonfun$1(id));
    }

    @Override
    public Task<Option<Object>> remove(String id) {
        return Task$.MODULE$.none();
    }

    @Override
    public Task<Option<CodexUpdate>> update(Document doc) {
        return Task$.MODULE$.none();
    }

    private final boolean $anonfun$1() {
        return this.ssConfig.config().getBoolean("is-addable");
    }

    private static final boolean $anonfun$2() {
        return false;
    }

    private static final Object isAddable$$anonfun$1() {
        return "AWS does not support addable true. Defaulting to false";
    }

    private final boolean isLinkable$$anonfun$1() {
        return this.ssConfig.config().getBoolean("is-linkable");
    }

    private static final boolean isLinkable$$anonfun$2() {
        return true;
    }

    private final Either add$$anonfun$1(Document doc$1) {
        AddInfo info;
        Option d = doc$1.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> Crypt$.MODULE$.encPrefixDecrypt(s.getValue(), false)).flatMap((Function1 & Serializable)name -> doc$1.get("secret", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> this.asSecret(s.getValue())).flatMap((Function1 & Serializable)secret -> doc$1.get("contentId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$1 -> _$1.getValue()).map((Function1 & Serializable)contentId -> AWSSecretsStoreLocation$AddInfo$.MODULE$.apply((String)name, (String)secret, (String)contentId))));
        Option option = d;
        if (option instanceof Some && (info = (AddInfo)((Some)option).value()).isLink()) {
            return this.linkToVault(doc$1, info);
        }
        return package$.MODULE$.leftError("malformed doc");
    }

    private static final Either all$$anonfun$1(List out$1) {
        return package$.MODULE$.right((Object)out$1);
    }

    private final Option get$$anonfun$1(String id$1) {
        Some some;
        GetSecretValueRequest request = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(id$1).build();
        try {
            GetSecretValueResponse response = this.client().getSecretValue(request);
            some = Some$.MODULE$.apply((Object)SecretsStore$Content$.MODULE$.apply(response.secretString(), (Option<Object>)None$.MODULE$));
        }
        catch (Exception ex) {
            Predef$.MODULE$.println((Object)("Unable to get secret " + new SecretsStore.ContentId(id$1) + ", " + ex.getMessage()));
            some = None$.MODULE$;
        }
        return some;
    }

    public static final class AddInfo
    implements Product,
    Serializable {
        private final String name;
        private final String secret;
        private final String contentId;

        public static AddInfo apply(String string, String string2, String string3) {
            return AWSSecretsStoreLocation$AddInfo$.MODULE$.apply(string, string2, string3);
        }

        public static AddInfo fromProduct(Product product) {
            return AWSSecretsStoreLocation$AddInfo$.MODULE$.fromProduct(product);
        }

        public static AddInfo unapply(AddInfo addInfo) {
            return AWSSecretsStoreLocation$AddInfo$.MODULE$.unapply(addInfo);
        }

        public AddInfo(String name, String secret, String contentId) {
            this.name = name;
            this.secret = secret;
            this.contentId = contentId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AddInfo)) return false;
            AddInfo addInfo = (AddInfo)object;
            String string = this.name();
            String string2 = addInfo.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.secret();
            String string4 = addInfo.secret();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.contentId();
            String string6 = addInfo.contentId();
            if (string5 == null) {
                if (string6 == null) return true;
                return false;
            } else {
                if (!string5.equals(string6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AddInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "AddInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "secret";
                }
                case 2: {
                    return "contentId";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String secret() {
            return this.secret;
        }

        public String contentId() {
            return this.contentId;
        }

        public boolean isLink() {
            return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.contentId()));
        }

        public AddInfo copy(String name, String secret, String contentId) {
            return new AddInfo(name, secret, contentId);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.secret();
        }

        public String copy$default$3() {
            return this.contentId();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.secret();
        }

        public String _3() {
            return this.contentId();
        }
    }
}

