/*
 * Decompiled with CFR 0.152.
 */
package ambience.secrets;

import ambience.api.Secrets;
import ambience.arch.Arch$;
import ambience.module.UserDB;
import ambience.secrets.SecretsAPI;
import ambience.secrets.SecretsAPI$Access$;
import ambience.secrets.SecretsStore;
import ambience.secrets.SecretsStore$;
import ambience.secrets.SecretsStore$ContentId$;
import ambience.secrets.SecretsStore$Id$;
import ambience.secrets.SecretsStore$LocationId$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.typesafe.config.Config;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonArray;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class SecretsAPI$
implements Secrets,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_6 = LazyVals$.MODULE$.getOffsetStatic(SecretsAPI$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_5 = LazyVals$.MODULE$.getOffsetStatic(SecretsAPI$.class.getDeclaredField("AuditComponent$lzy1"));
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(SecretsAPI$.class.getDeclaredField("auditAppender$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(SecretsAPI$.class.getDeclaredField("cacheSecs$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(SecretsAPI$.class.getDeclaredField("config$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(SecretsAPI$.class.getDeclaredField("cltnT$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SecretsAPI$.class.getDeclaredField("codexDB$lzy1"));
    private volatile Object log$lzy1;
    public static final SecretsAPI$Access$ Access;
    private volatile Object codexDB$lzy1;
    private volatile Object cltnT$lzy1;
    private volatile Object config$lzy1;
    private volatile Object cacheSecs$lzy1;
    private volatile Object auditAppender$lzy1;
    private volatile Object AuditComponent$lzy1;
    public static final SecretsAPI$ MODULE$;

    private SecretsAPI$() {
    }

    static {
        MODULE$ = new SecretsAPI$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SecretsAPI$.class);
    }

    public CodexDB codexDB() {
        Object object = this.codexDB$lzy1;
        if (object instanceof CodexDB) {
            return (CodexDB)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CodexDB)this.codexDB$lzyINIT1();
    }

    private Object codexDB$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codexDB$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CodexDB codexDB = null;
                    try {
                        codexDB = (CodexDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(CodexDB.class));
                        object2 = codexDB == null ? LazyVals.NullValue$.MODULE$ : codexDB;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codexDB$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return codexDB;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<CodexCollection> cltnT() {
        Object object = this.cltnT$lzy1;
        if (object instanceof Task) {
            return (Task)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Task)this.cltnT$lzyINIT1();
    }

    private Object cltnT$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cltnT$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Task task = null;
                    try {
                        task = this.codexDB().getCodexCollection("Secrets").memoize();
                        object2 = task == null ? LazyVals.NullValue$.MODULE$ : task;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltnT$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return task;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Config config() {
        Object object = this.config$lzy1;
        if (object instanceof Config) {
            return (Config)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Config)this.config$lzyINIT1();
    }

    private Object config$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.config$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Config config = null;
                    try {
                        config = (Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class));
                        object2 = config == null ? LazyVals.NullValue$.MODULE$ : config;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.config$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return config;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public long cacheSecs() {
        Object object = this.cacheSecs$lzy1;
        if (object instanceof Long) {
            return BoxesRunTime.unboxToLong((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToLong(null);
        }
        return BoxesRunTime.unboxToLong((Object)this.cacheSecs$lzyINIT1());
    }

    private Object cacheSecs$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cacheSecs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Long l = null;
                    try {
                        l = BoxesRunTime.boxToLong((long)this.config().getDuration("ambience.modules.secrets.cache", scala.concurrent.duration.package$.MODULE$.SECONDS()));
                        object2 = l == null ? LazyVals.NullValue$.MODULE$ : l;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cacheSecs$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return l;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.AuditAppender auditAppender() {
        Object object = this.auditAppender$lzy1;
        if (object instanceof AuditAPI.AuditAppender) {
            return (AuditAPI.AuditAppender)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AuditAPI.AuditAppender)this.auditAppender$lzyINIT1();
    }

    private Object auditAppender$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.auditAppender$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AuditAPI.AuditAppender auditAppender = null;
                    try {
                        auditAppender = (AuditAPI.AuditAppender)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(AuditAPI.AuditAppender.class));
                        object2 = auditAppender == null ? LazyVals.NullValue$.MODULE$ : auditAppender;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.auditAppender$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return auditAppender;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.Component AuditComponent() {
        Object object = this.AuditComponent$lzy1;
        if (object instanceof AuditAPI.Component) {
            return (AuditAPI.Component)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AuditAPI.Component)this.AuditComponent$lzyINIT1();
    }

    private Object AuditComponent$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.AuditComponent$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AuditAPI.Component component = null;
                    try {
                        component = AuditAPI.Component$.MODULE$.apply("secrets", "api-read-secret");
                        object2 = component == null ? LazyVals.NullValue$.MODULE$ : component;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.AuditComponent$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return component;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Option<Secrets.Value>> getSystemSecret(String name) {
        String systemName = "elxAmbienceSystem";
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name))).firstOptionL().flatMap((Function1 & Serializable)optDoc -> ((Task)optDoc.map((Function1 & Serializable)doc -> MODULE$.loadViaLocationId(systemName, (Document)doc, name)).getOrElse(() -> SecretsAPI$.getSystemSecret$$anonfun$1$$anonfun$1$$anonfun$2(systemName, name))).map((Function1 & Serializable)opt -> opt)));
    }

    public Task<Option<Secrets.Value>> getSecret(UserDB.User user, String name) {
        if (user.privileges().contains((Object)"mod-secrets-reader")) {
            return this.cltnT().flatMap((Function1 & Serializable)_$1 -> _$1.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name))).firstOptionL()).flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Document doc = (Document)((Some)option).value();
                    List access2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((BsonArray)doc.get("access", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).getOrElse(SecretsAPI$::$anonfun$1)).getValues()).asScala().flatMap((Function1 & Serializable)v -> MODULE$.toAccess((BsonValue)v))).toList();
                    if (access2.exists((Function1 & Serializable)access -> MODULE$.search(user, (SecretsAPI.Access)access))) {
                        return MODULE$.loadViaLocationId(user.name(), doc, name);
                    }
                    return MODULE$.logNotAuthorised(user.name(), name);
                }
                if (None$.MODULE$.equals(option)) {
                    return MODULE$.logNoSecret(user.name(), name);
                }
                throw new MatchError((Object)option);
            });
        }
        return this.logNoModPrivilege(user.name(), name);
    }

    public Task<Option<Secrets.Value>> loadViaLocationId(String userName, Document doc, String name) {
        Option option = doc.get("locationId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue());
        if (option instanceof Some) {
            String loc = (String)((Some)option).value();
            return this.loadFromLocation(userName, doc, loc, name);
        }
        if (None$.MODULE$.equals(option)) {
            return this.logNoLocation(userName, name);
        }
        throw new MatchError((Object)option);
    }

    public Task<Option<Secrets.Value>> loadFromLocation(String userName, Document doc, String loc, String name) {
        String contentId = SecretsStore$ContentId$.MODULE$.apply((String)doc.get("contentId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)c -> Arch$.MODULE$.opts(c.getValue())).getOrElse(() -> SecretsAPI$.$anonfun$4(name)));
        SecretsStore.Id id = SecretsStore$Id$.MODULE$.apply(SecretsStore$LocationId$.MODULE$.apply(loc), contentId);
        this.log().info(() -> SecretsAPI$.loadFromLocation$$anonfun$1(loc), Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.secrets.SecretsAPI.loadFromLocation"));
        return SecretsStore$.MODULE$.get(id).map((Function1 & Serializable)optC -> optC.map((Function1 & Serializable)c -> Secrets.Value$.MODULE$.apply(c.secret(), BoxesRunTime.unboxToLong((Object)c.optCache().getOrElse(SecretsAPI$::loadFromLocation$$anonfun$2$$anonfun$1$$anonfun$1))))).map((Function1 & Serializable)ret -> {
            AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(true, name, "Read", (Option)Some$.MODULE$.apply((Object)name));
            AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(userName, MODULE$.AuditComponent(), action);
            MODULE$.auditAppender().append(auditMsg);
            return ret;
        });
    }

    public Task<Option<Secrets.Value>> logNoLocation(String userName, String name) {
        AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(false, name, "Read", (Option)Some$.MODULE$.apply((Object)name));
        AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(userName, this.AuditComponent(), action);
        this.auditAppender().append(auditMsg);
        this.log().error(() -> SecretsAPI$.logNoLocation$$anonfun$1(name), Line$.MODULE$.apply(73), FullName$.MODULE$.apply("ambience.secrets.SecretsAPI.logNoLocation"));
        return Task$.MODULE$.now((Object)None$.MODULE$);
    }

    public Task<Option<Secrets.Value>> logNotAuthorised(String userName, String name) {
        AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(false, name, "Read", (Option)Some$.MODULE$.apply((Object)name));
        AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(userName, this.AuditComponent(), action);
        this.auditAppender().append(auditMsg);
        this.log().info(() -> SecretsAPI$.logNotAuthorised$$anonfun$1(userName, name), Line$.MODULE$.apply(81), FullName$.MODULE$.apply("ambience.secrets.SecretsAPI.logNotAuthorised"));
        return Task$.MODULE$.now((Object)None$.MODULE$);
    }

    public Task<Option<Secrets.Value>> logNoSecret(String userName, String name) {
        AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(false, name, "Read", (Option)Some$.MODULE$.apply((Object)name));
        AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(userName, this.AuditComponent(), action);
        this.auditAppender().append(auditMsg);
        this.log().info(() -> SecretsAPI$.logNoSecret$$anonfun$1(name), Line$.MODULE$.apply(89), FullName$.MODULE$.apply("ambience.secrets.SecretsAPI.logNoSecret"));
        return Task$.MODULE$.now((Object)None$.MODULE$);
    }

    public Task<Option<Secrets.Value>> logNoModPrivilege(String userName, String name) {
        AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(false, name, "Read", (Option)Some$.MODULE$.apply((Object)name));
        AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(userName, this.AuditComponent(), action);
        this.auditAppender().append(auditMsg);
        this.log().info(() -> SecretsAPI$.logNoModPrivilege$$anonfun$1(userName), Line$.MODULE$.apply(97), FullName$.MODULE$.apply("ambience.secrets.SecretsAPI.logNoModPrivilege"));
        return Task$.MODULE$.none();
    }

    public boolean search(UserDB.User user, SecretsAPI.Access access) {
        String string = access.accessType();
        switch (string == null ? 0 : string.hashCode()) {
            case 42: {
                if (!"*".equals(string)) break;
                return true;
            }
            case 2552982: {
                if (!"Role".equals(string)) break;
                return ((SetOps)user.roles().map((Function1 & Serializable)_$3 -> _$3.id())).contains((Object)access.id());
            }
            case 2645995: {
                if (!"User".equals(string)) break;
                String string2 = access.id();
                String string3 = user.id();
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
        }
        return false;
    }

    public Option<SecretsAPI.Access> toAccess(BsonValue v) {
        return (v.isDocument() ? Some$.MODULE$.apply((Object)org.mongodb.scala.bson.package$.MODULE$.Document().apply(v.asDocument())) : None$.MODULE$).flatMap((Function1 & Serializable)doc -> doc.get("accessType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$4 -> _$4.getValue()).flatMap((Function1 & Serializable)accessType -> doc.get("id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$5 -> _$5.getValue()).map((Function1 & Serializable)id -> SecretsAPI$Access$.MODULE$.apply((String)accessType, (String)id))));
    }

    public Task<List<String>> getSecretsNames(UserDB.User user) {
        if (user.privileges().contains((Object)"mod-secrets-reader")) {
            return this.cltnT().flatMap((Function1 & Serializable)_$6 -> _$6.findO((CodexFilter)CodexFilter.Exists$.MODULE$.apply("name")).map((Function1 & Serializable)doc -> {
                List access2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((BsonArray)doc.get("access", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).getOrElse(SecretsAPI$::$anonfun$5)).getValues()).asScala().flatMap((Function1 & Serializable)v -> MODULE$.toAccess((BsonValue)v))).toList();
                if (access2.exists((Function1 & Serializable)access -> MODULE$.search(user, (SecretsAPI.Access)access))) {
                    Option option = doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$7 -> _$7.getValue());
                    if (option instanceof Some) {
                        String name = (String)((Some)option).value();
                        return Some$.MODULE$.apply((Object)name);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return None$.MODULE$;
                    }
                    throw new MatchError((Object)option);
                }
                return None$.MODULE$;
            }).toListL().map((Function1 & Serializable)_$8 -> (List)_$8.flatten(Predef$.MODULE$.$conforms())));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Nil());
    }

    private static final Task getSystemSecret$$anonfun$1$$anonfun$1$$anonfun$2(String systemName$4, String name$4) {
        return MODULE$.logNoSecret(systemName$4, name$4);
    }

    private static final BsonArray $anonfun$1() {
        return BsonArray$.MODULE$.fromIterable((Iterable)package$.MODULE$.Nil());
    }

    private static final String $anonfun$4(String name$7) {
        return name$7;
    }

    private static final Object loadFromLocation$$anonfun$1(String loc$1) {
        return "fetching from secrets store: " + loc$1;
    }

    private static final long loadFromLocation$$anonfun$2$$anonfun$1$$anonfun$1() {
        return MODULE$.cacheSecs();
    }

    private static final Object logNoLocation$$anonfun$1(String name$9) {
        return "secret " + name$9 + " locationId missing";
    }

    private static final Object logNotAuthorised$$anonfun$1(String userName$2, String name$10) {
        return userName$2 + " is not authorised to read secret " + name$10;
    }

    private static final Object logNoSecret$$anonfun$1(String name$11) {
        return "secret " + name$11 + " not found";
    }

    private static final Object logNoModPrivilege$$anonfun$1(String userName$3) {
        return userName$3 + " does not have mod-secrets-reader";
    }

    private static final BsonArray $anonfun$5() {
        return BsonArray$.MODULE$.fromIterable((Iterable)package$.MODULE$.Nil());
    }
}

