/*
 * Decompiled with CFR 0.152.
 */
package ambience.secrets;

import ambience.codex.AuditedUUIDDocumentManager;
import ambience.codex.UUIDDocumentManager$;
import ambience.framework.ErrorExplanation$;
import ambience.module.UserDB;
import ambience.secrets.SecretsModule;
import ambience.secrets.SecretsStore$;
import ambience.secrets.SecretsStore$ContentId$;
import ambience.secrets.SecretsStore$LocationId$;
import ambience.secrets.SecretsStoreAPI$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LogMessage$None$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexIndex;
import com.elixirtech.codex.CodexUpdate;
import com.elixirtech.coredata.JsonProcessor;
import com.elixirtech.coredata.JsonProcessor$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public class SecretsManager
extends AuditedUUIDDocumentManager
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SecretsManager.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final SecretsModule module;
    private final AuditAPI.AuditAppender auditAppender;
    private final AuditAPI.Component auditComponent;
    private final Scheduler scheduler;
    private final Function1 UnAugmenter;

    public SecretsManager(SecretsModule module) {
        this.module = module;
        this.auditAppender = module.auditAppender();
        this.auditComponent = module.AuditComponent();
        this.scheduler = Scheduler$.MODULE$.global();
        List list = (List)new .colon.colon((Object)JsonProcessor.LimitStringLength$.MODULE$.apply((Option)None$.MODULE$, "name", module.projectConfig().MaxNameLength()), (List)Nil$.MODULE$);
        this.UnAugmenter = (Function1 & Serializable)json -> JsonProcessor$.MODULE$.run((Seq)list, json);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.AuditAppender auditAppender() {
        return this.auditAppender;
    }

    public AuditAPI.Component auditComponent() {
        return this.auditComponent;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Function1<Json, Json> UnAugmenter() {
        return this.UnAugmenter;
    }

    public Task<CodexCollection> cltnT() {
        return this.module.codexDB().getCodexCollection("Secrets").flatMap((Function1 & Serializable)c -> c.createIndexT((CodexIndex)CodexIndex.ExpireAt$.MODULE$.apply("expireAt")).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return c;
        })).memoize();
    }

    public String uniqueKey() {
        return "name";
    }

    public String extension() {
        return ".secrets.json";
    }

    public Task<LogMessage> delete(UserDB.User user, String uuid) {
        CodexFilter.Eq filter = CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(uuid));
        Task item = this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.findO((CodexFilter)filter).toListL().map((Function1 & Serializable)reply -> reply.headOption()));
        return item.flatMap((Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                boolean control = doc.get("control", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).exists((Function1 & Serializable)_$1 -> _$1.getValue());
                if (control) {
                    Option option2 = doc.get("locationId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue());
                    if (option2 instanceof Some) {
                        String loc = (String)((Some)option2).value();
                        String contentId = (String)doc.get("contentId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).getOrElse(() -> SecretsManager.$anonfun$4(uuid));
                        return SecretsStore$.MODULE$.delete(SecretsStore$ContentId$.MODULE$.apply(contentId), SecretsStore$LocationId$.MODULE$.apply(loc)).flatMap((Function1 & Serializable)x$1 -> this.delete$$anonfun$1$$anonfun$2(user, uuid, BoxesRunTime.unboxToBoolean((Object)x$1)));
                    }
                    if (None$.MODULE$.equals(option2)) {
                        return Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Missing locationId"));
                    }
                    throw new MatchError((Object)option2);
                }
                return this.definiteDelete(user, uuid);
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Unable to find record to delete"));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<LogMessage> definiteDelete(UserDB.User user, String uuid) {
        Task ret = this.logInfo(() -> SecretsManager.$anonfun$5(uuid)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.deleteOneT(this.getEditFilter(user, BsonString$.MODULE$.apply(uuid))).map((Function1 & Serializable)x$1 -> {
                CodexDB.DeleteResult deleteResult = x$1;
                return LogMessage$None$.MODULE$;
            }));
        }).onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Delete failed", ex));
        return ret.map((Function1 & Serializable)reply -> {
            LogMessage logMessage = reply;
            LogMessage$None$ logMessage$None$ = LogMessage$None$.MODULE$;
            AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(!(logMessage != null ? !logMessage.equals(logMessage$None$) : logMessage$None$ != null), uuid, "Deleted");
            AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(user.name(), this.auditComponent(), action);
            this.auditAppender().append(auditMsg);
            return reply;
        });
    }

    public Task<Json> get(UserDB.User user) {
        return super.get(user).flatMap((Function1 & Serializable)json -> (Task)json.asArray().map((Function1 & Serializable)v -> {
            Vector a = (Vector)v.map((Function1 & Serializable)j -> this.fix((Json)j).map((Function1 & Serializable)_$4 -> (Json)_$4.getOrElse(() -> SecretsManager.$anonfun$8$$anonfun$1$$anonfun$1(j))));
            Task b = Task$.MODULE$.sequence((Iterable)a, BuildFrom$.MODULE$.buildFromIterableOps());
            return b.map((Function1 & Serializable)values -> Json$.MODULE$.fromValues(values));
        }).getOrElse(() -> SecretsManager.get$$anonfun$1$$anonfun$2(json)));
    }

    public Task<Option<Json>> fix(Json json) {
        return this.isValidLocation(json).map((Function1 & Serializable)bool -> SecretsManager.fix$$anonfun$1(json, BoxesRunTime.unboxToBoolean((Object)bool)));
    }

    public Task<Object> isValidLocation(Json json) {
        Option option = json.hcursor().downField("locationId").focus().flatMap((Function1 & Serializable)_$5 -> _$5.asString());
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            return SecretsStoreAPI$.MODULE$.isValidLocationT(s);
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.apply(SecretsManager::isValidLocation$$anonfun$2);
        }
        throw new MatchError((Object)option);
    }

    public Task<Either<LogMessage, Document>> add(UserDB.User user, BsonValue key, Document doc) {
        Document document;
        Option option = doc.get("expireAt", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt64.class)).map((Function1 & Serializable)_$6 -> _$6.getValue());
        if (option instanceof Some) {
            long l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (0L == l) {
                document = (Document)doc.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"expireAt"}));
            } else {
                long num = l;
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"expireAt");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDateTime$.MODULE$.apply(num)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                document = (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }
        } else if (None$.MODULE$.equals(option)) {
            document = doc;
        } else {
            throw new MatchError((Object)option);
        }
        Document doc2 = document;
        Option option2 = doc.get("locationId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$7 -> _$7.getValue());
        if (option2 instanceof Some) {
            String loc = (String)((Some)option2).value();
            return SecretsStore$.MODULE$.add(doc2, SecretsStore$LocationId$.MODULE$.apply(loc)).flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Right) {
                    Document doc3 = (Document)((Right)either).value();
                    return super.add(user, key, doc3);
                }
                if (either instanceof Left) {
                    LogMessage log = (LogMessage)((Left)either).value();
                    return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)log));
                }
                throw new MatchError((Object)either);
            });
        }
        if (None$.MODULE$.equals(option2)) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing locationId")));
        }
        throw new MatchError((Object)option2);
    }

    public CodexFilter getEditFilter(UserDB.User user, BsonString uuid) {
        return UUIDDocumentManager$.MODULE$.withId(uuid);
    }

    public Task<LogMessage> update(UserDB.User user, BsonString id, BsonValue key, Document doc) {
        Option option = doc.get("locationId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$8 -> _$8.getValue());
        if (option instanceof Some) {
            String loc = (String)((Some)option).value();
            return SecretsStore$.MODULE$.update(doc, SecretsStore$LocationId$.MODULE$.apply(loc)).flatMap((Function1 & Serializable)updateSecret -> this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.updateOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)id), this.buildUpdate(doc, (Option<CodexUpdate>)updateSecret)).flatMap((Function1 & Serializable)x$12 -> {
                CodexDB.UpdateResult updateResult = x$12;
                return this.auditT(user, id, key, true).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return LogMessage$None$.MODULE$;
                });
            })));
        }
        if (None$.MODULE$.equals(option)) {
            return this.auditT(user, id, key, false).as((Object)LogMessage.Error$.MODULE$.apply("Missing locationId"));
        }
        throw new MatchError((Object)option);
    }

    public CodexUpdate buildUpdate(Document doc, Option<CodexUpdate> updateSecret) {
        Option updateName = doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$9 -> CodexUpdate.Set$.MODULE$.apply("name", _$9));
        Option updateExpiry = Option$.MODULE$.apply((Object)this.asDateTime((Option<BsonInt64>)doc.get("expireAt", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt64.class))));
        Option updateAccess = doc.get("access", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$10 -> CodexUpdate.Set$.MODULE$.apply("access", _$10));
        Some updateModified = Some$.MODULE$.apply((Object)CodexUpdate.CurrentTimestamp$.MODULE$.apply("lastModified"));
        List updateItems = (List)((StrictOptimizedIterableOps)new .colon.colon((Object)updateName, (List)new .colon.colon((Object)updateExpiry, (List)new .colon.colon(updateSecret, (List)new .colon.colon((Object)updateAccess, (List)new .colon.colon((Object)updateModified, (List)Nil$.MODULE$)))))).flatten(Predef$.MODULE$.$conforms());
        return CodexUpdate.Combine$.MODULE$.apply((Seq)updateItems);
    }

    public Task<BoxedUnit> auditT(UserDB.User user, BsonString id, BsonValue key, boolean success) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.auditT$$anonfun$1(key, success, id, user);
            return BoxedUnit.UNIT;
        });
    }

    public CodexUpdate asDateTime(Option<BsonInt64> opt) {
        CodexUpdate.Unset unset;
        Option<BsonInt64> option = opt;
        if (option instanceof Some) {
            BsonInt64 bv = (BsonInt64)((Some)option).value();
            unset = CodexUpdate.Set$.MODULE$.apply("expireAt", (BsonValue)this.asDateTime(bv));
        } else if (None$.MODULE$.equals(option)) {
            unset = CodexUpdate.Unset$.MODULE$.apply("expireAt");
        } else {
            throw new MatchError(option);
        }
        return (CodexUpdate)unset;
    }

    public BsonDateTime asDateTime(BsonInt64 bson) {
        return BsonDateTime$.MODULE$.apply(bson.getValue());
    }

    public Task<Either<LogMessage, Json>> save(UserDB.User user, Json json) {
        return super.save(user, (Json)this.UnAugmenter().apply((Object)json));
    }

    private static final String $anonfun$4(String uuid$2) {
        return uuid$2;
    }

    private final /* synthetic */ Task delete$$anonfun$1$$anonfun$2(UserDB.User user$2, String uuid$3, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return this.definiteDelete(user$2, uuid$3);
        }
        if (!bl) {
            return Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Unable to delete"));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final String $anonfun$5(String uuid$4) {
        return "deleting " + uuid$4;
    }

    private static final Json $anonfun$8$$anonfun$1$$anonfun$1(Json j$2) {
        return j$2;
    }

    private static final Json get$$anonfun$1$$anonfun$2$$anonfun$1(Json json$2) {
        return json$2;
    }

    private static final Task get$$anonfun$1$$anonfun$2(Json json$1) {
        return Task$.MODULE$.apply(() -> SecretsManager.get$$anonfun$1$$anonfun$2$$anonfun$1(json$1));
    }

    private static final Json fix$$anonfun$1$$anonfun$2(Json json$4) {
        return json$4;
    }

    private static final /* synthetic */ Option fix$$anonfun$1(Json json$3, boolean bool) {
        if (bool) {
            return Some$.MODULE$.apply(json$3.asObject().map((Function1 & Serializable)obj -> Json$.MODULE$.fromJsonObject(obj.remove("secret"))).getOrElse(() -> SecretsManager.fix$$anonfun$1$$anonfun$2(json$3)));
        }
        return None$.MODULE$;
    }

    private static final boolean isValidLocation$$anonfun$2() {
        return false;
    }

    private static final BsonString $anonfun$12(BsonValue key$6) {
        return key$6.asString();
    }

    private final void auditT$$anonfun$1(BsonValue key$5, boolean success$1, BsonString id$4, UserDB.User user$10) {
        Option optName = Try$.MODULE$.apply(() -> SecretsManager.$anonfun$12(key$5)).toOption().map((Function1 & Serializable)_$11 -> _$11.getValue());
        AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(success$1, id$4.getValue(), "Updated", optName);
        AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(user$10.name(), this.auditComponent(), action);
        this.auditAppender().append(auditMsg);
    }
}

