/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.info;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MinuteMinder;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class JVMMinuteMinder
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JVMMinuteMinder.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final MinuteMinder minuteMinder;
    private final long MB;
    private final Option optBean;
    private final java.lang.management.OperatingSystemMXBean osBean;
    private final MemoryMXBean memBean;

    public JVMMinuteMinder(MinuteMinder minuteMinder) {
        Some some;
        this.minuteMinder = minuteMinder;
        this.MB = 0x100000L;
        Try try_ = Try$.MODULE$.apply(JVMMinuteMinder::$init$$$anonfun$1);
        if (try_ instanceof Success) {
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = (java.lang.management.OperatingSystemMXBean)((Success)try_).value();
            if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean bean = (OperatingSystemMXBean)operatingSystemMXBean;
                some = Some$.MODULE$.apply((Object)bean);
            } else {
                java.lang.management.OperatingSystemMXBean x = operatingSystemMXBean;
                this.log().warn(() -> JVMMinuteMinder.$init$$$anonfun$2(x), Line$.MODULE$.apply(17), FullName$.MODULE$.apply("com.elixirtech.arch.info.JVMMinuteMinder.optBean"));
                some = None$.MODULE$;
            }
        } else if (try_ instanceof Failure) {
            Throwable err = ((Failure)try_).exception();
            this.log().warn(() -> JVMMinuteMinder.$init$$$anonfun$3(err), Line$.MODULE$.apply(18), FullName$.MODULE$.apply("com.elixirtech.arch.info.JVMMinuteMinder.optBean"));
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        this.optBean = some;
        this.osBean = ManagementFactory.getOperatingSystemMXBean();
        this.memBean = ManagementFactory.getMemoryMXBean();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public long MB() {
        return this.MB;
    }

    public Option<OperatingSystemMXBean> optBean() {
        return this.optBean;
    }

    public java.lang.management.OperatingSystemMXBean osBean() {
        return this.osBean;
    }

    public MemoryMXBean memBean() {
        return this.memBean;
    }

    public void tick() {
        int sysLoad = (int)(this.osBean().getSystemLoadAverage() * (double)100);
        MemoryUsage memHeapUsage = this.memBean().getHeapMemoryUsage();
        int totalMemory = (int)(memHeapUsage.getMax() / this.MB());
        int usedMemory = (int)(memHeapUsage.getUsed() / this.MB());
        this.minuteMinder.gauge("TotalRAM", totalMemory);
        this.minuteMinder.gauge("ProcessRAM", usedMemory);
        this.minuteMinder.gauge("SystemLoad", sysLoad);
        Option<OperatingSystemMXBean> option = this.optBean();
        if (option instanceof Some) {
            OperatingSystemMXBean bean = (OperatingSystemMXBean)((Some)option).value();
            int procCpu = (int)(bean.getProcessCpuLoad() * (double)100);
            int sysCpu = (int)(bean.getCpuLoad() * (double)100);
            this.minuteMinder.gauge("ProcessCPU", procCpu);
            this.minuteMinder.gauge("SystemCPU", sysCpu);
            this.log().info(() -> JVMMinuteMinder.tick$$anonfun$1(procCpu, sysCpu, usedMemory, totalMemory, sysLoad), Line$.MODULE$.apply(39), FullName$.MODULE$.apply("com.elixirtech.arch.info.JVMMinuteMinder.tick"));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.log().info(() -> JVMMinuteMinder.tick$$anonfun$2(usedMemory, totalMemory, sysLoad), Line$.MODULE$.apply(41), FullName$.MODULE$.apply("com.elixirtech.arch.info.JVMMinuteMinder.tick"));
            return;
        }
        throw new MatchError(option);
    }

    private static final java.lang.management.OperatingSystemMXBean $init$$$anonfun$1() {
        return ManagementFactory.getOperatingSystemMXBean();
    }

    private static final Object $init$$$anonfun$2(java.lang.management.OperatingSystemMXBean x$1) {
        return "Unexpected MXBean: " + x$1;
    }

    private static final Object $init$$$anonfun$3(Throwable err$1) {
        return "Can't obtain OS MXBean: " + err$1;
    }

    private static final Object tick$$anonfun$1(int procCpu$1, int sysCpu$1, int usedMemory$1, int totalMemory$1, int sysLoad$1) {
        return "CPU: " + procCpu$1 + " / " + sysCpu$1 + " RAM: " + usedMemory$1 + " / " + totalMemory$1 + " Load: " + sysLoad$1;
    }

    private static final Object tick$$anonfun$2(int usedMemory$2, int totalMemory$2, int sysLoad$2) {
        return "RAM: " + usedMemory$2 + " / " + totalMemory$2 + " Load: " + sysLoad$2;
    }
}

