/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.UpdateOptions;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import org.bson.BsonArray;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;

public final class DBUtils$
implements Serializable {
    private static final IndexOptions IndexUnique;
    private static final BulkWriteOptions BulkUnordered;
    private static final BulkWriteOptions BulkOrdered;
    private static final UpdateOptions Upsert;
    private static final Document All;
    public static final DBUtils$ MODULE$;

    private DBUtils$() {
    }

    static {
        MODULE$ = new DBUtils$();
        IndexUnique = new IndexOptions().unique(true);
        BulkUnordered = new BulkWriteOptions().ordered(false);
        BulkOrdered = new BulkWriteOptions().ordered(true);
        Upsert = new UpdateOptions().upsert(true);
        All = new Document(new BsonDocument());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DBUtils$.class);
    }

    public IndexOptions IndexUnique() {
        return IndexUnique;
    }

    public BulkWriteOptions BulkUnordered() {
        return BulkUnordered;
    }

    public BulkWriteOptions BulkOrdered() {
        return BulkOrdered;
    }

    public UpdateOptions Upsert() {
        return Upsert;
    }

    public Document All() {
        return All;
    }

    public Set<String> toSet(BsonValue doc) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(doc.asArray().getValues()).asScala().map((Function1 & Serializable)_$1 -> _$1.asString().getValue())).toSet();
    }

    public BsonValue toBsonSet(Set<String> set) {
        BsonArray bv = new BsonArray();
        set.foreach((Function1 & Serializable)g -> bv.add((BsonValue)new BsonString(g)));
        return bv;
    }

    public Seq<String> toArray(BsonValue doc) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(doc.asArray().getValues()).asScala().map((Function1 & Serializable)_$2 -> _$2.asString().getValue())).toSeq();
    }

    public <T> Seq<T> toArray(BsonValue doc, Function1<BsonValue, T> fn) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(doc.asArray().getValues()).asScala().map(fn)).toSeq();
    }

    public BsonValue toBsonArray(Seq<String> seq) {
        BsonArray bv = new BsonArray();
        seq.foreach((Function1 & Serializable)g -> bv.add((BsonValue)new BsonString(g)));
        return bv;
    }

    public <T> BsonValue toBsonArray(Seq<T> seq, Function1<T, BsonValue> fn) {
        BsonArray bv = new BsonArray();
        seq.foreach((Function1 & Serializable)t -> bv.add((BsonValue)fn.apply(t)));
        return bv;
    }

    public Map<String, String> toMap(BsonValue doc) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(doc.asDocument().entrySet()).asScala().map((Function1 & Serializable)pair -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(pair.getKey());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((BsonValue)pair.getValue()).asString().getValue());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public BsonDocument toBsonMap(Map<String, String> map) {
        BsonDocument extras = new BsonDocument();
        map.foreach((Function1 & Serializable)f -> extras.append((String)f._1(), (BsonValue)new BsonString((String)f._2())));
        return extras;
    }

    public Bson whereId(String name) {
        return this.whereId((BsonValue)new BsonString(name));
    }

    public Bson whereObjectId(String name) {
        return this.whereId((BsonValue)new BsonObjectId(new ObjectId(name)));
    }

    public Bson whereId(BsonValue bson) {
        return Filters$.MODULE$.eq("_id", (Object)bson);
    }

    public void appendTimestamp(BsonDocument doc, long ts) {
        BsonDocument when = new BsonDocument();
        when.append("timestamp", (BsonValue)new BsonDateTime(ts));
        Instant inst = Instant.ofEpochMilli(ts);
        LocalDateTime ldt = LocalDateTime.ofInstant(inst, ZoneId.systemDefault());
        when.append("date", (BsonValue)new BsonString(ldt.getYear() + "-" + this.pad2(ldt.getMonthValue()) + "-" + this.pad2(ldt.getDayOfMonth())));
        int ms = ldt.get(ChronoField.MILLI_OF_SECOND);
        when.append("time", (BsonValue)new BsonString(this.pad2(ldt.getHour()) + ":" + this.pad2(ldt.getMinute()) + ":" + this.pad2(ldt.getSecond()) + "." + this.pad3(ms)));
        when.append("year", (BsonValue)new BsonInt32(ldt.getYear()));
        when.append("month", (BsonValue)new BsonInt32(ldt.getMonthValue()));
        when.append("day", (BsonValue)new BsonInt32(ldt.getDayOfMonth()));
        when.append("dayOfYear", (BsonValue)new BsonInt32(ldt.getDayOfYear()));
        when.append("dayOfWeek", (BsonValue)new BsonInt32(ldt.getDayOfWeek().getValue()));
        when.append("hour", (BsonValue)new BsonInt32(ldt.getHour()));
        when.append("minute", (BsonValue)new BsonInt32(ldt.getMinute()));
        when.append("second", (BsonValue)new BsonInt32(ldt.getSecond()));
        doc.append("when", (BsonValue)when);
    }

    public String pad2(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    public String pad3(int n) {
        if (n < 10) {
            return "00" + n;
        }
        if (n < 100) {
            return "0" + n;
        }
        return String.valueOf(n);
    }
}

