/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.key.collection.PGPKeyRingCollection;
import sop.exception.SOPGPException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/sop/KeyReader;", "", "()V", "Companion", "pgpainless-sop"})
public final class KeyReader {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final PGPSecretKeyRingCollection readSecretKeys(@NotNull InputStream keyInputStream, boolean requireContent) {
        return Companion.readSecretKeys(keyInputStream, requireContent);
    }

    @JvmStatic
    @NotNull
    public static final PGPPublicKeyRingCollection readPublicKeys(@NotNull InputStream certIn, boolean requireContent) {
        return Companion.readPublicKeys(certIn, requireContent);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\f"}, d2={"Lorg/pgpainless/sop/KeyReader$Companion;", "", "()V", "readPublicKeys", "Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "certIn", "Ljava/io/InputStream;", "requireContent", "", "readSecretKeys", "Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "keyInputStream", "pgpainless-sop"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PGPSecretKeyRingCollection readSecretKeys(@NotNull InputStream keyInputStream, boolean requireContent) {
            PGPSecretKeyRingCollection pGPSecretKeyRingCollection;
            Intrinsics.checkNotNullParameter((Object)keyInputStream, (String)"keyInputStream");
            try {
                pGPSecretKeyRingCollection = PGPainless.Companion.readKeyRing().secretKeyRingCollection(keyInputStream);
            }
            catch (IOException e) {
                block8: {
                    block7: {
                        if (e.getMessage() == null) {
                            throw e;
                        }
                        String string = e.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        if (StringsKt.startsWith$default((String)string, (String)"unknown object in stream:", (boolean)false, (int)2, null)) break block7;
                        String string2 = e.getMessage();
                        Intrinsics.checkNotNull((Object)string2);
                        if (!StringsKt.startsWith$default((String)string2, (String)"invalid header encountered", (boolean)false, (int)2, null)) break block8;
                    }
                    throw new SOPGPException.BadData((Throwable)e);
                }
                throw e;
            }
            PGPSecretKeyRingCollection keys2 = pGPSecretKeyRingCollection;
            if (requireContent && CollectionsKt.none((Iterable)((Iterable)keys2))) {
                throw new SOPGPException.BadData((Throwable)new PGPException("No key data found."));
            }
            return keys2;
        }

        @JvmStatic
        @NotNull
        public final PGPPublicKeyRingCollection readPublicKeys(@NotNull InputStream certIn, boolean requireContent) {
            PGPKeyRingCollection pGPKeyRingCollection;
            Intrinsics.checkNotNullParameter((Object)certIn, (String)"certIn");
            try {
                pGPKeyRingCollection = PGPainless.Companion.readKeyRing().keyRingCollection(certIn, true);
            }
            catch (IOException e) {
                block10: {
                    block9: {
                        if (e.getMessage() == null) {
                            throw e;
                        }
                        String string = e.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        if (StringsKt.startsWith$default((String)string, (String)"unknown object in stream:", (boolean)false, (int)2, null)) break block9;
                        String string2 = e.getMessage();
                        Intrinsics.checkNotNull((Object)string2);
                        if (!StringsKt.startsWith$default((String)string2, (String)"invalid header encountered", (boolean)false, (int)2, null)) break block10;
                    }
                    throw new SOPGPException.BadData((Throwable)e);
                }
                throw e;
            }
            catch (PGPRuntimeOperationException e) {
                throw new SOPGPException.BadData((Throwable)e);
            }
            PGPKeyRingCollection certs = pGPKeyRingCollection;
            if (CollectionsKt.any((Iterable)((Iterable)certs.getPgpSecretKeyRingCollection()))) {
                throw new SOPGPException.BadData("Secret key components encountered, while certificates were expected.");
            }
            if (requireContent && CollectionsKt.none((Iterable)((Iterable)certs.getPgpPublicKeyRingCollection()))) {
                throw new SOPGPException.BadData((Throwable)new PGPException("No cert data found."));
            }
            return certs.getPgpPublicKeyRingCollection();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

