/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.docprocessor;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.js.ScriptException;
import com.elixirtech.opc.docprocessor.Config;
import com.elixirtech.opc.docprocessor.DocRenderContext;
import com.elixirtech.opc.docprocessor.Node;
import com.elixirtech.opc.docprocessor.Processor;
import com.elixirtech.opc.docprocessor.TablePos;
import java.util.Map;

public class Callback
implements ArgumentMap.ICallback {
    private final Processor m_Processor;
    private final DocRenderContext m_Context;
    private final Config m_Config;
    private final Map<String, String> m_LocalParams;

    public Callback(Processor processor, DocRenderContext docRenderContext, Config config, Map<String, String> map) {
        this.m_Processor = processor;
        this.m_Context = docRenderContext;
        this.m_Config = config;
        this.m_LocalParams = map;
    }

    public String getValue(String string, String string2) {
        Object object;
        String string3;
        int n;
        Object object2;
        if (string.startsWith("@")) {
            object2 = "/Elx/@/" + string.substring(1);
            Node node = this.m_Config.getNode((String)object2);
            if (node != null) {
                string = node.getChildText();
            } else {
                this.m_Context.error("Error in alias, can't find " + (String)object2);
                return "";
            }
        }
        object2 = "%s";
        if (string.startsWith("%") && (n = string.indexOf("|")) > 0) {
            object2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if (string.startsWith("=")) {
            try {
                return String.format((String)object2, this.m_Context.evaluate("script substitution", string.substring(1)));
            }
            catch (ScriptException scriptException) {
                this.m_Context.error("Error in script substitution \"" + string + "\": " + String.valueOf((Object)scriptException));
                return null;
            }
        }
        int n2 = string.indexOf(":");
        if (n2 >= 0) {
            string3 = string.substring(0, n2);
            object = string.substring(n2 + 1);
            if (!string3.equals(this.m_Context.getCurrentTableName())) {
                try {
                    DataTable dataTable = this.m_Processor.buildTable(this, string3);
                    this.m_Context.addTable(string3, dataTable);
                    return this.m_Context.getValue((String)object2, string3, (String)object);
                }
                catch (DataException dataException) {
                    return "Error: " + String.valueOf((Object)dataException);
                }
            }
        }
        if (this.m_Context.hasTable()) {
            string3 = string.toLowerCase();
            if (string3.startsWith("count(")) {
                return this.count((String)object2, string);
            }
            if (string3.startsWith("average(")) {
                return this.average((String)object2, string);
            }
            if (string3.startsWith("sum(")) {
                return this.sum((String)object2, string);
            }
            object = this.m_Context.getTablePos();
            DataSchema dataSchema = ((TablePos)object).getSchema();
            int n3 = dataSchema.getColumnIndex(string);
            if (n3 >= 0) {
                DataType dataType = dataSchema.getColumnType(n3);
                DataRecord dataRecord = ((TablePos)object).getRecord();
                Object object3 = dataRecord.getData(n3);
                if ("%s".equals(object2)) {
                    return dataSchema.format(dataType, object3);
                }
                return String.format((String)object2, object3);
            }
        }
        if (this.m_LocalParams.containsKey(string)) {
            if ("%s".equals(object2)) {
                return this.m_LocalParams.get(string);
            }
            return String.format((String)object2, this.m_LocalParams.get(string));
        }
        this.m_Context.warn("Can't substitute \"" + string + "\"");
        return null;
    }

    private String count(String string, String string2) {
        TablePos tablePos;
        DataSchema dataSchema;
        int n;
        if ((string2 = string2.substring(6).trim()).endsWith(")")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((n = (dataSchema = (tablePos = this.m_Context.getTablePos()).getSchema()).getColumnIndex(string2)) >= 0) {
            Long l = tablePos.table.count(tablePos.group, n);
            if ("%s".equals(string)) {
                DataType dataType = dataSchema.getColumnType(n);
                return dataSchema.format(dataType, (Object)l);
            }
            return String.format(string, l);
        }
        this.m_Context.error("Unable to count \"" + string2 + "\"");
        return null;
    }

    private String average(String string, String string2) {
        TablePos tablePos;
        DataSchema dataSchema;
        int n;
        if ((string2 = string2.substring(8).trim()).endsWith(")")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((n = (dataSchema = (tablePos = this.m_Context.getTablePos()).getSchema()).getColumnIndex(string2)) >= 0) {
            Number number = tablePos.table.average(tablePos.group, n);
            if ("%s".equals(string)) {
                DataType dataType = dataSchema.getColumnType(n);
                return dataSchema.format(dataType, (Object)number);
            }
            return String.format(string, number);
        }
        this.m_Context.error("Unable to average \"" + string2 + "\"");
        return null;
    }

    private String sum(String string, String string2) {
        TablePos tablePos;
        DataSchema dataSchema;
        int n;
        if ((string2 = string2.substring(4).trim()).endsWith(")")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((n = (dataSchema = (tablePos = this.m_Context.getTablePos()).getSchema()).getColumnIndex(string2)) >= 0) {
            Number number = tablePos.table.sum(tablePos.group, n);
            if ("%s".equals(string)) {
                DataType dataType = dataSchema.getColumnType(n);
                return dataSchema.format(dataType, (Object)number);
            }
            return String.format(string, number);
        }
        this.m_Context.error("Unable to sum \"" + string2 + "\"");
        return null;
    }
}

