/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.docprocessor;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Element;
import com.elixirtech.opc.Package;
import com.elixirtech.opc.XMLPart;
import com.elixirtech.opc.docprocessor.Node;
import com.elixirtech.opc.docprocessor.Processor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Config {
    private Node m_Root = new Node(null, "");
    private List<String> m_Prefixes = new ArrayList<String>();
    private List<String> m_Suffixes = new ArrayList<String>();
    private boolean m_AsposeResize = false;
    private Map<String, String> m_AsposeReplacements = new HashMap<String, String>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Config.class);

    public Config(Package package_) {
        XMLPart xMLPart = (XMLPart)package_.getPart("/word/document.xml");
        if (xMLPart != null) {
            Element element = xMLPart.getDocument().getRootElement();
            Element element2 = element.getChild("body", Processor.NS_W);
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (Element element3 : element2.getChildren("p", Processor.NS_W)) {
                List list = element3.getChildren("r", Processor.NS_W);
                StringBuilder stringBuilder = new StringBuilder();
                for (Element element4 : list) {
                    Element element5 = element4.getChild("t", Processor.NS_W);
                    if (element5 == null) continue;
                    stringBuilder.append(element5.getText());
                }
                if (stringBuilder.length() <= 0 || !this.buildConfig(stringBuilder.toString().trim())) continue;
                arrayList.add(element3);
            }
            for (Element element3 : arrayList) {
                element2.removeContent((Content)element3);
            }
        }
    }

    public boolean buildConfig(String string) {
        m_Log.debug((Object)("buildConfig " + string));
        if (string.startsWith("/Elx/Prefix=")) {
            String string2 = string.substring(12);
            this.m_Prefixes.add(string2);
            return true;
        }
        if (string.startsWith("/Elx/Suffix=")) {
            String string3 = string.substring(12);
            this.m_Suffixes.add(string3);
            return true;
        }
        if (string.startsWith("/Elx/Aspose/Resize")) {
            this.m_AsposeResize = true;
            return true;
        }
        if (string.startsWith("/Elx/Aspose/Replace/")) {
            String string4 = string.substring(20);
            int n = string4.indexOf("=");
            if (n > 0) {
                this.m_AsposeReplacements.put(string4.substring(0, n).trim(), string4.substring(n + 1).trim());
            }
            return true;
        }
        if (string.startsWith("/Elx/")) {
            this.define(string);
            return true;
        }
        return false;
    }

    public Node define(String string) {
        String string2 = string.startsWith("/") ? string.substring(1) : string;
        String[] stringArray = string2.split("/");
        Node node = this.m_Root;
        for (int i = 0; i < stringArray.length; ++i) {
            node = node.buildChild(stringArray[i]);
        }
        return node;
    }

    public Node getNode(String string) {
        String string2;
        String string3 = string2 = string.startsWith("/") ? string.substring(1) : string;
        if (StringUtil.isEmpty((String)string2)) {
            return this.m_Root;
        }
        String[] stringArray = string2.split("/");
        Node node = this.m_Root;
        for (int i = 0; i < stringArray.length && (node = node.getChild(stringArray[i])) != null; ++i) {
        }
        return node;
    }

    public List<String> getPrefixes() {
        return this.m_Prefixes;
    }

    public List<String> getSuffixes() {
        return this.m_Suffixes;
    }

    public boolean getAsposeResize() {
        return this.m_AsposeResize;
    }

    public Map<String, String> getAsposeReplacements() {
        return this.m_AsposeReplacements;
    }
}

