/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.docprocessor;

import com.elixirtech.opc.BinaryPart;
import com.elixirtech.opc.Package;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.Relationship;
import com.elixirtech.opc.RelationshipsPart;
import com.elixirtech.opc.XMLPart;
import com.elixirtech.opc.docprocessor.Processor;

public class MediaHandler {
    public static final String IMAGE_TYPE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image";
    public static final String CHUNK_TYPE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/aFChunk";
    private final Package m_Package;
    private final RelationshipsPart m_Relationships;

    public MediaHandler(Processor processor) {
        this.m_Package = processor.getPackage();
        XMLPart xMLPart = (XMLPart)this.m_Package.getPart("/word/document.xml");
        this.m_Relationships = xMLPart.getRelationships();
    }

    public String addMedia(String string, byte[] byArray) {
        Part part;
        int n = 0;
        while ((part = this.m_Package.getPart(this.name(++n))) != null) {
        }
        part = new BinaryPart(this.name(n), string, byArray);
        this.m_Package.addPart(part);
        String string2 = this.m_Relationships.addRelationship(new Relationship(IMAGE_TYPE, this.relativeName(n)));
        return string2;
    }

    public String addHtml(byte[] byArray) {
        Part part;
        int n = 0;
        while ((part = this.m_Package.getPart(this.htmlName(++n))) != null) {
        }
        part = new BinaryPart(this.htmlName(n), "text/html", byArray);
        this.m_Package.addPart(part);
        String string = this.m_Relationships.addRelationship(new Relationship(CHUNK_TYPE, this.htmlRelativeName(n)));
        return string;
    }

    private String name(int n) {
        return "/word/media/image" + n + ".png";
    }

    private String htmlName(int n) {
        return "/word/media/html" + n + ".html";
    }

    private String relativeName(int n) {
        return "media/image" + n + ".png";
    }

    private String htmlRelativeName(int n) {
        return "media/html" + n + ".html";
    }
}

