/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.docprocessor;

import ambience.docxengine.aspose.AsposeExtensions;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.grouping.GroupDataSource2;
import com.elixirtech.data2.grouping.GroupDefinition;
import com.elixirtech.jdom.Attribute;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.jdom.filter.Filter;
import com.elixirtech.js.ScriptException;
import com.elixirtech.opc.ContentTypes;
import com.elixirtech.opc.Package;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.RelationshipsPart;
import com.elixirtech.opc.XMLPart;
import com.elixirtech.opc.ZipReader;
import com.elixirtech.opc.docprocessor.BTInfo;
import com.elixirtech.opc.docprocessor.Backtrack;
import com.elixirtech.opc.docprocessor.Callback;
import com.elixirtech.opc.docprocessor.Comment;
import com.elixirtech.opc.docprocessor.CommentHandler;
import com.elixirtech.opc.docprocessor.Config;
import com.elixirtech.opc.docprocessor.DocRenderContext;
import com.elixirtech.opc.docprocessor.ImageHandler;
import com.elixirtech.opc.docprocessor.MediaHandler;
import com.elixirtech.opc.docprocessor.NewLineExpander;
import com.elixirtech.opc.docprocessor.Node;
import com.elixirtech.opc.docprocessor.ResourceLoader;
import com.elixirtech.opc.docprocessor.SubstitutionChecker;
import com.elixirtech.opc.docprocessor.TablePos;
import com.elixirtech.opc.docprocessor.XMLUtil;
import com.elixirtech.opc.docprocessor.XMLValidator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Processor {
    public static final Namespace NS_W = Namespace.getNamespace((String)"w", (String)"http://schemas.openxmlformats.org/wordprocessingml/2006/main");
    public static final Namespace NS_A = Namespace.getNamespace((String)"a", (String)"http://schemas.openxmlformats.org/drawingml/2006/main");
    public static final Namespace NS_R = Namespace.getNamespace((String)"r", (String)"http://schemas.openxmlformats.org/officeDocument/2006/relationships");
    public static final Namespace NS_PIC = Namespace.getNamespace((String)"pic", (String)"http://schemas.openxmlformats.org/drawingml/2006/picture");
    public static final Namespace NS_WP = Namespace.getNamespace((String)"wp", (String)"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing");
    private int m_DocPrId = 0;
    private Package m_Package;
    private DocRenderContext m_Context;
    private final ResourceLoader m_ResourceLoader;
    private Config m_Config;
    private CommentHandler m_CommentHandler;
    private Map<String, String> m_Parameters = new HashMap<String, String>();
    private Map<String, String> m_AllParameters = new HashMap<String, String>();
    private String m_CurrentImage = null;
    private int m_NextAltChunkId = 1;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Processor.class);

    public Processor(byte[] byArray, ResourceLoader resourceLoader) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.m_Package = ZipReader.read((InputStream)byteArrayInputStream);
        if (this.m_Package.getPart("/word/document.xml") == null) {
            throw new ZipReader.FileFormatException("This is not a valid DOCX file.");
        }
        this.m_ResourceLoader = resourceLoader;
        this.init();
        m_Log.info((Object)"Loaded docx from bytes");
    }

    public Package getPackage() {
        return this.m_Package;
    }

    protected void init() {
        this.m_Config = new Config(this.m_Package);
        this.m_CommentHandler = new CommentHandler(this.m_Package);
        m_Log.debug((Object)"Identified comments:");
        for (Comment comment : this.m_CommentHandler.getComments()) {
            m_Log.debug((Object)comment.getText());
        }
        this.readParameters();
    }

    public void setParameter(String string, String string2) {
        this.m_Parameters.put(string, string2);
    }

    public void render(DocRenderContext docRenderContext, Map<String, String> map, OutputStream outputStream) throws IOException, DataException {
        this.m_Context = docRenderContext;
        this.render(map, outputStream);
    }

    private void render(Map<String, String> map, OutputStream outputStream) throws IOException, DataException {
        Callback callback = new Callback(this, this.m_Context, this.m_Config, map);
        this.m_AllParameters.clear();
        for (Map.Entry<String, String> object2 : this.m_Parameters.entrySet()) {
            String string = object2.getKey();
            String string2 = ArgumentMap.substitute((String)object2.getValue(), (ArgumentMap.ICallback)callback);
            this.m_AllParameters.put(string, string2);
        }
        String string = map.getOrDefault("mimeType", MimeTypes.DOCX().value());
        this.m_AllParameters.put("mimeType", string);
        Callback callback2 = new Callback(this, this.m_Context, this.m_Config, this.m_AllParameters);
        this.readScripts();
        this.cleanDocument();
        this.render(callback2);
        this.m_Package.addPart((Part)new ContentTypes(this.m_Package));
        AsposeExtensions.run(this.m_ResourceLoader, this.m_Config, this.m_Package, this.m_AllParameters, outputStream);
    }

    public CommentHandler getCommentHandler() {
        return this.m_CommentHandler;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.m_Parameters);
    }

    public String getParameterValue(String string) {
        return this.m_Parameters.get(string);
    }

    public String getDataSource(String string) {
        Node node = this.m_Config.getNode("/Elx/DataSource/" + string + "/Name");
        if (node == null) {
            return null;
        }
        return "/" + node.getChildText();
    }

    public void readParameters() {
        Object object;
        this.m_Parameters.clear();
        Node node = this.m_Config.getNode("/Elx/ParameterFile");
        if (node != null) {
            object = node.children().iterator();
            while (object.hasNext()) {
                Node node2 = (Node)object.next();
                String object2 = node2.getFullText();
                m_Log.info((Object)("Loading parameters " + object2));
                try {
                    String string;
                    String string2 = this.m_ResourceLoader.getStringContents(object2);
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
                    while ((string = bufferedReader.readLine()) != null) {
                        if ((string = string.trim()).length() == 0 || string.startsWith("#")) continue;
                        String[] stringArray = StringUtil.keyAndValue((String)string);
                        this.m_Parameters.put(stringArray[0], stringArray[1]);
                    }
                }
                catch (Exception exception) {
                    m_Log.error((Object)("Error loading " + object2), (Throwable)exception);
                }
            }
        }
        if ((object = this.m_Config.getNode("/Elx/Parameter")) != null) {
            for (Node node2 : ((Node)object).children()) {
                this.m_Parameters.put(node2.getName(), node2.getChildText());
            }
        }
    }

    public void readScripts() {
        String iOException;
        Object object;
        this.m_Context.declareBean("Parameters", this.m_AllParameters);
        Node node = this.m_Config.getNode("/Elx/ScriptFile");
        if (node != null) {
            object = node.children().iterator();
            while (object.hasNext()) {
                Node node2 = (Node)object.next();
                String object2 = node2.getFullText();
                m_Log.info((Object)("Loading script " + object2));
                try {
                    iOException = this.m_ResourceLoader.getStringContents(object2);
                    iOException = Processor.removeSmartQuotes(iOException);
                    this.m_Context.evaluate(object2, iOException);
                }
                catch (ScriptException scriptException) {
                    m_Log.error((Object)("Error evaluating script " + object2 + ": " + String.valueOf((Object)scriptException)));
                }
                catch (IOException iOException2) {
                    m_Log.error((Object)("Unable to load script " + object2 + ": " + String.valueOf(iOException2)));
                }
            }
        }
        if ((object = this.m_Config.getNode("/Elx/Script")) != null) {
            for (Node node2 : ((Node)object).children()) {
                iOException = node2.getFullText();
                iOException = Processor.removeSmartQuotes(iOException);
                try {
                    this.m_Context.evaluate("script", iOException);
                }
                catch (ScriptException scriptException) {
                    m_Log.error((Object)("Error evaluating script " + iOException + ": " + String.valueOf((Object)scriptException)));
                }
            }
        }
    }

    private static String removeSmartQuotes(String string) {
        string = string.replace('\u2018', '\'');
        string = string.replace('\u2019', '\'');
        string = string.replace('\u201c', '\"');
        string = string.replace('\u201d', '\"');
        return string;
    }

    private void cleanDocument() {
        m_Log.debug((Object)"cleanDocument");
        XMLPart xMLPart = (XMLPart)this.m_Package.getPart("/word/document.xml");
        Processor.cleanDocument(this.m_Context, xMLPart);
    }

    public static void cleanDocument(DocRenderContext docRenderContext, XMLPart xMLPart) {
        RelationshipsPart relationshipsPart = xMLPart.getRelationships();
        if (relationshipsPart != null) {
            relationshipsPart.fillRelationships();
        }
        Element element = xMLPart.getDocument().getRootElement();
        Processor.cleanElement(docRenderContext, element);
    }

    public static void cleanElement(DocRenderContext docRenderContext, Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Iterator iterator = element.getDescendants((Filter)new WProofErrFilter());
        while (iterator.hasNext()) {
            arrayList.add((Element)iterator.next());
        }
        for (Object object : arrayList) {
            XMLUtil.remove(object);
        }
        arrayList = new ArrayList();
        iterator = element.getDescendants((Filter)new WBookmarkFilter());
        while (iterator.hasNext()) {
            arrayList.add((Element)iterator.next());
        }
        for (Object object : arrayList) {
            XMLUtil.remove(object);
        }
        arrayList = new ArrayList();
        iterator = element.getDescendants((Filter)new WTextFilter());
        while (iterator.hasNext()) {
            Object object;
            Element element2 = (Element)iterator.next();
            object = element2.getText();
            if (SubstitutionChecker.isSubstitutionComplete((String)object)) continue;
            arrayList.add(element2);
        }
        docRenderContext.debug("possibly " + arrayList.size() + " run merges");
        Processor.mergeSubstitutions(arrayList);
    }

    private static void mergeSubstitutions(List<Element> list) {
        for (Element element : list) {
            Element element2;
            if (!"t".equals(element.getName())) {
                throw new IllegalStateException();
            }
            Element element3 = element.getParentElement();
            while (!SubstitutionChecker.isSubstitutionComplete(element.getText()) && (element2 = XMLUtil.nextSibling(element3)) != null && "r".equals(element2.getName())) {
                Element element4 = element2.getChild("t", NS_W);
                if (element4 == null) continue;
                String string = element4.getText();
                element.setText(element.getText() + string);
                XMLUtil.remove(element2);
            }
        }
    }

    private void render(Callback callback) throws DataException {
        this.renderHeadersAndFooters(callback);
        this.renderBody(callback);
    }

    private boolean isHeaderOrFooter(String string) {
        return string.endsWith(".xml") && (string.startsWith("/word/header") || string.startsWith("/word/footer"));
    }

    private void renderHeadersAndFooters(Callback callback) throws DataException {
        m_Log.debug((Object)"renderHeadersAndFooters");
        for (Part part : this.m_Package.getParts()) {
            if (!this.isHeaderOrFooter(part.getName())) continue;
            this.renderHeaderOrFooter(callback, (XMLPart)part);
        }
    }

    private void renderHeaderOrFooter(Callback callback, XMLPart xMLPart) throws DataException {
        m_Log.debug((Object)("renderHeaderOrFooter " + xMLPart.getName()));
        Processor.cleanDocument(this.m_Context, xMLPart);
        Element element = xMLPart.getDocument().getRootElement();
        Element element2 = this.shallow(callback, element);
        Namespace namespace = Namespace.getNamespace((String)"mc", (String)"http://schemas.openxmlformats.org/markup-compatibility/2006");
        element2.removeAttribute("Ignorable", namespace);
        this.process(callback, new Backtrack(element, element2));
        NewLineExpander.walk(element2);
        xMLPart.getDocument().setRootElement(element2);
    }

    private void renderBody(Callback callback) throws DataException {
        m_Log.debug((Object)"renderBody");
        XMLPart xMLPart = (XMLPart)this.m_Package.getPart("/word/document.xml");
        Element element = xMLPart.getDocument().getRootElement();
        Element element2 = element.getChild("body", NS_W);
        Element element3 = this.shallow(callback, element2);
        this.process(callback, new Backtrack(element2, element3));
        element.removeContent((Content)element2);
        NewLineExpander.walk(element3);
        element.addContent((Content)element3);
    }

    private void process(Callback callback, Backtrack backtrack) throws DataException {
        Backtrack backtrack2 = backtrack;
        while (backtrack2 != null) {
            Element element = backtrack2.child;
            if (XMLUtil.equals(element, "commentRangeStart", NS_W)) {
                String string = element.getAttributeValue("id", NS_W);
                String string2 = this.m_CommentHandler.getComment(string);
                m_Log.debug((Object)(string2 + "(id=" + string + ")"));
                if (!string2.startsWith("/Elx/")) {
                    backtrack2 = this.loadDataSource(callback, backtrack2, string2, string);
                } else if (string2.startsWith("/Elx/Header")) {
                    this.elxHeader(string2, backtrack2);
                } else if (string2.startsWith("/Elx/Detail")) {
                    this.elxDetail(string2, backtrack2);
                } else if (string2.startsWith("/Elx/Footer")) {
                    backtrack2 = this.elxFooter(string2, backtrack2);
                } else if (string2.startsWith("/Elx/End")) {
                    backtrack2 = this.elxEnd(string2, backtrack2);
                } else if (string2.startsWith("/Elx/RenderIf")) {
                    backtrack2 = this.elxRenderIf(string2, backtrack2);
                } else if (string2.startsWith("/Elx/RenderBlockIf")) {
                    backtrack2 = this.elxRenderBlockIf(string2, backtrack2);
                } else if (string2.startsWith("/Elx/Image/")) {
                    this.m_CurrentImage = string2.substring(11);
                } else {
                    throw new IllegalStateException("Unknown comment: " + string2);
                }
                backtrack2 = backtrack2.next(false);
                continue;
            }
            if (XMLUtil.equals(element, "commentRangeEnd", NS_W)) {
                backtrack2 = backtrack2.next(false);
                continue;
            }
            if (XMLUtil.equals(element, "commentReference", NS_W)) {
                backtrack2 = backtrack2.next(false);
                continue;
            }
            if (XMLUtil.equals(element, "blip", NS_A)) {
                backtrack2 = this.processPictureBlip(callback, backtrack2);
                continue;
            }
            if (XMLUtil.equals(element, "docPr", NS_WP)) {
                backtrack2 = this.processDocPr(callback, backtrack2);
                continue;
            }
            backtrack2 = this.defaultProcess(callback, backtrack2);
        }
    }

    private Backtrack processPictureBlip(Callback callback, Backtrack backtrack) throws DataException {
        if (this.m_CurrentImage != null) {
            String string = this.m_CurrentImage;
            this.m_CurrentImage = null;
            m_Log.info((Object)("Picture with name: " + string));
            String string2 = ImageHandler.handle(this, this.m_Context, string);
            Element element = this.shallow(callback, backtrack.child);
            element.setAttribute("embed", string2, NS_R);
            backtrack.newParent.addContent((Content)element);
            return backtrack.next(true);
        }
        return this.defaultProcess(callback, backtrack);
    }

    private Backtrack processDocPr(Callback callback, Backtrack backtrack) {
        Element element = this.shallow(callback, backtrack.child);
        element.setAttribute("id", String.valueOf(++this.m_DocPrId));
        backtrack.newParent.addContent((Content)element);
        return backtrack.next(false);
    }

    private Backtrack defaultProcess(Callback callback, Backtrack backtrack) throws DataException {
        Element element = this.shallow(callback, backtrack.child);
        backtrack.newParent.addContent((Content)element);
        return backtrack.next(true);
    }

    private void elxHeader(String string, Backtrack backtrack) {
        if (this.m_Context.hasTable()) {
            TablePos tablePos = this.m_Context.getTablePos();
            if (!tablePos.hasChildGroup()) {
                throw new IllegalStateException("More headers than groups");
            }
            tablePos.pushGroup();
            BTInfo bTInfo = new BTInfo(backtrack, "Header " + string);
            this.m_Context.pushBacktrack(bTInfo);
        } else {
            m_Log.warn((Object)"Found header when no datasource has been loaded");
        }
    }

    private void elxDetail(String string, Backtrack backtrack) {
        if (this.m_Context.hasTable()) {
            BTInfo bTInfo = new BTInfo(backtrack, "Detail " + string);
            this.m_Context.pushBacktrack(bTInfo);
        } else {
            m_Log.warn((Object)"Found detail when no datasource has been loaded");
        }
    }

    private Backtrack elxFooter(String string, Backtrack backtrack) {
        if (this.m_Context.hasTable()) {
            TablePos tablePos = this.m_Context.getTablePos();
            if (this.m_Context.peekBacktrackInfo().startsWith("Detail ")) {
                if (tablePos.hasNextRecord()) {
                    tablePos.nextRecord();
                    Backtrack backtrack2 = this.m_Context.peekBacktrack();
                    return backtrack2;
                }
            } else {
                if (tablePos.hasNextGroup()) {
                    if ("/Elx/Footer/PageBreakAfter".equals(string)) {
                        this.elxPageBreak(backtrack);
                    }
                    tablePos.nextGroup();
                    Backtrack backtrack3 = this.m_Context.peekBacktrack();
                    return backtrack3;
                }
                tablePos.popGroup();
            }
            if ("/Elx/Footer/PageBreakAfter".equals(string)) {
                this.elxPageBreak(backtrack);
            }
            this.m_Context.popBacktrack();
            return backtrack;
        }
        m_Log.warn((Object)"Found footer when no datasource has been loaded");
        return backtrack;
    }

    private Backtrack elxEnd(String string, Backtrack backtrack) {
        if (this.m_Context.hasTable()) {
            TablePos tablePos = this.m_Context.getTablePos();
            m_Log.debug((Object)("elxEnd: " + String.valueOf(tablePos)));
            if (tablePos.hasNextRecord()) {
                tablePos.nextRecord();
                Backtrack backtrack2 = this.m_Context.peekBacktrack();
                return backtrack2;
            }
            if (tablePos.hasNextGroup()) {
                tablePos.nextGroup();
                Backtrack backtrack3 = this.m_Context.peekBacktrack();
                return backtrack3;
            }
            this.m_Context.popBacktrack();
            if (tablePos.depth > 0) {
                tablePos.popGroup();
            } else {
                this.m_Context.elxEnd();
            }
            return backtrack;
        }
        m_Log.warn((Object)"Found end when no datasource has been loaded");
        return backtrack;
    }

    private Backtrack elxRenderIf(String string, Backtrack backtrack) {
        String string2 = string.substring("/Elx/RenderIf".length()).trim();
        if (string2.length() > 0) {
            try {
                String string3 = Processor.removeSmartQuotes(string2);
                Object object = this.m_Context.evaluate("renderif", string3);
                m_Log.debug((Object)("RenderIf " + string3 + " returns " + String.valueOf(object)));
                if (Boolean.FALSE.equals(object)) {
                    return this.advanceToCommentEnd(backtrack);
                }
            }
            catch (ScriptException scriptException) {
                m_Log.error((Object)("Error testing " + string + ": " + String.valueOf((Object)scriptException)), (Throwable)scriptException);
            }
        }
        return backtrack;
    }

    private Backtrack elxRenderBlockIf(String string, Backtrack backtrack) {
        String string2 = string.substring("/Elx/RenderBlockIf".length()).trim();
        if (string2.length() > 0) {
            try {
                String string3 = Processor.removeSmartQuotes(string2);
                Object object = this.m_Context.evaluate("renderblockif", string3);
                m_Log.debug((Object)("RenderBlockIf " + string3 + " returns " + String.valueOf(object)));
                if (Boolean.FALSE.equals(object)) {
                    return this.advanceToCommentEnd(backtrack);
                }
            }
            catch (ScriptException scriptException) {
                m_Log.error((Object)("Error testing " + string + ": " + String.valueOf((Object)scriptException)), (Throwable)scriptException);
            }
        }
        return backtrack;
    }

    private void elxPageBreak(Backtrack backtrack) {
        Element element = new Element("p", NS_W);
        Element element2 = new Element("r", NS_W);
        Element element3 = new Element("br", NS_W);
        element3.setAttribute("type", "page", NS_W);
        element.addContent((Content)element2);
        element2.addContent((Content)element3);
        backtrack.newParent.addContent((Content)element);
    }

    protected Backtrack loadDataSource(Callback callback, Backtrack backtrack, String string, String string2) throws DataException {
        m_Log.debug((Object)("loadDataSource(" + string + ") id=" + string2));
        DataTable dataTable = this.buildTable(callback, string);
        if (dataTable.getRecordCount() == 0) {
            m_Log.info((Object)"Advancing to end of section as no records found");
            return this.advanceToEnd(backtrack);
        }
        this.m_Context.elxTable(dataTable.getName(), dataTable);
        return backtrack;
    }

    protected DataTable buildTable(Callback callback, String string) throws DataException {
        Object object;
        m_Log.debug((Object)("buildTable(" + string + ")"));
        Node node = this.m_Config.getNode("/Elx/DataSource/" + string + "/Name");
        if (node == null) {
            Node node2 = this.m_Config.getNode("/Elx/DataSource");
            String string2 = "Can't read datasource \"" + string + "\"";
            if (node2 != null) {
                string2 = string2 + "\nchoices are:\n" + node2.toString();
            }
            m_Log.error((Object)string2);
            throw new DataException(string2);
        }
        String string3 = "/" + node.getChildText();
        Node node3 = this.m_Config.getNode("/Elx/DataSource/" + string + "/Parameter");
        if (node3 == null && (object = this.m_Context.getTable(string)) != null) {
            return object;
        }
        m_Log.info((Object)("Reading datasource: \"" + string3 + "\""));
        object = new HashMap();
        if (node3 != null) {
            for (Node node4 : node3.children()) {
                String string4 = node4.getName();
                String string5 = node4.getChildText();
                string5 = this.substitute(callback, string5);
                object.put(string4, string5);
                m_Log.debug((Object)("Table " + string + " parameter " + string4 + "=" + string5));
            }
        }
        DataTable dataTable = this.m_ResourceLoader.generateData(string3, (Map<String, String>)object);
        dataTable = this.group(string, dataTable);
        dataTable.setName(string);
        m_Log.info((Object)("Table has " + dataTable.getRecordCount() + " records"));
        return dataTable;
    }

    private DataTable group(String string, DataTable dataTable) throws DataException {
        Node node = this.m_Config.getNode("/Elx/DataSource/" + string + "/Group");
        if (node != null && node.hasChildren()) {
            GroupDataSource2 groupDataSource2 = new GroupDataSource2("group", (IDataSource)dataTable);
            for (Node node2 : node.children()) {
                String string2 = node2.getName();
                String string3 = node2.getChildText();
                GroupDefinition groupDefinition = new GroupDefinition(string2, string3);
                groupDataSource2.group(groupDefinition);
            }
            return DataTable.build((PushContext)new DefaultPushContext(), (IDataSource)groupDataSource2);
        }
        return dataTable;
    }

    private Backtrack advanceToEnd(Backtrack backtrack) {
        int n = -1;
        while (backtrack != null) {
            String string;
            String string2;
            Element element = backtrack.child;
            if (XMLUtil.equals(element, "commentRangeStart", NS_W) && (string2 = this.m_CommentHandler.getComment(string = element.getAttributeValue("id", NS_W))) != null) {
                if (!string2.startsWith("/Elx")) {
                    m_Log.debug((Object)("skip over nested start " + string2 + "(id=" + string + ")"));
                    ++n;
                } else if (string2.startsWith("/Elx/End")) {
                    if (n == 0) {
                        m_Log.debug((Object)("advanceToEnd at " + string2 + "(id=" + string + ")"));
                        return backtrack;
                    }
                    m_Log.debug((Object)("skip over nested end " + string2 + "(id=" + string + ")"));
                    --n;
                } else {
                    m_Log.debug((Object)("skip over comment " + string2 + "(id=" + string + ")"));
                }
            }
            backtrack = backtrack.next(true);
        }
        return backtrack;
    }

    private Backtrack advanceToCommentEnd(Backtrack backtrack) {
        int n = 0;
        while (backtrack != null) {
            Element element = backtrack.child;
            if (XMLUtil.equals(element, "commentRangeStart", NS_W)) {
                ++n;
            }
            if (XMLUtil.equals(element, "commentRangeEnd", NS_W) && --n == 0) {
                return backtrack;
            }
            backtrack = backtrack.next(true);
        }
        return backtrack;
    }

    private Element shallow(Callback callback, Element element) {
        Namespace namespace;
        Element element2 = new Element(element.getName(), element.getNamespace());
        for (Object e : element.getAdditionalNamespaces()) {
            namespace = (Namespace)e;
            element2.addNamespaceDeclaration(namespace);
        }
        for (Object e : element.getAttributes()) {
            namespace = (Attribute)e;
            String string = namespace.getName();
            element2.setAttribute(new Attribute(string, namespace.getValue(), namespace.getNamespace()));
        }
        Object object = XMLValidator.safeXmlText(this.substitute(callback, element.getText()));
        if (((String)object).trim().startsWith("<html")) {
            m_Log.info((Object)("Including altChunk from " + element.getText()));
            return this.altChunk(((String)object).trim());
        }
        if (((String)object).contains("\n")) {
            object = ((String)object).replace("\r", "").replace("\n", NewLineExpander.NewLineMarker());
        }
        element2.setText((String)object);
        return element2;
    }

    private String substitute(Callback callback, String string) {
        if (string.length() == 0) {
            return string;
        }
        String string2 = ArgumentMap.substitute((String)string, (ArgumentMap.ICallback)callback);
        if (string2.contains("${")) {
            m_Log.info((Object)("Unable to substitute " + string2));
        }
        return string2;
    }

    private Element altChunk(String string) {
        String string2 = "/word/altChunk" + this.m_NextAltChunkId + ".html";
        ++this.m_NextAltChunkId;
        MediaHandler mediaHandler = new MediaHandler(this);
        String string3 = mediaHandler.addHtml(this.getBytes(string));
        Element element = new Element("altChunk", NS_W);
        element.setAttribute("id", string3, NS_R);
        return element;
    }

    private byte[] getBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    private static class WProofErrFilter
    implements Filter {
        private WProofErrFilter() {
        }

        public boolean matches(Object object) {
            return object instanceof Element && XMLUtil.equals((Element)object, "proofErr", NS_W);
        }
    }

    private static class WBookmarkFilter
    implements Filter {
        private WBookmarkFilter() {
        }

        public boolean matches(Object object) {
            return object instanceof Element && (XMLUtil.equals((Element)object, "bookmarkStart", NS_W) || XMLUtil.equals((Element)object, "bookmarkEnd", NS_W));
        }
    }

    private static class WTextFilter
    implements Filter {
        private WTextFilter() {
        }

        public boolean matches(Object object) {
            return object instanceof Element && XMLUtil.equals((Element)object, "t", NS_W);
        }
    }
}

