/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.docprocessor;

import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.jdom.Parent;
import java.util.ArrayList;
import java.util.List;

public class XMLUtil {
    static boolean equals(Element element, String string, Namespace namespace) {
        return string.equals(element.getName()) && namespace.equals((Object)element.getNamespace());
    }

    static List<Element> ancestors(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        XMLUtil.buildAncestors(element, arrayList);
        return arrayList;
    }

    static String id(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        XMLUtil.id(element, stringBuilder);
        return stringBuilder.toString();
    }

    static void insertBefore(Element element, Element element2) {
        Element element3 = (Element)element.getParent();
        List list = element3.getChildren();
        int n = list.indexOf(element);
        element3.addContent(n, (Content)element2);
    }

    static Element previousSibling(Element element) {
        if (!XMLUtil.isAttached((Parent)element)) {
            return null;
        }
        Element element2 = (Element)element.getParent();
        List list = element2.getChildren();
        int n = list.indexOf(element);
        if (n == 0) {
            return null;
        }
        return (Element)list.get(n - 1);
    }

    static Element nextSibling(Element element) {
        if (!XMLUtil.isAttached((Parent)element)) {
            return null;
        }
        Element element2 = (Element)element.getParent();
        List list = element2.getChildren();
        int n = list.indexOf(element) + 1;
        if (n < list.size()) {
            return (Element)list.get(n);
        }
        return null;
    }

    static void remove(Element element) {
        Element element2 = (Element)element.getParent();
        if (element2 != null) {
            element2.removeContent((Content)element);
        }
    }

    static boolean isAttached(Parent parent) {
        do {
            if (!(parent instanceof Document)) continue;
            return true;
        } while ((parent = parent.getParent()) != null);
        return false;
    }

    static void dumpParents(Element element) {
        XMLUtil.dumpParents(element, 0);
    }

    static void dumpParents(Element element, int n) {
        System.out.println(n + " " + element.getName());
        Element element2 = element.getParentElement();
        if (element2 != null) {
            XMLUtil.dumpParents(element2, n + 1);
        }
    }

    private static void id(Element element, StringBuilder stringBuilder) {
        Parent parent = element.getParent();
        if (parent instanceof Element) {
            XMLUtil.id((Element)parent, stringBuilder);
            stringBuilder.append(".");
            stringBuilder.append(parent.indexOf((Content)element));
        } else {
            stringBuilder.append("0");
        }
    }

    private static void buildAncestors(Element element, List<Element> list) {
        Parent parent = element.getParent();
        if (parent instanceof Element) {
            list.add((Element)parent);
            XMLUtil.buildAncestors((Element)parent, list);
        }
    }
}

