/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYLi;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzVQb;
import com.aspose.words.net.System.Data.zzWRw;
import com.aspose.words.net.System.Data.zzXr0;
import com.aspose.words.net.System.Data.zzrk;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzWJ9;
    private final DataColumnCollection zzWa5;
    private final ConstraintCollection zzZv0;
    private final zzrk zzW0o;
    private ResultSet zzWnZ;
    private String zzYgJ;
    private DataSet zzVSE;
    private String zzWk8;
    private UniqueConstraint zzEP;
    private boolean zzZwY;
    private final List<DataTableEventListener> zzXDW;
    private final Set<DataRow> zzZqR;
    private DataRelationCollection zzWol;

    public DataTable() {
        this.zzWJ9 = new DataRowCollection(this);
        this.zzWa5 = new DataColumnCollection(this);
        this.zzZv0 = new ConstraintCollection(this);
        this.zzW0o = new zzrk(this);
        this.zzWk8 = "";
        this.zzZwY = true;
        this.zzXDW = new ArrayList<DataTableEventListener>();
        this.zzZqR = new HashSet<DataRow>();
        this.zzWol = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzWJ9 = new DataRowCollection(this);
        this.zzWa5 = new DataColumnCollection(this);
        this.zzZv0 = new ConstraintCollection(this);
        this.zzW0o = new zzrk(this);
        this.zzWk8 = "";
        this.zzZwY = true;
        this.zzXDW = new ArrayList<DataTableEventListener>();
        this.zzZqR = new HashSet<DataRow>();
        this.zzWol = new DataRelationCollection();
        this.zzYgJ = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzVQb.zzXsO(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzWJ9 = new DataRowCollection(this);
        this.zzWa5 = new DataColumnCollection(this);
        this.zzZv0 = new ConstraintCollection(this);
        this.zzW0o = new zzrk(this);
        this.zzWk8 = "";
        this.zzZwY = true;
        this.zzXDW = new ArrayList<DataTableEventListener>();
        this.zzZqR = new HashSet<DataRow>();
        this.zzWol = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzWnZ = resultSet;
        this.zzYgJ = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzWnZ != null) {
            if (this.zzWnZ.getStatement() != null) {
                this.zzWnZ.getStatement().getConnection().close();
            }
            this.zzWnZ = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzYgJ;
    }

    public void setTableName(String tableName) {
        this.zzYgJ = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzWa5.getCount();
    }

    public String getColumnName(int index) {
        return this.zzWa5.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzWnZ;
    }

    public DataSet getDataSet() {
        return this.zzVSE;
    }

    final void zzZ28(DataSet dataSet) {
        this.zzVSE = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzVSE.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzWol.add(dataRelation);
        }
        return this.zzWol;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzVSE.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzWJ9;
    }

    public DataColumnCollection getColumns() {
        return this.zzWa5;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzZv0;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzEP == null) {
            return new DataColumn[0];
        }
        return this.zzEP.getColumns();
    }

    final void zzrk(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzEP != null) {
                this.zzEP.zzVRY(false);
                this.getConstraints().remove(this.zzEP);
                this.zzEP = null;
            }
            return;
        }
        if (this.zzEP != null && DataColumn.areColumnSetsTheSame(value, this.zzEP.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXsO(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzEP != null) {
            this.zzEP.zzVRY(false);
            this.getConstraints().remove(this.zzEP);
            this.zzEP = null;
        }
        UniqueConstraint.zzXsO(this.getConstraints(), uniqueConstraint);
        this.zzEP = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzWk8;
    }

    public void setNamespace(String namespace) {
        this.zzWk8 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZwY;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZwY = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzZqR.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzVQb.zzXsO(this.getResultSet(), this);
            zzVQb.zzVQb(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzYLi.zzZ28(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzVQb.zzXQ4(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXDW.contains(listener)) {
            this.zzXDW.add(listener);
        }
    }

    public void removeEventListener(zzWRw listener) {
        if (this.zzXDW.contains(listener)) {
            this.zzXDW.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXDW.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzZqR.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXDW) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzZqR.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXDW) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzZqR.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXDW) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXDW) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXDW) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzXr0 zzXsO(zzVQb[] zzVQbArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzVQbArray.length];
        for (int i = 0; i < zzVQbArray.length; ++i) {
            dataColumnArray[i] = zzVQbArray[i].zzXB3();
        }
        DataTable dataTable = this;
        zzXr0 zzXr02 = dataTable.zzW0o.zzZ28(dataColumnArray);
        if (zzXr02 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzXr02;
    }

    final zzrk zzXXp() {
        return this.zzW0o;
    }

    final Set<DataRow> zzZow() {
        return this.zzZqR;
    }
}

