/*
 * Decompiled with CFR 0.152.
 */
package monix.kafka;

import monix.eval.Task;
import monix.kafka.Commit;
import monix.kafka.CommittableOffset;
import monix.kafka.CommittableOffsetBatch$;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CommittableOffsetBatch {
    private final Map offsets;
    private final Commit commitCallback;

    public static CommittableOffsetBatch apply(Seq<CommittableOffset> seq) {
        return CommittableOffsetBatch$.MODULE$.apply(seq);
    }

    public static CommittableOffsetBatch empty() {
        return CommittableOffsetBatch$.MODULE$.empty();
    }

    public static List<CommittableOffsetBatch> mergeByCommitCallback(Seq<CommittableOffset> seq) {
        return CommittableOffsetBatch$.MODULE$.mergeByCommitCallback(seq);
    }

    public CommittableOffsetBatch(Map<TopicPartition, Object> offsets, Commit commitCallback) {
        this.offsets = offsets;
        this.commitCallback = commitCallback;
    }

    public Map<TopicPartition, Object> offsets() {
        return this.offsets;
    }

    public Task<BoxedUnit> commitSync() {
        return this.commitCallback.commitBatchSync(this.offsets());
    }

    public Task<BoxedUnit> commitAsync() {
        return this.commitCallback.commitBatchAsync(this.offsets());
    }

    public Task<BoxedUnit> commitAsync(OffsetCommitCallback callback) {
        return this.commitCallback.commitBatchAsync(this.offsets());
    }

    public CommittableOffsetBatch updated(CommittableOffset committableOffset) {
        return new CommittableOffsetBatch((Map<TopicPartition, Object>)((Map)this.offsets().updated((Object)committableOffset.topicPartition(), (Object)BoxesRunTime.boxToLong((long)committableOffset.offset()))), committableOffset.commitCallback());
    }
}

