/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.dynalink.StandardNamespace;
import jdk.dynalink.StandardOperation;
import jdk.dynalink.linker.GuardedInvocation;
import jdk.dynalink.linker.LinkRequest;
import jdk.dynalink.linker.LinkerServices;
import jdk.dynalink.linker.TypeBasedGuardingDynamicLinker;
import jdk.dynalink.linker.support.Guards;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.optimizer.DefaultLinker;
import org.mozilla.javascript.optimizer.ParsedOperation;
import org.mozilla.javascript.optimizer.RhinoNamespace;
import org.mozilla.javascript.optimizer.RhinoOperation;

class ConstAwareLinker
implements TypeBasedGuardingDynamicLinker {
    ConstAwareLinker() {
    }

    @Override
    public boolean canLinkType(Class<?> type) {
        return ScriptableObject.class.isAssignableFrom(type) || NativeWith.class.isAssignableFrom(type);
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest req, LinkerServices svc) {
        Object constValue;
        if (req.isCallSiteUnstable()) {
            return null;
        }
        ParsedOperation op = new ParsedOperation(req.getCallSiteDescriptor().getOperation());
        Object target = req.getReceiver();
        if ((op.isNamespace(RhinoNamespace.NAME) && op.isOperation(StandardOperation.GET) || op.isNamespace(StandardNamespace.PROPERTY) && op.isOperation(StandardOperation.GET, RhinoOperation.GETNOWARN)) && (constValue = this.getConstValue(target, op.getName())) != null) {
            MethodType mType = req.getCallSiteDescriptor().getMethodType();
            MethodHandle guard = Guards.asType(Guards.getIdentityGuard(target), mType);
            MethodHandle mh = MethodHandles.dropArguments(MethodHandles.constant(Object.class, constValue), 0, mType.parameterList());
            if (DefaultLinker.DEBUG) {
                System.out.println(String.valueOf(op) + ": constant");
            }
            return new GuardedInvocation(mh, guard);
        }
        return null;
    }

    private Object getConstValue(Object t, String name) {
        if (t instanceof NativeWith) {
            return this.getConstValue(((NativeWith)t).getPrototype(), name);
        }
        assert (t instanceof ScriptableObject);
        try {
            int attributes;
            ScriptableObject target = (ScriptableObject)t;
            if (target.has(name, (Scriptable)target) && ((attributes = target.getAttributes(name)) & 1) != 0 && (attributes & 4) != 0 && (attributes & 8) == 0) {
                return target.get(name, (Scriptable)target);
            }
        }
        catch (RhinoException rhinoException) {
            // empty catch block
        }
        return null;
    }
}

