/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import monix.eval.Task;
import monix.eval.internal.TaskToReactivePublisher$;
import monix.execution.Callback;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class TaskToReactivePublisher {
    public static <A> Publisher<A> apply(Task<A> task, Scheduler scheduler) {
        return TaskToReactivePublisher$.MODULE$.apply(task, scheduler);
    }

    private static final class PublisherCallback<A>
    extends Callback<Throwable, A> {
        private final Subscriber<? super A> out;
        private final UncaughtExceptionReporter s;
        private boolean isActive;

        public PublisherCallback(Subscriber<? super A> out, UncaughtExceptionReporter s) {
            this.out = out;
            this.s = s;
            this.isActive = true;
        }

        public void onError(Throwable e) {
            if (this.isActive) {
                this.isActive = false;
                this.out.onError(e);
            } else {
                this.s.reportFailure(e);
            }
        }

        public void onSuccess(A value) {
            if (this.isActive) {
                this.isActive = false;
                this.out.onNext(value);
                this.out.onComplete();
            }
        }
    }
}

