/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository;

import ambience.api.Repository;
import ambience.api.Repository2;
import ambience.api.RepositoryAccessChecker;
import ambience.module.UserDB;
import ambience.repository.AccessChecker$;
import ambience.repository.FileHandle;
import ambience.repository.FileHandle$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.typesafe.config.Config;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.apache.commons.io.FileUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

public final class DiskRepositoryAPI2$
implements Repository2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(DiskRepositoryAPI2$.class.getDeclaredField("rootFolder$lzy1"));
    private static final String ACLFilename;
    private volatile Object rootFolder$lzy1;
    public static final DiskRepositoryAPI2$ MODULE$;

    private DiskRepositoryAPI2$() {
    }

    static {
        MODULE$ = new DiskRepositoryAPI2$();
        ACLFilename = ".elx-acl.json";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DiskRepositoryAPI2$.class);
    }

    public String ACLFilename() {
        return ACLFilename;
    }

    public File rootFolder() {
        Object object = this.rootFolder$lzy1;
        if (object instanceof File) {
            return (File)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (File)this.rootFolder$lzyINIT1();
    }

    private Object rootFolder$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.rootFolder$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    File file = null;
                    try {
                        Config config = (Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class));
                        file = new File(config.getString("ambience.repository.disk.root"));
                        object2 = file == null ? LazyVals.NullValue$.MODULE$ : file;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.rootFolder$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return file;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean isReserved(Path path) {
        return this.isReserved(path.name());
    }

    public boolean isReserved(String filename) {
        return filename.startsWith(".") || filename.endsWith(".bak") || filename.endsWith(".sos");
    }

    public Task<RepositoryAccessChecker> getAccessChecker(UserDB.User user) {
        return AccessChecker$.MODULE$.forT(user, AccessChecker$.MODULE$.forT$default$2());
    }

    public Task<RepositoryAccessChecker> getPrimedAccessChecker(UserDB.User user) {
        return this.getAccessChecker(user);
    }

    public Task<Repository.FileData> readFileDataT(RepositoryAccessChecker checker, Path path) {
        return checker.canRead(path).flatMap((Function1 & Serializable)canRead -> DiskRepositoryAPI2$.readFileDataT$$anonfun$1(path, BoxesRunTime.unboxToBoolean((Object)canRead)));
    }

    public Task<Option<Repository.FileData>> readOptFileDataT(RepositoryAccessChecker checker, Path path) {
        return checker.canRead(path).flatMap((Function1 & Serializable)canRead -> DiskRepositoryAPI2$.readOptFileDataT$$anonfun$1(path, BoxesRunTime.unboxToBoolean((Object)canRead)));
    }

    public Task<Option<Repository.FileData>> readOptFileDataT(Path path) {
        return Task$.MODULE$.apply(() -> DiskRepositoryAPI2$.readOptFileDataT$$anonfun$2(path));
    }

    public Task<Repository.FileData> readFileDataT(Path path) {
        return Task$.MODULE$.apply(() -> DiskRepositoryAPI2$.readFileDataT$$anonfun$2(path));
    }

    public Task<Option<Repository.FileData>> readFileDataIfModifiedT(RepositoryAccessChecker checker, Path path, long lastModified) {
        return checker.canRead(path).flatMap((Function1 & Serializable)canRead -> DiskRepositoryAPI2$.readFileDataIfModifiedT$$anonfun$1(path, lastModified, BoxesRunTime.unboxToBoolean((Object)canRead)));
    }

    public Task<Option<Repository.FileData>> readFileDataIfModifiedT(Path path, long lastModified) {
        return Task$.MODULE$.apply(() -> DiskRepositoryAPI2$.readFileDataIfModifiedT$$anonfun$2(path, lastModified));
    }

    public Observable<byte[]> readFileO(RepositoryAccessChecker checker, Path path) {
        return Observable$.MODULE$.fromTask(this.readFileT(checker, path));
    }

    public Observable<byte[]> readFileO(Path path) {
        return Observable$.MODULE$.fromTask(this.readFileT(path));
    }

    public Task<Option<byte[]>> readOptFileT(RepositoryAccessChecker checker, Path path) {
        return checker.canRead(path).flatMap((Function1 & Serializable)canRead -> DiskRepositoryAPI2$.readOptFileT$$anonfun$1(path, BoxesRunTime.unboxToBoolean((Object)canRead)));
    }

    public Task<byte[]> readFileT(RepositoryAccessChecker checker, Path path) {
        return checker.canRead(path).flatMap((Function1 & Serializable)canRead -> DiskRepositoryAPI2$.readFileT$$anonfun$1(path, BoxesRunTime.unboxToBoolean((Object)canRead)));
    }

    public Task<byte[]> readFileT(Path path) {
        return Task$.MODULE$.apply(() -> DiskRepositoryAPI2$.readFileT$$anonfun$2(path));
    }

    public Task<Option<byte[]>> readOptFileT(Path path) {
        return Task$.MODULE$.apply(() -> DiskRepositoryAPI2$.readOptFileT$$anonfun$2(path));
    }

    public Task<BoxedUnit> writeFileT(RepositoryAccessChecker checker, Path path, byte[] data) {
        return checker.canWrite(path).flatMap((Function1 & Serializable)canWrite -> DiskRepositoryAPI2$.writeFileT$$anonfun$1(path, data, BoxesRunTime.unboxToBoolean((Object)canWrite)));
    }

    public Task<BoxedUnit> writeFileT(Path path, byte[] data) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            DiskRepositoryAPI2$.writeFileT$$anonfun$2(path, data);
            return BoxedUnit.UNIT;
        });
    }

    public Task<BoxedUnit> writeFileT(RepositoryAccessChecker checker, Path path, Observable<byte[]> data) {
        return checker.canWrite(path).flatMap((Function1 & Serializable)canWrite -> DiskRepositoryAPI2$.writeFileT$$anonfun$3(path, data, BoxesRunTime.unboxToBoolean((Object)canWrite)));
    }

    public Task<BoxedUnit> writeFileT(Path path, Observable<byte[]> data) {
        return this.bytesBuilder(data).flatMap((Function1 & Serializable)bytes -> MODULE$.writeFileT(path, (byte[])bytes));
    }

    public Task<Object> createFolderT(RepositoryAccessChecker checker, Path path) {
        return checker.canWrite(path).flatMap((Function1 & Serializable)canWrite -> DiskRepositoryAPI2$.createFolderT$$anonfun$1(path, BoxesRunTime.unboxToBoolean((Object)canWrite)));
    }

    public Task<Object> createFolderT(Path path) {
        if (this.isReserved(path)) {
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return this.doCreateFolderT(path);
    }

    public Task<Object> doCreateFolderT(Path path) {
        return Task$.MODULE$.apply(() -> DiskRepositoryAPI2$.doCreateFolderT$$anonfun$1(path));
    }

    public boolean doCreateFolder(Path path) {
        File folder = this.pathToFile(path);
        if (folder.isFile()) {
            throw new RuntimeException("Folder " + path + " already exists as a file");
        }
        return folder.mkdirs();
    }

    public Task<Object> deleteFileT(RepositoryAccessChecker checker, Path path) {
        return this.deleteFileT(path);
    }

    public Task<Object> deleteFileT(Path path) {
        return Task$.MODULE$.apply(() -> DiskRepositoryAPI2$.deleteFileT$$anonfun$1(path));
    }

    public Task<Object> deleteFolderT(RepositoryAccessChecker checker, Path path) {
        return checker.canWrite(path).flatMap((Function1 & Serializable)canWrite -> DiskRepositoryAPI2$.deleteFolderT$$anonfun$1(path, BoxesRunTime.unboxToBoolean((Object)canWrite)));
    }

    public Task<Object> deleteFolderT(Path path) {
        return Task$.MODULE$.apply(() -> DiskRepositoryAPI2$.deleteFolderT$$anonfun$2(path));
    }

    public Task<Option<Repository.RItem>> getItemT(RepositoryAccessChecker checker, Path path) {
        return checker.canRead(path).flatMap((Function1 & Serializable)canRead -> DiskRepositoryAPI2$.getItemT$$anonfun$1(path, BoxesRunTime.unboxToBoolean((Object)canRead)));
    }

    public Task<Option<Repository.RItem>> getItemT(Path path) {
        return Task$.MODULE$.apply(() -> DiskRepositoryAPI2$.getItemT$$anonfun$2(path));
    }

    public Observable<Path> getByTagO(RepositoryAccessChecker checker, String tag) {
        return Observable$.MODULE$.empty();
    }

    public Observable<Path> getFilesByTagO(RepositoryAccessChecker checker, String tag) {
        return Observable$.MODULE$.empty();
    }

    public Observable<Path> getFoldersByTagO(RepositoryAccessChecker checker, String tag) {
        return Observable$.MODULE$.empty();
    }

    public Observable<Repository.RItem> getFileItemsByTagO(RepositoryAccessChecker ac, String tag) {
        return Observable$.MODULE$.empty();
    }

    public Observable<Repository.RItem> getFolderItemsByTagO(RepositoryAccessChecker ac, String tag) {
        return Observable$.MODULE$.empty();
    }

    public Observable<Repository.RItem> getItemByTagO(RepositoryAccessChecker ac, String tag) {
        return Observable$.MODULE$.empty();
    }

    public Observable<Path> getByExtensionO(RepositoryAccessChecker checker, String ext) {
        return this.getByExtensionO(ext).flatMap((Function1 & Serializable)path -> MODULE$.canReadO(checker, (Path)path).map((Function1 & Serializable)ret -> ret));
    }

    public Observable<Path> getByExtensionO(String ext) {
        return this.getDescendantsO(Path$.MODULE$.apply((List)package$.MODULE$.Nil())).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Repository.RItem x) {
                Repository.RItem rItem = x;
                if (rItem instanceof Repository.RFile) {
                    Repository.RFile f = (Repository.RFile)rItem;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Repository.RItem x, Function1 function1) {
                Repository.RItem rItem = x;
                if (rItem instanceof Repository.RFile) {
                    Repository.RFile f = (Repository.RFile)rItem;
                    return f;
                }
                return function1.apply((Object)x);
            }
        }).filter((Function1 & Serializable)_$1 -> _$1.path().extension().contains((Object)ext)).map((Function1 & Serializable)_$2 -> _$2.path());
    }

    public Observable<Repository.RItem> getChildrenO(RepositoryAccessChecker checker, Path path) {
        return this.getChildrenO(path).flatMap((Function1 & Serializable)child -> MODULE$.canReadO(checker, (Repository.RItem)child).map((Function1 & Serializable)item -> item));
    }

    public Observable<Repository.RItem> getChildrenO(Path path) {
        return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.pathToFile(path)})).flatMap((Function1 & Serializable)parent -> MODULE$.getChildren((File)parent).flatMap((Function1 & Serializable)child -> Observable$.MODULE$.now((Object)MODULE$.toRItem(path.$div(child.getName()), (File)child)).map((Function1 & Serializable)item -> item)));
    }

    public Observable<Repository.RItem> getDescendantsO(RepositoryAccessChecker checker, Path path) {
        return this.getChildrenO(checker, path).flatMap((Function1 & Serializable)child -> Observable$.MODULE$.now(child).$plus$plus(() -> DiskRepositoryAPI2$.getDescendantsO$$anonfun$1$$anonfun$1(checker, child)).flatMap((Function1 & Serializable)possibleItem -> MODULE$.canReadO(checker, (Repository.RItem)possibleItem).map((Function1 & Serializable)item -> item)));
    }

    public Observable<Repository.RItem> getDescendantsO(Path path) {
        return this.getChildrenO(path).flatMap((Function1 & Serializable)child -> Observable$.MODULE$.now(child).$plus$plus(() -> DiskRepositoryAPI2$.getDescendantsO$$anonfun$2$$anonfun$1(child)).map((Function1 & Serializable)item -> item));
    }

    public Task<Object> canReadT(RepositoryAccessChecker checker, Path path) {
        if (this.isReserved(path)) {
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return checker.canRead(path);
    }

    public Task<Object> canReadT(Path path) {
        return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((!this.isReserved(path) ? 1 : 0) != 0));
    }

    public Task<Object> canWriteT(RepositoryAccessChecker checker, Path path) {
        if (this.isReserved(path)) {
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return checker.canWrite(path);
    }

    public Task<Object> canWriteT(Path path) {
        return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((!this.isReserved(path) ? 1 : 0) != 0));
    }

    public File pathToFile(Path path) {
        return new File(this.rootFolder(), path.toRelativeString());
    }

    public FileHandle pathToFileHandle(Path path) {
        return FileHandle$.MODULE$.apply(path, new File(this.rootFolder(), path.toRelativeString()));
    }

    private Observable<File> getChildren(File parent) {
        if (parent.isDirectory()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])parent.listFiles());
            return Observable$.MODULE$.fromIterable((Iterable)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1 & Serializable)_$3 -> _$3.getName(), (Ordering)Ordering.String$.MODULE$))).filterNot((Function1 & Serializable)f -> MODULE$.isReserved(f.getName()));
        }
        return Observable$.MODULE$.empty();
    }

    private Repository.RItem toRItem(Path path, File file) {
        if (file.isFile()) {
            return Repository.RFile$.MODULE$.apply(path, Predef$.MODULE$.Set().empty(), file.length(), file.lastModified());
        }
        return Repository.RFolder$.MODULE$.apply(path, Predef$.MODULE$.Set().empty());
    }

    private Task<byte[]> bytesBuilder(Observable<byte[]> o) {
        return o.toListL().map((Function1 & Serializable)x$1 -> {
            List list = x$1;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return Array$.MODULE$.emptyByteArray();
            }
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                byte[] head = (byte[])colon2.head();
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                    return head;
                }
            }
            List bytesList = list;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bytesList.foreach((Function1)(JProcedure1 & Serializable)bytes -> baos.write((byte[])bytes));
            return baos.toByteArray();
        });
    }

    private Observable<Path> canReadO(RepositoryAccessChecker checker, Path path) {
        if (this.isReserved(path)) {
            return Observable$.MODULE$.empty();
        }
        return Observable$.MODULE$.fromTask(checker.canRead(path)).filter((Function1 & Serializable)_$4 -> DiskRepositoryAPI2$.canReadO$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$4))).map((Function1 & Serializable)_$5 -> path);
    }

    private Observable<Repository.RItem> canReadO(RepositoryAccessChecker checker, Repository.RItem rItem) {
        if (this.isReserved(rItem.path())) {
            return Observable$.MODULE$.empty();
        }
        return Observable$.MODULE$.fromTask(checker.canRead(rItem.path())).filter((Function1 & Serializable)_$6 -> DiskRepositoryAPI2$.canReadO$$anonfun$3(BoxesRunTime.unboxToBoolean((Object)_$6))).map((Function1 & Serializable)_$7 -> rItem);
    }

    private RuntimeException fileNotFound(Path path) {
        return new RuntimeException("File not found: " + path.toString());
    }

    private static final /* synthetic */ Task readFileDataT$$anonfun$1(Path path$1, boolean canRead) {
        return (canRead ? MODULE$.readFileDataT(path$1) : Task$.MODULE$.raiseError((Throwable)MODULE$.fileNotFound(path$1))).map((Function1 & Serializable)data -> data);
    }

    private static final /* synthetic */ Task readOptFileDataT$$anonfun$1(Path path$2, boolean canRead) {
        return (canRead ? MODULE$.readOptFileDataT(path$2) : Task$.MODULE$.now((Object)None$.MODULE$)).map((Function1 & Serializable)data -> data);
    }

    private static final Repository.FileData readOptFileDataT$$anonfun$2$$anonfun$1(Path path$4, File file$1) {
        return Repository.FileData$.MODULE$.apply(path$4, file$1.lastModified(), com.elixirtech.arch.package$.MODULE$.enrichFile(file$1).data());
    }

    private static final Option readOptFileDataT$$anonfun$2(Path path$3) {
        if (MODULE$.isReserved(path$3)) {
            throw MODULE$.fileNotFound(path$3);
        }
        File file = MODULE$.pathToFile(path$3);
        if (file.isFile()) {
            return Try$.MODULE$.apply(() -> DiskRepositoryAPI2$.readOptFileDataT$$anonfun$2$$anonfun$1(path$3, file)).toOption();
        }
        return None$.MODULE$;
    }

    private static final Repository.FileData readFileDataT$$anonfun$2(Path path$5) {
        if (MODULE$.isReserved(path$5)) {
            throw MODULE$.fileNotFound(path$5);
        }
        File file = MODULE$.pathToFile(path$5);
        if (file.isFile()) {
            return Repository.FileData$.MODULE$.apply(path$5, file.lastModified(), com.elixirtech.arch.package$.MODULE$.enrichFile(file).data());
        }
        throw MODULE$.fileNotFound(path$5);
    }

    private static final /* synthetic */ Task readFileDataIfModifiedT$$anonfun$1(Path path$6, long lastModified$1, boolean canRead) {
        return (canRead ? MODULE$.readFileDataIfModifiedT(path$6, lastModified$1) : Task$.MODULE$.raiseError((Throwable)MODULE$.fileNotFound(path$6))).map((Function1 & Serializable)ret -> ret);
    }

    private static final Option readFileDataIfModifiedT$$anonfun$2(Path path$7, long lastModified$2) {
        if (MODULE$.isReserved(path$7)) {
            throw MODULE$.fileNotFound(path$7);
        }
        File file = MODULE$.pathToFile(path$7);
        if (file.isFile()) {
            if (file.lastModified() == lastModified$2) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)Repository.FileData$.MODULE$.apply(path$7, file.lastModified(), com.elixirtech.arch.package$.MODULE$.enrichFile(file).data()));
        }
        throw MODULE$.fileNotFound(path$7);
    }

    private static final /* synthetic */ Task readOptFileT$$anonfun$1(Path path$8, boolean canRead) {
        return (canRead ? MODULE$.readOptFileT(path$8) : Task$.MODULE$.now((Object)None$.MODULE$)).map((Function1 & Serializable)bytes -> bytes);
    }

    private static final /* synthetic */ Task readFileT$$anonfun$1(Path path$9, boolean canRead) {
        return (canRead ? MODULE$.readFileT(path$9) : Task$.MODULE$.raiseError((Throwable)MODULE$.fileNotFound(path$9))).map((Function1 & Serializable)bytes -> bytes);
    }

    private static final byte[] readFileT$$anonfun$2(Path path$10) {
        if (MODULE$.isReserved(path$10)) {
            throw MODULE$.fileNotFound(path$10);
        }
        File file = MODULE$.pathToFile(path$10);
        if (file.isFile()) {
            return com.elixirtech.arch.package$.MODULE$.enrichFile(file).data();
        }
        throw MODULE$.fileNotFound(path$10);
    }

    private static final byte[] readOptFileT$$anonfun$2$$anonfun$1(File file$2) {
        return com.elixirtech.arch.package$.MODULE$.enrichFile(file$2).data();
    }

    private static final Option readOptFileT$$anonfun$2(Path path$11) {
        if (MODULE$.isReserved(path$11)) {
            return None$.MODULE$;
        }
        File file = MODULE$.pathToFile(path$11);
        if (file.isFile()) {
            return Try$.MODULE$.apply(() -> DiskRepositoryAPI2$.readOptFileT$$anonfun$2$$anonfun$1(file)).toOption();
        }
        return None$.MODULE$;
    }

    private static final /* synthetic */ Task writeFileT$$anonfun$1(Path path$12, byte[] data$1, boolean canWrite) {
        return (canWrite ? MODULE$.writeFileT(path$12, data$1) : Task$.MODULE$.unit()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private static final void writeFileT$$anonfun$2(Path path$13, byte[] data$2) {
        if (!MODULE$.isReserved(path$13)) {
            File file = MODULE$.pathToFile(path$13);
            file.getParentFile().mkdirs();
            Files.write(file.toPath(), data$2, new OpenOption[0]);
            return;
        }
    }

    private static final /* synthetic */ Task writeFileT$$anonfun$3(Path path$14, Observable data$3, boolean canWrite) {
        return (canWrite ? MODULE$.writeFileT(path$14, (Observable<byte[]>)data$3) : Task$.MODULE$.unit()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private static final /* synthetic */ Task createFolderT$$anonfun$1(Path path$16, boolean canWrite) {
        return (canWrite ? MODULE$.createFolderT(path$16) : Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false))).map((Function1 & Serializable)ret -> BoxesRunTime.unboxToBoolean((Object)ret));
    }

    private static final boolean doCreateFolderT$$anonfun$1(Path path$17) {
        File folder = MODULE$.pathToFile(path$17);
        if (folder.isFile()) {
            throw new RuntimeException("Folder " + path$17 + " already exists as a file");
        }
        return folder.mkdirs();
    }

    private static final boolean deleteFileT$$anonfun$1(Path path$18) {
        if (MODULE$.isReserved(path$18)) {
            return false;
        }
        File file = MODULE$.pathToFile(path$18);
        if (file.isFile()) {
            return file.delete();
        }
        return false;
    }

    private static final /* synthetic */ Task deleteFolderT$$anonfun$1(Path path$19, boolean canWrite) {
        return (canWrite ? MODULE$.deleteFolderT(path$19) : Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false))).map((Function1 & Serializable)ret -> BoxesRunTime.unboxToBoolean((Object)ret));
    }

    private static final boolean deleteFolderT$$anonfun$2(Path path$20) {
        if (MODULE$.isReserved(path$20)) {
            return false;
        }
        File file = MODULE$.pathToFile(path$20);
        if (file.isDirectory()) {
            FileUtils.deleteDirectory((File)file);
            return true;
        }
        return false;
    }

    private static final /* synthetic */ Task getItemT$$anonfun$1(Path path$21, boolean canRead) {
        return (canRead ? MODULE$.getItemT(path$21) : Task$.MODULE$.now((Object)None$.MODULE$)).map((Function1 & Serializable)ret -> ret);
    }

    private static final Option getItemT$$anonfun$2(Path path$22) {
        if (MODULE$.isReserved(path$22)) {
            return None$.MODULE$;
        }
        File file = MODULE$.pathToFile(path$22);
        if (file.exists()) {
            return Some$.MODULE$.apply((Object)MODULE$.toRItem(path$22, file));
        }
        return None$.MODULE$;
    }

    private static final Observable getDescendantsO$$anonfun$1$$anonfun$1(RepositoryAccessChecker checker$4, Repository.RItem child$1) {
        return MODULE$.getDescendantsO(checker$4, child$1.path());
    }

    private static final Observable getDescendantsO$$anonfun$2$$anonfun$1(Repository.RItem child$2) {
        return MODULE$.getDescendantsO(child$2.path());
    }

    private static final /* synthetic */ boolean canReadO$$anonfun$1(boolean _$4) {
        return _$4;
    }

    private static final /* synthetic */ boolean canReadO$$anonfun$3(boolean _$6) {
        return _$6;
    }
}

