/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository;

import ambience.api.Repository;
import ambience.api.RepositoryAccessChecker;
import ambience.module.UserDB;
import ambience.repository.AccessChecker$;
import ambience.repository.Metadata$;
import ambience.repository.ModelConverter$;
import ambience.repository.PanelExtras;
import ambience.repository.RepositoryModel;
import ambience.repository.RepositoryModule;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.AddFolder$;
import cats.Functor;
import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.implicits$;
import cats.syntax.OptionIdOps$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class Navigator
implements LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Navigator.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Navigator.class.getDeclaredField("repository$lzy1"));
    private volatile Object log$lzy1;
    private final Scheduler scheduler = Scheduler$.MODULE$.global();
    private volatile Object repository$lzy1;

    public Navigator(RepositoryModule module) {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Repository repository() {
        Object object = this.repository$lzy1;
        if (object instanceof Repository) {
            return (Repository)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Repository)this.repository$lzyINIT1();
    }

    private Object repository$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.repository$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Repository repository = null;
                    try {
                        repository = (Repository)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Repository.class));
                        object2 = repository == null ? LazyVals.NullValue$.MODULE$ : repository;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.repository$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return repository;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> route(UserDB.User user) {
        return (Function1 & Serializable)request -> (Task)request.parameter("path").map((Function1 & Serializable)path -> this.loadPath(user, (String)path).map((Function1 & Serializable)in -> this.response((Option<RepositoryModel.TreeNode>)in))).getOrElse(Navigator::route$$anonfun$1$$anonfun$2);
    }

    public Task<Option<RepositoryModel.TreeNode>> loadPath(UserDB.User user, String pathString) {
        OptionT ret = OptionT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.$anonfun$1(user, pathString))).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.ensureDefaultsExist(user, pathString).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return OptionT$.MODULE$.apply((Object)this.repository().getItemT(user, Path$.MODULE$.apply(pathString))).flatMap((Function1 & Serializable)doc -> OptionT$.MODULE$.apply((Object)AccessChecker$.MODULE$.forT(user, AccessChecker$.MODULE$.forT$default$2()).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x))).flatMap((Function1 & Serializable)checker -> OptionT$.MODULE$.apply((Object)this.loadTreeNode((RepositoryAccessChecker)checker, ModelConverter$.MODULE$.toModel((Repository.RItem)doc)).map((Function1 & Serializable)_$1 -> {
                    RepositoryModel.TreeNode treeNode = (RepositoryModel.TreeNode)implicits$.MODULE$.catsSyntaxOptionId(_$1);
                    return OptionIdOps$.MODULE$.some$extension((Object)treeNode);
                })).map((Function1 & Serializable)optTreeNode -> optTreeNode, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync());
        return (Task)ret.value();
    }

    private OptionT<Task, BoxedUnit> ensureDefaultsExist(UserDB.User user, String pathString) {
        if (this.defaultPaths(user).contains((Object)pathString)) {
            return OptionT$.MODULE$.apply((Object)this.createFolderIfNotExists(user, pathString).map((Function1 & Serializable)_$2 -> {
                BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxOptionId(_$2);
                return OptionIdOps$.MODULE$.some$extension((Object)boxedUnit);
            }));
        }
        BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxOptionId((Object)BoxedUnit.UNIT);
        return OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)OptionIdOps$.MODULE$.some$extension((Object)boxedUnit)));
    }

    private Set<String> defaultPaths(UserDB.User user) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/User/" + user.name(), "/Temp/" + user.name()}));
    }

    private Task<BoxedUnit> createFolderIfNotExists(UserDB.User user, String pathString) {
        Path path = Path$.MODULE$.apply(pathString);
        return Metadata$.MODULE$.apply(path).flatMap((Function1 & Serializable)optMd -> {
            if (optMd.isDefined()) {
                return Task$.MODULE$.unit();
            }
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.createFolderIfNotExists$$anonfun$1$$anonfun$1(pathString);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return AddFolder$.MODULE$.doRun(path).flatMap((Function1 & Serializable)x$12 -> {
                    RepositoryModel.ActionResult actionResult = x$12;
                    return ActionHelper$.MODULE$.setACL(path, (List<PanelExtras.Access>)((List)new .colon.colon((Object)PanelExtras.Access$.MODULE$.apply("user-" + user.id(), true), (List)Nil$.MODULE$))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                });
            });
        });
    }

    private Task<RepositoryModel.TreeNode> loadTreeNode(RepositoryAccessChecker checker, RepositoryModel.RItem rItem) {
        RepositoryModel.RItem rItem2 = rItem;
        if (rItem2 instanceof RepositoryModel.RFile) {
            RepositoryModel.RFile file = (RepositoryModel.RFile)rItem2;
            return this.loadFileTreeNode(checker, file);
        }
        if (rItem2 instanceof RepositoryModel.RFolder) {
            RepositoryModel.RFolder folder = (RepositoryModel.RFolder)rItem2;
            return this.loadFolderTreeNode(checker, folder);
        }
        throw new MatchError((Object)rItem2);
    }

    private Task<RepositoryModel.FileTreeNode> loadFileTreeNode(RepositoryAccessChecker checker, RepositoryModel.RFile rFile) {
        return this.loadFolderTreeNode(checker, RepositoryModel.RFolder$.MODULE$.apply(Path$.MODULE$.apply(rFile.path()).parent().toString(), "")).map((Function1 & Serializable)parent -> RepositoryModel.FileTreeNode$.MODULE$.apply(parent, rFile));
    }

    private Task<RepositoryModel.FolderTreeNode> loadFolderTreeNode(RepositoryAccessChecker checker, RepositoryModel.RFolder rFolder) {
        Observable children = this.repository().getChildrenO(checker.user(), Path$.MODULE$.apply(rFolder.path())).flatMap((Function1 & Serializable)child -> Observable$.MODULE$.now((Object)ModelConverter$.MODULE$.toModel((Repository.RItem)child)).map((Function1 & Serializable)valid -> valid));
        return children.toListL().map((Function1 & Serializable)_$3 -> RepositoryModel.FolderTreeNode$.MODULE$.apply(rFolder, _$3));
    }

    public GravityResponse response(Option<RepositoryModel.TreeNode> in) {
        Option<RepositoryModel.TreeNode> option = in;
        if (option instanceof Some) {
            RepositoryModel.TreeNode treeNode = (RepositoryModel.TreeNode)((Some)option).value();
            return GravityResponse$.MODULE$.json(treeNode.json());
        }
        if (None$.MODULE$.equals(option)) {
            return Gravity$.MODULE$.NotFoundResponse();
        }
        throw new MatchError(option);
    }

    private static final Task route$$anonfun$1$$anonfun$2() {
        return Gravity$.MODULE$.BadRequestResponseT("Missing parameter `path`");
    }

    private static final Object $anonfun$1$$anonfun$1(UserDB.User user$4, String pathString$2) {
        return user$4.name() + " " + pathString$2;
    }

    private final Option $anonfun$1(UserDB.User user$3, String pathString$1) {
        this.log().info(() -> Navigator.$anonfun$1$$anonfun$1(user$3, pathString$1), Line$.MODULE$.apply(30), FullName$.MODULE$.apply("ambience.repository.Navigator.ret"));
        return Option$.MODULE$.apply((Object)BoxedUnit.UNIT);
    }

    private static final Object createFolderIfNotExists$$anonfun$1$$anonfun$1$$anonfun$1(String pathString$7) {
        return "Creating folder " + pathString$7;
    }

    private final void createFolderIfNotExists$$anonfun$1$$anonfun$1(String pathString$6) {
        this.log().info(() -> Navigator.createFolderIfNotExists$$anonfun$1$$anonfun$1$$anonfun$1(pathString$6), Line$.MODULE$.apply(54), FullName$.MODULE$.apply("ambience.repository.Navigator.createFolderIfNotExists"));
    }
}

