/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.actions;

import ambience.api.RepositoryAccessChecker;
import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.repository.Metadata;
import ambience.repository.actions.DownloadZip$;
import ambience.repository.actions.DownloadZip$Info$;
import ambience.repository.archive.ArchiveBuilder$;
import ambience.repository.archive.SafeName$;
import better.files.File$;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.GravityResponse;
import io.circe.Json;
import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class DownloadZip {
    public static Task<GravityResponse> apply(UserDB.User user, Json json) {
        return DownloadZip$.MODULE$.apply(user, json);
    }

    public static Task<GravityResponse> auditRun(UserDB.User user, Info info) {
        return DownloadZip$.MODULE$.auditRun(user, info);
    }

    public static Task<GravityResponse> loadResult(RepositoryAccessChecker repositoryAccessChecker, Metadata.Folder folder) {
        return DownloadZip$.MODULE$.loadResult(repositoryAccessChecker, folder);
    }

    public static LoggingInterface log() {
        return DownloadZip$.MODULE$.log();
    }

    public static Panel panel() {
        return DownloadZip$.MODULE$.panel();
    }

    public static Task<GravityResponse> run(UserDB.User user, Info info) {
        return DownloadZip$.MODULE$.run(user, info);
    }

    public static Scheduler scheduler() {
        return DownloadZip$.MODULE$.scheduler();
    }

    public static class Builder {
        private final RepositoryAccessChecker accessChecker;
        private final Metadata.Folder root;
        private final String rootPrefixSlash;
        private final better.files.File tmpDir;
        private final String zipName;
        private final better.files.File zipFile;
        private final better.files.File outFolder;

        public Builder(RepositoryAccessChecker accessChecker, Metadata.Folder root) {
            this.accessChecker = accessChecker;
            this.root = root;
            this.rootPrefixSlash = root.path().isEmpty() ? root.path().toString() : root.path().toString() + "/";
            String string = File$.MODULE$.newTemporaryDirectory$default$1();
            Option option = File$.MODULE$.newTemporaryDirectory$default$2();
            this.tmpDir = File$.MODULE$.newTemporaryDirectory(string, option, File$.MODULE$.newTemporaryDirectory$default$3(string, option));
            this.zipName = root.path().isEmpty() ? "Root.zip" : root.path().name() + ".zip";
            boolean bl = this.tmpDir().createChild$default$3();
            this.zipFile = this.tmpDir().createChild(this.zipName(), false, bl, this.tmpDir().createChild$default$4(this.zipName(), false, bl), this.tmpDir().createChild$default$5(this.zipName(), false, bl));
            boolean bl2 = this.tmpDir().createChild$default$3();
            this.outFolder = this.tmpDir().createChild("root", true, bl2, this.tmpDir().createChild$default$4("root", true, bl2), this.tmpDir().createChild$default$5("root", true, bl2));
        }

        public String rootPrefixSlash() {
            return this.rootPrefixSlash;
        }

        public better.files.File tmpDir() {
            return this.tmpDir;
        }

        public String zipName() {
            return this.zipName;
        }

        public better.files.File zipFile() {
            return this.zipFile;
        }

        public better.files.File outFolder() {
            return this.outFolder;
        }

        public Task<better.files.File> run() {
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.run$$anonfun$2();
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.run$$anonfun$3$$anonfun$1();
                    return BoxedUnit.UNIT;
                }).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.copyFolderChildren(this.root).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                            this.run$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1();
                            return BoxedUnit.UNIT;
                        }).map((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return this.zipFile();
                        });
                    });
                });
            });
        }

        public void dispose() {
            DownloadZip$.MODULE$.log().info(this::dispose$$anonfun$1, Line$.MODULE$.apply(89), FullName$.MODULE$.apply("ambience.repository.actions.DownloadZip.Builder.dispose"));
            this.tmpDir().delete(this.tmpDir().delete$default$1(), this.tmpDir().delete$default$2());
        }

        public Task<BoxedUnit> copyFolderChildren(Metadata.Folder folder) {
            BoxedUnit[] boxedUnitArray = new BoxedUnit[1];
            DownloadZip$.MODULE$.log().info(() -> DownloadZip$.ambience$repository$actions$DownloadZip$Builder$$_$_$$anonfun$2(folder), Line$.MODULE$.apply(95), FullName$.MODULE$.apply("ambience.repository.actions.DownloadZip.Builder.all"));
            boxedUnitArray[0] = BoxedUnit.UNIT;
            Observable all = Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapUnitArray(boxedUnitArray)).flatMap(arg_0 -> DownloadZip$.ambience$repository$actions$DownloadZip$Builder$$_$_$$anonfun$3(folder, arg_0));
            return all.mapEval((Function1 & Serializable)x$1 -> {
                Metadata.Item item = x$1;
                if (item instanceof Metadata.File) {
                    Metadata.File f = (Metadata.File)item;
                    return this.copyFile(f);
                }
                if (item instanceof Metadata.Folder) {
                    Metadata.Folder f = (Metadata.Folder)item;
                    return this.accessChecker.canReadLeaf(f.path()).flatMap((Function1 & Serializable)ok -> this.copyFolderChildren$$anonfun$1$$anonfun$1(f, BoxesRunTime.unboxToBoolean((Object)ok)));
                }
                throw new MatchError((Object)item);
            }).completedL();
        }

        public Task<BoxedUnit> copyFile(Metadata.File f) {
            return this.accessChecker.canRead(f.path()).map((Function1 & Serializable)v1 -> {
                this.copyFile$$anonfun$1(f, BoxesRunTime.unboxToBoolean((Object)v1));
                return BoxedUnit.UNIT;
            });
        }

        private final Object run$$anonfun$2$$anonfun$1() {
            return "Building zip from " + this.root.path();
        }

        private final void run$$anonfun$2() {
            DownloadZip$.MODULE$.log().info(this::run$$anonfun$2$$anonfun$1, Line$.MODULE$.apply(81), FullName$.MODULE$.apply("ambience.repository.actions.DownloadZip.Builder.run"));
        }

        private final Object run$$anonfun$3$$anonfun$1$$anonfun$1() {
            return "tmpDir = " + this.tmpDir().path();
        }

        private final void run$$anonfun$3$$anonfun$1() {
            DownloadZip$.MODULE$.log().info(this::run$$anonfun$3$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(82), FullName$.MODULE$.apply("ambience.repository.actions.DownloadZip.Builder.run"));
        }

        private final void run$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1() {
            ArchiveBuilder$.MODULE$.apply(this.outFolder().toJava(), this.zipFile().toJava());
        }

        private final Object dispose$$anonfun$1() {
            return "Deleting temporary directory " + this.tmpDir().path();
        }

        private final /* synthetic */ Task copyFolderChildren$$anonfun$1$$anonfun$1(Metadata.Folder f$1, boolean ok) {
            if (ok) {
                return this.copyFolderChildren(f$1);
            }
            return Task$.MODULE$.unit();
        }

        private final /* synthetic */ void copyFile$$anonfun$1(Metadata.File f$2, boolean ok) {
            if (ok) {
                String remainder = SafeName$.MODULE$.safe(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(f$2.path().toString()), this.rootPrefixSlash()));
                File file = new File(this.outFolder().toJava(), remainder);
                file.getParentFile().mkdirs();
                DownloadZip$.MODULE$.log().info(() -> DownloadZip$.ambience$repository$actions$DownloadZip$Builder$$_$copyFile$$anonfun$1$$anonfun$1(f$2), Line$.MODULE$.apply(116), FullName$.MODULE$.apply("ambience.repository.actions.DownloadZip.Builder.copyFile"));
                Files.copy(f$2.handle().toPath(), file.toPath(), new CopyOption[0]);
                return;
            }
            DownloadZip$.MODULE$.log().info(() -> DownloadZip$.ambience$repository$actions$DownloadZip$Builder$$_$copyFile$$anonfun$1$$anonfun$2(f$2), Line$.MODULE$.apply(120), FullName$.MODULE$.apply("ambience.repository.actions.DownloadZip.Builder.copyFile"));
        }
    }

    public static final class Info
    implements Product,
    Serializable {
        private final String path;

        public static Info apply(String string) {
            return DownloadZip$Info$.MODULE$.apply(string);
        }

        public static Info fromProduct(Product product) {
            return DownloadZip$Info$.MODULE$.fromProduct(product);
        }

        public static Info unapply(Info info) {
            return DownloadZip$Info$.MODULE$.unapply(info);
        }

        public Info(String path) {
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Info)) return false;
            Info info = (Info)object;
            String string = this.path();
            String string2 = info.path();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Info;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Info";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String path() {
            return this.path;
        }

        public Info copy(String path) {
            return new Info(path);
        }

        public String copy$default$1() {
            return this.path();
        }

        public String _1() {
            return this.path();
        }
    }
}

