/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.actions;

import ambience.api.RepositoryAccessChecker;
import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.AccessChecker$;
import ambience.repository.DiskRepositoryAPI$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.PanelExtras;
import ambience.repository.PanelExtras$;
import ambience.repository.RepositoryModel;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.MoveFile;
import ambience.repository.actions.MoveFile$Info$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class MoveFile$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(MoveFile$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final MoveFile$Info$ Info;
    public static final MoveFile$ MODULE$;

    private MoveFile$() {
    }

    static {
        MODULE$ = new MoveFile$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MoveFile$.class);
    }

    public Panel panel(UserDB.User user) {
        PanelExtras.FolderChooserSetup folderChooserSetup = (PanelExtras.FolderChooserSetup)io.circe.syntax.package$.MODULE$.EncoderOps((Object)PanelExtras.FolderChooserSetup$.MODULE$.apply("/User/" + user.name()));
        String string = "value";
        Json setup = package.EncoderOps$.MODULE$.asJson$extension((Object)folderChooserSetup, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MoveFile$::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)Panel.Item$.MODULE$.apply(PanelExtras$.MODULE$.FolderChooser(), "newParent", "Target Folder", setup), (List)Nil$.MODULE$));
    }

    public Task<RepositoryModel.ActionResult> apply(UserDB.User user, Json json) {
        String string = "path";
        String string2 = "newParent";
        int size = 2;
        Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", MoveFile$::apply$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), MoveFile$::apply$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(MoveFile$::apply$$anonfun$3)))));
        if (either instanceof Right) {
            MoveFile.Info info = (MoveFile.Info)((Right)either).value();
            return this.auditRun(user, info);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().warn(() -> MoveFile$.apply$$anonfun$4(json, err), Line$.MODULE$.apply(32), FullName$.MODULE$.apply("ambience.repository.actions.MoveFile.apply"));
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Invalid request", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
        }
        throw new MatchError((Object)either);
    }

    public Task<RepositoryModel.ActionResult> auditRun(UserDB.User user, MoveFile.Info info) {
        return this.run(user, info).map((Function1 & Serializable)reply -> {
            MoveFile.Info info = (MoveFile.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)info);
            String string = "path";
            String string2 = "newParent";
            ActionHelper$.MODULE$.audit(user, ActionHelper$.MODULE$.buildAction((RepositoryModel.ActionResult)reply, info.path(), "move-file", (Option<Json>)Some$.MODULE$.apply((Object)package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MoveFile$::auditRun$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))))));
            return reply;
        });
    }

    public Task<RepositoryModel.ActionResult> run(UserDB.User user, MoveFile.Info info) {
        com.elixirtech.arch.Path oldPath = Path$.MODULE$.apply(info.path());
        com.elixirtech.arch.Path newPath = Path$.MODULE$.apply(info.newParent());
        return AccessChecker$.MODULE$.forT(user, AccessChecker$.MODULE$.forT$default$2()).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(oldPath).flatMap((Function1 & Serializable)oldItem -> Metadata$.MODULE$.apply(newPath).flatMap((Function1 & Serializable)newFolder -> Metadata$.MODULE$.apply(newPath.$div(oldPath.name())).flatMap((Function1 & Serializable)newFile -> MODULE$.canMove((RepositoryAccessChecker)checker, (Option<Metadata.Item>)oldItem, (Option<Metadata.Item>)newFolder, (Option<Metadata.Item>)newFile).flatMap((Function1 & Serializable)eReply -> {
            Task task;
            Either either = eReply;
            if (either instanceof Right) {
                task = MODULE$.doRun(info);
            } else if (either instanceof Left) {
                RepositoryModel.ActionResult reply2 = (RepositoryModel.ActionResult)((Left)either).value();
                task = Task$.MODULE$.now((Object)reply2);
            } else {
                throw new MatchError((Object)either);
            }
            return task.map((Function1 & Serializable)reply -> reply);
        })))));
    }

    public Task<Either<RepositoryModel.ActionResult, Metadata.Folder>> canMove(RepositoryAccessChecker checker, Option<Metadata.Item> oldItem, Option<Metadata.Item> newFolder, Option<Metadata.Item> newFile) {
        Metadata.Item item;
        if (newFile.isDefined()) {
            return Task$.MODULE$.now((Object)Left$.MODULE$.apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target file already exists", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
        }
        Option<Metadata.Item> option = oldItem;
        if (option instanceof Some && (item = (Metadata.Item)((Some)option).value()) instanceof Metadata.File) {
            Metadata.Item item2;
            Metadata.File f = (Metadata.File)item;
            Option<Metadata.Item> option2 = newFolder;
            if (option2 instanceof Some && (item2 = (Metadata.Item)((Some)option2).value()) instanceof Metadata.Folder) {
                Metadata.Folder newParent = (Metadata.Folder)item2;
                return checker.canWrite(newParent.path()).map((Function1 & Serializable)ok -> MoveFile$.canMove$$anonfun$1(newParent, BoxesRunTime.unboxToBoolean((Object)ok)));
            }
            return Task$.MODULE$.now((Object)Left$.MODULE$.apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target is not a folder", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
        }
        return Task$.MODULE$.now((Object)Left$.MODULE$.apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not a file", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
    }

    public Task<RepositoryModel.ActionResult> doRun(MoveFile.Info info) {
        com.elixirtech.arch.Path oldPath = Path$.MODULE$.apply(info.path());
        com.elixirtech.arch.Path newPath = Path$.MODULE$.apply(info.newParent()).$div(oldPath.name());
        Task result = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            MoveFile$.$anonfun$2(oldPath, newPath);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.moveFile(oldPath, newPath).map((Function1 & Serializable)reply -> reply);
        });
        return result.onErrorHandle((Function1 & Serializable)ex -> {
            MODULE$.log().error(() -> MoveFile$.doRun$$anonfun$1$$anonfun$1(ex), ex, Line$.MODULE$.apply(90), FullName$.MODULE$.apply("ambience.repository.actions.MoveFile.doRun"));
            return RepositoryModel.ActionResult$.MODULE$.apply("error", "Database error", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4());
        });
    }

    public com.elixirtech.arch.Path getUniqueName(com.elixirtech.arch.Path newParent, List<Document> children, String name) {
        Set pathSet = children.flatMap((Function1 & Serializable)_$1 -> _$1.get("path", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class))).map((Function1 & Serializable)_$2 -> _$2.getValue()).toSet();
        return newParent.$div(this.getNewName((Set<String>)pathSet, newParent, name));
    }

    public String getNewName(Set<String> pathSet, com.elixirtech.arch.Path newParent, String name) {
        Object workingName = name;
        if (pathSet.contains((Object)newParent.$div((String)workingName).toString())) {
            String newname = (String)workingName + " (Copy)";
            int i = 1;
            while (pathSet.contains((Object)newParent.$div(newname).toString())) {
                newname = (String)workingName + " (Copy " + ++i + ")";
            }
            workingName = newname;
        }
        return workingName;
    }

    public Task<RepositoryModel.ActionResult> moveFile(com.elixirtech.arch.Path oldPath, com.elixirtech.arch.Path newPath) {
        return Task$.MODULE$.apply(() -> MoveFile$.moveFile$$anonfun$1(oldPath, newPath));
    }

    private static final List $anonfun$1() {
        Encoder encodeA;
        EncoderNotDeriveSum f$proxy1;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy1 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder);
    }

    private static final List apply$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        DecoderNotDeriveSum f$proxy2;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy2 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy2 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy3 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 apply$$anonfun$2() {
        MoveFile$Info$ moveFile$Info$ = MoveFile$Info$.MODULE$;
        return (Function1 & Serializable)p -> (MoveFile.Info)moveFile$Info$.fromProduct((Product)p);
    }

    private static final Product apply$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object apply$$anonfun$4(Json json$1, DecodingFailure err$1) {
        return "Can't process " + json$1.noSpaces() + ": " + err$1;
    }

    private static final List auditRun$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        EncoderNotDeriveSum f$proxy3;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy3 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy4 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy3;
        Configuration x$2$proxy5 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final /* synthetic */ Either canMove$$anonfun$1(Metadata.Folder newParent$1, boolean ok) {
        if (ok) {
            return Right$.MODULE$.apply((Object)newParent$1);
        }
        return Left$.MODULE$.apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target folder is not writable", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final Object $anonfun$2$$anonfun$1(com.elixirtech.arch.Path oldPath$5, com.elixirtech.arch.Path newPath$5) {
        return "Moving " + oldPath$5.toString() + " to " + newPath$5.toString();
    }

    private static final void $anonfun$2(com.elixirtech.arch.Path oldPath$4, com.elixirtech.arch.Path newPath$4) {
        MODULE$.log().info(() -> MoveFile$.$anonfun$2$$anonfun$1(oldPath$4, newPath$4), Line$.MODULE$.apply(86), FullName$.MODULE$.apply("ambience.repository.actions.MoveFile.result"));
    }

    private static final Object doRun$$anonfun$1$$anonfun$1(Throwable ex$1) {
        return "Database error: " + ex$1;
    }

    private static final Path moveFile$$anonfun$1$$anonfun$1(File from$1, File to$1) {
        return Files.move(from$1.toPath(), to$1.toPath(), new CopyOption[0]);
    }

    private static final RepositoryModel.ActionResult moveFile$$anonfun$1(com.elixirtech.arch.Path oldPath$7, com.elixirtech.arch.Path newPath$7) {
        File to;
        File from = DiskRepositoryAPI$.MODULE$.pathToFile(oldPath$7);
        Try try_ = Try$.MODULE$.apply(() -> MoveFile$.moveFile$$anonfun$1$$anonfun$1(from, to = DiskRepositoryAPI$.MODULE$.pathToFile(newPath$7)));
        if (try_ instanceof Success) {
            return RepositoryModel.ActionResult$.MODULE$.apply("info", "File moved successfully", (Option)Some$.MODULE$.apply((Object)oldPath$7.parent().toString()), true);
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return RepositoryModel.ActionResult$.MODULE$.apply("warn", "File move failed - " + ex, RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4());
        }
        throw new MatchError((Object)try_);
    }
}

