/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.actions;

import ambience.api.RepositoryAccessChecker;
import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.AccessChecker$;
import ambience.repository.DiskRepositoryAPI$;
import ambience.repository.FileActions$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.RepositoryModel;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.RenameFile;
import ambience.repository.actions.RenameFile$Info$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class RenameFile$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RenameFile$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final RenameFile$Info$ Info;
    public static final RenameFile$ MODULE$;

    private RenameFile$() {
    }

    static {
        MODULE$ = new RenameFile$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RenameFile$.class);
    }

    public Panel panel(String name) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)Panel.Item$.MODULE$.apply(Panel$.MODULE$.Text(), "name", "File Name", FileActions$.MODULE$.text(name)), (List)Nil$.MODULE$));
    }

    public Task<RepositoryModel.ActionResult> apply(UserDB.User user, Json json) {
        String string = "path";
        String string2 = "name";
        int size = 2;
        Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", RenameFile$::apply$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), RenameFile$::apply$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(RenameFile$::apply$$anonfun$3)))));
        if (either instanceof Right) {
            RenameFile.Info info = (RenameFile.Info)((Right)either).value();
            return this.auditRun(user, info);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().warn(() -> RenameFile$.apply$$anonfun$4(json, err), Line$.MODULE$.apply(27), FullName$.MODULE$.apply("ambience.repository.actions.RenameFile.apply"));
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Invalid request", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
        }
        throw new MatchError((Object)either);
    }

    public Task<RepositoryModel.ActionResult> auditRun(UserDB.User user, RenameFile.Info info) {
        return this.run(user, info).map((Function1 & Serializable)reply -> {
            RenameFile.Info info = (RenameFile.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)info);
            String string = "path";
            String string2 = "name";
            ActionHelper$.MODULE$.audit(user, ActionHelper$.MODULE$.buildAction((RepositoryModel.ActionResult)reply, info.path(), "rename-file", (Option<Json>)Some$.MODULE$.apply((Object)package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(RenameFile$::auditRun$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))))));
            return reply;
        });
    }

    public Task<RepositoryModel.ActionResult> run(UserDB.User user, RenameFile.Info info) {
        if (info.name().contains("/")) {
            return ActionHelper$.MODULE$.warnReply("File name cannot contain /");
        }
        if (info.name().contains("\\")) {
            return ActionHelper$.MODULE$.warnReply("File name cannot contain \\");
        }
        if (info.name().trim().isEmpty()) {
            return ActionHelper$.MODULE$.warnReply("File name required");
        }
        String string = info.name().trim();
        String string2 = ".";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return ActionHelper$.MODULE$.warnReply("File name '.' not allowed");
        }
        String string3 = info.name().trim();
        String string4 = "..";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return ActionHelper$.MODULE$.warnReply("File name '..' not allowed");
        }
        com.elixirtech.arch.Path oldPath = Path$.MODULE$.apply(info.path());
        com.elixirtech.arch.Path newPath = oldPath.parent().$div(info.name());
        return AccessChecker$.MODULE$.forT(user, AccessChecker$.MODULE$.forT$default$2()).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(oldPath).flatMap((Function1 & Serializable)oldItem -> Metadata$.MODULE$.apply(newPath).flatMap((Function1 & Serializable)newItem -> MODULE$.canRename((RepositoryAccessChecker)checker, (Option<Metadata.Item>)oldItem, (Option<Metadata.Item>)newItem).flatMap((Function1 & Serializable)eReply -> {
            Task task;
            Either either = eReply;
            if (either instanceof Right) {
                task = MODULE$.doRun(user, info);
            } else if (either instanceof Left) {
                RepositoryModel.ActionResult reply2 = (RepositoryModel.ActionResult)((Left)either).value();
                task = Task$.MODULE$.now((Object)reply2);
            } else {
                throw new MatchError((Object)either);
            }
            return task.map((Function1 & Serializable)reply -> reply);
        }))));
    }

    public Task<Either<RepositoryModel.ActionResult, Metadata.File>> canRename(RepositoryAccessChecker checker, Option<Metadata.Item> oldItem, Option<Metadata.Item> newItem) {
        Metadata.Item item;
        Option<Metadata.Item> option = oldItem;
        if (option instanceof Some && (item = (Metadata.Item)((Some)option).value()) instanceof Metadata.File) {
            Metadata.File f = (Metadata.File)item;
            if (newItem.isDefined()) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "New path already exists", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
            }
            return checker.canWrite(f.path()).map((Function1 & Serializable)ok -> RenameFile$.canRename$$anonfun$1(f, BoxesRunTime.unboxToBoolean((Object)ok)));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not a file", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
    }

    public Task<RepositoryModel.ActionResult> doRun(UserDB.User user, RenameFile.Info info) {
        return Task$.MODULE$.apply(() -> RenameFile$.doRun$$anonfun$1(info));
    }

    private static final List apply$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        DecoderNotDeriveSum f$proxy1;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy1 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 apply$$anonfun$2() {
        RenameFile$Info$ renameFile$Info$ = RenameFile$Info$.MODULE$;
        return (Function1 & Serializable)p -> (RenameFile.Info)renameFile$Info$.fromProduct((Product)p);
    }

    private static final Product apply$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object apply$$anonfun$4(Json json$1, DecodingFailure err$1) {
        return "Can't process " + json$1.noSpaces() + ": " + err$1;
    }

    private static final List auditRun$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        EncoderNotDeriveSum f$proxy2;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy2 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy3 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy4 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final /* synthetic */ Either canRename$$anonfun$1(Metadata.File f$1, boolean ok) {
        if (ok) {
            return package$.MODULE$.Right().apply((Object)f$1);
        }
        return package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not writable", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final Path doRun$$anonfun$1$$anonfun$1(File from$1, File to$1) {
        return Files.move(from$1.toPath(), to$1.toPath(), new CopyOption[0]);
    }

    private static final RepositoryModel.ActionResult doRun$$anonfun$1(RenameFile.Info info$6) {
        File to;
        com.elixirtech.arch.Path oldPath = Path$.MODULE$.apply(info$6.path());
        File from = DiskRepositoryAPI$.MODULE$.pathToFile(oldPath);
        Try try_ = Try$.MODULE$.apply(() -> RenameFile$.doRun$$anonfun$1$$anonfun$1(from, to = new File(from.getParentFile(), info$6.name())));
        if (try_ instanceof Success) {
            return RepositoryModel.ActionResult$.MODULE$.apply("info", "File renamed successfully", (Option)Some$.MODULE$.apply((Object)oldPath.parent().toString()), true);
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return RepositoryModel.ActionResult$.MODULE$.apply("warn", "File rename failed - " + ex, RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4());
        }
        throw new MatchError((Object)try_);
    }
}

