/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.actions;

import ambience.api.RepositoryAccessChecker;
import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.AccessChecker$;
import ambience.repository.Constants$;
import ambience.repository.DiskRepositoryAPI$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.RepositoryModel;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.DeleteFile$;
import ambience.repository.actions.DeleteFile$Info$;
import ambience.repository.actions.Upload;
import ambience.repository.actions.UploadArchive$FileInfo$;
import ambience.repository.actions.UploadArchive$Info$;
import ambience.repository.archive.ArchiveExtractor$;
import ambience.repository.archive.Bzip2Type$;
import ambience.repository.archive.SafeName$;
import ambience.repository.archive.TgzType$;
import ambience.repository.archive.ZipType$;
import better.files.File$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.FileDataBytes;
import com.elixirtech.arch.FileDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class UploadArchive$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(UploadArchive$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(UploadArchive$.class.getDeclaredField("panel$lzy1"));
    private volatile Object log$lzy1;
    public static final UploadArchive$Info$ Info;
    public static final UploadArchive$FileInfo$ FileInfo;
    private volatile Object panel$lzy1;
    public static final UploadArchive$ MODULE$;

    private UploadArchive$() {
    }

    static {
        MODULE$ = new UploadArchive$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UploadArchive$.class);
    }

    public Panel panel() {
        Object object = this.panel$lzy1;
        if (object instanceof Panel) {
            return (Panel)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Panel)this.panel$lzyINIT1();
    }

    private Object panel$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.panel$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Panel panel = null;
                    try {
                        int n = Constants$.MODULE$.OneMB() * 500;
                        boolean bl = Panel.FileSetup$.MODULE$.$lessinit$greater$default$1();
                        Set set = Panel.FileSetup$.MODULE$.$lessinit$greater$default$3();
                        Panel.FileSetup fileSetup = (Panel.FileSetup)io.circe.syntax.package$.MODULE$.EncoderOps((Object)Panel.FileSetup$.MODULE$.apply(bl, n, set));
                        String string = "required";
                        String string2 = "maxSize";
                        String string3 = "allowedExtensions";
                        Panel.CheckboxSetup checkboxSetup = (Panel.CheckboxSetup)io.circe.syntax.package$.MODULE$.EncoderOps((Object)Panel.CheckboxSetup$.MODULE$.apply(false, Panel.CheckboxSetup$.MODULE$.$lessinit$greater$default$2()));
                        String string4 = "value";
                        String string5 = "rebuild";
                        panel = Panel$.MODULE$.apply((List)new .colon.colon((Object)Panel.Item$.MODULE$.apply(Panel$.MODULE$.File(), "file", "Archive File", package.EncoderOps$.MODULE$.asJson$extension((Object)fileSetup, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(UploadArchive$::panel$lzyINIT1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))))), (List)new .colon.colon((Object)Panel.Item$.MODULE$.apply(Panel$.MODULE$.Checkbox(), "overwrite", "Overwrite", package.EncoderOps$.MODULE$.asJson$extension((Object)checkboxSetup, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(UploadArchive$::panel$lzyINIT1$$anonfun$2, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4), Configuration$.MODULE$.default()))))), (List)Nil$.MODULE$)));
                        object2 = panel == null ? LazyVals.NullValue$.MODULE$ : panel;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.panel$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.panel$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return panel;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<RepositoryModel.ActionResult> apply(UserDB.User user, Upload.Request request) {
        return this.run(user, request).map((Function1 & Serializable)reply -> {
            ActionHelper$.MODULE$.audit(user, ActionHelper$.MODULE$.buildAction((RepositoryModel.ActionResult)reply, request.path().toString(), "upload-archive", (Option<Json>)None$.MODULE$));
            return reply;
        });
    }

    public Task<RepositoryModel.ActionResult> run(UserDB.User user, Upload.Request request) {
        this.log().info(() -> UploadArchive$.run$$anonfun$1(request), Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.repository.actions.UploadArchive.run"));
        Path basePath = request.path();
        return AccessChecker$.MODULE$.forT(user, AccessChecker$.MODULE$.forT$default$2()).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(basePath).flatMap((Function1 & Serializable)baseItem -> MODULE$.canAdd((RepositoryAccessChecker)checker, (Option<Metadata.Item>)baseItem).flatMap((Function1 & Serializable)eReply -> {
            Task task;
            Either either = eReply;
            if (either instanceof Right) {
                task = MODULE$.doRun(user, request);
            } else if (either instanceof Left) {
                RepositoryModel.ActionResult reply2 = (RepositoryModel.ActionResult)((Left)either).value();
                task = Task$.MODULE$.now((Object)reply2);
            } else {
                throw new MatchError((Object)either);
            }
            return task.map((Function1 & Serializable)reply -> reply);
        })));
    }

    public Task<Either<RepositoryModel.ActionResult, Metadata.Folder>> canAdd(RepositoryAccessChecker checker, Option<Metadata.Item> baseItem) {
        Metadata.Item item;
        Option<Metadata.Item> option = baseItem;
        if (option instanceof Some && (item = (Metadata.Item)((Some)option).value()) instanceof Metadata.Folder) {
            Metadata.Folder f = (Metadata.Folder)item;
            return checker.canWrite(f.path()).map((Function1 & Serializable)ok -> UploadArchive$.canAdd$$anonfun$1(f, BoxesRunTime.unboxToBoolean((Object)ok)));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not a folder", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
    }

    public Task<RepositoryModel.ActionResult> doRun(UserDB.User user, Upload.Request request) {
        return this.withTempFile((DataBytes)request.file().data(), (Function1 & Serializable)tmp -> {
            better.files.File tempDir = MODULE$.expandArchive(request, (better.files.File)tmp);
            MODULE$.log().info(() -> UploadArchive$.doRun$$anonfun$1$$anonfun$1(tempDir), Line$.MODULE$.apply(64), FullName$.MODULE$.apply("ambience.repository.actions.UploadArchive.doRun"));
            int n = tempDir.walk$default$1();
            List allFiles = tempDir.walk(n, tempDir.walk$default$2(n)).toList();
            return MODULE$.doAddAll(user, request, tempDir.pathAsString(), (List<better.files.File>)allFiles, 0).map((Function1 & Serializable)reply -> {
                MODULE$.log().info(UploadArchive$::doRun$$anonfun$1$$anonfun$2$$anonfun$1, Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.repository.actions.UploadArchive.doRun"));
                tempDir.delete(tempDir.delete$default$1(), tempDir.delete$default$2());
                return reply;
            });
        });
    }

    public better.files.File expandArchive(Upload.Request request, better.files.File tmp) {
        String filename = request.file().filename().toLowerCase();
        if (filename.endsWith(".zip")) {
            return this.eitherToException(ArchiveExtractor$.MODULE$.expand(tmp.toJava(), ZipType$.MODULE$));
        }
        if (filename.endsWith(".tgz")) {
            return this.eitherToException(ArchiveExtractor$.MODULE$.expand(tmp.toJava(), TgzType$.MODULE$));
        }
        if (filename.endsWith(".tar.gz")) {
            return this.eitherToException(ArchiveExtractor$.MODULE$.expand(tmp.toJava(), TgzType$.MODULE$));
        }
        if (filename.endsWith(".bzip2")) {
            return this.eitherToException(ArchiveExtractor$.MODULE$.expand(tmp.toJava(), Bzip2Type$.MODULE$));
        }
        throw new RuntimeException("Unknown archive type for " + filename);
    }

    public <T> Task<T> withTempFile(DataBytes db, Function1<better.files.File, Task<T>> fn) {
        DataBytes dataBytes = db;
        if (dataBytes instanceof FileDataBytes) {
            File file;
            FileDataBytes fileDataBytes = FileDataBytes$.MODULE$.unapply((FileDataBytes)dataBytes);
            File file2 = file = fileDataBytes._1();
            return (Task)fn.apply((Object)File$.MODULE$.apply(file2.toPath()));
        }
        return this.buildTempFile(db).flatMap((Function1 & Serializable)tmp -> ((Task)fn.apply(tmp)).map((Function1 & Serializable)ret -> {
            tmp.delete(tmp.delete$default$1(), tmp.delete$default$2());
            return ret;
        }));
    }

    public Task<better.files.File> buildTempFile(DataBytes bytes) {
        Option option = File$.MODULE$.newTemporaryFile$default$3();
        better.files.File tmp = File$.MODULE$.newTemporaryFile("upload-archive", "", option, File$.MODULE$.newTemporaryFile$default$4("upload-archive", "", option));
        FileOutputStream fos = new FileOutputStream(tmp.toJava());
        return bytes.observable().map((Function1)(JProcedure1 & Serializable)x$0 -> fos.write((byte[])x$0)).completedL().map((Function1)(JProcedure1 & Serializable)_$1 -> fos.close()).as((Object)tmp);
    }

    public better.files.File eitherToException(Either<String, File> e) {
        Either<String, File> either = e;
        if (either instanceof Right) {
            File file = (File)((Right)either).value();
            return better.files.package$.MODULE$.FileExtensions(file).toScala();
        }
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            throw new RuntimeException(msg);
        }
        throw new MatchError(either);
    }

    public Task<RepositoryModel.ActionResult> doAddAll(UserDB.User user, Upload.Request request, String tempPath, List<better.files.File> allFiles, int failCount) {
        List<better.files.File> list = allFiles;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<better.files.File> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            if (failCount > 0) {
                String string = "Unarchive completed (" + failCount + " failed to add)";
                Option option = RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3();
                return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("info", string, option, true));
            }
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("info", "Unarchive completed", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), true));
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            better.files.File head = (better.files.File)colon2.head();
            List tail = list3;
            return this.doAdd(user, request, tempPath, head).flatMap((Function1 & Serializable)ok -> UploadArchive$.doAddAll$$anonfun$1(failCount, user, request, tempPath, tail, BoxesRunTime.unboxToBoolean((Object)ok)));
        }
        throw new MatchError(list);
    }

    public Task<Object> doAdd(UserDB.User user, Upload.Request request, String tempPath, better.files.File file) {
        Path newPath = request.path().$div(SafeName$.MODULE$.unsafe(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(file.pathAsString()), tempPath).replace("\\", "/")));
        if (file.isDirectory(file.isDirectory$default$1())) {
            return Metadata$.MODULE$.apply(newPath).map((Function1 & Serializable)_$2 -> _$2.isDefined()).flatMap((Function1 & Serializable)exists -> UploadArchive$.doAdd$$anonfun$2(newPath, BoxesRunTime.unboxToBoolean((Object)exists)));
        }
        return (request.overwrite() && file.isRegularFile(file.isRegularFile$default$1()) ? this.removeExisting(user, newPath.toString()) : Task$.MODULE$.unit()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ActionHelper$.MODULE$.ensureDoesNotExist(newPath).flatMap((Function1 & Serializable)ok -> UploadArchive$.doAdd$$anonfun$3$$anonfun$1(user, newPath, file, BoxesRunTime.unboxToBoolean((Object)ok)));
        });
    }

    public Task<BoxedUnit> removeExisting(UserDB.User user, String existing) {
        this.log().info(() -> UploadArchive$.removeExisting$$anonfun$1(existing), Line$.MODULE$.apply(149), FullName$.MODULE$.apply("ambience.repository.actions.UploadArchive.removeExisting"));
        return DeleteFile$.MODULE$.doRun(user, DeleteFile$Info$.MODULE$.apply(existing)).map((Function1)(JProcedure1 & Serializable)reply -> ActionHelper$.MODULE$.logResult(this, (RepositoryModel.ActionResult)reply));
    }

    public Task<Object> addFolder(Path newPath) {
        return Task$.MODULE$.apply(() -> UploadArchive$.addFolder$$anonfun$1(newPath));
    }

    public Task<Object> addFile(UserDB.User user, Path newPath, better.files.File file) {
        return Task$.MODULE$.apply(() -> UploadArchive$.addFile$$anonfun$1(newPath, file));
    }

    private static final List panel$lzyINIT1$$anonfun$1() {
        Encoder.AsArray encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        EncoderNotDeriveSum f$proxy1;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy1 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeBoolean();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeInt();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy1;
        Configuration x$2$proxy3 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder.AsArray asArray = encodeA = Encoder$.MODULE$.encodeSet(Encoder$.MODULE$.encodeString());
        return package$.MODULE$.Nil().$colon$colon((Object)asArray).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final List panel$lzyINIT1$$anonfun$2() {
        Encoder encodeA;
        Encoder encodeA2;
        EncoderNotDeriveSum f$proxy2;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy2 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy4 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeBoolean();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy5 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeBoolean();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final Object run$$anonfun$1(Upload.Request request$2) {
        return "run: " + request$2;
    }

    private static final /* synthetic */ Either canAdd$$anonfun$1(Metadata.Folder f$1, boolean ok) {
        if (ok) {
            return package$.MODULE$.Right().apply((Object)f$1);
        }
        return package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not writable", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final Object doRun$$anonfun$1$$anonfun$1(better.files.File tempDir$1) {
        return "Files unarchived to " + tempDir$1.path().toString();
    }

    private static final Object doRun$$anonfun$1$$anonfun$2$$anonfun$1() {
        return "All unarchived files added";
    }

    private static final /* synthetic */ Task doAddAll$$anonfun$1(int failCount$1, UserDB.User user$6, Upload.Request request$7, String tempPath$1, List tail$1, boolean ok) {
        int newCount = ok ? failCount$1 : failCount$1 + 1;
        return MODULE$.doAddAll(user$6, request$7, tempPath$1, (List<better.files.File>)tail$1, newCount);
    }

    private static final /* synthetic */ Task doAdd$$anonfun$2(Path newPath$1, boolean exists) {
        return (!exists ? MODULE$.addFolder(newPath$1) : Task$.MODULE$.unit()).map((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            return true;
        });
    }

    private static final /* synthetic */ Task doAdd$$anonfun$3$$anonfun$1(UserDB.User user$8, Path newPath$3, better.files.File file$2, boolean ok) {
        return (ok ? MODULE$.addFile(user$8, newPath$3, file$2) : Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false))).map((Function1 & Serializable)ok2 -> BoxesRunTime.unboxToBoolean((Object)ok2));
    }

    private static final Object removeExisting$$anonfun$1(String existing$1) {
        return "Removing existing file at " + existing$1;
    }

    private static final Object addFolder$$anonfun$1$$anonfun$1(Path newPath$5) {
        return "Adding folder " + newPath$5;
    }

    private static final boolean $anonfun$1(Path newPath$6) {
        return DiskRepositoryAPI$.MODULE$.doCreateFolder(newPath$6);
    }

    private static final Object addFolder$$anonfun$1$$anonfun$2(Path newPath$7) {
        return "Adding folder " + newPath$7 + " failed";
    }

    private static final boolean addFolder$$anonfun$1(Path newPath$4) {
        MODULE$.log().info(() -> UploadArchive$.addFolder$$anonfun$1$$anonfun$1(newPath$4), Line$.MODULE$.apply(154), FullName$.MODULE$.apply("ambience.repository.actions.UploadArchive.addFolder"));
        boolean ret = Try$.MODULE$.apply(() -> UploadArchive$.$anonfun$1(newPath$4)).isSuccess();
        if (!ret) {
            MODULE$.log().info(() -> UploadArchive$.addFolder$$anonfun$1$$anonfun$2(newPath$4), Line$.MODULE$.apply(156), FullName$.MODULE$.apply("ambience.repository.actions.UploadArchive.addFolder"));
        }
        return ret;
    }

    private static final Object addFile$$anonfun$1$$anonfun$1(Path newPath$9) {
        return "Adding file " + newPath$9;
    }

    private static final better.files.File $anonfun$2(Path newPath$10, better.files.File file$4) {
        better.files.File file = File$.MODULE$.apply(DiskRepositoryAPI$.MODULE$.pathToFile(newPath$10).toPath());
        boolean bl = file$4.copyTo$default$2();
        return file$4.copyTo(file, bl, file$4.copyTo$default$3(file, bl));
    }

    private static final Object addFile$$anonfun$1$$anonfun$2(Path newPath$11) {
        return "Adding file " + newPath$11 + " failed";
    }

    private static final boolean addFile$$anonfun$1(Path newPath$8, better.files.File file$3) {
        MODULE$.log().info(() -> UploadArchive$.addFile$$anonfun$1$$anonfun$1(newPath$8), Line$.MODULE$.apply(161), FullName$.MODULE$.apply("ambience.repository.actions.UploadArchive.addFile"));
        boolean ret = Try$.MODULE$.apply(() -> UploadArchive$.$anonfun$2(newPath$8, file$3)).isSuccess();
        if (!ret) {
            MODULE$.log().info(() -> UploadArchive$.addFile$$anonfun$1$$anonfun$2(newPath$8), Line$.MODULE$.apply(163), FullName$.MODULE$.apply("ambience.repository.actions.UploadArchive.addFile"));
        }
        return ret;
    }
}

