/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.internal;

import cats.effect.ExitCase;
import cats.effect.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import java.io.Serializable;
import monix.execution.UncaughtExceptionReporter$;
import monix.execution.atomic.Atomic;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.internal.Platform$;
import monix.tail.Iterant;
import monix.tail.Iterant$;
import monix.tail.Iterant$Concat$;
import monix.tail.Iterant$Last$;
import monix.tail.Iterant$Next$;
import monix.tail.Iterant$NextBatch$;
import monix.tail.Iterant$NextCursor$;
import monix.tail.Iterant$Scope$;
import monix.tail.Iterant$Suspend$;
import monix.tail.batches.Batch;
import monix.tail.batches.Batch$;
import monix.tail.batches.BatchCursor;
import monix.tail.internal.IterantAttempt$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class IterantAttempt {
    public static <F, A> Iterant<F, Either<Throwable, A>> apply(Iterant<F, A> iterant, Sync<F> sync) {
        return IterantAttempt$.MODULE$.apply(iterant, sync);
    }

    private static final class AttemptVisitor<F, A>
    extends Iterant.Visitor<F, A, Iterant<F, Either<Throwable, A>>> {
        private final Sync<F> F;
        private boolean wasErrorHandled;
        private final Function1<Throwable, Either<Throwable, A>> handleError;
        private final Function1<Either<Throwable, Iterant<F, A>>, Iterant<F, Either<Throwable, A>>> continueMapRef;

        public AttemptVisitor(Sync<F> F) {
            this.F = F;
            this.wasErrorHandled = false;
            this.handleError = (Function1 & Serializable)e -> {
                this.wasErrorHandled = true;
                return package$.MODULE$.Left().apply(e);
            };
            this.continueMapRef = (Function1 & Serializable)x$1 -> {
                Iterant iterant;
                Either either = x$1;
                if (either instanceof Left) {
                    Throwable e = (Throwable)((Left)either).value();
                    iterant = Iterant$.MODULE$.now(this.handleError.apply((Object)e));
                } else if (either instanceof Right) {
                    Iterant iter = (Iterant)((Right)either).value();
                    iterant = (Iterant)this.apply(iter);
                } else {
                    throw new MatchError((Object)either);
                }
                return iterant;
            };
        }

        @Override
        public Iterant<F, Either<Throwable, A>> visit(Iterant.Next<F, A> ref) {
            return Iterant$Next$.MODULE$.apply(package$.MODULE$.Right().apply(ref.item()), this.continueWith(ref.rest()));
        }

        @Override
        public Iterant<F, Either<Throwable, A>> visit(Iterant.NextBatch<F, A> ref) {
            Iterant<Object, Object> iterant;
            Iterant.NextBatch<F, A> nextBatch = ref;
            if (nextBatch == null) {
                throw new MatchError(nextBatch);
            }
            Iterant.NextBatch<F, A> nextBatch2 = Iterant$NextBatch$.MODULE$.unapply(nextBatch);
            Batch<A> batch = nextBatch2._1();
            F f = nextBatch2._2();
            Batch<A> batch2 = batch;
            F rest = f;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(batch2, rest);
            Batch batch3 = (Batch)tuple2._1();
            Object rest2 = tuple2._2();
            boolean signalError = true;
            try {
                BatchCursor cursor = batch3.cursor();
                signalError = false;
                iterant = this.handleCursor(Iterant$NextCursor$.MODULE$.apply(cursor, rest2), cursor, rest2);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e) && signalError) {
                    iterant = Iterant$.MODULE$.now(this.handleError.apply((Object)e));
                }
                throw throwable;
            }
            return iterant;
        }

        @Override
        public Iterant<F, Either<Throwable, A>> visit(Iterant.NextCursor<F, A> ref) {
            return this.handleCursor(ref, ref.cursor(), ref.rest());
        }

        @Override
        public Iterant<F, Either<Throwable, A>> visit(Iterant.Suspend<F, A> ref) {
            return Iterant$Suspend$.MODULE$.apply(this.continueWith(ref.rest()));
        }

        @Override
        public Iterant<F, Either<Throwable, A>> visit(Iterant.Concat<F, A> ref) {
            return Iterant$Concat$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.lh(), this.F).map((Function1)this), this.F.defer(() -> this.visit$$anonfun$1(ref)));
        }

        @Override
        public <S> Iterant<F, Either<Throwable, A>> visit(Iterant.Scope<F, S, A> ref) {
            Iterant.Scope<F, S, A> scope = ref;
            if (scope == null) {
                throw new MatchError(scope);
            }
            Iterant.Scope<F, S, A> scope2 = Iterant$Scope$.MODULE$.unapply(scope);
            F f = scope2._1();
            Function1<S, F> function1 = scope2._2();
            Function2<S, ExitCase<Throwable>, F> function2 = scope2._3();
            F acquire = f;
            Function1<S, F> use = function1;
            Function2<S, ExitCase<Throwable>, F> release = function2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(acquire, use, release);
            Object acquire2 = tuple3._1();
            Function1 use2 = (Function1)tuple3._2();
            Function2 release2 = (Function2)tuple3._3();
            return Iterant$Suspend$.MODULE$.apply(this.F.delay(() -> this.visit$$anonfun$2(acquire2, use2, release2)));
        }

        @Override
        public Iterant<F, Either<Throwable, A>> visit(Iterant.Last<F, A> ref) {
            return Iterant$Last$.MODULE$.apply(package$.MODULE$.Right().apply(ref.item()));
        }

        @Override
        public Iterant<F, Either<Throwable, A>> visit(Iterant.Halt<F, A> ref) {
            Iterant.Last last;
            Option<Throwable> option = ref.e();
            if (None$.MODULE$.equals(option)) {
                last = (Iterant.Last)((Object)ref);
            } else if (option instanceof Some) {
                Throwable error = (Throwable)((Some)option).value();
                last = Iterant$Last$.MODULE$.apply(this.handleError.apply((Object)error));
            } else {
                throw new MatchError(option);
            }
            return last;
        }

        @Override
        public Iterant<F, Either<Throwable, A>> fail(Throwable e) {
            return Iterant$.MODULE$.raiseError(e);
        }

        private F continueWith(F rest) {
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(rest, this.F);
            return (F)package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.F), this.F).map(this.continueMapRef);
        }

        private Iterant<F, Either<Throwable, A>> handleCursor(Iterant.NextCursor<F, A> node, BatchCursor<A> cursor, F rest) {
            Iterant iterant;
            try {
                F next;
                Either<Throwable, A>[] array = this.extractFromCursor(cursor);
                Object object = next = cursor.hasNext() ? this.F.delay(() -> this.$anonfun$3(node)) : this.continueWith(rest);
                iterant = array.length != 0 ? Iterant$NextBatch$.MODULE$.apply(Batch$.MODULE$.fromArray(array), next) : Iterant$Suspend$.MODULE$.apply(next);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    iterant = Iterant$.MODULE$.pure(this.handleError.apply((Object)e));
                }
                throw throwable;
            }
            return iterant;
        }

        private Either<Throwable, A>[] extractFromCursor(BatchCursor<A> ref) {
            ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
            for (int size = ref.recommendedBatchSize(); size > 0 && ref.hasNext(); --size) {
                buffer.$plus$eq((Object)package$.MODULE$.Right().apply(ref.next()));
            }
            return (Either[])buffer.toArray(ClassTag$.MODULE$.apply(Either.class));
        }

        private void pushError(Atomic<Throwable> ref, Throwable e) {
            Throwable update;
            Throwable current;
            AttemptVisitor attemptVisitor = this;
            do {
                Throwable throwable;
                Throwable throwable2;
                if ((throwable2 = (current = (Throwable)ref.get())) == null) {
                    throwable = e;
                    continue;
                }
                Throwable e0 = throwable2;
                throwable = update = Platform$.MODULE$.composeErrors(e0, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Throwable[]{e}));
            } while (!ref.compareAndSet((Object)current, (Object)update));
        }

        private final Object visit$$anonfun$1(Iterant.Concat ref$1) {
            return this.wasErrorHandled ? this.F.pure(Iterant$.MODULE$.empty()) : package.all$.MODULE$.toFunctorOps(ref$1.rh(), this.F).map((Function1)this);
        }

        private final void $anonfun$2$$anonfun$2(AtomicAny errors$6, Throwable e$1) {
            this.pushError((Atomic<Throwable>)errors$6, e$1);
        }

        private final Iterant visit$$anonfun$2$$anonfun$1(AtomicAny errors$7) {
            Iterant iterant;
            Throwable err = (Throwable)errors$7.getAndSet(null);
            if (err != null) {
                if (!this.wasErrorHandled) {
                    iterant = Iterant$Last$.MODULE$.apply(this.handleError.apply((Object)err));
                } else {
                    UncaughtExceptionReporter$.MODULE$.default().reportFailure(err);
                    iterant = Iterant$.MODULE$.empty();
                }
            } else {
                iterant = Iterant$.MODULE$.empty();
            }
            return iterant;
        }

        private final Iterant.Concat visit$$anonfun$2(Object acquire$1, Function1 use$1, Function2 release$1) {
            Object initialValue$proxy1 = null;
            AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
            AtomicAny errors = (AtomicAny)builder$proxy1.buildInstance(initialValue$proxy1, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(acquire$1, this.F);
            Iterant.Scope lh = Iterant$Scope$.MODULE$.apply(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.F), (Function1 & Serializable)es -> package.all$.MODULE$.toFlatMapOps(this.F.pure(es), this.F).flatMap((Function1 & Serializable)x$1 -> {
                Object object;
                Either either = x$1;
                if (either instanceof Left) {
                    Throwable e2 = (Throwable)((Left)either).value();
                    this.pushError((Atomic<Throwable>)errors, e2);
                    object = this.F.pure(Iterant$.MODULE$.empty());
                } else if (either instanceof Right) {
                    Object s = ((Right)either).value();
                    try {
                        Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(use$1.apply(s), this.F);
                        object = package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object2, (Function1 & Serializable)e -> {
                            this.pushError((Atomic<Throwable>)errors, (Throwable)e);
                            return Iterant$.MODULE$.empty();
                        }, this.F), this.F).map((Function1)this);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e3 = throwable3 = (Throwable)option.get();
                            this.pushError((Atomic<Throwable>)errors, e3);
                            object = this.F.pure(Iterant$.MODULE$.empty());
                        }
                        throw throwable;
                    }
                } else {
                    throw new MatchError((Object)either);
                }
                return object;
            }), (Function2 & Serializable)(es, exit) -> {
                Object object;
                Either either = es;
                if (either instanceof Left) {
                    object = this.F.unit();
                } else if (either instanceof Right) {
                    Object s = ((Right)either).value();
                    try {
                        object = this.F.handleError(release$1.apply(s, exit), (Function1)(JProcedure1 & Serializable)e -> this.pushError((Atomic<Throwable>)errors, (Throwable)e));
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e2 = throwable3 = (Throwable)option.get();
                            object = this.F.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$2$$anonfun$2(errors, e2)));
                        }
                        throw throwable;
                    }
                } else {
                    throw new MatchError((Object)either);
                }
                return object;
            });
            return Iterant$Concat$.MODULE$.apply(this.F.pure(lh), this.F.delay(() -> this.visit$$anonfun$2$$anonfun$1(errors)));
        }

        private final Iterant $anonfun$3(Iterant.NextCursor node$1) {
            return (Iterant)this.apply(node$1);
        }
    }
}

