/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.internal;

import cats.effect.Sync;
import cats.syntax.package;
import monix.tail.Iterant;
import monix.tail.Iterant$;
import monix.tail.Iterant$Next$;
import monix.tail.Iterant$NextCursor$;
import monix.tail.Iterant$Suspend$;
import monix.tail.batches.BatchCursor;
import monix.tail.batches.BatchCursor$;
import monix.tail.internal.IterantTakeEveryNth$;
import monix.tail.internal.package$;
import monix.tail.internal.package$ConcatExtensions$;
import monix.tail.internal.package$ScopeExtensions$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;

public final class IterantTakeEveryNth {
    public static <F, A> Iterant<F, A> apply(Iterant<F, A> iterant, int n, Sync<F> sync) {
        return IterantTakeEveryNth$.MODULE$.apply(iterant, n, sync);
    }

    private static final class Loop<F, A>
    extends Iterant.Visitor<F, A, Iterant<F, A>> {
        private final int n;
        private final Sync<F> F;
        private int index;

        public Loop(int n, Sync<F> F) {
            this.n = n;
            this.F = F;
            this.index = n;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Next<F, A> ref) {
            Iterant iterant;
            if (this.index == 1) {
                this.index = this.n;
                iterant = Iterant$Next$.MODULE$.apply(ref.item(), package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
            } else {
                --this.index;
                iterant = Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextBatch<F, A> ref) {
            return this.processSeq(this.index, ref.toNextCursor());
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextCursor<F, A> ref) {
            return this.processSeq(this.index, ref);
        }

        @Override
        public Iterant<F, A> visit(Iterant.Suspend<F, A> ref) {
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, A> visit(Iterant.Concat<F, A> ref) {
            Iterant.Concat concat = package$.MODULE$.ConcatExtensions(ref);
            return package$ConcatExtensions$.MODULE$.runMap$extension(concat, this, this.F);
        }

        @Override
        public <S> Iterant<F, A> visit(Iterant.Scope<F, S, A> ref) {
            Iterant.Scope scope = package$.MODULE$.ScopeExtensions(ref);
            return package$ScopeExtensions$.MODULE$.runMap$extension(scope, this, this.F);
        }

        @Override
        public Iterant<F, A> visit(Iterant.Last<F, A> ref) {
            Iterant iterant;
            if (this.index == 1) {
                this.index = this.n;
                iterant = ref;
            } else {
                --this.index;
                iterant = Iterant$.MODULE$.empty();
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Halt<F, A> ref) {
            return ref;
        }

        @Override
        public Iterant<F, A> fail(Throwable e) {
            return Iterant$.MODULE$.raiseError(e);
        }

        private Iterant.NextCursor<F, A> processSeq(int index, Iterant.NextCursor<F, A> ref) {
            Iterant.NextCursor<F, A> nextCursor = ref;
            if (nextCursor == null) {
                throw new MatchError(nextCursor);
            }
            Iterant.NextCursor<F, A> nextCursor2 = Iterant$NextCursor$.MODULE$.unapply(nextCursor);
            BatchCursor<A> batchCursor = nextCursor2._1();
            F f = nextCursor2._2();
            BatchCursor<A> cursor = batchCursor;
            F rest = f;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(cursor, rest);
            BatchCursor cursor2 = (BatchCursor)tuple2._1();
            Object rest2 = tuple2._2();
            ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
            int idx = index;
            for (int toProcess = cursor2.recommendedBatchSize(); toProcess > 0 && cursor2.hasNext(); --toProcess) {
                if (idx == 1) {
                    buffer.$plus$eq(cursor2.next());
                    idx = this.n;
                    continue;
                }
                cursor2.next();
                --idx;
            }
            Object next = cursor2.hasNext() ? this.F.pure(ref) : rest2;
            this.index = idx;
            return Iterant$NextCursor$.MODULE$.apply(BatchCursor$.MODULE$.fromArray(buffer.toArray(ClassTag$.MODULE$.Any())), package.all$.MODULE$.toFunctorOps(next, this.F).map((Function1)this));
        }
    }
}

