/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.internal;

import cats.effect.Sync;
import cats.syntax.package;
import monix.execution.internal.collection.ChunkedArrayStack;
import monix.execution.internal.collection.ChunkedArrayStack$;
import monix.execution.internal.collection.DropHeadOnOverflowQueue;
import monix.execution.internal.collection.DropHeadOnOverflowQueue$;
import monix.tail.Iterant;
import monix.tail.Iterant$;
import monix.tail.Iterant$Next$;
import monix.tail.Iterant$NextCursor$;
import monix.tail.Iterant$Suspend$;
import monix.tail.batches.BatchCursor;
import monix.tail.batches.BatchCursor$;
import monix.tail.internal.IterantTakeLast$;
import monix.tail.internal.package$;
import monix.tail.internal.package$ScopeExtensions$;
import scala.Function1;
import scala.None$;
import scala.Option;

public final class IterantTakeLast {
    public static <F, A> Iterant<F, A> apply(Iterant<F, A> iterant, int n, Sync<F> sync) {
        return IterantTakeLast$.MODULE$.apply(iterant, n, sync);
    }

    private static class Loop<F, A>
    extends Iterant.Visitor<F, A, Iterant<F, A>> {
        private final Sync<F> F;
        private final DropHeadOnOverflowQueue<A> buffer;
        private ChunkedArrayStack<F> stackRef;

        public Loop(int n, Sync<F> F) {
            this.F = F;
            this.buffer = DropHeadOnOverflowQueue$.MODULE$.boxed(n);
        }

        private void stackPush(F item) {
            if (this.stackRef == null) {
                this.stackRef = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
            }
            this.stackRef.push(item);
        }

        private F stackPop() {
            return (F)(this.stackRef != null ? this.stackRef.pop() : null);
        }

        @Override
        public Iterant<F, A> visit(Iterant.Next<F, A> ref) {
            this.buffer.offer(ref.item());
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextBatch<F, A> ref) {
            BatchCursor<A> cursor = ref.batch().cursor();
            while (cursor.hasNext()) {
                this.buffer.offer(cursor.next());
            }
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextCursor<F, A> ref) {
            BatchCursor<A> cursor = ref.cursor();
            while (cursor.hasNext()) {
                this.buffer.offer(cursor.next());
            }
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, A> visit(Iterant.Suspend<F, A> ref) {
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, A> visit(Iterant.Concat<F, A> ref) {
            this.stackPush(ref.rh());
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.lh(), this.F).map((Function1)this));
        }

        @Override
        public <S> Iterant<F, A> visit(Iterant.Scope<F, S, A> ref) {
            Iterant.Scope scope = package$.MODULE$.ScopeExtensions(ref);
            return package$ScopeExtensions$.MODULE$.runMap$extension(scope, this, this.F);
        }

        @Override
        public Iterant<F, A> visit(Iterant.Last<F, A> ref) {
            Iterant iterant;
            F f = this.stackPop();
            if (f == null) {
                this.buffer.offer(ref.item());
                iterant = this.finalCursor();
            } else {
                F some = f;
                iterant = (Iterant)this.apply(Iterant$Next$.MODULE$.apply(ref.item(), some));
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Halt<F, A> ref) {
            Iterant iterant;
            Option<Throwable> option = ref.e();
            if (None$.MODULE$.equals(option)) {
                F f = this.stackPop();
                if (f == null) {
                    iterant = this.finalCursor();
                } else {
                    F some = f;
                    iterant = Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(some, this.F).map((Function1)this));
                }
            } else {
                iterant = ref;
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> fail(Throwable e) {
            return Iterant$.MODULE$.raiseError(e);
        }

        private Iterant<F, A> finalCursor() {
            BatchCursor cursor = BatchCursor$.MODULE$.fromIterator(this.buffer.iterator(true), Integer.MAX_VALUE);
            return Iterant$NextCursor$.MODULE$.apply(cursor, this.F.pure(Iterant$.MODULE$.empty()));
        }
    }
}

