/*
 * Decompiled with CFR 0.152.
 */
package ambience.simplesso.identity;

import ambience.simplesso.IdentityModel;
import ambience.simplesso.IdentityModel$LoginError$AccountDisabled$;
import ambience.simplesso.IdentityModel$LoginError$InvalidPassword$;
import ambience.simplesso.IdentityModel$LoginError$InvalidUser$;
import ambience.simplesso.IdentityModel$LoginError$TooManyFailedLogins$;
import ambience.simplesso.IdentityModel$LoginError$UserLimitReached$;
import ambience.simplesso.identity.IdentityConfig$;
import ambience.simplesso.identity.IdentityDB;
import ambience.simplesso.identity.IdentityDB$PasswordError$;
import ambience.simplesso.identity.SSOLoginHandler;
import ambience.simplesso.identity.UserId;
import ambience.simplesso.identity.UserId$;
import ambience.simplesso.identity.UserPassword;
import ambience.simplesso.twofa.SecretHandler$;
import ambience.simplesso.twofa.TOTPSecret$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Credentials;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.identity.UserManagement$;
import java.io.Serializable;
import monix.eval.Task;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class Login
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Login.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final SSOLoginHandler identityModule;
    private final AuditAPI.ComponentAuditMessage CAM;

    public Login(SSOLoginHandler identityModule) {
        this.identityModule = identityModule;
        this.CAM = new AuditAPI.ComponentAuditMessage(AuditAPI.Component$.MODULE$.apply("Identity", "Login"));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.ComponentAuditMessage CAM() {
        return this.CAM;
    }

    public Task<Either<IdentityModel.LoginError, UserId>> run(IdentityModel.LoginRequest request, Option<Credentials> existingAnonCreds) {
        Predef$.MODULE$.require(existingAnonCreds.isEmpty() || existingAnonCreds.exists((Function1 & Serializable)_$1 -> _$1.isAnon()), () -> Login.run$$anonfun$2(existingAnonCreds));
        return this.identityModule.users().getUserPassword(request.username()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                UserPassword user = (UserPassword)((Right)either).value();
                return this.login(user, request);
            }
            if (either instanceof Left) {
                IdentityDB.PasswordError passwordError = (IdentityDB.PasswordError)((Left)either).value();
                IdentityDB.PasswordError passwordError2 = IdentityDB$PasswordError$.NoSuchUser;
                IdentityDB.PasswordError passwordError3 = passwordError;
                if (!(passwordError2 != null ? !passwordError2.equals(passwordError3) : passwordError3 != null)) {
                    this.log().warn(() -> Login.run$$anonfun$3$$anonfun$1(request), Line$.MODULE$.apply(20), FullName$.MODULE$.apply("ambience.simplesso.identity.Login.run"));
                    return package$.MODULE$.Left().apply((Object)IdentityModel$LoginError$InvalidUser$.MODULE$);
                }
                IdentityDB.PasswordError passwordError4 = IdentityDB$PasswordError$.UserLimitReached;
                IdentityDB.PasswordError passwordError5 = passwordError;
                if (!(passwordError4 != null ? !passwordError4.equals(passwordError5) : passwordError5 != null)) {
                    this.log().warn(() -> Login.run$$anonfun$3$$anonfun$2(request), Line$.MODULE$.apply(23), FullName$.MODULE$.apply("ambience.simplesso.identity.Login.run"));
                    return package$.MODULE$.Left().apply((Object)IdentityModel$LoginError$UserLimitReached$.MODULE$);
                }
            }
            throw new MatchError((Object)either);
        });
    }

    private void audit(AuditAPI.AuditMessage msg) {
        this.identityModule.auditAppender().append(msg);
    }

    private Either<IdentityModel.LoginError, UserId> login(UserPassword user, IdentityModel.LoginRequest request) {
        if (!user.enabled()) {
            this.audit(this.CAM().apply(user.name(), AuditAPI.Failure$.MODULE$.apply(user.name(), "login failed", (Option)Some$.MODULE$.apply((Object)"User disabled"), AuditAPI.Failure$.MODULE$.apply$default$4())));
            return package$.MODULE$.Left().apply((Object)IdentityModel$LoginError$AccountDisabled$.MODULE$);
        }
        if (IdentityConfig$.MODULE$.passwordPolicy().retryAttemptLockoutCount() > 0 && user.failedLogins() >= IdentityConfig$.MODULE$.passwordPolicy().retryAttemptLockoutCount()) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"FailedLogins");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)user.failedLogins()).toString());
            AuditAPI.Action action = AuditAPI.Failure$.MODULE$.apply(user.name(), "login failed", (Option)Some$.MODULE$.apply((Object)"Retry attempt lockout"), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            this.audit(this.CAM().apply(user.name(), action));
            return package$.MODULE$.Left().apply((Object)IdentityModel$LoginError$TooManyFailedLogins$.MODULE$);
        }
        if (!this.isValidPassword(user, request.password())) {
            this.identityModule.users().bumpFailedLogins(user.id());
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"FailedLogins");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)(user.failedLogins() + 1)).toString());
            AuditAPI.Action action = AuditAPI.Failure$.MODULE$.apply(user.name(), "login failed", (Option)Some$.MODULE$.apply((Object)"Incorrect password"), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            this.audit(this.CAM().apply(user.name(), action));
            return package$.MODULE$.Left().apply((Object)IdentityModel$LoginError$InvalidPassword$.MODULE$);
        }
        if (!this.isValidTotp(user, request.totp())) {
            this.identityModule.users().bumpFailedLogins(user.id());
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"FailedLogins");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)(user.failedLogins() + 1)).toString());
            AuditAPI.Action action = AuditAPI.Failure$.MODULE$.apply(user.name(), "login failed", (Option)Some$.MODULE$.apply((Object)"Incorrect 2FA"), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            this.audit(this.CAM().apply(user.name(), action));
            return package$.MODULE$.Left().apply((Object)IdentityModel$LoginError$InvalidPassword$.MODULE$);
        }
        this.identityModule.users().successfulLogin(user.id());
        return package$.MODULE$.Right().apply((Object)UserId$.MODULE$.apply(user.id()));
    }

    private boolean isValidPassword(UserPassword user, String password) {
        if (password.trim().isEmpty()) {
            return false;
        }
        return UserManagement$.MODULE$.validate(user.id().getValue().toHexString(), password, user.password());
    }

    private boolean isValidTotp(UserPassword user, String totpCode) {
        if (user.totp().isEmpty()) {
            return totpCode.trim().isEmpty();
        }
        return SecretHandler$.MODULE$.isValid(TOTPSecret$.MODULE$.apply(user.totp()), totpCode);
    }

    private static final Object run$$anonfun$2(Option existingAnonCreds$1) {
        return existingAnonCreds$1;
    }

    private static final Object run$$anonfun$3$$anonfun$1(IdentityModel.LoginRequest request$2) {
        return "No such user: " + request$2.username();
    }

    private static final Object run$$anonfun$3$$anonfun$2(IdentityModel.LoginRequest request$3) {
        return "User limit reached: " + request$3.username();
    }
}

