/*
 * Decompiled with CFR 0.152.
 */
package ambience.cli;

import ambience.cli.CommandProcessor;
import ambience.module.AmbienceRunMode;
import ambience.module.CodexRunMode;
import ambience.module.ConfigLoader$;
import com.elixirtech.arch.CustomSysConfig;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.SystemConfig;
import com.elixirtech.arch.info.RunMode;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.memory.InMemoryCodexDB;
import com.elixirtech.mongodb.RichMongoCollection;
import com.elixirtech.mongodb.StandardMongoDB;
import com.mongodb.client.model.UpdateOptions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import monix.eval.Task;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class DeployLicence$
implements CommandProcessor,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(DeployLicence$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(DeployLicence$.class.getDeclaredField("runMode$lzy1"));
    private volatile Object log$lzy1;
    private static final String name;
    private static final String help;
    private static final String usage;
    private volatile Object runMode$lzy1;
    public static final DeployLicence$ MODULE$;

    private DeployLicence$() {
    }

    static {
        MODULE$ = new DeployLicence$();
        name = "deploy-licence";
        help = "Deploys a licence file.";
        usage = "deploy-licence <licence-file>";
    }

    @Override
    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeployLicence$.class);
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public String help() {
        return help;
    }

    @Override
    public String usage() {
        return usage;
    }

    public RunMode runMode() {
        Object object = this.runMode$lzy1;
        if (object instanceof RunMode) {
            return (RunMode)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RunMode)this.runMode$lzyINIT1();
    }

    private Object runMode$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.runMode$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RunMode runMode = null;
                    try {
                        runMode = (RunMode)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(RunMode.class));
                        object2 = runMode == null ? LazyVals.NullValue$.MODULE$ : runMode;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.runMode$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return runMode;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public int main(Seq<String> params) {
        RunMode runMode = this.runMode();
        if (runMode instanceof CodexRunMode) {
            return this.mainRep(params);
        }
        if (runMode instanceof AmbienceRunMode) {
            return this.mainAmb(params);
        }
        Predef$.MODULE$.println((Object)("Unknown runMode: " + this.runMode()));
        return -1;
    }

    public int mainAmb(Seq<String> params) {
        Either<String, String> either = this.loadFile(params);
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            Predef$.MODULE$.println((Object)msg);
            return -1;
        }
        if (either instanceof Right) {
            String content = (String)((Right)either).value();
            CustomSysConfig sysConfig = new CustomSysConfig(ConfigLoader$.MODULE$.config());
            StandardMongoDB mongo = new StandardMongoDB((SystemConfig)sysConfig);
            RichMongoCollection cltn = new RichMongoCollection(mongo.database().getCollection("Ambience", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
            Bson setContent = Updates$.MODULE$.set("content", (Object)BsonString$.MODULE$.apply(content));
            Bson setTimestamp = Updates$.MODULE$.currentDate("lastModified");
            Bson update = Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{setContent, setTimestamp}));
            UpdateOptions options = new UpdateOptions().upsert(true);
            Await$.MODULE$.result((Awaitable)cltn.updateOneT(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(this.runMode().licenceFilename())), update, options).runToFuture(Scheduler$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
            this.log().info(DeployLicence$::mainAmb$$anonfun$1, Line$.MODULE$.apply(53), FullName$.MODULE$.apply("ambience.cli.DeployLicence.mainAmb"));
            return 0;
        }
        throw new MatchError(either);
    }

    public int mainRep(Seq<String> params) {
        Scheduler scheduler = Scheduler$.MODULE$.global();
        Either<String, String> either = this.loadFile(params);
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            Predef$.MODULE$.println((Object)msg);
            return -1;
        }
        if (either instanceof Right) {
            String content = (String)((Right)either).value();
            InMemoryCodexDB codexDB = new InMemoryCodexDB();
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(this.runMode().licenceFilename())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"content");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(content)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModified");
            objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonDateTime$.MODULE$.apply(System.currentTimeMillis())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            Document doc = org.mongodb.scala.bson.package$.MODULE$.Document().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            CodexFilter.Eq filter = CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(this.runMode().licenceFilename()));
            Task task = codexDB.getCodexCollection("Ambience").flatMap((Function1 & Serializable)cltn -> cltn.upsertOneT((CodexFilter)filter, doc).map((Function1 & Serializable)result -> result));
            Await$.MODULE$.result((Awaitable)task.runToFuture(scheduler), (Duration)Duration$.MODULE$.Inf());
            this.log().info(DeployLicence$::mainRep$$anonfun$1, Line$.MODULE$.apply(77), FullName$.MODULE$.apply("ambience.cli.DeployLicence.mainRep"));
            return 0;
        }
        throw new MatchError(either);
    }

    public Either<String, String> loadFile(Seq<String> params) {
        Option option = params.headOption();
        if (option instanceof Some) {
            String filename = (String)((Some)option).value();
            return this.validate(com.elixirtech.arch.package$.MODULE$.enrichFile(this.getFile(filename)).text());
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)this.usage());
        }
        throw new MatchError((Object)option);
    }

    public Either<String, String> validate(String content) {
        Config cfg = ConfigFactory.parseString((String)content);
        return (Try$.MODULE$.apply(() -> DeployLicence$.validate$$anonfun$1(cfg)).toOption().contains((Object)this.runMode().productName()) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)"Incorrect product")).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (Try$.MODULE$.apply(() -> DeployLicence$.validate$$anonfun$2$$anonfun$1(cfg)).toOption().contains((Object)BoxesRunTime.boxToInteger((int)MODULE$.runMode().majorVersion())) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)"Incorrect major-version")).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return content;
            });
        });
    }

    public File getFile(String filename) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        if (file.exists() && file.isFile()) {
            return file;
        }
        File binDir = new File("bin");
        if (binDir.exists() && binDir.isDirectory()) {
            return new File(binDir, filename);
        }
        return file;
    }

    private static final Object mainAmb$$anonfun$1() {
        return "Licence Deployed";
    }

    private static final Object mainRep$$anonfun$1() {
        return "Licence Deployed";
    }

    private static final String validate$$anonfun$1(Config cfg$1) {
        return cfg$1.getString("product");
    }

    private static final int validate$$anonfun$2$$anonfun$1(Config cfg$3) {
        return cfg$3.getInt("major-version");
    }
}

