/*
 * Decompiled with CFR 0.152.
 */
package ambience.codex;

import ambience.codex.BulkDownload$;
import ambience.codex.BulkDownload$Intermediate$;
import ambience.codex.BulkDownload$Result$;
import better.files.File;
import better.files.File$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.FileDataBytes$;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.gravity.GravityResponse;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import monix.eval.Task;
import org.bson.BsonValue;
import org.bson.json.JsonWriterSettings;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class BulkDownload {
    public static JsonWriterSettings RelaxedJsonSettings() {
        return BulkDownload$.MODULE$.RelaxedJsonSettings();
    }

    public static Task<Result> apply(Task<CodexCollection> task, String string, CodexFilter codexFilter, String string2, Set<BsonValue> set, String string3) {
        return BulkDownload$.MODULE$.apply(task, string, codexFilter, string2, set, string3);
    }

    public static Intermediate buildZip(List<Document> list, String string, String string2) {
        return BulkDownload$.MODULE$.buildZip(list, string, string2);
    }

    public static String buildZipFilename(String string) {
        return BulkDownload$.MODULE$.buildZipFilename(string);
    }

    public static Option<String> getName(String string, Document document) {
        return BulkDownload$.MODULE$.getName(string, document);
    }

    public static LoggingInterface log() {
        return BulkDownload$.MODULE$.log();
    }

    public static class Builder {
        private final String nameField;
        private final String extension;
        private final File tmpDir;
        private final File zipFile;
        private final File outFolder;

        public Builder(String nameField, String extension) {
            this.nameField = nameField;
            this.extension = extension;
            String string = File$.MODULE$.newTemporaryDirectory$default$1();
            Option option = File$.MODULE$.newTemporaryDirectory$default$2();
            this.tmpDir = File$.MODULE$.newTemporaryDirectory(string, option, File$.MODULE$.newTemporaryDirectory$default$3(string, option));
            boolean bl = this.tmpDir().createChild$default$3();
            this.zipFile = this.tmpDir().createChild("bulk.zip", false, bl, this.tmpDir().createChild$default$4("bulk.zip", false, bl), this.tmpDir().createChild$default$5("bulk.zip", false, bl));
            boolean bl2 = this.tmpDir().createChild$default$3();
            this.outFolder = this.tmpDir().createChild("root", true, bl2, this.tmpDir().createChild$default$4("root", true, bl2), this.tmpDir().createChild$default$5("root", true, bl2));
        }

        public File tmpDir() {
            return this.tmpDir;
        }

        public File zipFile() {
            return this.zipFile;
        }

        public File outFolder() {
            return this.outFolder;
        }

        public Intermediate run(List<Document> documents) {
            List fullNames = documents.flatMap((Function1 & Serializable)doc -> this.exportDoc((Document)doc));
            int n = this.outFolder().zipTo$default$2();
            this.outFolder().zipTo(this.zipFile(), n, this.outFolder().zipTo$default$3(this.zipFile(), n));
            return BulkDownload$Intermediate$.MODULE$.apply((List<String>)fullNames, (DataBytes)FileDataBytes$.MODULE$.apply(this.zipFile().toJava()));
        }

        public Option<String> exportDoc(Document doc) {
            return BulkDownload$.MODULE$.getName(this.nameField, doc).map((Function1 & Serializable)name -> {
                String fullName = name + "." + this.extension;
                File file = this.outFolder().$div(this.safe(fullName));
                File file2 = file.createFileIfNotExists(true, file.createFileIfNotExists$default$2(true), file.createFileIfNotExists$default$3(true));
                file2.appendText(doc.toJson(BulkDownload$.MODULE$.RelaxedJsonSettings()), StandardCharsets.UTF_8);
                return fullName;
            });
        }

        public String safe(String fullName) {
            return fullName.replace("\\", "_").replace("/", "_").replace(":", "_");
        }

        public void dispose() {
            BulkDownload$.MODULE$.log().info(this::dispose$$anonfun$1, Line$.MODULE$.apply(80), FullName$.MODULE$.apply("ambience.codex.BulkDownload.Builder.dispose"));
            this.tmpDir().delete(this.tmpDir().delete$default$1(), this.tmpDir().delete$default$2());
        }

        private final Object dispose$$anonfun$1() {
            return "Deleting temporary directory " + this.tmpDir().path();
        }
    }

    public static final class Intermediate
    implements Product,
    Serializable {
        private final List names;
        private final DataBytes bytes;

        public static Intermediate apply(List<String> list, DataBytes dataBytes) {
            return BulkDownload$Intermediate$.MODULE$.apply(list, dataBytes);
        }

        public static Intermediate fromProduct(Product product) {
            return BulkDownload$Intermediate$.MODULE$.fromProduct(product);
        }

        public static Intermediate unapply(Intermediate intermediate) {
            return BulkDownload$Intermediate$.MODULE$.unapply(intermediate);
        }

        public Intermediate(List<String> names, DataBytes bytes) {
            this.names = names;
            this.bytes = bytes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Intermediate)) return false;
            Intermediate intermediate = (Intermediate)object;
            List<String> list = this.names();
            List<String> list2 = intermediate.names();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            DataBytes dataBytes = this.bytes();
            DataBytes dataBytes2 = intermediate.bytes();
            if (dataBytes == null) {
                if (dataBytes2 == null) return true;
                return false;
            } else {
                if (!dataBytes.equals(dataBytes2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Intermediate;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Intermediate";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "names";
            }
            if (1 == n2) {
                return "bytes";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<String> names() {
            return this.names;
        }

        public DataBytes bytes() {
            return this.bytes;
        }

        public Intermediate copy(List<String> names, DataBytes bytes) {
            return new Intermediate(names, bytes);
        }

        public List<String> copy$default$1() {
            return this.names();
        }

        public DataBytes copy$default$2() {
            return this.bytes();
        }

        public List<String> _1() {
            return this.names();
        }

        public DataBytes _2() {
            return this.bytes();
        }
    }

    public static final class Result
    implements Product,
    Serializable {
        private final AuditAPI.Action action;
        private final GravityResponse response;

        public static Result apply(AuditAPI.Action action, GravityResponse gravityResponse) {
            return BulkDownload$Result$.MODULE$.apply(action, gravityResponse);
        }

        public static Result fromProduct(Product product) {
            return BulkDownload$Result$.MODULE$.fromProduct(product);
        }

        public static Result unapply(Result result) {
            return BulkDownload$Result$.MODULE$.unapply(result);
        }

        public Result(AuditAPI.Action action, GravityResponse response) {
            this.action = action;
            this.response = response;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            Result result = (Result)object;
            AuditAPI.Action action = this.action();
            AuditAPI.Action action2 = result.action();
            if (action == null) {
                if (action2 != null) {
                    return false;
                }
            } else if (!action.equals(action2)) return false;
            GravityResponse gravityResponse = this.response();
            GravityResponse gravityResponse2 = result.response();
            if (gravityResponse == null) {
                if (gravityResponse2 == null) return true;
                return false;
            } else {
                if (!gravityResponse.equals(gravityResponse2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "action";
            }
            if (1 == n2) {
                return "response";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AuditAPI.Action action() {
            return this.action;
        }

        public GravityResponse response() {
            return this.response;
        }

        public Result copy(AuditAPI.Action action, GravityResponse response) {
            return new Result(action, response);
        }

        public AuditAPI.Action copy$default$1() {
            return this.action();
        }

        public GravityResponse copy$default$2() {
            return this.response();
        }

        public AuditAPI.Action _1() {
            return this.action();
        }

        public GravityResponse _2() {
            return this.response();
        }
    }
}

