/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.framework.SafeUploadHandler;
import ambience.framework.SafeUploadHandler$ConflictInfo$;
import ambience.framework.SafeUploadHandler$ExtractedInfo$;
import ambience.framework.SafeUploadHandler$IdNameOwner$;
import ambience.framework.SafeUploadHandler$Request$;
import ambience.framework.SafeUploadHandler$Result$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.codex.CodexFindOptions$;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import io.circe.Json;
import io.circe.Json$;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class SafeUploadHandler$
implements Serializable {
    private static final CodexFindOptions KeepIdNameAndOwner;
    public static final SafeUploadHandler$ExtractedInfo$ ExtractedInfo;
    public static final SafeUploadHandler$Request$ Request;
    public static final SafeUploadHandler$ConflictInfo$ ConflictInfo;
    public static final SafeUploadHandler$IdNameOwner$ IdNameOwner;
    public static final SafeUploadHandler$Result$ Result;
    public static final SafeUploadHandler$ MODULE$;

    private SafeUploadHandler$() {
    }

    static {
        MODULE$ = new SafeUploadHandler$();
        KeepIdNameAndOwner = CodexFindOptions$.MODULE$.projections((CodexFindOptions.Projection)CodexFindOptions.Retain$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "name", "owner"})));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SafeUploadHandler$.class);
    }

    public CodexFindOptions KeepIdNameAndOwner() {
        return KeepIdNameAndOwner;
    }

    public List<byte[]> unzip(byte[] bytes) {
        return this.buildZipEntries(new ZipInputStream(new ByteArrayInputStream(bytes)));
    }

    public List<byte[]> buildZipEntries(ZipInputStream zip) {
        Option option;
        while ((option = Option$.MODULE$.apply((Object)zip.getNextEntry())) instanceof Some) {
            ZipEntry zipEntry = (ZipEntry)((Some)option).value();
            ZipEntry entry = zipEntry;
            if (entry.isDirectory()) continue;
            ZipEntry entry2 = zipEntry;
            byte[] byArray = com.elixirtech.arch.package$.MODULE$.enrichInputStream((InputStream)zip).contents();
            return this.buildZipEntries(zip).$colon$colon((Object)byArray);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Nil();
        }
        throw new MatchError((Object)option);
    }

    public GravityResponse buildResponse(SafeUploadHandler.Result result) {
        LogMessage logMessage = result.msg();
        if (LogMessage.None$.MODULE$.equals(logMessage)) {
            return GravityResponse$.MODULE$.text("Upload completed");
        }
        if (logMessage instanceof LogMessage.Info) {
            LogMessage.Info msg = (LogMessage.Info)logMessage;
            return GravityResponse$.MODULE$.text(msg.msg());
        }
        return Gravity$.MODULE$.BadRequestResponse(result.msg().msg());
    }

    public GravityResponse buildZipResponse(List<SafeUploadHandler.Result> result2) {
        return GravityResponse$.MODULE$.json(Json$.MODULE$.fromValues((Iterable)result2.map((Function1 & Serializable)result -> MODULE$.buildResultJson((SafeUploadHandler.Result)result))));
    }

    public Json buildResultJson(SafeUploadHandler.Result result) {
        LogMessage logMessage = result.msg();
        String msg = LogMessage.None$.MODULE$.equals(logMessage) ? "Upload completed" : result.msg().msg();
        LogMessage logMessage2 = result.msg();
        boolean error = LogMessage.None$.MODULE$.equals(logMessage2) ? false : !(logMessage2 instanceof LogMessage.Info);
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"file");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(result.name()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"msg");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(msg));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromBoolean(error));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Task<BoxedUnit> audit(AuditAPI.Component component, SafeUploadHandler.Request request, SafeUploadHandler.Result result) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            SafeUploadHandler$.audit$$anonfun$1(result, request, component);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isSuccess(LogMessage msg) {
        LogMessage logMessage = msg;
        if (LogMessage.None$.MODULE$.equals(logMessage)) {
            return true;
        }
        return logMessage instanceof LogMessage.Info;
    }

    private static final void audit$$anonfun$1(SafeUploadHandler.Result result$2, SafeUploadHandler.Request request$26, AuditAPI.Component component$1) {
        String string;
        Option<BsonValue> option = result$2.optInsertedId();
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                string = bs.getValue();
            } else if (bsonValue instanceof BsonObjectId) {
                BsonObjectId bs = (BsonObjectId)bsonValue;
                string = bs.getValue().toHexString();
            } else {
                BsonValue bs = bsonValue;
                string = String.valueOf(bs);
            }
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError(option);
        }
        String obj = string;
        AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(MODULE$.isSuccess(result$2.msg()), obj, "Uploaded", (Option)Some$.MODULE$.apply((Object)request$26.name()));
        AuditAPI.AuditMessage msg = AuditAPI.AuditMessage$.MODULE$.apply(request$26.user().name(), component$1, action);
        ((AuditAPI.AuditAppender)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(AuditAPI.AuditAppender.class))).append(msg);
    }
}

