/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.framework.SafeUploadHandler$;
import ambience.framework.SafeUploadHandler$ConflictInfo$;
import ambience.framework.SafeUploadHandler$ExtractedInfo$;
import ambience.framework.SafeUploadHandler$IdNameOwner$;
import ambience.framework.SafeUploadHandler$Request$;
import ambience.framework.SafeUploadHandler$Result$;
import ambience.module.UserDB;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelperT;
import com.elixirtech.arch.LoggingInterfaceT;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import java.util.UUID;
import java.util.zip.ZipInputStream;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable$;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class SafeUploadHandler
implements LoggingHelperT {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SafeUploadHandler.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;

    public static CodexFindOptions KeepIdNameAndOwner() {
        return SafeUploadHandler$.MODULE$.KeepIdNameAndOwner();
    }

    public static GravityResponse buildResponse(Result result) {
        return SafeUploadHandler$.MODULE$.buildResponse(result);
    }

    public static Json buildResultJson(Result result) {
        return SafeUploadHandler$.MODULE$.buildResultJson(result);
    }

    public static List<byte[]> buildZipEntries(ZipInputStream zipInputStream) {
        return SafeUploadHandler$.MODULE$.buildZipEntries(zipInputStream);
    }

    public static GravityResponse buildZipResponse(List<Result> list) {
        return SafeUploadHandler$.MODULE$.buildZipResponse(list);
    }

    public static boolean isSuccess(LogMessage logMessage) {
        return SafeUploadHandler$.MODULE$.isSuccess(logMessage);
    }

    public static List<byte[]> unzip(byte[] byArray) {
        return SafeUploadHandler$.MODULE$.unzip(byArray);
    }

    public LoggingInterfaceT log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterfaceT) {
            return (LoggingInterfaceT)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterfaceT)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterfaceT loggingInterfaceT = null;
                    try {
                        loggingInterfaceT = LoggingHelperT.log$((LoggingHelperT)this);
                        object2 = loggingInterfaceT == null ? LazyVals.NullValue$.MODULE$ : loggingInterfaceT;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterfaceT;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public abstract Task<CodexCollection> cltnT();

    public abstract Either<Task<Result>, ExtractedInfo> isValidContent(Json var1);

    public Function1<GravityRequest, Task<GravityResponse>> postUpload(UserDB.User user) {
        return (Function1 & Serializable)request -> (Task)request.formParameter("name").map((Function1 & Serializable)name -> {
            Object object = request.formParameter("overwrite").getOrElse(SafeUploadHandler::$anonfun$1);
            String string = "true";
            boolean overwrite = !(object != null ? !object.equals(string) : string != null);
            return this.log().infoT(() -> SafeUploadHandler.postUpload$$anonfun$1$$anonfun$1$$anonfun$1(user, name, overwrite), Line$.MODULE$.apply(115), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.postUpload")).flatMap((Function1 & Serializable)_$3 -> {
                Gravity.FormItem formItem;
                Option option = request.formItems().get("file");
                if (option instanceof Some && (formItem = (Gravity.FormItem)((Some)option).value()) instanceof Gravity.FileUploadItem) {
                    Gravity.FileUploadItem file = (Gravity.FileUploadItem)formItem;
                    return this.handleUpload(user, file.data().bytes(), (Option<String>)Some$.MODULE$.apply(name), overwrite).map((Function1 & Serializable)result -> SafeUploadHandler$.MODULE$.buildResponse((Result)result));
                }
                return Gravity$.MODULE$.BadRequestResponseT("Can't read file");
            });
        }).getOrElse(SafeUploadHandler::postUpload$$anonfun$1$$anonfun$2);
    }

    public Function1<GravityRequest, Task<GravityResponse>> postUploadZip(UserDB.User user) {
        return (Function1 & Serializable)request -> {
            Object object = request.formParameter("overwrite").getOrElse(SafeUploadHandler::$anonfun$2);
            String string = "true";
            boolean overwrite = !(object != null ? !object.equals(string) : string != null);
            return this.log().infoT(() -> SafeUploadHandler.postUploadZip$$anonfun$1$$anonfun$1(user, overwrite), Line$.MODULE$.apply(128), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.postUploadZip")).flatMap((Function1 & Serializable)_$4 -> {
                Gravity.FormItem formItem;
                Option option = request.formItems().get("file");
                if (option instanceof Some && (formItem = (Gravity.FormItem)((Some)option).value()) instanceof Gravity.FileUploadItem) {
                    Gravity.FileUploadItem file = (Gravity.FileUploadItem)formItem;
                    return this.handleUploadZip(user, file.data().bytes(), overwrite).map((Function1 & Serializable)result -> SafeUploadHandler$.MODULE$.buildZipResponse((List<Result>)result));
                }
                return Gravity$.MODULE$.BadRequestResponseT("Can't read file");
            });
        };
    }

    public Task<Result> handleUpload(UserDB.User user, byte[] bytes, Option<String> optName, boolean overwrite) {
        Either either = package$.MODULE$.parse(new String(bytes, DataBytes$.MODULE$.UTF_8()));
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            return this.parsingFailed(err);
        }
        if (either instanceof Right) {
            Json incomingJson = (Json)((Right)either).value();
            return this.handleUpload(user, incomingJson, optName, overwrite);
        }
        throw new MatchError((Object)either);
    }

    public Task<Result> handleUpload(UserDB.User user, Json json, Option<String> optName, boolean overwrite) {
        Either<Task<Result>, ExtractedInfo> either = this.isValidContent(json);
        if (either instanceof Right) {
            ExtractedInfo extractedInfo;
            ExtractedInfo incoming = extractedInfo = (ExtractedInfo)((Right)either).value();
            if (optName.isEmpty() && incoming.name().isEmpty()) {
                return Task$.MODULE$.now((Object)SafeUploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Empty name not allowed"), SafeUploadHandler$Result$.MODULE$.$lessinit$greater$default$3()));
            }
            ExtractedInfo incoming2 = extractedInfo;
            return this.handleRequest(SafeUploadHandler$Request$.MODULE$.apply(user, json, incoming2._id(), (String)optName.getOrElse(() -> SafeUploadHandler.handleUpload$$anonfun$1(incoming2)), overwrite));
        }
        if (either instanceof Left) {
            Task result = (Task)((Left)either).value();
            return result;
        }
        throw new MatchError(either);
    }

    public Task<List<Result>> handleUploadZip(UserDB.User user, byte[] bytes2, boolean overwrite) {
        return Observable$.MODULE$.fromIterable(SafeUploadHandler$.MODULE$.unzip(bytes2)).flatMap((Function1 & Serializable)bytes -> Observable$.MODULE$.fromTask(this.handleUpload(user, (byte[])bytes, (Option<String>)None$.MODULE$, overwrite))).toListL();
    }

    public Task<Result> parsingFailed(ParsingFailure err) {
        return this.log().errorT(() -> SafeUploadHandler.parsingFailed$$anonfun$1(err), Line$.MODULE$.apply(161), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.parsingFailed")).map((Function1 & Serializable)_$5 -> SafeUploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Parsing json failed"), SafeUploadHandler$Result$.MODULE$.$lessinit$greater$default$3()));
    }

    public Task<Result> decodingFailed(String fileType, DecodingFailure err) {
        return this.log().errorT(() -> SafeUploadHandler.decodingFailed$$anonfun$1(fileType, err), Line$.MODULE$.apply(165), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.decodingFailed")).map((Function1 & Serializable)_$6 -> SafeUploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Decoding " + fileType + " failed"), SafeUploadHandler$Result$.MODULE$.$lessinit$greater$default$3()));
    }

    public Task<Result> handleRequest(Request request) {
        return this.buildConflictInfo(request).flatMap((Function1 & Serializable)conflictInfo -> this.conflictResolution((ConflictInfo)conflictInfo).flatMap((Function1 & Serializable)result -> this.audit(request, (Result)result).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return result;
        })));
    }

    public Task<BoxedUnit> audit(Request request, Result result) {
        return Task$.MODULE$.unit();
    }

    public Task<ConflictInfo> buildConflictInfo(Request request) {
        CodexFilter.Or filter = CodexFilter.Or$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", request.id()), CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(request.name()))}));
        return this.cltnT().flatMap((Function1 & Serializable)_$7 -> _$7.findO((CodexFilter)filter, SafeUploadHandler$.MODULE$.KeepIdNameAndOwner()).toListL()).map((Function1 & Serializable)docs -> {
            List conflicts = docs.map((Function1 & Serializable)doc -> {
                Option name = doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).orElse(() -> SafeUploadHandler.$anonfun$4(doc)).map((Function1 & Serializable)_$8 -> _$8.getValue());
                String owner = (String)doc.get("owner", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$9 -> _$9.getValue()).getOrElse(SafeUploadHandler::$anonfun$7);
                return SafeUploadHandler$IdNameOwner$.MODULE$.apply(doc.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)), (Option<String>)name, owner);
            });
            return SafeUploadHandler$ConflictInfo$.MODULE$.apply(request, (List<IdNameOwner>)conflicts);
        });
    }

    public Task<Result> conflictResolution(ConflictInfo conflictInfo) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(conflictInfo.optMatchingId(), conflictInfo.optMatchingName());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return this.newAddition(conflictInfo.request());
            }
            if (option instanceof Some) {
                IdNameOwner idNameOwner;
                IdNameOwner a = idNameOwner = (IdNameOwner)((Some)option).value();
                if (None$.MODULE$.equals(option2)) {
                    if (a.name().isEmpty()) {
                        return this.replaceDeleted(conflictInfo.request());
                    }
                    return this.idExistsWithDifferentName(conflictInfo.request());
                }
                IdNameOwner a2 = idNameOwner;
                if (option2 instanceof Some) {
                    IdNameOwner idNameOwner2;
                    IdNameOwner b = idNameOwner2 = (IdNameOwner)((Some)option2).value();
                    IdNameOwner idNameOwner3 = a2;
                    IdNameOwner idNameOwner4 = b;
                    if (!(idNameOwner3 != null ? !((Object)idNameOwner3).equals(idNameOwner4) : idNameOwner4 != null)) {
                        return this.replace(b, conflictInfo.request());
                    }
                    IdNameOwner b2 = idNameOwner2;
                    return this.idAndNameExistIndependently(b2, conflictInfo.request());
                }
            }
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                IdNameOwner b = (IdNameOwner)((Some)option2).value();
                return this.nameExistsWithDifferentId(b, conflictInfo.request());
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public Task<Result> newAddition(Request request) {
        return this.log().infoT(SafeUploadHandler::newAddition$$anonfun$1, Line$.MODULE$.apply(203), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.newAddition")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.insert(request.newDocument()).map((Function1 & Serializable)id -> SafeUploadHandler$Result$.MODULE$.apply(request.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload added successfully"), (Option<BsonValue>)id)).map((Function1 & Serializable)result -> result);
        });
    }

    public Task<Result> replace(IdNameOwner nameMatch, Request request) {
        return this.checkConstraints(nameMatch, request, (Function0<Task<Result>>)((Function0 & Serializable)() -> this.replace$$anonfun$1(request)));
    }

    public Task<Result> replaceDeleted(Request request) {
        CodexFilter.Eq filter = CodexFilter.Eq$.MODULE$.apply("_id", request.id());
        return this.log().infoT(SafeUploadHandler::replaceDeleted$$anonfun$1, Line$.MODULE$.apply(222), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.replaceDeleted")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.replaceOneT((CodexFilter)filter, this.interceptStore(request.newDocument())).map((Function1 & Serializable)x$1 -> {
                CodexDB.UpdateResult updateResult = x$1;
                return SafeUploadHandler$Result$.MODULE$.apply(request.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload added successfully"), (Option<BsonValue>)Some$.MODULE$.apply((Object)request.id()));
            }));
        });
    }

    public Document interceptStore(Document doc) {
        return doc;
    }

    public Task<Result> idAndNameExistIndependently(IdNameOwner nameMatch, Request request) {
        return this.checkConstraints(nameMatch, request, (Function0<Task<Result>>)((Function0 & Serializable)() -> this.idAndNameExistIndependently$$anonfun$1(request)));
    }

    public Task<Result> idExistsWithDifferentName(Request request) {
        BsonValue newId = this.generateNewId();
        return this.log().infoT(() -> SafeUploadHandler.idExistsWithDifferentName$$anonfun$1(newId), Line$.MODULE$.apply(248), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.idExistsWithDifferentName")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)newId), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return this.insert((Document)request.newDocument().updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)id -> SafeUploadHandler$Result$.MODULE$.apply(request.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload added with new id"), (Option<BsonValue>)id));
        });
    }

    public Task<Result> nameExistsWithDifferentId(IdNameOwner nameMatch, Request request) {
        return this.checkConstraints(nameMatch, request, (Function0<Task<Result>>)((Function0 & Serializable)() -> this.nameExistsWithDifferentId$$anonfun$1(request)));
    }

    public Task<Result> checkConstraints(IdNameOwner nameMatch, Request request, Function0<Task<Result>> fn) {
        boolean canOverwrite = request.overwrite();
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)canOverwrite), (Object)BoxesRunTime.boxToBoolean((boolean)this.isOwner(nameMatch, request.user().id())));
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            boolean bl2 = tuple2._2$mcZ$sp();
            if (!bl && bl2) {
                return Task$.MODULE$.now((Object)SafeUploadHandler$Result$.MODULE$.apply(request.name(), (LogMessage)LogMessage.Error$.MODULE$.apply("Name already used (tick Overwrite to replace)"), SafeUploadHandler$Result$.MODULE$.$lessinit$greater$default$3()));
            }
            if (!bl2) {
                return Task$.MODULE$.now((Object)SafeUploadHandler$Result$.MODULE$.apply(request.name(), (LogMessage)LogMessage.Error$.MODULE$.apply("Name owned by someone else"), SafeUploadHandler$Result$.MODULE$.$lessinit$greater$default$3()));
            }
            if (bl && bl2) {
                return (Task)fn.apply();
            }
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOwner(IdNameOwner nameMatch, String userId) {
        if (nameMatch.owner().isEmpty()) return true;
        String string = nameMatch.owner();
        String string2 = userId;
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public Task<Option<BsonValue>> insert(Document doc) {
        return this.cltnT().flatMap((Function1 & Serializable)_$10 -> _$10.insertOneT(this.interceptStore(doc)).map((Function1 & Serializable)ret -> ret.insertedId()));
    }

    public Task<BoxedUnit> deleteName(String name) {
        return this.cltnT().flatMap((Function1 & Serializable)_$11 -> _$11.deleteOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name))).map((Function1)(JProcedure1 & Serializable)_$12 -> {}));
    }

    public BsonValue generateNewId() {
        return BsonString$.MODULE$.apply(UUID.randomUUID().toString());
    }

    private static final String $anonfun$1() {
        return "false";
    }

    private static final Object postUpload$$anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$3, String name$1, boolean overwrite$1) {
        return "upload by " + user$3.name() + " parameters: name=" + name$1 + ", overwrite=" + overwrite$1;
    }

    private static final Task postUpload$$anonfun$1$$anonfun$2() {
        return Gravity$.MODULE$.BadRequestResponseT("Missing form item 'name'");
    }

    private static final String $anonfun$2() {
        return "false";
    }

    private static final Object postUploadZip$$anonfun$1$$anonfun$1(UserDB.User user$6, boolean overwrite$3) {
        return "upload-zip by " + user$6.name() + " parameters: overwrite=" + overwrite$3;
    }

    private static final String handleUpload$$anonfun$1(ExtractedInfo incoming$1) {
        return incoming$1.name();
    }

    private static final Object parsingFailed$$anonfun$1(ParsingFailure err$1) {
        return "Cannot parse uploaded file as json: " + err$1;
    }

    private static final Object decodingFailed$$anonfun$1(String fileType$1, DecodingFailure err$2) {
        return "Cannot decode json as " + fileType$1 + ": " + err$2;
    }

    private static final Option $anonfun$4(Document doc$1) {
        return doc$1.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class));
    }

    private static final String $anonfun$7() {
        return "";
    }

    private static final Object newAddition$$anonfun$1() {
        return "action = newAddition";
    }

    private static final Object replace$$anonfun$1$$anonfun$1() {
        return "action = replace";
    }

    private final Task replace$$anonfun$1(Request request$9) {
        CodexFilter.Eq filter = CodexFilter.Eq$.MODULE$.apply("_id", request$9.id());
        return this.log().infoT(SafeUploadHandler::replace$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(212), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.replace")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.replaceOneT((CodexFilter)filter, this.interceptStore(request$9.newDocument())).map((Function1 & Serializable)x$1 -> {
                CodexDB.UpdateResult updateResult = x$1;
                return SafeUploadHandler$Result$.MODULE$.apply(request$9.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload replaced successfully"), (Option<BsonValue>)Some$.MODULE$.apply((Object)request$9.id()));
            }));
        });
    }

    private static final Object replaceDeleted$$anonfun$1() {
        return "action = replaceDeleted";
    }

    private static final Object idAndNameExistIndependently$$anonfun$1$$anonfun$1(BsonValue newId$1) {
        return "action = idAndNameExistIndependently changing to id " + newId$1;
    }

    private final Task idAndNameExistIndependently$$anonfun$1(Request request$16) {
        BsonValue newId = this.generateNewId();
        return this.log().infoT(() -> SafeUploadHandler.idAndNameExistIndependently$$anonfun$1$$anonfun$1(newId), Line$.MODULE$.apply(237), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.idAndNameExistIndependently")).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.deleteName(request$16.name()).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)newId), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                return this.insert((Document)request$16.newDocument().updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)id -> SafeUploadHandler$Result$.MODULE$.apply(request$16.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload replaced with new id"), (Option<BsonValue>)id));
            });
        });
    }

    private static final Object idExistsWithDifferentName$$anonfun$1(BsonValue newId$4) {
        return "action = idExistsWithDifferentName changing to id " + newId$4;
    }

    private static final Object nameExistsWithDifferentId$$anonfun$1$$anonfun$1() {
        return "action = nameExistsWithDifferentId";
    }

    private final Task nameExistsWithDifferentId$$anonfun$1(Request request$22) {
        return this.log().infoT(SafeUploadHandler::nameExistsWithDifferentId$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(257), FullName$.MODULE$.apply("ambience.framework.SafeUploadHandler.nameExistsWithDifferentId")).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.deleteName(request$22.name()).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.insert(request$22.newDocument()).map((Function1 & Serializable)id -> SafeUploadHandler$Result$.MODULE$.apply(request$22.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload replaced successfully"), (Option<BsonValue>)id));
            });
        });
    }

    public static final class ConflictInfo
    implements Product,
    Serializable {
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ConflictInfo.class.getDeclaredField("optMatchingName$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConflictInfo.class.getDeclaredField("optMatchingId$lzy1"));
        private final Request request;
        private final List conflicts;
        private volatile Object optMatchingId$lzy1;
        private volatile Object optMatchingName$lzy1;

        public static ConflictInfo apply(Request request, List<IdNameOwner> list) {
            return SafeUploadHandler$ConflictInfo$.MODULE$.apply(request, list);
        }

        public static ConflictInfo fromProduct(Product product) {
            return SafeUploadHandler$ConflictInfo$.MODULE$.fromProduct(product);
        }

        public static ConflictInfo unapply(ConflictInfo conflictInfo) {
            return SafeUploadHandler$ConflictInfo$.MODULE$.unapply(conflictInfo);
        }

        public ConflictInfo(Request request, List<IdNameOwner> conflicts) {
            this.request = request;
            this.conflicts = conflicts;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConflictInfo)) return false;
            ConflictInfo conflictInfo = (ConflictInfo)object;
            Request request = this.request();
            Request request2 = conflictInfo.request();
            if (request == null) {
                if (request2 != null) {
                    return false;
                }
            } else if (!((Object)request).equals(request2)) return false;
            List<IdNameOwner> list = this.conflicts();
            List<IdNameOwner> list2 = conflictInfo.conflicts();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ConflictInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ConflictInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "request";
            }
            if (1 == n2) {
                return "conflicts";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Request request() {
            return this.request;
        }

        public List<IdNameOwner> conflicts() {
            return this.conflicts;
        }

        public Option<IdNameOwner> optMatchingId() {
            Object object = this.optMatchingId$lzy1;
            if (object instanceof Option) {
                return (Option)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Option)this.optMatchingId$lzyINIT1();
        }

        private Object optMatchingId$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.optMatchingId$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Option option = null;
                        try {
                            option = this.conflicts().find((Function1 & Serializable)_$1 -> {
                                BsonValue bsonValue = _$1.id();
                                BsonValue bsonValue2 = this.request().id();
                                return !(bsonValue != null ? !bsonValue.equals(bsonValue2) : bsonValue2 != null);
                            });
                            object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.optMatchingId$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return option;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Option<IdNameOwner> optMatchingName() {
            Object object = this.optMatchingName$lzy1;
            if (object instanceof Option) {
                return (Option)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Option)this.optMatchingName$lzyINIT1();
        }

        private Object optMatchingName$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.optMatchingName$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Option option = null;
                        try {
                            option = this.conflicts().find((Function1 & Serializable)_$2 -> _$2.name().contains((Object)this.request().name()));
                            object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.optMatchingName$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return option;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public ConflictInfo copy(Request request, List<IdNameOwner> conflicts) {
            return new ConflictInfo(request, conflicts);
        }

        public Request copy$default$1() {
            return this.request();
        }

        public List<IdNameOwner> copy$default$2() {
            return this.conflicts();
        }

        public Request _1() {
            return this.request();
        }

        public List<IdNameOwner> _2() {
            return this.conflicts();
        }
    }

    public static final class ExtractedInfo
    implements Product,
    Serializable {
        private final BsonValue _id;
        private final String name;

        public static ExtractedInfo apply(BsonValue bsonValue, String string) {
            return SafeUploadHandler$ExtractedInfo$.MODULE$.apply(bsonValue, string);
        }

        public static ExtractedInfo fromProduct(Product product) {
            return SafeUploadHandler$ExtractedInfo$.MODULE$.fromProduct(product);
        }

        public static ExtractedInfo unapply(ExtractedInfo extractedInfo) {
            return SafeUploadHandler$ExtractedInfo$.MODULE$.unapply(extractedInfo);
        }

        public ExtractedInfo(BsonValue _id, String name) {
            this._id = _id;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExtractedInfo)) return false;
            ExtractedInfo extractedInfo = (ExtractedInfo)object;
            BsonValue bsonValue = this._id();
            BsonValue bsonValue2 = extractedInfo._id();
            if (bsonValue == null) {
                if (bsonValue2 != null) {
                    return false;
                }
            } else if (!bsonValue.equals(bsonValue2)) return false;
            String string = this.name();
            String string2 = extractedInfo.name();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExtractedInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ExtractedInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "_id";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BsonValue _id() {
            return this._id;
        }

        public String name() {
            return this.name;
        }

        public ExtractedInfo copy(BsonValue _id, String name) {
            return new ExtractedInfo(_id, name);
        }

        public BsonValue copy$default$1() {
            return this._id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public BsonValue _1() {
            return this._id();
        }

        public String _2() {
            return this.name();
        }
    }

    public static final class IdNameOwner
    implements Product,
    Serializable {
        private final BsonValue id;
        private final Option name;
        private final String owner;

        public static IdNameOwner apply(BsonValue bsonValue, Option<String> option, String string) {
            return SafeUploadHandler$IdNameOwner$.MODULE$.apply(bsonValue, option, string);
        }

        public static IdNameOwner fromProduct(Product product) {
            return SafeUploadHandler$IdNameOwner$.MODULE$.fromProduct(product);
        }

        public static IdNameOwner unapply(IdNameOwner idNameOwner) {
            return SafeUploadHandler$IdNameOwner$.MODULE$.unapply(idNameOwner);
        }

        public IdNameOwner(BsonValue id, Option<String> name, String owner) {
            this.id = id;
            this.name = name;
            this.owner = owner;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IdNameOwner)) return false;
            IdNameOwner idNameOwner = (IdNameOwner)object;
            BsonValue bsonValue = this.id();
            BsonValue bsonValue2 = idNameOwner.id();
            if (bsonValue == null) {
                if (bsonValue2 != null) {
                    return false;
                }
            } else if (!bsonValue.equals(bsonValue2)) return false;
            Option<String> option = this.name();
            Option<String> option2 = idNameOwner.name();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            String string = this.owner();
            String string2 = idNameOwner.owner();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof IdNameOwner;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "IdNameOwner";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "owner";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BsonValue id() {
            return this.id;
        }

        public Option<String> name() {
            return this.name;
        }

        public String owner() {
            return this.owner;
        }

        public IdNameOwner copy(BsonValue id, Option<String> name, String owner) {
            return new IdNameOwner(id, name, owner);
        }

        public BsonValue copy$default$1() {
            return this.id();
        }

        public Option<String> copy$default$2() {
            return this.name();
        }

        public String copy$default$3() {
            return this.owner();
        }

        public BsonValue _1() {
            return this.id();
        }

        public Option<String> _2() {
            return this.name();
        }

        public String _3() {
            return this.owner();
        }
    }

    public static final class Request
    implements Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Request.class.getDeclaredField("newDocument$lzy1"));
        private final UserDB.User user;
        private final Json incomingJson;
        private final BsonValue id;
        private final String name;
        private final boolean overwrite;
        private volatile Object newDocument$lzy1;

        public static Request apply(UserDB.User user, Json json, BsonValue bsonValue, String string, boolean bl) {
            return SafeUploadHandler$Request$.MODULE$.apply(user, json, bsonValue, string, bl);
        }

        public static Request fromProduct(Product product) {
            return SafeUploadHandler$Request$.MODULE$.fromProduct(product);
        }

        public static Request unapply(Request request) {
            return SafeUploadHandler$Request$.MODULE$.unapply(request);
        }

        public Request(UserDB.User user, Json incomingJson, BsonValue id, String name, boolean overwrite) {
            this.user = user;
            this.incomingJson = incomingJson;
            this.id = id;
            this.name = name;
            this.overwrite = overwrite;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.incomingJson()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)(this.overwrite() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Request)) return false;
            Request request = (Request)object;
            if (this.overwrite() != request.overwrite()) return false;
            UserDB.User user = this.user();
            UserDB.User user2 = request.user();
            if (user == null) {
                if (user2 != null) {
                    return false;
                }
            } else if (!((Object)user).equals(user2)) return false;
            Json json = this.incomingJson();
            Json json2 = request.incomingJson();
            if (json == null) {
                if (json2 != null) {
                    return false;
                }
            } else if (!json.equals(json2)) return false;
            BsonValue bsonValue = this.id();
            BsonValue bsonValue2 = request.id();
            if (bsonValue == null) {
                if (bsonValue2 != null) {
                    return false;
                }
            } else if (!bsonValue.equals(bsonValue2)) return false;
            String string = this.name();
            String string2 = request.name();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Request;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Request";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean((boolean)this._5());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "incomingJson";
                }
                case 2: {
                    return "id";
                }
                case 3: {
                    return "name";
                }
                case 4: {
                    return "overwrite";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UserDB.User user() {
            return this.user;
        }

        public Json incomingJson() {
            return this.incomingJson;
        }

        public BsonValue id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public boolean overwrite() {
            return this.overwrite;
        }

        public Document newDocument() {
            Object object = this.newDocument$lzy1;
            if (object instanceof Document) {
                return (Document)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Document)this.newDocument$lzyINIT1();
        }

        private Object newDocument$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.newDocument$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Document document = null;
                        try {
                            Json recordJson = this.incomingJson().mapObject((Function1 & Serializable)obj -> obj.add("owner", Json$.MODULE$.fromString(this.user().id())).add("name", Json$.MODULE$.fromString(this.name())));
                            document = org.mongodb.scala.bson.package$.MODULE$.Document().apply(recordJson.noSpaces());
                            object2 = document == null ? LazyVals.NullValue$.MODULE$ : document;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.newDocument$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return document;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Request copy(UserDB.User user, Json incomingJson, BsonValue id, String name, boolean overwrite) {
            return new Request(user, incomingJson, id, name, overwrite);
        }

        public UserDB.User copy$default$1() {
            return this.user();
        }

        public Json copy$default$2() {
            return this.incomingJson();
        }

        public BsonValue copy$default$3() {
            return this.id();
        }

        public String copy$default$4() {
            return this.name();
        }

        public boolean copy$default$5() {
            return this.overwrite();
        }

        public UserDB.User _1() {
            return this.user();
        }

        public Json _2() {
            return this.incomingJson();
        }

        public BsonValue _3() {
            return this.id();
        }

        public String _4() {
            return this.name();
        }

        public boolean _5() {
            return this.overwrite();
        }
    }

    public static final class Result
    implements Product,
    Serializable {
        private final String name;
        private final LogMessage msg;
        private final Option optInsertedId;

        public static Result apply(String string, LogMessage logMessage, Option<BsonValue> option) {
            return SafeUploadHandler$Result$.MODULE$.apply(string, logMessage, option);
        }

        public static Result fromProduct(Product product) {
            return SafeUploadHandler$Result$.MODULE$.fromProduct(product);
        }

        public static Result unapply(Result result) {
            return SafeUploadHandler$Result$.MODULE$.unapply(result);
        }

        public static Option<BsonValue> $lessinit$greater$default$3() {
            return SafeUploadHandler$Result$.MODULE$.$lessinit$greater$default$3();
        }

        public Result(String name, LogMessage msg, Option<BsonValue> optInsertedId) {
            this.name = name;
            this.msg = msg;
            this.optInsertedId = optInsertedId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            Result result = (Result)object;
            String string = this.name();
            String string2 = result.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            LogMessage logMessage = this.msg();
            LogMessage logMessage2 = result.msg();
            if (logMessage == null) {
                if (logMessage2 != null) {
                    return false;
                }
            } else if (!logMessage.equals(logMessage2)) return false;
            Option<BsonValue> option = this.optInsertedId();
            Option<BsonValue> option2 = result.optInsertedId();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "msg";
                }
                case 2: {
                    return "optInsertedId";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public LogMessage msg() {
            return this.msg;
        }

        public Option<BsonValue> optInsertedId() {
            return this.optInsertedId;
        }

        public Result copy(String name, LogMessage msg, Option<BsonValue> optInsertedId) {
            return new Result(name, msg, optInsertedId);
        }

        public String copy$default$1() {
            return this.name();
        }

        public LogMessage copy$default$2() {
            return this.msg();
        }

        public Option<BsonValue> copy$default$3() {
            return this.optInsertedId();
        }

        public String _1() {
            return this.name();
        }

        public LogMessage _2() {
            return this.msg();
        }

        public Option<BsonValue> _3() {
            return this.optInsertedId();
        }
    }
}

