/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.api.NoSecrets$;
import ambience.api.Secrets;
import ambience.framework.AESCipher$;
import ambience.framework.AESCipher$Secret$;
import ambience.module.UserDB;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class SecretsUtil$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(SecretsUtil$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SecretsUtil$.class.getDeclaredField("secretsT$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object secretsT$lzy1;
    private static final String SecretPrefix;
    public static final SecretsUtil$ MODULE$;

    private SecretsUtil$() {
    }

    static {
        MODULE$ = new SecretsUtil$();
        SecretPrefix = "{secret}";
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SecretsUtil$.class);
    }

    public Task<Secrets> secretsT() {
        Object object = this.secretsT$lzy1;
        if (object instanceof Task) {
            return (Task)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Task)this.secretsT$lzyINIT1();
    }

    private Object secretsT$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.secretsT$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Task task = null;
                    try {
                        task = Task$.MODULE$.apply(SecretsUtil$::secretsT$lzyINIT1$$anonfun$1).memoize();
                        object2 = task == null ? LazyVals.NullValue$.MODULE$ : task;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.secretsT$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return task;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String SecretPrefix() {
        return SecretPrefix;
    }

    public Task<String> prefixDecrypt(UserDB.User user, String s, boolean allowFile) {
        if (s.startsWith(this.SecretPrefix())) {
            return this.secretPrefixDecrypt(user, s, allowFile);
        }
        return this.encPrefixDecrypt(s, allowFile);
    }

    public Task<String> systemPrefixDecrypt(String s, boolean allowFile) {
        if (s.startsWith(this.SecretPrefix())) {
            return this.systemSecretPrefixDecrypt(s, allowFile);
        }
        return this.encPrefixDecrypt(s, allowFile);
    }

    public Task<String> secretPrefixDecrypt(UserDB.User user, String s, boolean allowFile) {
        return this.secretsT().flatMap((Function1 & Serializable)_$1 -> _$1.getSecret(user, StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s), MODULE$.SecretPrefix()))).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Secrets.Value enc = (Secrets.Value)((Some)option).value();
                return Crypt$.MODULE$.encPrefixDecrypt(enc.value(), allowFile);
            }
            if (None$.MODULE$.equals(option)) {
                MODULE$.log().error(() -> SecretsUtil$.secretPrefixDecrypt$$anonfun$2$$anonfun$1(s, user), Line$.MODULE$.apply(34), FullName$.MODULE$.apply("ambience.framework.SecretsUtil.secretPrefixDecrypt"));
                return s;
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<String> systemSecretPrefixDecrypt(String s, boolean allowFile) {
        return this.secretsT().flatMap((Function1 & Serializable)_$2 -> _$2.getSystemSecret(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s), MODULE$.SecretPrefix()))).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Secrets.Value enc = (Secrets.Value)((Some)option).value();
                return Crypt$.MODULE$.encPrefixDecrypt(enc.value(), allowFile);
            }
            if (None$.MODULE$.equals(option)) {
                MODULE$.log().error(() -> SecretsUtil$.systemSecretPrefixDecrypt$$anonfun$2$$anonfun$1(s), Line$.MODULE$.apply(43), FullName$.MODULE$.apply("ambience.framework.SecretsUtil.systemSecretPrefixDecrypt"));
                return s;
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<String> encPrefixDecrypt(String s, boolean allowFile) {
        return Task$.MODULE$.now((Object)Crypt$.MODULE$.encPrefixDecrypt(s, allowFile));
    }

    public Task<Either<LogMessage, byte[]>> encryptWithSecret(UserDB.User user, String secret, byte[] data) {
        return this.secretsT().flatMap((Function1 & Serializable)_$3 -> _$3.getSecret(user, secret)).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Secrets.Value secretValue = (Secrets.Value)((Some)option).value();
                return package$.MODULE$.Right().apply((Object)AESCipher$.MODULE$.encrypt(AESCipher$Secret$.MODULE$.apply(secretValue.value()), data));
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Secret " + secret + " not available"));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<LogMessage, byte[]>> decryptWithSecret(UserDB.User user, String secret, byte[] data) {
        return this.secretsT().flatMap((Function1 & Serializable)_$4 -> _$4.getSecret(user, secret)).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Secrets.Value secretValue = (Secrets.Value)((Some)option).value();
                return package$.MODULE$.Right().apply((Object)AESCipher$.MODULE$.decrypt(AESCipher$Secret$.MODULE$.apply(secretValue.value()), data));
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Secret " + secret + " not available"));
            }
            throw new MatchError((Object)option);
        });
    }

    private static final Secrets secretsT$lzyINIT1$$anonfun$1$$anonfun$1() {
        return (Secrets)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Secrets.class));
    }

    private static final Object secretsT$lzyINIT1$$anonfun$1$$anonfun$2() {
        return "Unable to load Secrets API";
    }

    private static final Secrets secretsT$lzyINIT1$$anonfun$1() {
        Option option = Try$.MODULE$.apply(SecretsUtil$::secretsT$lzyINIT1$$anonfun$1$$anonfun$1).toOption();
        if (option instanceof Some) {
            Secrets sec = (Secrets)((Some)option).value();
            return sec;
        }
        if (None$.MODULE$.equals(option)) {
            MODULE$.log().warn(SecretsUtil$::secretsT$lzyINIT1$$anonfun$1$$anonfun$2, Line$.MODULE$.apply(15), FullName$.MODULE$.apply("ambience.framework.SecretsUtil.secretsT"));
            return NoSecrets$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private static final Object secretPrefixDecrypt$$anonfun$2$$anonfun$1(String s$3, UserDB.User user$3) {
        return "Can't locate secret " + s$3 + " for user " + user$3.name();
    }

    private static final Object systemSecretPrefixDecrypt$$anonfun$2$$anonfun$1(String s$6) {
        return "Can't locate system secret " + s$6;
    }
}

