/*
 * Decompiled with CFR 0.152.
 */
package ambience.queue;

import ambience.module.UserDB;
import ambience.queue.JobRunner;
import ambience.queue.JobType;
import ambience.queue.JobType$;
import ambience.queue.PollRunLater$;
import ambience.queue.PollWaitTimeout$;
import ambience.queue.QId;
import ambience.queue.QId$;
import ambience.queue.Queue;
import ambience.queue.Queue$;
import ambience.queue.QueueEngine;
import ambience.queue.QueueEvent;
import ambience.queue.QueueEvent$;
import ambience.queue.QueueEvent$Added$;
import ambience.queue.QueueEvent$Cancelled$;
import ambience.queue.QueueEvent$Deleted$;
import ambience.queue.QueueJobHandler;
import ambience.queue.QueueUtil$;
import ambience.queue.SystemQueueManager;
import ambience.queue.SystemQueueManager$;
import ambience.queue.SystemQueueManager$NoResultAvailable$;
import ambience.queue.SystemQueueManager$NoStatusAvailable$;
import ambience.queue.SystemQueueManager$RequestCancelled$;
import ambience.queue.SystemQueueManager$RequestDeleted$;
import ambience.queue.SystemQueueManager$RequestFailed$;
import ambience.queue.SystemQueueManager$RequestNotFound$;
import ambience.queue.SystemQueueManager$RequestNotStarted$;
import ambience.queue.SystemQueueManager$RequestTimedOut$;
import ambience.queue.SystemQueueManager$ResultAvailable$;
import ambience.queue.SystemQueueManager$ResultNotYetAvailable$;
import ambience.queue.SystemQueueManager$ResultTimedOut$;
import com.elixirtech.arch.Clock;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class SystemQueueManagerImpl
implements SystemQueueManager {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(SystemQueueManagerImpl.class.getDeclaredField("jobTypes$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(SystemQueueManagerImpl.class.getDeclaredField("runnerMap$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(SystemQueueManagerImpl.class.getDeclaredField("queue$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SystemQueueManagerImpl.class.getDeclaredField("cltnT$lzy1"));
    private Clock clock;
    private CodexDB codexDB;
    private volatile Object cltnT$lzy1;
    private volatile Object queue$lzy1;
    private volatile Object runnerMap$lzy1;
    private volatile Object jobTypes$lzy1;
    private final List engines;
    private final String msg;

    public SystemQueueManagerImpl(Clock clock, CodexDB codexDB) {
        this.clock = clock;
        this.codexDB = codexDB;
        this.engines = this.buildEngines();
        SystemQueueManager$.MODULE$.log().info(this::$init$$$anonfun$5, Line$.MODULE$.apply(88), FullName$.MODULE$.apply("ambience.queue.SystemQueueManagerImpl"));
        this.msg = "QueueManager running (engines=" + this.engineIds().size() + " runners=" + SystemQueueManager$.MODULE$.runners().runners().size() + ")";
        SystemQueueManager$.MODULE$.log().info(this::$init$$$anonfun$6, Line$.MODULE$.apply(90), FullName$.MODULE$.apply("ambience.queue.SystemQueueManagerImpl"));
        PollRunLater$.MODULE$.apply();
        PollWaitTimeout$.MODULE$.apply(this.queue());
    }

    public Task<CodexCollection> cltnT() {
        Object object = this.cltnT$lzy1;
        if (object instanceof Task) {
            return (Task)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Task)this.cltnT$lzyINIT1();
    }

    private Object cltnT$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cltnT$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Task task = null;
                    try {
                        task = this.codexDB.getCodexCollection("JobQueue").memoize();
                        object2 = task == null ? LazyVals.NullValue$.MODULE$ : task;
                        this.codexDB = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltnT$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return task;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Queue queue() {
        Object object = this.queue$lzy1;
        if (object instanceof Queue) {
            return (Queue)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Queue)this.queue$lzyINIT1();
    }

    private Object queue$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.queue$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Queue queue = null;
                    try {
                        queue = new Queue(this.clock, this.cltnT(), SystemQueueManager$.MODULE$.expiry(), Scheduler$.MODULE$.global());
                        object2 = queue == null ? LazyVals.NullValue$.MODULE$ : queue;
                        this.clock = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.queue$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return queue;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Map<JobType, JobRunner> runnerMap() {
        Object object = this.runnerMap$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.runnerMap$lzyINIT1();
    }

    private Object runnerMap$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.runnerMap$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Map<JobType, JobRunner> map = null;
                    Map<JobType, JobRunner> map2 = null;
                    try {
                        map2 = this.buildRunnerMap();
                        map = map2 == null ? LazyVals.NullValue$.MODULE$ : map2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, map)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.runnerMap$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, map);
                            waiting.countDown();
                        }
                    }
                    return map2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Set<JobType> jobTypes() {
        Object object = this.jobTypes$lzy1;
        if (object instanceof Set) {
            return (Set)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Set)this.jobTypes$lzyINIT1();
    }

    private Object jobTypes$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jobTypes$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Set set = null;
                    try {
                        set = this.runnerMap().keySet();
                        object2 = set == null ? LazyVals.NullValue$.MODULE$ : set;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jobTypes$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return set;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<QueueEngine> engines() {
        return this.engines;
    }

    @Override
    public Set<String> engineIds() {
        return SystemQueueManager$.MODULE$.engineIds();
    }

    public String msg() {
        return this.msg;
    }

    public List<QueueEngine> buildEngines() {
        SystemQueueManager$.MODULE$.log().info(SystemQueueManagerImpl::buildEngines$$anonfun$1, Line$.MODULE$.apply(96), FullName$.MODULE$.apply("ambience.queue.SystemQueueManagerImpl.buildEngines"));
        return ((IterableOnceOps)SystemQueueManager$.MODULE$.engineIds().map((Function1 & Serializable)engineId -> new QueueEngine(this, (String)engineId, this.queue()))).toList();
    }

    public Map<JobType, JobRunner> buildRunnerMap() {
        SystemQueueManager$.MODULE$.log().info(SystemQueueManagerImpl::buildRunnerMap$$anonfun$1, Line$.MODULE$.apply(101), FullName$.MODULE$.apply("ambience.queue.SystemQueueManagerImpl.buildRunnerMap"));
        Map all = (Map)SystemQueueManager$.MODULE$.runners().runners().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(v))) {
                    Either either = SystemQueueManagerImpl.loader$2(v);
                    if (either instanceof Right) {
                        JobRunner jobRunner = (JobRunner)((Right)either).value();
                        JobType jobType = (JobType)Predef$.MODULE$.ArrowAssoc((Object)new JobType(JobType$.MODULE$.apply(k)));
                        return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jobType, (Object)jobRunner));
                    }
                    if (either instanceof Left) {
                        String err = (String)((Left)either).value();
                        SystemQueueManager$.MODULE$.log().warn(() -> SystemQueueManagerImpl.$anonfun$2$$anonfun$1(k, v, err), Line$.MODULE$.apply(110), FullName$.MODULE$.apply("ambience.queue.SystemQueueManagerImpl.all"));
                        return None$.MODULE$;
                    }
                    throw new MatchError((Object)either);
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        });
        SystemQueueManager$.MODULE$.log().info(() -> SystemQueueManagerImpl.buildRunnerMap$$anonfun$2(all), Line$.MODULE$.apply(116), FullName$.MODULE$.apply("ambience.queue.SystemQueueManagerImpl.buildRunnerMap"));
        return all;
    }

    @Override
    public Task<Document> run(Document req) {
        return Task$.MODULE$.apply(() -> SystemQueueManagerImpl.run$$anonfun$1(req)).flatMap((Function1 & Serializable)wt -> this.run$$anonfun$2(req, BoxesRunTime.unboxToLong((Object)wt)));
    }

    @Override
    public Task<QId> writeRequest(Document req) {
        return Task$.MODULE$.apply(() -> SystemQueueManagerImpl.writeRequest$$anonfun$1(req)).flatMap((Function1 & Serializable)wt -> this.writeRequest$$anonfun$2(req, BoxesRunTime.unboxToLong((Object)wt)));
    }

    @Override
    public Task<SystemQueueManager.ResultInfo> getResult(UserDB.User user, String qId) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(qId)), CodexFilter.Eq$.MODULE$.apply("request.user", (BsonValue)BsonString$.MODULE$.apply(user.id()))}));
        return this.cltnT().flatMap((Function1 & Serializable)_$2 -> _$2.findOneO((CodexFilter)filter).firstOptionL()).map((Function1 & Serializable)x$1 -> {
            BsonString bsonString;
            Product product;
            block15: {
                Document doc;
                block13: {
                    block14: {
                        BsonString bsonString2;
                        BsonString bsonString3;
                        block12: {
                            BsonString status;
                            Option option = x$1;
                            if (!(option instanceof Some)) {
                                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                product = SystemQueueManager$RequestNotFound$.MODULE$;
                                return product;
                            }
                            doc = (Document)((Some)option).value();
                            bsonString = status = (BsonString)doc.get("status", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).getOrElse(SystemQueueManagerImpl::$anonfun$3);
                            bsonString3 = Queue$.MODULE$.Replied();
                            bsonString2 = bsonString;
                            if (bsonString3 != null) break block12;
                            if (bsonString2 == null) break block13;
                            break block14;
                        }
                        if (bsonString3.equals(bsonString2)) break block13;
                    }
                    BsonString bsonString4 = Queue$.MODULE$.Completed();
                    BsonString bsonString5 = bsonString;
                    if (bsonString4 != null ? !bsonString4.equals(bsonString5) : bsonString5 != null) break block15;
                }
                Option option = doc.get("result", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class));
                if (option instanceof Some) {
                    BsonDocument value = (BsonDocument)((Some)option).value();
                    product = SystemQueueManager$ResultAvailable$.MODULE$.apply(Document$.MODULE$.apply(value));
                    return product;
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                product = SystemQueueManager$NoResultAvailable$.MODULE$;
                return product;
            }
            BsonString bsonString6 = Queue$.MODULE$.Added();
            BsonString bsonString7 = bsonString;
            if (!(bsonString6 != null ? !bsonString6.equals(bsonString7) : bsonString7 != null)) {
                product = SystemQueueManager$RequestNotStarted$.MODULE$;
                return product;
            }
            BsonString bsonString8 = Queue$.MODULE$.Processing();
            BsonString bsonString9 = bsonString;
            if (!(bsonString8 != null ? !bsonString8.equals(bsonString9) : bsonString9 != null)) {
                product = SystemQueueManager$ResultNotYetAvailable$.MODULE$;
                return product;
            }
            BsonString bsonString10 = Queue$.MODULE$.Cancelled();
            BsonString bsonString11 = bsonString;
            if (!(bsonString10 != null ? !bsonString10.equals(bsonString11) : bsonString11 != null)) {
                product = SystemQueueManager$RequestCancelled$.MODULE$;
                return product;
            }
            BsonString bsonString12 = Queue$.MODULE$.Deleted();
            BsonString bsonString13 = bsonString;
            if (!(bsonString12 != null ? !bsonString12.equals(bsonString13) : bsonString13 != null)) {
                product = SystemQueueManager$RequestDeleted$.MODULE$;
                return product;
            }
            BsonString bsonString14 = Queue$.MODULE$.Failed();
            BsonString bsonString15 = bsonString;
            if (!(bsonString14 != null ? !bsonString14.equals(bsonString15) : bsonString15 != null)) {
                product = SystemQueueManager$RequestFailed$.MODULE$;
                return product;
            }
            BsonString bsonString16 = Queue$.MODULE$.WaitTimeout();
            BsonString bsonString17 = bsonString;
            if (!(bsonString16 != null ? !bsonString16.equals(bsonString17) : bsonString17 != null)) {
                product = SystemQueueManager$RequestTimedOut$.MODULE$;
                return product;
            }
            BsonString bsonString18 = Queue$.MODULE$.JobTimeout();
            BsonString bsonString19 = bsonString;
            if (!(bsonString18 != null ? !bsonString18.equals(bsonString19) : bsonString19 != null)) {
                product = SystemQueueManager$ResultTimedOut$.MODULE$;
                return product;
            }
            product = SystemQueueManager$NoStatusAvailable$.MODULE$;
            return product;
        });
    }

    @Override
    public Task<BoxedUnit> delete(UserDB.User user, String qId) {
        return this.queue().delete(qId).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.delete$$anonfun$1$$anonfun$1(qId, user);
                return BoxedUnit.UNIT;
            }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    @Override
    public Task<BoxedUnit> cancel(UserDB.User user, String qId) {
        return this.queue().cancel(qId).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.cancel$$anonfun$1$$anonfun$1(qId, user);
                return BoxedUnit.UNIT;
            }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    @Override
    public Task<BoxedUnit> syncWaitTimeout() {
        return this.queue().syncWaitTimeout();
    }

    @Override
    public Option<JobRunner> getRunner(String jobType) {
        return this.runnerMap().get((Object)new JobType(jobType));
    }

    public Task<BoxedUnit> cancel(String qId) {
        return this.queue().cancel(qId);
    }

    @Override
    public Task<Option<String>> getStatus(String qId) {
        return this.queue().getStatus(qId);
    }

    @Override
    public Task<Option<Document>> readResultAndMarkCompleted(String qId) {
        return this.queue().readResultAndMarkCompleted(qId);
    }

    public Document userInfo(UserDB.User user) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"userId");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)user.id()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"userName");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)user.name()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        return Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private final Object $init$$$anonfun$5() {
        return "Running with engines: " + ((IterableOnceOps)this.engineIds().toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("[", ", ", "]");
    }

    private final Object $init$$$anonfun$6() {
        return this.msg();
    }

    private static final Object buildEngines$$anonfun$1() {
        return "Building engines";
    }

    private static final Object buildRunnerMap$$anonfun$1() {
        return "Building runner map";
    }

    private static final Either loader$2(String cls) {
        return SystemQueueManager$.MODULE$.load(Thread.currentThread().getContextClassLoader(), cls);
    }

    private static final Object $anonfun$2$$anonfun$1(String k$1, String v$1, String err$2) {
        return "Can't load jobRunner: " + k$1 + "->" + v$1 + ": " + err$2;
    }

    private static final Object buildRunnerMap$$anonfun$2(Map all$1) {
        return "Running with job runners for " + ((IterableOnceOps)all$1.keySet().toList().map((Function1 & Serializable)_$1 -> _$1 == null ? null : ((JobType)_$1).value()).sorted((Ordering)Ordering.String$.MODULE$)).mkString("[", ", ", "]");
    }

    private static final long run$$anonfun$1(Document req$1) {
        return QueueUtil$.MODULE$.calculateWaitTimeOutTs(req$1);
    }

    private static final Object run$$anonfun$2$$anonfun$1$$anonfun$1(Document req$4) {
        return "doRun called with " + req$4;
    }

    private static final void run$$anonfun$2$$anonfun$1(Document req$3) {
        SystemQueueManager$.MODULE$.log().debug(() -> SystemQueueManagerImpl.run$$anonfun$2$$anonfun$1$$anonfun$1(req$3), Line$.MODULE$.apply(123), FullName$.MODULE$.apply("ambience.queue.SystemQueueManagerImpl.run"));
    }

    private static final String run$$anonfun$2$$anonfun$2$$anonfun$1() {
        return QId$.MODULE$.apply(UUID.randomUUID().toString());
    }

    private final QueueJobHandler run$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(String qId$1, long wt$1) {
        return new QueueJobHandler(this, qId$1, wt$1);
    }

    private static final void run$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(Document req$9) {
        QueueEvent$.MODULE$.addEvent((QueueEvent.QueueEvent)QueueEvent$Added$.MODULE$, req$9);
    }

    private static final /* synthetic */ Task run$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Document req$8, QueueJobHandler qjh$1, String x$12) {
        String string = x$12;
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            SystemQueueManagerImpl.run$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(req$8);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return qjh$1.getResult().map((Function1 & Serializable)res -> res);
        });
    }

    private final /* synthetic */ Task run$$anonfun$2$$anonfun$2$$anonfun$2(long wt$3, Document req$6, String qId) {
        return Task$.MODULE$.apply(() -> this.run$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(qId, wt$3)).flatMap((Function1 & Serializable)qjh -> this.queue().writeRequest(qId, req$6, wt$3).flatMap((Function1 & Serializable)x$1 -> SystemQueueManagerImpl.run$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(req$6, qjh, x$1 == null ? null : ((QId)x$1).value())));
    }

    private final /* synthetic */ Task run$$anonfun$2(Document req$2, long wt) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            SystemQueueManagerImpl.run$$anonfun$2$$anonfun$1(req$2);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply((Function0 & Serializable)() -> new QId(SystemQueueManagerImpl.run$$anonfun$2$$anonfun$2$$anonfun$1())).flatMap((Function1 & Serializable)qId -> this.run$$anonfun$2$$anonfun$2$$anonfun$2(wt, req$2, qId == null ? null : ((QId)qId).value()));
        });
    }

    private static final long writeRequest$$anonfun$1(Document req$10) {
        return QueueUtil$.MODULE$.calculateWaitTimeOutTs(req$10);
    }

    private static final void writeRequest$$anonfun$2$$anonfun$1$$anonfun$1(Document req$13) {
        QueueEvent$.MODULE$.addEvent((QueueEvent.QueueEvent)QueueEvent$Added$.MODULE$, req$13);
    }

    private static final /* synthetic */ String writeRequest$$anonfun$2$$anonfun$1$$anonfun$2(String qId$3, BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return qId$3;
    }

    private static final /* synthetic */ Task writeRequest$$anonfun$2$$anonfun$1(Document req$12, String qId) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            SystemQueueManagerImpl.writeRequest$$anonfun$2$$anonfun$1$$anonfun$1(req$12);
            return BoxedUnit.UNIT;
        }).map((Function1 & Serializable)x$1 -> new QId(SystemQueueManagerImpl.writeRequest$$anonfun$2$$anonfun$1$$anonfun$2(qId, x$1)));
    }

    private final /* synthetic */ Task writeRequest$$anonfun$2(Document req$11, long wt) {
        return this.queue().writeRequest(req$11, wt).flatMap((Function1 & Serializable)qId -> SystemQueueManagerImpl.writeRequest$$anonfun$2$$anonfun$1(req$11, qId == null ? null : ((QId)qId).value()));
    }

    private static final BsonString $anonfun$3() {
        return BsonString$.MODULE$.apply("Unknown");
    }

    private final void delete$$anonfun$1$$anonfun$1(String qId$5, UserDB.User user$2) {
        QueueEvent$.MODULE$.addEvent(QueueEvent$Deleted$.MODULE$, qId$5, this.userInfo(user$2));
    }

    private final void cancel$$anonfun$1$$anonfun$1(String qId$7, UserDB.User user$4) {
        QueueEvent$.MODULE$.addEvent(QueueEvent$Cancelled$.MODULE$, qId$7, this.userInfo(user$4));
    }
}

