/*
 * Decompiled with CFR 0.152.
 */
package ambience.queue.overflow;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$Content$;
import ambience.api.BinaryStore$ContentId$;
import ambience.api.BinaryStore$LocationId$;
import ambience.chunk.ChunkAPI;
import ambience.chunk.ChunkAPI$ChunkId$;
import ambience.queue.overflow.JobOverflowChunkDB;
import ambience.queue.overflow.MyBinaryStoreChunkDB$CID$;
import ambience.queue.overflow.MyBinaryStoreChunkDB$ExpiryInfo$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MyBinaryStoreChunkDB
implements JobOverflowChunkDB,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MyBinaryStoreChunkDB.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MyBinaryStoreChunkDB.class.getDeclaredField("api$lzy1"));
    private volatile Object log$lzy1;
    private final String locationId;
    private final long expiryMs;
    private final String JobOverflowType;
    private final long MinCleanInterval;
    private volatile Object api$lzy1;
    public final MyBinaryStoreChunkDB$CID$ CID$lzy1;
    public final MyBinaryStoreChunkDB$ExpiryInfo$ ExpiryInfo$lzy1;
    private long lastClean;

    public MyBinaryStoreChunkDB(String locationId, long expiryMs) {
        this.locationId = locationId;
        this.expiryMs = expiryMs;
        this.CID$lzy1 = new MyBinaryStoreChunkDB$CID$(this);
        this.ExpiryInfo$lzy1 = new MyBinaryStoreChunkDB$ExpiryInfo$(this);
        this.JobOverflowType = "JobOverflow";
        this.MinCleanInterval = 600000L;
        this.lastClean = 0L;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String JobOverflowType() {
        return this.JobOverflowType;
    }

    public long MinCleanInterval() {
        return this.MinCleanInterval;
    }

    public BinaryStore api() {
        Object object = this.api$lzy1;
        if (object instanceof BinaryStore) {
            return (BinaryStore)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BinaryStore)this.api$lzyINIT1();
    }

    private Object api$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.api$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BinaryStore binaryStore = null;
                    try {
                        binaryStore = (BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class));
                        object2 = binaryStore == null ? LazyVals.NullValue$.MODULE$ : binaryStore;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.api$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return binaryStore;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final MyBinaryStoreChunkDB$CID$ CID() {
        return this.CID$lzy1;
    }

    public final MyBinaryStoreChunkDB$ExpiryInfo$ ExpiryInfo() {
        return this.ExpiryInfo$lzy1;
    }

    @Override
    public Task<List<ChunkAPI.ChunkId>> writeBytes(byte[] bytes) {
        MyBinaryStoreChunkDB myBinaryStoreChunkDB = this;
        synchronized (myBinaryStoreChunkDB) {
            long now = System.currentTimeMillis();
            if (this.lastClean <= now - this.MinCleanInterval()) {
                this.lastClean = now;
                this.expiryCleanerT().runAsyncAndForget(Scheduler$.MODULE$.global());
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
        }
        long expiry = System.currentTimeMillis() + this.expiryMs;
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(this.JobOverflowType()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"expiresAt");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromLong(expiry));
        BinaryStore.Content content = BinaryStore$Content$.MODULE$.apply(DataBytes$.MODULE$.apply(bytes), Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return this.api().location(this.locationId).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                BinaryStore.Location location = (BinaryStore.Location)((Some)option).value();
                return location.add(content).map((Function1 & Serializable)cid -> this.writeBytes$$anonfun$1$$anonfun$1(cid == null ? null : ((BinaryStore.ContentId)cid).value()));
            }
            if (None$.MODULE$.equals(option)) {
                this.log().error(this::writeBytes$$anonfun$1$$anonfun$2, Line$.MODULE$.apply(46), FullName$.MODULE$.apply("ambience.queue.overflow.MyBinaryStoreChunkDB.writeBytes"));
                return Task$.MODULE$.now((Object)package$.MODULE$.Nil());
            }
            throw new MatchError((Object)option);
        });
    }

    @Override
    public Task<DataBytes> readDataBytes(List<ChunkAPI.ChunkId> shas) {
        Option option = shas.headOption().flatMap((Function1 & Serializable)cid -> this.readDataBytes$$anonfun$1(cid == null ? null : ((ChunkAPI.ChunkId)cid).value()));
        if (option instanceof Some) {
            CID cid2 = (CID)((Some)option).value();
            return this.api().location(BinaryStore$LocationId$.MODULE$.apply(cid2.locationId())).flatMap((Function1 & Serializable)x$12 -> {
                Option option = x$12;
                if (option instanceof Some) {
                    BinaryStore.Location location = (BinaryStore.Location)((Some)option).value();
                    return location.get(BinaryStore$ContentId$.MODULE$.apply(cid2.contentId())).map((Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                            return content.bytes();
                        }
                        if (None$.MODULE$.equals(option)) {
                            this.log().error(() -> MyBinaryStoreChunkDB.readDataBytes$$anonfun$2$$anonfun$1$$anonfun$1(cid2), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.queue.overflow.MyBinaryStoreChunkDB.readDataBytes"));
                            return DataBytes$.MODULE$.empty();
                        }
                        throw new MatchError((Object)option);
                    });
                }
                if (None$.MODULE$.equals(option)) {
                    this.log().error(() -> MyBinaryStoreChunkDB.readDataBytes$$anonfun$2$$anonfun$2(cid2), Line$.MODULE$.apply(63), FullName$.MODULE$.apply("ambience.queue.overflow.MyBinaryStoreChunkDB.readDataBytes"));
                    return Task$.MODULE$.now((Object)DataBytes$.MODULE$.empty());
                }
                throw new MatchError((Object)option);
            });
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(() -> MyBinaryStoreChunkDB.readDataBytes$$anonfun$3(shas), Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.queue.overflow.MyBinaryStoreChunkDB.readDataBytes"));
            return Task$.MODULE$.now((Object)DataBytes$.MODULE$.empty());
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Task<BoxedUnit> readToOutputStream(List<ChunkAPI.ChunkId> shas, OutputStream os) {
        return this.readDataBytes(shas).flatMap((Function1 & Serializable)db -> DataBytes$.MODULE$.toFullT(db)).map((Function1)(JProcedure1 & Serializable)fdb -> os.write(fdb.bytes()));
    }

    @Override
    public Task<List<ChunkAPI.ChunkId>> writeDataBytes(DataBytes db) {
        return DataBytes$.MODULE$.toFullT(db).flatMap((Function1 & Serializable)full -> this.writeBytes(full.bytes()));
    }

    public Task<BoxedUnit> expiryCleanerT() {
        return this.api().location(this.locationId).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                BinaryStore.Location location = (BinaryStore.Location)((Some)option).value();
                long now = System.currentTimeMillis();
                return location.all().toListL().flatMap((Function1 & Serializable)all -> {
                    this.log().info(() -> MyBinaryStoreChunkDB.expiryCleanerT$$anonfun$1$$anonfun$1$$anonfun$1(all), Line$.MODULE$.apply(85), FullName$.MODULE$.apply("ambience.queue.overflow.MyBinaryStoreChunkDB.expiryCleanerT"));
                    Observable x = Observable$.MODULE$.fromIterable((Iterable)all).flatMap((Function1 & Serializable)cid -> this.$anonfun$1(location, cid == null ? null : ((BinaryStore.ContentId)cid).value()));
                    return x.filter((Function1 & Serializable)_$1 -> this.shouldRemove((ExpiryInfo)_$1, now)).mapEval((Function1 & Serializable)e -> location.remove(e.cid())).countL().map((Function1)(JFunction1.mcVJ.sp & Serializable)count -> this.log().info(() -> MyBinaryStoreChunkDB.expiryCleanerT$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1(count, now), Line$.MODULE$.apply(88), FullName$.MODULE$.apply("ambience.queue.overflow.MyBinaryStoreChunkDB.expiryCleanerT")));
                });
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(this::expiryCleanerT$$anonfun$1$$anonfun$2, Line$.MODULE$.apply(92), FullName$.MODULE$.apply("ambience.queue.overflow.MyBinaryStoreChunkDB.expiryCleanerT"));
                return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
            }
            throw new MatchError((Object)option);
        }).onErrorHandle((Function1)(JProcedure1 & Serializable)x$1 -> {
            Throwable throwable;
            Throwable ex = throwable = x$1;
            this.log().error(() -> MyBinaryStoreChunkDB.expiryCleanerT$$anonfun$2$$anonfun$1(ex), Line$.MODULE$.apply(95), FullName$.MODULE$.apply("ambience.queue.overflow.MyBinaryStoreChunkDB.expiryCleanerT"));
        });
    }

    public boolean shouldRemove(ExpiryInfo e, long now) {
        return e.expiresAt() < now;
    }

    public Task<Option<ExpiryInfo>> getExpiryInfo(BinaryStore.Location location, String cid) {
        return location.getMetadata(cid).map((Function1 & Serializable)omd -> omd.flatMap((Function1 & Serializable)md -> this.toExpiryInfo(cid, (Json)md))).onErrorRecover((PartialFunction)new Serializable(cid, this){
            private final String cid$7;
            private final /* synthetic */ MyBinaryStoreChunkDB $outer;
            {
                this.cid$7 = cid$9;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                this.$outer.log().warn(() -> this.applyOrElse$$anonfun$1(x), Line$.MODULE$.apply(103), FullName$.MODULE$.apply("ambience.queue.overflow.MyBinaryStoreChunkDB.getExpiryInfo"));
                return None$.MODULE$;
            }

            private final Object applyOrElse$$anonfun$1(Throwable x$1) {
                return "getExpiryInfo failed for " + new BinaryStore.ContentId(this.cid$7) + ": " + x$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public Observable<ExpiryInfo> toObservable(Task<Option<ExpiryInfo>> t) {
        return Observable$.MODULE$.fromTask(t).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ExpiryInfo j = (ExpiryInfo)((Some)option).value();
                return Observable$.MODULE$.now((Object)j);
            }
            if (None$.MODULE$.equals(option)) {
                return Observable$.MODULE$.empty();
            }
            throw new MatchError((Object)option);
        });
    }

    public Option<ExpiryInfo> toExpiryInfo(String cid, Json json) {
        Either either = json.hcursor().downField("type").as(Decoder$.MODULE$.decodeString());
        Right right = package$.MODULE$.Right().apply((Object)this.JobOverflowType());
        if (!(either != null ? !either.equals(right) : right != null)) {
            return json.hcursor().downField("expiresAt").as(Decoder$.MODULE$.decodeLong()).toOption().map((Function1 & Serializable)expiresAt -> this.toExpiryInfo$$anonfun$1(cid, BoxesRunTime.unboxToLong((Object)expiresAt)));
        }
        return None$.MODULE$;
    }

    private static final List writeBytes$$anonfun$1$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        EncoderNotDeriveSum f$proxy1;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy1 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private final /* synthetic */ List writeBytes$$anonfun$1$$anonfun$1(String cid) {
        ChunkAPI.ChunkId[] chunkIdArray = new ChunkAPI.ChunkId[1];
        CID cID = (CID)io.circe.syntax.package$.MODULE$.EncoderOps((Object)this.CID().apply(this.locationId, cid));
        String string = "locationId";
        String string2 = "contentId";
        chunkIdArray[0] = new ChunkAPI.ChunkId(ChunkAPI$ChunkId$.MODULE$.apply(package.EncoderOps$.MODULE$.asJson$extension((Object)cID, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MyBinaryStoreChunkDB::writeBytes$$anonfun$1$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))).noSpaces()));
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)chunkIdArray));
    }

    private final Object writeBytes$$anonfun$1$$anonfun$2() {
        return "Write cannot access location " + new BinaryStore.LocationId(this.locationId);
    }

    private static final List readDataBytes$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        DecoderNotDeriveSum f$proxy2;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy2 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy3 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy4 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private final Function1 readDataBytes$$anonfun$1$$anonfun$2() {
        MyBinaryStoreChunkDB$CID$ myBinaryStoreChunkDB$CID$ = this.CID();
        return (Function1 & Serializable)p -> (CID)myBinaryStoreChunkDB$CID$.fromProduct((Product)p);
    }

    private static final Product readDataBytes$$anonfun$1$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private final /* synthetic */ Option readDataBytes$$anonfun$1(String cid) {
        String string = "locationId";
        String string2 = "contentId";
        int size = 2;
        return io.circe.parser.package$.MODULE$.decode(cid, Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("CID", MyBinaryStoreChunkDB::readDataBytes$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), this::readDataBytes$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(MyBinaryStoreChunkDB::readDataBytes$$anonfun$1$$anonfun$3))))).toOption();
    }

    private static final Object readDataBytes$$anonfun$2$$anonfun$1$$anonfun$1(CID cid$3) {
        return "Read cannot access contentId " + cid$3.locationId() + ":" + cid$3.contentId();
    }

    private static final Object readDataBytes$$anonfun$2$$anonfun$2(CID cid$4) {
        return "Read cannot access location " + cid$4.locationId();
    }

    private static final Object readDataBytes$$anonfun$3(List shas$1) {
        return "Invalid chunkIds: " + shas$1;
    }

    private static final Object expiryCleanerT$$anonfun$1$$anonfun$1$$anonfun$1(List all$1) {
        return "expiryCleaner looking at " + all$1.size() + " items";
    }

    private final /* synthetic */ Observable $anonfun$1(BinaryStore.Location location$2, String cid) {
        return this.toObservable(this.getExpiryInfo(location$2, cid));
    }

    private static final Object expiryCleanerT$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1(long count$1, long now$3) {
        return "expiryCleaner removed " + count$1 + " expired results, elapsedTime: " + (System.currentTimeMillis() - now$3) + "ms";
    }

    private final Object expiryCleanerT$$anonfun$1$$anonfun$2() {
        return "ExpiryCleaner can't access " + this.locationId;
    }

    private static final Object expiryCleanerT$$anonfun$2$$anonfun$1(Throwable ex$1) {
        return "Expiry cleaner failed due to " + ex$1;
    }

    private final /* synthetic */ ExpiryInfo toExpiryInfo$$anonfun$1(String cid$8, long expiresAt) {
        return this.ExpiryInfo().apply(cid$8, expiresAt);
    }

    public final class CID
    implements Product,
    Serializable {
        private final String locationId;
        private final String contentId;
        private final /* synthetic */ MyBinaryStoreChunkDB $outer;

        public CID(MyBinaryStoreChunkDB $outer, String locationId, String contentId) {
            this.locationId = locationId;
            this.contentId = contentId;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CID)) return false;
            if (((CID)object).ambience$queue$overflow$MyBinaryStoreChunkDB$CID$$$outer() != this.$outer) return false;
            CID cID = (CID)object;
            String string = this.locationId();
            String string2 = cID.locationId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.contentId();
            String string4 = cID.contentId();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CID;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CID";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "locationId";
            }
            if (1 == n2) {
                return "contentId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String locationId() {
            return this.locationId;
        }

        public String contentId() {
            return this.contentId;
        }

        public CID copy(String locationId, String contentId) {
            return new CID(this.$outer, locationId, contentId);
        }

        public String copy$default$1() {
            return this.locationId();
        }

        public String copy$default$2() {
            return this.contentId();
        }

        public String _1() {
            return this.locationId();
        }

        public String _2() {
            return this.contentId();
        }

        public final /* synthetic */ MyBinaryStoreChunkDB ambience$queue$overflow$MyBinaryStoreChunkDB$CID$$$outer() {
            return this.$outer;
        }
    }

    public final class ExpiryInfo
    implements Product,
    Serializable {
        private final String cid;
        private final long expiresAt;
        private final /* synthetic */ MyBinaryStoreChunkDB $outer;

        public ExpiryInfo(MyBinaryStoreChunkDB $outer, String cid, long expiresAt) {
            this.cid = cid;
            this.expiresAt = expiresAt;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new BinaryStore.ContentId(this.cid())));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.expiresAt()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExpiryInfo)) return false;
            if (((ExpiryInfo)object).ambience$queue$overflow$MyBinaryStoreChunkDB$ExpiryInfo$$$outer() != this.$outer) return false;
            ExpiryInfo expiryInfo = (ExpiryInfo)object;
            if (this.expiresAt() != expiryInfo.expiresAt()) return false;
            String string = this.cid();
            String string2 = expiryInfo.cid();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExpiryInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ExpiryInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return new BinaryStore.ContentId(this._1());
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cid";
            }
            if (1 == n2) {
                return "expiresAt";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String cid() {
            return this.cid;
        }

        public long expiresAt() {
            return this.expiresAt;
        }

        public ExpiryInfo copy(String cid, long expiresAt) {
            return new ExpiryInfo(this.$outer, cid, expiresAt);
        }

        public String copy$default$1() {
            return this.cid();
        }

        public long copy$default$2() {
            return this.expiresAt();
        }

        public String _1() {
            return this.cid();
        }

        public long _2() {
            return this.expiresAt();
        }

        public final /* synthetic */ MyBinaryStoreChunkDB ambience$queue$overflow$MyBinaryStoreChunkDB$ExpiryInfo$$$outer() {
            return this.$outer;
        }
    }
}

