/*
 * Decompiled with CFR 0.152.
 */
package ambience.session;

import ambience.module.Launcher;
import ambience.module.ProjectConfig;
import ambience.session.SessionManager;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MinuteMinder;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.AtomicInt$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class IdleWatcher
implements LoggingHelper2 {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(IdleWatcher.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(IdleWatcher.class.getDeclaredField("ShutDownAfter$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(IdleWatcher.class.getDeclaredField("Enabled$lzy1"));
    private volatile Object log$lzy1;
    private final Launcher launcher;
    private final ProjectConfig projectConfig;
    private final SessionManager sessionManager;
    private final AuditAPI.AuditAppender auditAppender;
    private final Scheduler scheduler;
    private final AuditAPI.Component auditComponent;
    private volatile Object Enabled$lzy1;
    private volatile Object ShutDownAfter$lzy1;
    private final AtomicInt zeroCount;
    private final AtomicBoolean enabled;

    public IdleWatcher(Launcher launcher, ProjectConfig projectConfig, SessionManager sessionManager, MinuteMinder minuteMinder, AuditAPI.AuditAppender auditAppender) {
        this.launcher = launcher;
        this.projectConfig = projectConfig;
        this.sessionManager = sessionManager;
        this.auditAppender = auditAppender;
        this.scheduler = Scheduler$.MODULE$.global();
        this.auditComponent = AuditAPI.Component$.MODULE$.apply("kernel", "idle-watcher");
        this.zeroCount = AtomicInt$.MODULE$.apply(0);
        this.enabled = AtomicBoolean$.MODULE$.apply(this.Enabled());
        if (this.Enabled()) {
            this.log().info(this::$init$$$anonfun$1, Line$.MODULE$.apply(28), FullName$.MODULE$.apply("ambience.session.IdleWatcher"));
        }
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public AuditAPI.Component auditComponent() {
        return this.auditComponent;
    }

    public boolean Enabled() {
        Object object = this.Enabled$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.Enabled$lzyINIT1());
    }

    private Object Enabled$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Enabled$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.projectConfig.config().getBoolean("ambience.idle-watcher.enabled"));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Enabled$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public long ShutDownAfter() {
        Object object = this.ShutDownAfter$lzy1;
        if (object instanceof Long) {
            return BoxesRunTime.unboxToLong((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToLong(null);
        }
        return BoxesRunTime.unboxToLong((Object)this.ShutDownAfter$lzyINIT1());
    }

    private Object ShutDownAfter$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ShutDownAfter$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Long l = null;
                    try {
                        l = BoxesRunTime.boxToLong((long)package$.MODULE$.max(1L, this.projectConfig.config().getDuration("ambience.idle-watcher.shutdown-after").toMinutes()));
                        object2 = l == null ? LazyVals.NullValue$.MODULE$ : l;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ShutDownAfter$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return l;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void tick() {
        if (this.enabled.get()) {
            this.run().runToFuture(this.scheduler()).recover((PartialFunction)new Serializable(this){
                private final /* synthetic */ IdleWatcher $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    this.$outer.log().error(() -> IdleWatcher.ambience$session$IdleWatcher$$anon$1$$_$applyOrElse$$anonfun$1(x), x, Line$.MODULE$.apply(32), FullName$.MODULE$.apply("ambience.session.IdleWatcher.tick"));
                    return BoxedUnit.UNIT;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$session$IdleWatcher$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
                }
            }, (ExecutionContext)this.scheduler());
            return;
        }
    }

    public Task<BoxedUnit> run() {
        return this.sessionManager.getActiveSessionCount().map((Function1)(JFunction1.mcVI.sp & Serializable)count -> {
            this.log().debug(() -> this.run$$anonfun$1$$anonfun$1(count), Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.session.IdleWatcher.run"));
            if (count == 0) {
                if ((long)this.zeroCount.get() >= this.ShutDownAfter()) {
                    this.enabled.set(false);
                    this.doShutdown().runAsyncAndForget(Scheduler$.MODULE$.global());
                    return;
                }
                this.zeroCount.add(1);
                return;
            }
            this.zeroCount.set(0);
        });
    }

    public Task<BoxedUnit> doShutdown() {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.doShutdown$$anonfun$1();
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.launcher.terminateWeb(this.projectConfig).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.doShutdown$$anonfun$2$$anonfun$1$$anonfun$1();
                    return BoxedUnit.UNIT;
                }).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                        this.doShutdown$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1();
                        return BoxedUnit.UNIT;
                    }).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                            this.doShutdown$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1();
                            return BoxedUnit.UNIT;
                        }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    });
                });
            });
        });
    }

    private final Object $init$$$anonfun$1() {
        return "Enabled with shutdown after " + this.ShutDownAfter() + " minutes";
    }

    public static final Object ambience$session$IdleWatcher$$anon$1$$_$applyOrElse$$anonfun$1(Throwable x$1) {
        return "Tick error: " + x$1;
    }

    private final Object run$$anonfun$1$$anonfun$1(int count$1) {
        return "Active sessions: " + count$1 + ", zeroCount: " + this.zeroCount.get();
    }

    private static final Object doShutdown$$anonfun$1$$anonfun$1() {
        return "Web terminate starting";
    }

    private final void doShutdown$$anonfun$1() {
        this.log().info(IdleWatcher::doShutdown$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(54), FullName$.MODULE$.apply("ambience.session.IdleWatcher.doShutdown"));
    }

    private static final Object doShutdown$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "Shutdown starting";
    }

    private final void doShutdown$$anonfun$2$$anonfun$1$$anonfun$1() {
        this.log().info(IdleWatcher::doShutdown$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(56), FullName$.MODULE$.apply("ambience.session.IdleWatcher.doShutdown"));
    }

    private final void doShutdown$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1() {
        this.auditAppender.append(AuditAPI.AuditMessage$.MODULE$.apply("", this.auditComponent(), AuditAPI.Success$.MODULE$.apply("Ambience", "Shutdown", AuditAPI.Success$.MODULE$.apply$default$3(), AuditAPI.Success$.MODULE$.apply$default$4())));
    }

    private final void doShutdown$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1() {
        this.launcher.shutdown();
    }
}

