/*
 * Decompiled with CFR 0.152.
 */
package ambience.sso.client;

import ambience.sso.client.ClientHandler$;
import ambience.sso.client.ClientModel;
import ambience.sso.client.ClientModel$AccessToken$;
import ambience.sso.client.ClientModel$AuthGranted$;
import ambience.sso.client.ClientModel$AuthUserInfo$;
import ambience.sso.client.ClientModel$AwaitingAuth$;
import ambience.sso.client.ClientModel$Expires$;
import ambience.sso.client.ClientModel$ExpiresAt$;
import ambience.sso.client.ClientModel$ExpiresIn$;
import ambience.sso.client.ClientModel$Reply$;
import ambience.sso.client.ClientModel$State$;
import ambience.sso.client.ClientModel$Token$;
import ambience.sso.client.ClientModel$When$;
import ambience.sso.client.SSOClientState;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.HttpClientRequest$;
import com.elixirtech.arch.HttpClientResponse;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.json.JsonLens$;
import com.typesafe.config.Config;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monocle.POptional;
import org.apache.commons.codec.binary.Base64;
import org.owasp.encoder.Encode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3$;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ClientHandler {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ClientHandler.class.getDeclaredField("localInfoSupplier$lzy1"));
    private final SSOClientState clientState;
    private final Decoder<ClientModel.Reply> replyDecoder;
    private final Scheduler scheduler;
    private volatile Object localInfoSupplier$lzy1;
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(ClientHandler$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(ClientHandler$.class.getDeclaredField("ExtraRequestHeaders$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ClientHandler$.class.getDeclaredField("config$lzy1"));

    public static Map<String, String> ExtraRequestHeaders() {
        return ClientHandler$.MODULE$.ExtraRequestHeaders();
    }

    public static Config config() {
        return ClientHandler$.MODULE$.config();
    }

    public static LoggingInterface log() {
        return ClientHandler$.MODULE$.log();
    }

    public static Either<String, ClientModel.AuthUserInfo> unpackToken(ClientModel.ServiceDefinition serviceDefinition, ClientModel.AuthGranted authGranted) {
        return ClientHandler$.MODULE$.unpackToken(serviceDefinition, authGranted);
    }

    public ClientHandler(SSOClientState clientState) {
        this.clientState = clientState;
        String string = "refresh_token";
        String string2 = "access_token";
        String string3 = "expires_in";
        int size = 3;
        this.replyDecoder = ConfiguredDecoder$.MODULE$.inline$ofProduct("Reply", ClientHandler::$init$$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ClientHandler::$init$$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ClientHandler::$init$$$anonfun$3));
        this.scheduler = Scheduler$.MODULE$.global();
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Option<ClientModel.LocalInfoSupplier> localInfoSupplier() {
        Object object = this.localInfoSupplier$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.localInfoSupplier$lzyINIT1();
    }

    private Object localInfoSupplier$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.localInfoSupplier$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = Try$.MODULE$.apply(ClientHandler::localInfoSupplier$lzyINIT1$$anonfun$1).toOption();
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.localInfoSupplier$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<BoxedUnit> logDebug(ClientModel.ServiceDefinition s, Function0<String> msg) {
        if (s.debug()) {
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                ClientHandler.logDebug$$anonfun$1(msg);
                return BoxedUnit.UNIT;
            });
        }
        return Task$.MODULE$.unit();
    }

    public Task<String> getRedirectURIT(ClientModel.ServiceDefinition s, String responseType, String scope, String originalUri) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> new ClientModel.State(this.getRedirectURIT$$anonfun$1())).flatMap((Function1 & Serializable)state -> this.getRedirectURIT$$anonfun$2(s, originalUri, responseType, scope, state == null ? null : ((ClientModel.State)state).value()));
    }

    public String getRedirectURIT$default$2() {
        return "code";
    }

    public String buildRedirectURI(ClientModel.ServiceDefinition s, String responseType, String scope, String state, String codeVerifier) {
        return s.authorizationEndpoint() + ("?client_id=" + this.escapeUriParameter(s.clientId())) + ("&response_type=" + this.escapeUriParameter(responseType)) + ("&redirect_uri=" + this.escapeUriParameter(s.clientEndpoint())) + ("&scope=" + this.escapeUriParameter(scope)) + ("&elx_now=" + System.currentTimeMillis()) + ("&state=" + this.escapeUriParameter(state)) + this.pkceExtras(s, codeVerifier) + s.authorizationSuffix();
    }

    public String buildCodeVerifier(ClientModel.ServiceDefinition s) {
        if (s.requiresPKCE()) {
            return this.encodeB64(UUID.randomUUID().toString() + UUID.randomUUID().toString());
        }
        return "";
    }

    public String encodeB64(String s) {
        return this.encodeB64(s.getBytes(Crypt$.MODULE$.DEFAULT_ENCODING()));
    }

    public String encodeB64(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes, (boolean)false, (boolean)true), Crypt$.MODULE$.DEFAULT_ENCODING());
    }

    public String pkceExtras(ClientModel.ServiceDefinition s, String codeVerifier) {
        if (s.requiresPKCE()) {
            String codeChallenge = this.hashSHA256(codeVerifier);
            return "&code_challenge=" + codeChallenge + "&code_challenge_method=S256";
        }
        return "";
    }

    public String hashSHA256(String s) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return this.encodeB64(md.digest(s.getBytes(Crypt$.MODULE$.DEFAULT_ENCODING())));
    }

    public String escapeUriParameter(String s) {
        return Encode.forUriComponent((String)s);
    }

    public Task<Map<String, String>> withClientSecretT(ClientModel.ServiceDefinition s2, Map<String, String> map) {
        Option<Task<ClientModel.ClientSecret>> option = s2.clientSecret();
        if (option instanceof Some) {
            Task ts = (Task)((Some)option).value();
            return ts.map((Function1 & Serializable)s -> ClientHandler.withClientSecretT$$anonfun$1(map, s == null ? null : ((ClientModel.ClientSecret)s).value()));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now(map);
        }
        throw new MatchError(option);
    }

    public Map<String, String> withPKCE(ClientModel.ServiceDefinition s, String codeVerifier, Map<String, String> map) {
        if (s.requiresPKCE()) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"code_verifier");
            return (Map)map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)codeVerifier));
        }
        return map;
    }

    public Task<Map<String, String>> getTokenFormDataT(ClientModel.ServiceDefinition s, String code, String codeVerifier) {
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"client_id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)s.clientId());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"grant_type");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"authorization_code");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)code);
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"redirect_uri");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)s.clientEndpoint());
        Map base = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.withClientSecretT(s, this.withPKCE(s, codeVerifier, (Map<String, String>)base)).map((Function1 & Serializable)map -> {
            if (s.debug()) {
                ClientHandler$.MODULE$.log().info(() -> ClientHandler.getTokenFormDataT$$anonfun$1$$anonfun$1(map), Line$.MODULE$.apply(159), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.getTokenFormDataT"));
            }
            return map;
        });
    }

    public Task<Either<String, ClientModel.AuthUserInfo>> getAuthUserInfo(ClientModel.ServiceDefinition s, ClientModel.AuthGranted authGranted) {
        if (s.userInfoEndpoint().isEmpty()) {
            return Task$.MODULE$.apply(() -> ClientHandler.getAuthUserInfo$$anonfun$1(s, authGranted));
        }
        String string = s.userInfoEndpoint();
        String string2 = "local";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Option<ClientModel.LocalInfoSupplier> option = this.localInfoSupplier();
            if (option instanceof Some) {
                ClientModel.LocalInfoSupplier lis = (ClientModel.LocalInfoSupplier)((Some)option).value();
                return this.localInfoRequest(lis, s, authGranted);
            }
            if (None$.MODULE$.equals(option)) {
                ClientHandler$.MODULE$.log().warn(ClientHandler::getAuthUserInfo$$anonfun$2, Line$.MODULE$.apply(170), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.getAuthUserInfo"));
                return this.sendUserInfoRequest(s, authGranted);
            }
            throw new MatchError(option);
        }
        return this.sendUserInfoRequest(s, authGranted);
    }

    public Task<Either<String, ClientModel.AuthUserInfo>> localInfoRequest(ClientModel.LocalInfoSupplier lis, ClientModel.ServiceDefinition s, ClientModel.AuthGranted authGranted) {
        return lis.lookup(authGranted.at()).map((Function1 & Serializable)reply -> reply.map((Function1 & Serializable)json -> {
            if (s.debug()) {
                ClientHandler$.MODULE$.log().info(() -> ClientHandler.localInfoRequest$$anonfun$1$$anonfun$1$$anonfun$1(authGranted), Line$.MODULE$.apply(181), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.localInfoRequest"));
                ClientHandler$.MODULE$.log().info(() -> ClientHandler.localInfoRequest$$anonfun$1$$anonfun$1$$anonfun$2(json), Line$.MODULE$.apply(182), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.localInfoRequest"));
            }
            return ClientModel$AuthUserInfo$.MODULE$.apply(authGranted, (Json)json);
        }));
    }

    public Task<Either<String, ClientModel.AuthUserInfo>> sendUserInfoRequest(ClientModel.ServiceDefinition s, ClientModel.AuthGranted authGranted) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Authorization");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)("Bearer " + authGranted.at().token()));
        Map requestHeaders = (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus(ClientHandler$.MODULE$.ExtraRequestHeaders());
        if (s.debug()) {
            ClientHandler$.MODULE$.log().info(() -> ClientHandler.sendUserInfoRequest$$anonfun$1(requestHeaders), Line$.MODULE$.apply(191), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.sendUserInfoRequest"));
        }
        return HttpClientRequest$.MODULE$.getT(s.userInfoEndpoint(), Predef$.MODULE$.Map().empty(), requestHeaders).map((Function1 & Serializable)response -> {
            if (response.statusCode() == 200) {
                Either either = io.circe.parser.package$.MODULE$.parse(response.bodyUtf8());
                if (either instanceof Right) {
                    Json json = (Json)((Right)either).value();
                    if (s.debug()) {
                        ClientHandler$.MODULE$.log().info(() -> ClientHandler.sendUserInfoRequest$$anonfun$2$$anonfun$1(authGranted), Line$.MODULE$.apply(197), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.sendUserInfoRequest"));
                        ClientHandler$.MODULE$.log().info(() -> ClientHandler.sendUserInfoRequest$$anonfun$2$$anonfun$2(json), Line$.MODULE$.apply(198), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.sendUserInfoRequest"));
                    }
                    return Right$.MODULE$.apply((Object)ClientModel$AuthUserInfo$.MODULE$.apply(authGranted, json));
                }
                if (either instanceof Left) {
                    ParsingFailure err = (ParsingFailure)((Left)either).value();
                    return Left$.MODULE$.apply((Object)("Can't read json " + response.bodyUtf8() + " " + err));
                }
                throw new MatchError((Object)either);
            }
            if (s.debug()) {
                ClientHandler$.MODULE$.log().error(() -> ClientHandler.sendUserInfoRequest$$anonfun$2$$anonfun$3(response), Line$.MODULE$.apply(206), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.sendUserInfoRequest"));
                ClientHandler$.MODULE$.log().error(() -> ClientHandler.sendUserInfoRequest$$anonfun$2$$anonfun$4(response), Line$.MODULE$.apply(207), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.sendUserInfoRequest"));
                ClientHandler$.MODULE$.log().error(() -> ClientHandler.sendUserInfoRequest$$anonfun$2$$anonfun$5(response), Line$.MODULE$.apply(208), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.sendUserInfoRequest"));
            }
            return Left$.MODULE$.apply((Object)("GetAuthUserInfo got a " + response.statusCode()));
        });
    }

    public Task<Either<String, ClientModel.AuthGranted>> convertToToken(ClientModel.ServiceDefinition s, String code, String state) {
        return this.clientState.get(state).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ClientModel.AwaitingAuth awaitingAuth = (ClientModel.AwaitingAuth)((Some)option).value();
                return this.clientState.delete(state).flatMap((Function1 & Serializable)_$1 -> this.getToken(s, code, awaitingAuth));
            }
            if (None$.MODULE$.equals(option)) {
                ClientHandler$.MODULE$.log().warn(() -> ClientHandler.convertToToken$$anonfun$1$$anonfun$2(state), Line$.MODULE$.apply(224), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.convertToToken"));
                return Task$.MODULE$.now((Object)Left$.MODULE$.apply((Object)"Error: invalid state"));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<String, ClientModel.AuthGranted>> getToken(ClientModel.ServiceDefinition s, String code, ClientModel.AwaitingAuth awaitingAuth) {
        String string = s.tokenEndpoint();
        String string2 = "local";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Option<ClientModel.LocalInfoSupplier> option = this.localInfoSupplier();
            if (option instanceof Some) {
                ClientModel.LocalInfoSupplier lis = (ClientModel.LocalInfoSupplier)((Some)option).value();
                return this.getLocalToken(lis, s, code, awaitingAuth);
            }
            if (None$.MODULE$.equals(option)) {
                return this.getRemoteToken(s, code, awaitingAuth);
            }
            throw new MatchError(option);
        }
        return this.getRemoteToken(s, code, awaitingAuth);
    }

    public Task<Either<String, ClientModel.AuthGranted>> getLocalToken(ClientModel.LocalInfoSupplier lis, ClientModel.ServiceDefinition s, String code, ClientModel.AwaitingAuth awaitingAuth) {
        return lis.getAccessToken(code).map((Function1 & Serializable)ereply -> ereply.map((Function1 & Serializable)reply -> this.replyToAuthGranted(s, awaitingAuth.originalUri(), (ClientModel.Reply)reply)));
    }

    public Task<Either<String, ClientModel.AuthGranted>> getRemoteToken(ClientModel.ServiceDefinition s, String code, ClientModel.AwaitingAuth awaitingAuth) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Accept");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"application/json; q=1.0f");
        Map requestHeaders = (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus(ClientHandler$.MODULE$.ExtraRequestHeaders());
        return this.getTokenFormDataT(s, code, awaitingAuth.codeVerifier()).flatMap((Function1 & Serializable)form -> {
            if (s.debug()) {
                ClientHandler$.MODULE$.log().info(() -> ClientHandler.getRemoteToken$$anonfun$1$$anonfun$1(form), Line$.MODULE$.apply(251), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.getRemoteToken"));
            }
            return HttpClientRequest$.MODULE$.postT(s.tokenEndpoint(), form, requestHeaders).flatMap((Function1 & Serializable)response -> {
                if (response.statusCode() == 200) {
                    return this.buildAuthGranted(s, response.bodyUtf8(), awaitingAuth.originalUri());
                }
                ClientHandler$.MODULE$.log().warn(() -> ClientHandler.getRemoteToken$$anonfun$1$$anonfun$2$$anonfun$1(s, response), Line$.MODULE$.apply(255), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.getRemoteToken"));
                return Task$.MODULE$.now((Object)Left$.MODULE$.apply((Object)("Get Token got a " + response.statusCode())));
            });
        });
    }

    private Task<Either<String, ClientModel.AuthGranted>> buildAuthGranted(ClientModel.ServiceDefinition s, String entityString, String originalUri) {
        return Task$.MODULE$.apply(() -> this.buildAuthGranted$$anonfun$1(entityString, s, originalUri));
    }

    public Json fixupChosenToken(ClientModel.ServiceDefinition s, Json json) {
        POptional IdTokenLens = JsonLens$.MODULE$.root().selectDynamic("id_token").string();
        if (s.useIdToken()) {
            return (Json)IdTokenLens.getOption((Object)json).map((Function1 & Serializable)id -> {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"access_token");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(id));
                return json.deepMerge(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }).getOrElse(() -> ClientHandler.fixupChosenToken$$anonfun$2(json));
        }
        return json;
    }

    public ClientModel.AuthGranted replyToAuthGranted(ClientModel.ServiceDefinition s, String originalUri, ClientModel.Reply reply) {
        if (s.debug()) {
            ClientHandler$.MODULE$.log().info(() -> ClientHandler.replyToAuthGranted$$anonfun$1(reply), Line$.MODULE$.apply(291), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.replyToAuthGranted"));
        }
        long now = System.currentTimeMillis();
        ClientModel.AccessToken at = ClientModel$AccessToken$.MODULE$.apply(ClientModel$Token$.MODULE$.apply(reply.access_token()), (Option<ClientModel.Expires>)reply.expires_in().map((Function1 & Serializable)ei -> ClientModel$Expires$.MODULE$.apply(ClientModel$ExpiresIn$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)ei)), ClientModel$ExpiresAt$.MODULE$.apply(now + BoxesRunTime.unboxToLong((Object)ei) * 1000L))));
        Option rt = reply.refresh_token().map((Function1 & Serializable)_$2 -> new ClientModel.Token(ClientModel$Token$.MODULE$.apply(_$2)));
        if (s.debug()) {
            ClientHandler$.MODULE$.log().info(() -> ClientHandler.replyToAuthGranted$$anonfun$2(at, rt), Line$.MODULE$.apply(296), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.replyToAuthGranted"));
        }
        return ClientModel$AuthGranted$.MODULE$.apply(at, (Option<ClientModel.Token>)rt, originalUri);
    }

    private String genState() {
        return ClientModel$State$.MODULE$.apply(UUID.randomUUID().toString());
    }

    private static final List $init$$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        DecoderNotDeriveSum f$proxy1;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy1 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy1;
        Configuration x$2$proxy3 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeLong());
        return package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 $init$$$anonfun$2() {
        ClientModel$Reply$ clientModel$Reply$ = ClientModel$Reply$.MODULE$;
        return (Function1 & Serializable)p -> (ClientModel.Reply)clientModel$Reply$.fromProduct((Product)p);
    }

    private static final Product $init$$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final ClientModel.LocalInfoSupplier localInfoSupplier$lzyINIT1$$anonfun$1() {
        return (ClientModel.LocalInfoSupplier)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ClientModel.LocalInfoSupplier.class));
    }

    private static final void logDebug$$anonfun$1(Function0 msg$1) {
        ClientHandler$.MODULE$.log().info(msg$1, Line$.MODULE$.apply(71), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.logDebug"));
    }

    private final String getRedirectURIT$$anonfun$1() {
        return this.genState();
    }

    private static final String getRedirectURIT$$anonfun$2$$anonfun$1(String state$1) {
        return "In getRedirectURI with new state: " + state$1;
    }

    private final String getRedirectURIT$$anonfun$2$$anonfun$2$$anonfun$1(ClientModel.ServiceDefinition s$3) {
        return this.buildCodeVerifier(s$3);
    }

    private static final String getRedirectURIT$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(String state$4) {
        return "Saving state " + state$4;
    }

    private static final String getRedirectURIT$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(String state$7) {
        return "state " + new ClientModel.State(state$7) + " has been stored";
    }

    private final String getRedirectURIT$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(ClientModel.ServiceDefinition s$8, String responseType$7, String scope$7, String state$9, String codeVerifier$4) {
        return this.buildRedirectURI(s$8, responseType$7, scope$7, state$9, codeVerifier$4);
    }

    private final /* synthetic */ Task getRedirectURIT$$anonfun$2(ClientModel.ServiceDefinition s$1, String originalUri$1, String responseType$1, String scope$1, String state) {
        return this.logDebug(s$1, (Function0<String>)((Function0 & Serializable)() -> ClientHandler.getRedirectURIT$$anonfun$2$$anonfun$1(state))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply(() -> this.getRedirectURIT$$anonfun$2$$anonfun$2$$anonfun$1(s$1)).flatMap((Function1 & Serializable)codeVerifier -> this.logDebug(s$1, (Function0<String>)((Function0 & Serializable)() -> ClientHandler.getRedirectURIT$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(state))).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.clientState.set(state, ClientModel$AwaitingAuth$.MODULE$.apply(ClientModel$When$.MODULE$.apply(System.currentTimeMillis()), state, (String)codeVerifier, originalUri$1)).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.logDebug(s$1, (Function0<String>)((Function0 & Serializable)() -> ClientHandler.getRedirectURIT$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(state))).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return Task$.MODULE$.apply(() -> this.getRedirectURIT$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(s$1, responseType$1, scope$1, state, codeVerifier)).map((Function1 & Serializable)reply -> reply);
                    });
                });
            }));
        });
    }

    private static final /* synthetic */ Map withClientSecretT$$anonfun$1(Map map$1, String s) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"client_secret");
        return (Map)map$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)s));
    }

    private static final Object getTokenFormDataT$$anonfun$1$$anonfun$1(Map map$2) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"client_secret");
        return "getting token " + map$2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"XXX"));
    }

    private static final Either getAuthUserInfo$$anonfun$1(ClientModel.ServiceDefinition s$10, ClientModel.AuthGranted authGranted$1) {
        return ClientHandler$.MODULE$.unpackToken(s$10, authGranted$1);
    }

    private static final Object getAuthUserInfo$$anonfun$2() {
        return "userInfoEndpoint==local but no LocalInfoSupplier found";
    }

    private static final Object localInfoRequest$$anonfun$1$$anonfun$1$$anonfun$1(ClientModel.AuthGranted authGranted$4) {
        return "localInfoRequest authGranted=" + authGranted$4;
    }

    private static final Object localInfoRequest$$anonfun$1$$anonfun$1$$anonfun$2(Json json$1) {
        return "localInfoRequest json=" + json$1.noSpaces();
    }

    private static final Object sendUserInfoRequest$$anonfun$1(Map requestHeaders$1) {
        return "getAuthUserInfo requestHeaders=" + requestHeaders$1;
    }

    private static final Object sendUserInfoRequest$$anonfun$2$$anonfun$1(ClientModel.AuthGranted authGranted$6) {
        return "getAuthUserInfo authGranted=" + authGranted$6;
    }

    private static final Object sendUserInfoRequest$$anonfun$2$$anonfun$2(Json json$2) {
        return "getAuthUserInfo json=" + json$2.noSpaces();
    }

    private static final Object sendUserInfoRequest$$anonfun$2$$anonfun$3(HttpClientResponse response$1) {
        return "getAuthUserInfo got response status " + response$1.statusCode();
    }

    private static final Object sendUserInfoRequest$$anonfun$2$$anonfun$4(HttpClientResponse response$2) {
        return "getAuthUserInfo got response headers " + response$2.headers().mkString("\n");
    }

    private static final Object sendUserInfoRequest$$anonfun$2$$anonfun$5(HttpClientResponse response$3) {
        return "getAuthUserInfo got response entity " + response$3.bodyUtf8();
    }

    private static final Object convertToToken$$anonfun$1$$anonfun$2(String state$11) {
        return "convertToToken received invalid state " + state$11;
    }

    private static final Object getRemoteToken$$anonfun$1$$anonfun$1(Map form$1) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"client_secret");
        return "Sending entity " + form$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"XXX"));
    }

    private static final Object getRemoteToken$$anonfun$1$$anonfun$2$$anonfun$1(ClientModel.ServiceDefinition s$20, HttpClientResponse response$4) {
        return "Getting token from " + new ClientModel.TokenEndpoint(s$20.tokenEndpoint()) + " returned " + response$4.statusCode() + ": " + response$4.bodyUtf8();
    }

    private static final Object buildAuthGranted$$anonfun$1$$anonfun$1() {
        return "Can't read json reply";
    }

    private static final Object buildAuthGranted$$anonfun$1$$anonfun$2(ParsingFailure err$1) {
        return "Can't parse json: " + err$1;
    }

    private final Either buildAuthGranted$$anonfun$1(String entityString$1, ClientModel.ServiceDefinition s$21, String originalUri$5) {
        Either either = io.circe.parser.package$.MODULE$.parse(entityString$1);
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            Either either2 = this.fixupChosenToken(s$21, json).as(this.replyDecoder);
            if (either2 instanceof Right) {
                ClientModel.Reply reply = (ClientModel.Reply)((Right)either2).value();
                return Right$.MODULE$.apply((Object)this.replyToAuthGranted(s$21, originalUri$5, reply));
            }
            if (either2 instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either2).value();
                ClientHandler$.MODULE$.log().error(ClientHandler::buildAuthGranted$$anonfun$1$$anonfun$1, (Throwable)err, Line$.MODULE$.apply(272), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.buildAuthGranted"));
                return Left$.MODULE$.apply((Object)"Can't read json reply");
            }
            throw new MatchError((Object)either2);
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            ClientHandler$.MODULE$.log().error(() -> ClientHandler.buildAuthGranted$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(276), FullName$.MODULE$.apply("ambience.sso.client.ClientHandler.buildAuthGranted"));
            return Left$.MODULE$.apply((Object)"Can't parse json");
        }
        throw new MatchError((Object)either);
    }

    private static final Json fixupChosenToken$$anonfun$2(Json json$4) {
        return json$4;
    }

    private static final Object replyToAuthGranted$$anonfun$1(ClientModel.Reply reply$1) {
        return "buildAuthGranted reply=" + reply$1;
    }

    private static final Object replyToAuthGranted$$anonfun$2(ClientModel.AccessToken at$1, Option rt$1) {
        return "buildAuthGranted at=" + at$1 + " rt=" + rt$1;
    }
}

