/*
 * Decompiled with CFR 0.152.
 */
package ambience.sso.client;

import ambience.gravity.GravityHelper$;
import ambience.module.MaintenanceMode$;
import ambience.module.ProjectConfig;
import ambience.sso.client.ClientHandler;
import ambience.sso.client.ClientModel;
import ambience.sso.client.ClientModel$;
import ambience.sso.client.ClientModel$Code$;
import ambience.sso.client.ClientModel$Cookie$;
import ambience.sso.client.ClientModel$OriginalUri$;
import ambience.sso.client.ClientModel$RequestInfo$;
import ambience.sso.client.ClientModel$State$;
import ambience.sso.client.EndpointInterceptor$;
import ambience.sso.client.OAuth2CookieClient$;
import ambience.sso.client.SSOClientState;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingMixin;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityCookie;
import com.elixirtech.gravity.GravityCookie$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.typesafe.config.Config;
import io.circe.Decoder$;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class OAuth2CookieClient {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(OAuth2CookieClient.class.getDeclaredField("auditAppender$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(OAuth2CookieClient.class.getDeclaredField("service$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(OAuth2CookieClient.class.getDeclaredField("clientHandler$lzy1"));
    private String serviceName;
    private SSOClientState ssoClientState;
    private final Function1<Gravity.Path, Gravity.Path> uriMapper;
    private volatile Object clientHandler$lzy1;
    private volatile Object service$lzy1;
    private volatile Object auditAppender$lzy1;
    private final AuditAPI.Component auditComponent;
    private final AuditAPI.Component auditSessionComponent;
    private final Scheduler scheduler;
    public static final long OFFSET$_m_5 = LazyVals$.MODULE$.getOffsetStatic(OAuth2CookieClient$.class.getDeclaredField("GroupsMatcher$lzy1"));
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(OAuth2CookieClient$.class.getDeclaredField("GroupsField$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(OAuth2CookieClient$.class.getDeclaredField("OpenIdScope$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(OAuth2CookieClient$.class.getDeclaredField("OpenIdField$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(OAuth2CookieClient$.class.getDeclaredField("CookieName$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(OAuth2CookieClient$.class.getDeclaredField("config$lzy1"));

    public static String CookieName() {
        return OAuth2CookieClient$.MODULE$.CookieName();
    }

    public static String GroupsField() {
        return OAuth2CookieClient$.MODULE$.GroupsField();
    }

    public static String GroupsMatcher() {
        return OAuth2CookieClient$.MODULE$.GroupsMatcher();
    }

    public static String OpenIdField() {
        return OAuth2CookieClient$.MODULE$.OpenIdField();
    }

    public static String OpenIdScope() {
        return OAuth2CookieClient$.MODULE$.OpenIdScope();
    }

    public static Config config() {
        return OAuth2CookieClient$.MODULE$.config();
    }

    public static Function1<Gravity.Path, Gravity.Path> $lessinit$greater$default$3() {
        return OAuth2CookieClient$.MODULE$.$lessinit$greater$default$3();
    }

    public OAuth2CookieClient(String serviceName, SSOClientState ssoClientState, Function1<Gravity.Path, Gravity.Path> uriMapper) {
        this.serviceName = serviceName;
        this.ssoClientState = ssoClientState;
        this.uriMapper = uriMapper;
        this.auditComponent = AuditAPI.Component$.MODULE$.apply("kernel", "oauth2-client");
        this.auditSessionComponent = AuditAPI.Component$.MODULE$.apply("kernel", "session");
        this.scheduler = Scheduler$.MODULE$.global();
    }

    public ClientHandler clientHandler() {
        Object object = this.clientHandler$lzy1;
        if (object instanceof ClientHandler) {
            return (ClientHandler)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClientHandler)this.clientHandler$lzyINIT1();
    }

    private Object clientHandler$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.clientHandler$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClientHandler clientHandler = null;
                    try {
                        clientHandler = new ClientHandler(this.ssoClientState);
                        object2 = clientHandler == null ? LazyVals.NullValue$.MODULE$ : clientHandler;
                        this.ssoClientState = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.clientHandler$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clientHandler;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ClientModel.ServiceDefinition service() {
        Object object = this.service$lzy1;
        if (object instanceof ClientModel.ServiceDefinition) {
            return (ClientModel.ServiceDefinition)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClientModel.ServiceDefinition)this.service$lzyINIT1();
    }

    private Object service$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.service$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClientModel.ServiceDefinition serviceDefinition = null;
                    try {
                        serviceDefinition = ClientModel$.MODULE$.buildServiceDefinition(OAuth2CookieClient$.MODULE$.config().getConfig("service-definition"), this.serviceName);
                        object2 = serviceDefinition == null ? LazyVals.NullValue$.MODULE$ : serviceDefinition;
                        this.serviceName = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.service$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serviceDefinition;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.AuditAppender auditAppender() {
        Object object = this.auditAppender$lzy1;
        if (object instanceof AuditAPI.AuditAppender) {
            return (AuditAPI.AuditAppender)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AuditAPI.AuditAppender)this.auditAppender$lzyINIT1();
    }

    private Object auditAppender$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.auditAppender$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AuditAPI.AuditAppender auditAppender = null;
                    try {
                        auditAppender = (AuditAPI.AuditAppender)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(AuditAPI.AuditAppender.class));
                        object2 = auditAppender == null ? LazyVals.NullValue$.MODULE$ : auditAppender;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.auditAppender$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return auditAppender;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.Component auditComponent() {
        return this.auditComponent;
    }

    public AuditAPI.Component auditSessionComponent() {
        return this.auditSessionComponent;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public abstract Task<Either<String, GravityCookie>> buildCookie(ClientModel.RequestInfo var1, ClientModel.AuthUserInfo var2);

    public abstract Function1<GravityRequest, Task<GravityResponse>> decodeCookie(String var1, Function1<Option<ClientModel.UserInfo>, Function1<GravityRequest, Task<GravityResponse>>> var2);

    public abstract Task<BoxedUnit> logoutSession(String var1);

    public Function1<GravityRequest, Task<GravityResponse>> approve(Function1<ClientModel.UserInfo, Function1<GravityRequest, Task<GravityResponse>>> innerRoute) {
        return this.approve(OAuth2CookieClient$.MODULE$.OpenIdScope(), innerRoute);
    }

    public Function1<GravityRequest, Task<GravityResponse>> approve(String scope, Function1<ClientModel.UserInfo, Function1<GravityRequest, Task<GravityResponse>>> innerRoute) {
        return GravityHelper$.MODULE$.getCookie(OAuth2CookieClient$.MODULE$.CookieName(), (Function1<Option<GravityCookie>, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                GravityCookie c = (GravityCookie)((Some)option).value();
                return this.decodeCookie(ClientModel$Cookie$.MODULE$.apply(c.value()), (Function1<Option<ClientModel.UserInfo>, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        ClientModel.UserInfo userInfo = (ClientModel.UserInfo)((Some)option).value();
                        return (Function1)innerRoute.apply((Object)userInfo);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return this.getAuth(scope, "can't decode cookie");
                    }
                    throw new MatchError((Object)option);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return this.getAuth(scope, "no cookie");
            }
            throw new MatchError((Object)option);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> ifCookieApproved(Function1<ClientModel.UserInfo, Function1<GravityRequest, Task<GravityResponse>>> innerRoute, Function1<GravityRequest, Task<GravityResponse>> elseHandler) {
        return GravityHelper$.MODULE$.getCookie(OAuth2CookieClient$.MODULE$.CookieName(), (Function1<Option<GravityCookie>, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                GravityCookie c = (GravityCookie)((Some)option).value();
                return this.decodeCookie(ClientModel$Cookie$.MODULE$.apply(c.value()), (Function1<Option<ClientModel.UserInfo>, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        ClientModel.UserInfo userInfo = (ClientModel.UserInfo)((Some)option).value();
                        return (Function1)innerRoute.apply((Object)userInfo);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return elseHandler;
                    }
                    throw new MatchError((Object)option);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return elseHandler;
            }
            throw new MatchError((Object)option);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> ifCookieApproved$default$2() {
        return Gravity$.MODULE$.NotFoundHandler();
    }

    public String openIdField(ClientModel.UserInfo ui) {
        return (String)ui.json().hcursor().downField(OAuth2CookieClient$.MODULE$.OpenIdField()).as(Decoder$.MODULE$.decodeString()).getOrElse(OAuth2CookieClient::openIdField$$anonfun$1);
    }

    public Function1<GravityRequest, Task<GravityResponse>> endpoint() {
        return (Function1 & Serializable)request -> {
            Gravity.Method method = request.method();
            Gravity.Method method2 = Gravity$.MODULE$.GET();
            if (!(method != null ? !method.equals(method2) : method2 != null)) {
                Option optTask = request.parameters().get("code").flatMap((Function1 & Serializable)code -> request.parameters().get("state").map((Function1 & Serializable)state -> (Task)this.endpoint((String)code, (String)state).apply(request)));
                return (Task)optTask.getOrElse(OAuth2CookieClient::endpoint$$anonfun$1$$anonfun$1);
            }
            return Gravity$.MODULE$.MethodNotAllowedResponseT();
        };
    }

    public Function1<GravityRequest, Task<GravityResponse>> endpoint(String code, String state) {
        if (this.service().debug()) {
            ((LoggingMixin)this).log().info(() -> OAuth2CookieClient.endpoint$$anonfun$2(code, state), Line$.MODULE$.apply(91), FullName$.MODULE$.apply("ambience.sso.client.OAuth2CookieClient.endpoint"));
        }
        return EndpointInterceptor$.MODULE$.run(state, (Function1<GravityRequest, Task<GravityResponse>>)(Function1 & Serializable)request -> {
            Task<Either<String, ClientModel.AuthGranted>> fat = this.clientHandler().convertToToken(this.service(), ClientModel$Code$.MODULE$.apply(code), ClientModel$State$.MODULE$.apply(state));
            Task e = fat.flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    return Task$.MODULE$.now((Object)Left$.MODULE$.apply((Object)msg));
                }
                if (either instanceof Right) {
                    ClientModel.AuthGranted authGranted = (ClientModel.AuthGranted)((Right)either).value();
                    return this.clientHandler().getAuthUserInfo(this.service(), authGranted);
                }
                throw new MatchError((Object)either);
            });
            return e.flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    String rootUrl = ((ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class))).WebURL();
                    String html = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<html>\n               |<body>\n               |<h1>SSO Failed</h1>\n               |<p>" + msg + "</p>\n               |<p><a href=\"" + rootUrl + "\">Retry</a></p>\n               |</body>\n               |</html>"));
                    return Task$.MODULE$.now((Object)GravityResponse$.MODULE$.html(html));
                }
                if (either instanceof Right) {
                    ClientModel.AuthUserInfo ui = (ClientModel.AuthUserInfo)((Right)either).value();
                    Option optPeerIP = request.headers().get(Gravity$.MODULE$.ElxPeerIP());
                    return this.buildResponse(ClientModel$RequestInfo$.MODULE$.apply((Option<String>)optPeerIP, request.host()), ui);
                }
                throw new MatchError((Object)either);
            });
        });
    }

    public void auditSuccess(ClientModel.RequestInfo requestInfo, ClientModel.AuthUserInfo ui, GravityCookie cookie) {
        String sub = (String)ui.json().hcursor().downField(OAuth2CookieClient$.MODULE$.OpenIdField()).as(Decoder$.MODULE$.decodeString()).toOption().getOrElse(OAuth2CookieClient::$anonfun$3);
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"ip");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(requestInfo.requestIP()));
        String extras = ui.json().deepMerge(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).noSpaces();
        AuditAPI.Action action = AuditAPI.Success$.MODULE$.apply("sso-client", "Accepted", (Option)Some$.MODULE$.apply((Object)extras), AuditAPI.Success$.MODULE$.apply$default$4());
        AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(sub, this.auditComponent(), action);
        this.auditAppender().append(auditMsg);
    }

    public void auditFailure(ClientModel.RequestInfo requestInfo, ClientModel.AuthUserInfo ui, String err) {
        String sub = (String)ui.json().hcursor().downField(OAuth2CookieClient$.MODULE$.OpenIdField()).as(Decoder$.MODULE$.decodeString()).toOption().getOrElse(OAuth2CookieClient::$anonfun$4);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"ip");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(requestInfo.requestIP()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(err));
        String extras = ui.json().deepMerge(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).noSpaces();
        AuditAPI.Action action = AuditAPI.Failure$.MODULE$.apply("sso-client", "Rejected", (Option)Some$.MODULE$.apply((Object)extras), AuditAPI.Failure$.MODULE$.apply$default$4());
        AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(sub, this.auditComponent(), action);
        this.auditAppender().append(auditMsg);
    }

    public Function1<GravityRequest, Task<GravityResponse>> logout(String redirectTo, List<String> otherCookies) {
        return (Function1 & Serializable)request -> {
            Gravity.Method method = request.method();
            Gravity.Method method2 = Gravity$.MODULE$.POST();
            if (!(method != null ? !method.equals(method2) : method2 != null)) {
                ((LoggingMixin)this).log().info(() -> OAuth2CookieClient.logout$$anonfun$1$$anonfun$1(otherCookies), Line$.MODULE$.apply(142), FullName$.MODULE$.apply("ambience.sso.client.OAuth2CookieClient.logout"));
                Option option = request.cookies().get((Object)OAuth2CookieClient$.MODULE$.CookieName());
                if (option instanceof Some) {
                    GravityCookie c = (GravityCookie)((Some)option).value();
                    Gravity.Header delCookie = this.buildCookie(OAuth2CookieClient$.MODULE$.CookieName(), "deleted", (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L))).asSetCookieHeader();
                    return this.logoutSession(c.value()).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return Task$.MODULE$.apply(() -> this.logout$$anonfun$1$$anonfun$2$$anonfun$1(redirectTo, otherCookies, c, delCookie)).map((Function1 & Serializable)response -> response);
                    });
                }
                if (None$.MODULE$.equals(option)) {
                    ((LoggingMixin)this).log().info(() -> OAuth2CookieClient.logout$$anonfun$1$$anonfun$3(redirectTo), Line$.MODULE$.apply(151), FullName$.MODULE$.apply("ambience.sso.client.OAuth2CookieClient.logout"));
                    return Task$.MODULE$.now((Object)GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.apply(302), Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{Gravity.Header$.MODULE$.Location(redirectTo)})), GravityResponse$.MODULE$.$lessinit$greater$default$3()));
                }
                throw new MatchError((Object)option);
            }
            return Gravity$.MODULE$.MethodNotAllowedResponseT();
        };
    }

    public List<String> logout$default$2() {
        return package$.MODULE$.Nil();
    }

    public GravityResponse doLogout(String redirectTo, List<String> otherCookies, String cookieInfo) {
        List removeOthers = otherCookies.map((Function1 & Serializable)oc -> this.buildCookie((String)oc, "", this.buildCookie$default$3()).asSetCookieHeader());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.service().logoutEndpoint()))) {
            Gravity.Header redirect = Gravity.Header$.MODULE$.Location(this.service().logoutEndpoint() + "?ret=" + redirectTo + "&logout_uri=" + redirectTo + ("&client_id=" + this.service().clientId()));
            List removeCookies = removeOthers;
            Gravity.Headers headers = Gravity.Headers$.MODULE$.apply(removeCookies.$colon$colon((Object)redirect));
            ((LoggingMixin)this).log().debug(() -> OAuth2CookieClient.doLogout$$anonfun$1(cookieInfo), Line$.MODULE$.apply(169), FullName$.MODULE$.apply("ambience.sso.client.OAuth2CookieClient.doLogout"));
            return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.apply(302), headers, GravityResponse$.MODULE$.$lessinit$greater$default$3());
        }
        Gravity.Header redirect = Gravity.Header$.MODULE$.Location(redirectTo);
        List removeCookies = removeOthers;
        Gravity.Headers headers = Gravity.Headers$.MODULE$.apply(removeCookies.$colon$colon((Object)redirect));
        ((LoggingMixin)this).log().debug(() -> OAuth2CookieClient.doLogout$$anonfun$2(cookieInfo), Line$.MODULE$.apply(176), FullName$.MODULE$.apply("ambience.sso.client.OAuth2CookieClient.doLogout"));
        return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.apply(302), headers, GravityResponse$.MODULE$.$lessinit$greater$default$3());
    }

    public Function1<GravityRequest, Task<GravityResponse>> getAuth(String scope, String reason) {
        return (Function1 & Serializable)request -> {
            ((LoggingMixin)this).log().info(() -> OAuth2CookieClient.getAuth$$anonfun$1$$anonfun$1(scope, reason), Line$.MODULE$.apply(182), FullName$.MODULE$.apply("ambience.sso.client.OAuth2CookieClient.getAuth"));
            Gravity.Path originalUri = request.path();
            return this.clientHandler().getRedirectURIT(this.service(), "code", scope, ClientModel$OriginalUri$.MODULE$.apply(((Gravity.Path)this.uriMapper.apply((Object)originalUri)).toString())).map((Function1 & Serializable)uri -> {
                ((LoggingMixin)this).log().debug(() -> OAuth2CookieClient.getAuth$$anonfun$1$$anonfun$2$$anonfun$1(uri), Line$.MODULE$.apply(185), FullName$.MODULE$.apply("ambience.sso.client.OAuth2CookieClient.getAuth"));
                Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{Gravity.Header$.MODULE$.Location(uri)}));
                return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.TemporaryRedirect(), headers, GravityResponse$.MODULE$.$lessinit$greater$default$3());
            });
        };
    }

    public Task<GravityResponse> buildResponse(ClientModel.RequestInfo requestInfo, ClientModel.AuthUserInfo ui) {
        return this.buildCookie(requestInfo, ui).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                GravityCookie cookie = (GravityCookie)((Right)either).value();
                ((LoggingMixin)this).log().info(() -> OAuth2CookieClient.buildResponse$$anonfun$1$$anonfun$1(ui), Line$.MODULE$.apply(194), FullName$.MODULE$.apply("ambience.sso.client.OAuth2CookieClient.buildResponse"));
                this.auditSuccess(requestInfo, ui, cookie);
                Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{Gravity.Header$.MODULE$.Location(ui.authGranted().originalUri()), cookie.asSetCookieHeader()}));
                return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.apply(302), headers, GravityResponse$.MODULE$.$lessinit$greater$default$3());
            }
            if (either instanceof Left) {
                String err = (String)((Left)either).value();
                ((LoggingMixin)this).log().warn(() -> OAuth2CookieClient.buildResponse$$anonfun$1$$anonfun$2(ui, err), Line$.MODULE$.apply(199), FullName$.MODULE$.apply("ambience.sso.client.OAuth2CookieClient.buildResponse"));
                this.auditFailure(requestInfo, ui, err);
                if (MaintenanceMode$.MODULE$.isEnabled()) {
                    return this.doLogout(((ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class))).WebURL() + "/maintenance-mode.html", (List<String>)package$.MODULE$.Nil(), "Maintenance Mode");
                }
                return this.doLogout(((ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class))).WebURL() + "/unknown-user.html", (List<String>)package$.MODULE$.Nil(), "Unknown user");
            }
            throw new MatchError((Object)either);
        });
    }

    public GravityCookie buildCookie(String name, String value, Option<Object> optMaxAge) {
        ((LoggingMixin)this).log().info(() -> OAuth2CookieClient.buildCookie$$anonfun$1(name, value, optMaxAge), Line$.MODULE$.apply(208), FullName$.MODULE$.apply("ambience.sso.client.OAuth2CookieClient.buildCookie"));
        Some some = Some$.MODULE$.apply((Object)"/");
        boolean bl = GravityCookie$.MODULE$.$lessinit$greater$default$5();
        Option option = GravityCookie$.MODULE$.$lessinit$greater$default$7();
        return GravityCookie$.MODULE$.apply(name, value, optMaxAge, (Option)some, bl, true, option);
    }

    public Option<Object> buildCookie$default$3() {
        return None$.MODULE$;
    }

    private static final String openIdField$$anonfun$1() {
        return "";
    }

    private static final Task endpoint$$anonfun$1$$anonfun$1() {
        return Gravity$.MODULE$.BadRequestResponseT();
    }

    private static final Object endpoint$$anonfun$2(String code$2, String state$1) {
        return "endpoint code=" + code$2 + " state=" + state$1;
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final String $anonfun$4() {
        return "";
    }

    private static final Object logout$$anonfun$1$$anonfun$1(List otherCookies$2) {
        return "logout " + otherCookies$2;
    }

    private final GravityResponse logout$$anonfun$1$$anonfun$2$$anonfun$1(String redirectTo$3, List otherCookies$4, GravityCookie c$2, Gravity.Header delCookie$2) {
        return this.doLogout(redirectTo$3, (List<String>)otherCookies$4, c$2.value()).withHeader(delCookie$2);
    }

    private static final Object logout$$anonfun$1$$anonfun$3(String redirectTo$4) {
        return "No cookie available, so redirecting to " + redirectTo$4;
    }

    private static final Object doLogout$$anonfun$1(String cookieInfo$1) {
        return "SSO Logout by " + cookieInfo$1;
    }

    private static final Object doLogout$$anonfun$2(String cookieInfo$2) {
        return "Local Logout by " + cookieInfo$2;
    }

    private static final Object getAuth$$anonfun$1$$anonfun$1(String scope$4, String reason$2) {
        return "getAuth(" + new ClientModel.Scope(scope$4) + "," + reason$2 + ")";
    }

    private static final Object getAuth$$anonfun$1$$anonfun$2$$anonfun$1(String uri$1) {
        return "Redirecting to " + uri$1;
    }

    private static final Object buildResponse$$anonfun$1$$anonfun$1(ClientModel.AuthUserInfo ui$2) {
        return "buildResponse redirecting to " + new ClientModel.OriginalUri(ui$2.authGranted().originalUri());
    }

    private static final Object buildResponse$$anonfun$1$$anonfun$2(ClientModel.AuthUserInfo ui$3, String err$1) {
        return "Cannot build cookie for " + ui$3 + ": " + err$1;
    }

    private static final Object buildCookie$$anonfun$1(String name$1, String value$1, Option optMaxAge$1) {
        return "buildCookie " + name$1 + " " + value$1 + " " + optMaxAge$1;
    }
}

