/*
 * Decompiled with CFR 0.152.
 */
package ambience.util;

import ambience.util.ONConverter$;
import ambience.util.SharedCache$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexIndex;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class SharedCache<V> {
    private final long expiryMs;
    private final Clock clock;
    private final CodexDB codexDB;
    private final Task cltnT;

    public static <V> Task<SharedCache<V>> apply(String string, int n) {
        return SharedCache$.MODULE$.apply(string, n);
    }

    public SharedCache(String name, long expiryMs) {
        this.expiryMs = expiryMs;
        this.clock = (Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class));
        this.codexDB = (CodexDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(CodexDB.class));
        this.cltnT = this.codexDB().getCodexCollection(name).memoize();
    }

    public Clock clock() {
        return this.clock;
    }

    public CodexDB codexDB() {
        return this.codexDB;
    }

    public Task<CodexCollection> cltnT() {
        return this.cltnT;
    }

    public Task<SharedCache<V>> init() {
        return this.cltnT().flatMap((Function1 & Serializable)_$1 -> _$1.createIndexT((CodexIndex)CodexIndex.ExpireAt$.MODULE$.apply("ts")).map((Function1 & Serializable)_$2 -> this));
    }

    public Task<Option<V>> get(String key, Decoder<V> d) {
        return this.cltnT().flatMap((Function1 & Serializable)_$3 -> _$3.findO(this.withId(key)).firstOptionL().map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                return this.decode(doc, d);
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        }));
    }

    public Task<String> put(V value, Encoder<V> e) {
        String uuid = UUID.randomUUID().toString();
        return this.put(uuid, value, e).map((Function1 & Serializable)_$4 -> uuid);
    }

    public Task<BoxedUnit> put(String key, V value, Encoder<V> e) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(key)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ts");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonDateTime$.MODULE$.apply(this.clock().now() + this.expiryMs)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document doc = (Document)this.encode(value, e).updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.cltnT().flatMap((Function1 & Serializable)_$5 -> _$5.upsertOneT(this.withId(key), doc)).map((Function1)(JProcedure1 & Serializable)_$6 -> {});
    }

    public Task<Object> remove(String key) {
        return this.cltnT().flatMap((Function1 & Serializable)_$7 -> _$7.deleteOneT(this.withId(key))).map((Function1 & Serializable)_$8 -> _$8.getDeletedCount() > 0L);
    }

    public Document encode(V value, Encoder<V> e) {
        Object object = package$.MODULE$.EncoderOps(value);
        return Document$.MODULE$.apply(package.EncoderOps$.MODULE$.asJson$extension(object, e).noSpaces());
    }

    public Option<V> decode(Document doc, Decoder<V> d) {
        return ONConverter$.MODULE$.bsonToRelaxedJson(doc).as(d).toOption();
    }

    public CodexFilter withId(String key) {
        return CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(key));
    }
}

