/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.SystemConfig;
import com.elixirtech.mongodb.StandardMongoDB;
import com.elixirtech.mongodb.X509MongoDB$;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoClient$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class X509MongoDB
extends StandardMongoDB {
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(X509MongoDB.class.getDeclaredField("keyManagerFactory$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(X509MongoDB.class.getDeclaredField("keyStore$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(X509MongoDB.class.getDeclaredField("connectionString$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(X509MongoDB.class.getDeclaredField("keystorePassword$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(X509MongoDB.class.getDeclaredField("keystoreFileType$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(X509MongoDB.class.getDeclaredField("keystoreFile$lzy1"));
    private volatile Object keystoreFile$lzy1;
    private volatile Object keystoreFileType$lzy1;
    private volatile Object keystorePassword$lzy1;
    private volatile Object connectionString$lzy1;
    private volatile Object keyStore$lzy1;
    private volatile Object keyManagerFactory$lzy1;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(X509MongoDB$.class.getDeclaredField("log$lzy1"));

    public static LoggingInterface log() {
        return X509MongoDB$.MODULE$.log();
    }

    public X509MongoDB(SystemConfig sysConfig) {
        super(sysConfig);
    }

    private SystemConfig sysConfig$accessor() {
        return super.sysConfig();
    }

    public String keystoreFile() {
        Object object = this.keystoreFile$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.keystoreFile$lzyINIT1();
    }

    private Object keystoreFile$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.keystoreFile$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = this.sysConfig$accessor().config().getString("elixir.mongo.x509.keystoreFile");
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.keystoreFile$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String keystoreFileType() {
        Object object = this.keystoreFileType$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.keystoreFileType$lzyINIT1();
    }

    private Object keystoreFileType$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.keystoreFileType$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = this.sysConfig$accessor().config().getString("elixir.mongo.x509.keystoreFileType");
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.keystoreFileType$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String keystorePassword() {
        Object object = this.keystorePassword$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.keystorePassword$lzyINIT1();
    }

    private Object keystorePassword$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.keystorePassword$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = this.encPrefixDecrypt("elixir.mongo.x509.keystorePassword");
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.keystorePassword$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String connectionString() {
        Object object = this.connectionString$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.connectionString$lzyINIT1();
    }

    private Object connectionString$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.connectionString$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = this.encPrefixDecrypt("elixir.mongo.x509.connectionString");
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.connectionString$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public KeyStore keyStore() {
        Object object = this.keyStore$lzy1;
        if (object instanceof KeyStore) {
            return (KeyStore)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (KeyStore)this.keyStore$lzyINIT1();
    }

    private Object keyStore$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.keyStore$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    KeyStore keyStore = null;
                    try {
                        KeyStore ks = KeyStore.getInstance(this.keystoreFileType());
                        byte[] bytes = Files.readAllBytes(new File(this.keystoreFile()).toPath());
                        ks.load(new ByteArrayInputStream(bytes), (char[])StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString(this.keystorePassword()), ClassTag$.MODULE$.apply(Character.TYPE)));
                        keyStore = ks;
                        object2 = keyStore == null ? LazyVals.NullValue$.MODULE$ : keyStore;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.keyStore$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.keyStore$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return keyStore;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public KeyManagerFactory keyManagerFactory() {
        Object object = this.keyManagerFactory$lzy1;
        if (object instanceof KeyManagerFactory) {
            return (KeyManagerFactory)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (KeyManagerFactory)this.keyManagerFactory$lzyINIT1();
    }

    private Object keyManagerFactory$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.keyManagerFactory$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    KeyManagerFactory keyManagerFactory = null;
                    try {
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                        kmf.init(this.keyStore(), this.keystorePassword().toCharArray());
                        keyManagerFactory = kmf;
                        object2 = keyManagerFactory == null ? LazyVals.NullValue$.MODULE$ : keyManagerFactory;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.keyManagerFactory$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return keyManagerFactory;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public SSLContext ssl() {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagerFactory().getKeyManagers(), null, new SecureRandom());
        return sslContext;
    }

    @Override
    public MongoClient buildMongoClient() {
        this.logUsefulConnectionInfo(this.connectionString());
        return (MongoClient)X509MongoDB$.MODULE$.log().infoElapsedTime(X509MongoDB::buildMongoClient$$anonfun$1, this::buildMongoClient$$anonfun$2, Line$.MODULE$.apply(57), FullName$.MODULE$.apply("com.elixirtech.mongodb.X509MongoDB.buildMongoClient"));
    }

    private static final String buildMongoClient$$anonfun$1() {
        return "Building X509 MongoDB Client";
    }

    private final MongoClient buildMongoClient$$anonfun$2() {
        MongoClientSettings settings = MongoClientSettings.builder().codecRegistry(MongoClient$.MODULE$.DEFAULT_CODEC_REGISTRY()).applyConnectionString(new ConnectionString(this.connectionString())).applyToSslSettings(builder -> builder.enabled(true).context(this.ssl())).build();
        return MongoClient$.MODULE$.apply(settings);
    }
}

